/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.jruby.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.jruby.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cms.CMSAlgorithm;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import org.jruby.org.bouncycastle.cms.jcajce.CMSUtils;
import org.jruby.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.jruby.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.jruby.org.bouncycastle.jce.spec.MQVPublicKeySpec;
import org.jruby.org.bouncycastle.operator.GenericKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private KeyPair ephemeralKP;

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, PrivateKey privateKey, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier2) throws CMSException {
        super(aSN1ObjectIdentifier, SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()), aSN1ObjectIdentifier2);
        this.senderPublicKey = publicKey;
        this.senderPrivateKey = privateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String string2) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(x509Certificate)));
        this.recipientKeys.add(x509Certificate.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] byArray, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(byArray)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, GenericKey genericKey) throws CMSException {
        this.init(algorithmIdentifier.getAlgorithm());
        PrivateKey privateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            privateKey = new MQVPrivateKeySpec(privateKey, this.ephemeralKP.getPrivate(), this.ephemeralKP.getPublic());
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int j = 0; j != this.recipientIDs.size(); ++j) {
            PublicKey publicKey = (PublicKey)this.recipientKeys.get(j);
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(j);
            if (aSN1ObjectIdentifier.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                publicKey = new MQVPublicKeySpec(publicKey, publicKey);
            }
            try {
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(aSN1ObjectIdentifier);
                keyAgreement.init((Key)privateKey, this.random);
                keyAgreement.doPhase(publicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret(algorithmIdentifier2.getAlgorithm().getId());
                Cipher cipher2 = this.helper.createCipher(algorithmIdentifier2.getAlgorithm());
                cipher2.init(3, (Key)secretKey, this.random);
                byte[] byArray = cipher2.wrap(CMSUtils.getJceKey(genericKey));
                DEROctetString dEROctetString = new DEROctetString(byArray);
                aSN1EncodableVector.add(new RecipientEncryptedKey(keyAgreeRecipientIdentifier, dEROctetString));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("cannot perform agreement step: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    protected ASN1Encodable getUserKeyingMaterial(AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        this.init(algorithmIdentifier.getAlgorithm());
        if (this.ephemeralKP != null) {
            return new MQVuserKeyingMaterial(this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.ephemeralKP.getPublic().getEncoded())), null);
        }
        return null;
    }

    private void init(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (aSN1ObjectIdentifier.equals(CMSAlgorithm.ECMQV_SHA1KDF) && this.ephemeralKP == null) {
            try {
                ECParameterSpec eCParameterSpec = ((ECPublicKey)this.senderPublicKey).getParams();
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(aSN1ObjectIdentifier);
                keyPairGenerator.initialize(eCParameterSpec, this.random);
                this.ephemeralKP = keyPairGenerator.generateKeyPair();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + invalidAlgorithmParameterException);
            }
        }
    }
}

