/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.RecipientOperator;
import org.jruby.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import org.jruby.org.bouncycastle.operator.InputDecryptor;

public class JceKeyAgreeEnvelopedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeEnvelopedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        Key key2 = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, subjectPublicKeyInfo, aSN1OctetString, byArray);
        final Cipher cipher2 = this.contentHelper.createContentCipher(key2, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, cipher2);
            }
        });
    }
}

