/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.bc;

import java.security.cert.CertificateException;
import org.jruby.org.bouncycastle.cert.X509CertificateHolder;
import org.jruby.org.bouncycastle.cms.SignerInformationVerifier;
import org.jruby.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.jruby.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.jruby.org.bouncycastle.operator.DigestCalculatorProvider;
import org.jruby.org.bouncycastle.operator.OperatorCreationException;
import org.jruby.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;

    public BcRSASignerInfoVerifierBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException, CertificateException {
        return new SignerInformationVerifier(this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

