/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.org.bouncycastle.asn1.cmp.PBMParameter;
import org.jruby.org.bouncycastle.asn1.crmf.PKMACValue;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.cert.crmf.CRMFException;
import org.jruby.org.bouncycastle.cert.crmf.PKMACBuilder;
import org.jruby.org.bouncycastle.operator.MacCalculator;
import org.jruby.org.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getDEREncoded());
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.areEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

