/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.DERIA5String;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERPrintableString;
import org.jruby.org.bouncycastle.asn1.DERUTF8String;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;
import org.jruby.org.bouncycastle.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    public DERObject getConvertedValue(DERObjectIdentifier dERObjectIdentifier, String string2) {
        if (string2.length() != 0 && string2.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(string2, 1);
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't recode value for oid " + dERObjectIdentifier.getId());
            }
        }
        if (string2.length() != 0 && string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        if (dERObjectIdentifier.equals(X509Name.EmailAddress) || dERObjectIdentifier.equals(X509Name.DC)) {
            return new DERIA5String(string2);
        }
        if (dERObjectIdentifier.equals(X509Name.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(string2);
        }
        if (dERObjectIdentifier.equals(X509Name.C) || dERObjectIdentifier.equals(X509Name.SN) || dERObjectIdentifier.equals(X509Name.DN_QUALIFIER) || dERObjectIdentifier.equals(X509Name.TELEPHONE_NUMBER)) {
            return new DERPrintableString(string2);
        }
        return new DERUTF8String(string2);
    }
}

