/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DEROctetString;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;
import org.jruby.org.bouncycastle.crypto.digests.SHA1Digest;

public class SubjectKeyIdentifier
extends ASN1Encodable {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectKeyIdentifier getInstance(Object object) {
        if (object instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)object;
        }
        if (object instanceof SubjectPublicKeyInfo) {
            return new SubjectKeyIdentifier((SubjectPublicKeyInfo)object);
        }
        if (object instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)object);
        }
        if (object instanceof X509Extension) {
            return SubjectKeyIdentifier.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + object.getClass().getName());
    }

    public SubjectKeyIdentifier(byte[] byArray) {
        this.keyidentifier = byArray;
    }

    public SubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this.keyidentifier = aSN1OctetString.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.keyidentifier = SubjectKeyIdentifier.getDigest(subjectPublicKeyInfo);
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    public DERObject toASN1Object() {
        return new DEROctetString(this.keyidentifier);
    }

    public static SubjectKeyIdentifier createSHA1KeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    public static SubjectKeyIdentifier createTruncatedSHA1KeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = SubjectKeyIdentifier.getDigest(subjectPublicKeyInfo);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] & 0xF);
        byArray2[0] = (byte)(byArray2[0] | 0x40);
        return new SubjectKeyIdentifier(byArray2);
    }

    private static byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        return byArray;
    }
}

