/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1OutputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1SetParser;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERNull;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DEROutputStream;
import org.jruby.org.bouncycastle.asn1.DERSet;

public abstract class ASN1Set
extends ASN1Object {
    protected Vector set = new Vector();

    public static ASN1Set getInstance(Object object) {
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            DERSet dERSet = new DERSet(aSN1TaggedObject.getObject());
            return dERSet;
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Set) {
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((DEREncodable)enumeration.nextElement());
            }
            return new DERSet(aSN1EncodableVector, false);
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.set.elementAt(n);
    }

    public int size() {
        return this.set.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[this.size()];
        for (int j = 0; j != this.size(); ++j) {
            aSN1EncodableArray[j] = (ASN1Encodable)this.getObjectAt(j);
        }
        return aSN1EncodableArray;
    }

    public ASN1SetParser parser() {
        final ASN1Set aSN1Set = this;
        return new ASN1SetParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Set.this.size();
            }

            public DEREncodable readObject() throws IOException {
                DEREncodable dEREncodable;
                if (this.index == this.max) {
                    return null;
                }
                if ((dEREncodable = ASN1Set.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)dEREncodable).parser();
                }
                if (dEREncodable instanceof ASN1Set) {
                    return ((ASN1Set)dEREncodable).parser();
                }
                return dEREncodable;
            }

            public DERObject getLoadedObject() {
                return aSN1Set;
            }

            public DERObject getDERObject() {
                return aSN1Set;
            }
        };
    }

    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = this.size();
        while (enumeration.hasMoreElements()) {
            DEREncodable dEREncodable = this.getNext(enumeration);
            n *= 17;
            n ^= dEREncodable.hashCode();
        }
        return n;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)dERObject;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject2;
            DEREncodable dEREncodable = this.getNext(enumeration);
            DEREncodable dEREncodable2 = this.getNext(enumeration2);
            DERObject dERObject3 = dEREncodable.getDERObject();
            if (dERObject3 == (dERObject2 = dEREncodable2.getDERObject()) || dERObject3.equals(dERObject2)) continue;
            return false;
        }
        return true;
    }

    private DEREncodable getNext(Enumeration enumeration) {
        DEREncodable dEREncodable = (DEREncodable)enumeration.nextElement();
        if (dEREncodable == null) {
            return DERNull.INSTANCE;
        }
        return dEREncodable;
    }

    private boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        for (int j = 0; j != n; ++j) {
            if (byArray[j] == byArray2[j]) continue;
            return (byArray[j] & 0xFF) < (byArray2[j] & 0xFF);
        }
        return n == byArray.length;
    }

    private byte[] getEncoded(DEREncodable dEREncodable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(dEREncodable);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void sort() {
        if (this.set.size() > 1) {
            boolean bl = true;
            int n = this.set.size() - 1;
            while (bl) {
                int n2 = 0;
                byte[] byArray = this.getEncoded((DEREncodable)this.set.elementAt(0));
                bl = false;
                for (int j = 0; j != n; ++j) {
                    byte[] byArray2 = this.getEncoded((DEREncodable)this.set.elementAt(j + 1));
                    if (this.lessThanOrEqual(byArray, byArray2)) {
                        byArray = byArray2;
                        continue;
                    }
                    Object e = this.set.elementAt(j);
                    this.set.setElementAt(this.set.elementAt(j + 1), j);
                    this.set.setElementAt(e, j + 1);
                    bl = true;
                    n2 = j;
                }
                n = n2;
            }
        }
    }

    protected void addObject(DEREncodable dEREncodable) {
        this.set.addElement(dEREncodable);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return this.set.toString();
    }
}

