/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;

public class RecipInfo {
    private int version;
    private IssuerAndSerialNumber issuerAndSerial;
    private AlgorithmIdentifier keyEncAlgor;
    private ASN1OctetString encKey;
    private X509AuxCertificate cert;

    public void set(X509AuxCertificate cert2) throws PKCS7Exception {
        this.version = 0;
        try {
            X509Name issuer2 = X509Name.getInstance(new ASN1InputStream(new ByteArrayInputStream(cert2.getIssuerX500Principal().getEncoded())).readObject());
            BigInteger serial2 = cert2.getSerialNumber();
            this.issuerAndSerial = new IssuerAndSerialNumber(issuer2, serial2);
            String algo = this.addEncryptionIfNeeded(cert2.getPublicKey().getAlgorithm());
            this.keyEncAlgor = new AlgorithmIdentifier(ASN1Registry.sym2oid(algo));
            this.cert = cert2;
        }
        catch (IOException e) {
            throw new PKCS7Exception(-1, -1, e);
        }
    }

    private String addEncryptionIfNeeded(String input) {
        if ((input = input.toLowerCase()).equals("rsa")) {
            return input + "Encryption";
        }
        if (input.equals("dsa")) {
            return input + "Encryption";
        }
        return input;
    }

    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other instanceof RecipInfo) {
            RecipInfo o = (RecipInfo)other;
            ret = this.version == o.version && (this.issuerAndSerial == null ? o.issuerAndSerial == null : this.issuerAndSerial.equals(o.issuerAndSerial)) && (this.keyEncAlgor == null ? o.keyEncAlgor == null : this.keyEncAlgor.equals(o.keyEncAlgor)) && (this.encKey == null ? o.encKey == null : this.encKey.equals(o.encKey));
        }
        return ret;
    }

    public int hashCode() {
        int result2 = 31;
        result2 += 13 * this.version;
        result2 += this.issuerAndSerial == null ? 0 : 13 * this.issuerAndSerial.hashCode();
        result2 += this.keyEncAlgor == null ? 0 : 13 * this.keyEncAlgor.hashCode();
        return result2 += this.encKey == null ? 0 : 13 * this.encKey.hashCode();
    }

    public String toString() {
        return "#<Recipient version=" + this.version + " issuerAndSerial=[" + this.issuerAndSerial.getName() + "," + this.issuerAndSerial.getCertificateSerialNumber() + "] keyEncAlgor=" + ASN1Registry.o2a(this.keyEncAlgor.getObjectId()) + " encKey=" + this.encKey + ">";
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public final IssuerAndSerialNumber getIssuerAndSerial() {
        return this.issuerAndSerial;
    }

    public final void setIssuerAndSerial(IssuerAndSerialNumber newIssuerAndSerial) {
        this.issuerAndSerial = newIssuerAndSerial;
    }

    public final AlgorithmIdentifier getKeyEncAlgor() {
        return this.keyEncAlgor;
    }

    public final void setKeyEncAlgor(AlgorithmIdentifier newKeyEncAlgor) {
        this.keyEncAlgor = newKeyEncAlgor;
    }

    public final ASN1OctetString getEncKey() {
        return this.encKey;
    }

    public final void setEncKey(ASN1OctetString newEncKey) {
        this.encKey = newEncKey;
    }

    public final X509AuxCertificate getCert() {
        return this.cert;
    }

    public final void setCert(X509AuxCertificate newCert) {
        this.cert = newCert;
    }

    public boolean compare(X509AuxCertificate pcert) {
        if (!new Name(this.issuerAndSerial.getName()).isEqual(pcert.getIssuerX500Principal())) {
            return false;
        }
        return pcert.getSerialNumber().compareTo(this.issuerAndSerial.getCertificateSerialNumber().getValue()) == 0;
    }

    public static RecipInfo fromASN1(DEREncodable content) {
        DERSequence sequence = (DERSequence)content;
        RecipInfo ri = new RecipInfo();
        ri.setVersion(((DERInteger)sequence.getObjectAt(0)).getValue().intValue());
        ri.setIssuerAndSerial(IssuerAndSerialNumber.getInstance(sequence.getObjectAt(1)));
        ri.setKeyEncAlgor(AlgorithmIdentifier.getInstance(sequence.getObjectAt(2)));
        ri.setEncKey((ASN1OctetString)sequence.getObjectAt(3));
        return ri;
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new DERInteger(this.getVersion()));
        vector.add(this.issuerAndSerial.toASN1Object());
        vector.add(this.keyEncAlgor.toASN1Object());
        vector.add(this.encKey.toASN1Object());
        return new DERSequence(vector);
    }
}

