/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureManager;
import com.kenai.jffi.ClosurePool;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.NativeCallbackPointer;
import org.jruby.ext.ffi.jffi.NativeClosureProxy;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;

public class NativeCallbackFactory {
    private final WeakIdentityHashMap closures = new WeakIdentityHashMap();
    private final Ruby runtime;
    private final ClosurePool closurePool;
    private final NativeFunctionInfo closureInfo;
    private final CallbackInfo callbackInfo;
    private final RubyClass callbackClass;

    public NativeCallbackFactory(Ruby runtime, CallbackInfo cbInfo) {
        this.runtime = runtime;
        this.closureInfo = this.newFunctionInfo(runtime, cbInfo);
        this.closurePool = ClosureManager.getInstance().getClosurePool(this.closureInfo.callContext);
        this.callbackInfo = cbInfo;
        this.callbackClass = runtime.getModule("FFI").getClass("Callback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Pointer getCallback(RubyObject callable) {
        NativeCallbackPointer cbptr;
        if (callable instanceof Pointer) {
            return (Pointer)callable;
        }
        Object ffiHandle = callable.getFFIHandle();
        if (ffiHandle instanceof NativeCallbackPointer) {
            cbptr = (NativeCallbackPointer)ffiHandle;
            if (cbptr.cbInfo == this.callbackInfo) {
                return cbptr;
            }
        }
        RubyObject rubyObject = callable;
        synchronized (rubyObject) {
            cbptr = (NativeCallbackPointer)this.closures.get(callable);
            if (cbptr != null) {
                return cbptr;
            }
            cbptr = this.newCallback(callable);
            if (callable.getFFIHandle() == null) {
                callable.setFFIHandle(cbptr);
            } else {
                this.closures.put(callable, cbptr);
            }
            return cbptr;
        }
    }

    NativeCallbackPointer newCallback(IRubyObject callable) {
        if (!(callable instanceof RubyProc) && !callable.respondsTo("call")) {
            throw this.runtime.newArgumentError("callable does not respond to :call");
        }
        return new NativeCallbackPointer(this.runtime, this.callbackClass, this.closurePool.newClosureHandle((Closure)new NativeClosureProxy(this.runtime, this.closureInfo, callable)), this.callbackInfo, this.closureInfo);
    }

    NativeCallbackPointer newCallback(Object callable) {
        return new NativeCallbackPointer(this.runtime, this.callbackClass, this.closurePool.newClosureHandle((Closure)new NativeClosureProxy(this.runtime, this.closureInfo, callable)), this.callbackInfo, this.closureInfo);
    }

    private final NativeFunctionInfo newFunctionInfo(Ruby runtime, CallbackInfo cbInfo) {
        Type[] paramTypes = cbInfo.getParameterTypes();
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (NativeCallbackFactory.isParameterTypeValid(paramTypes[i2]) && FFIUtil.getFFIType(paramTypes[i2]) != null) continue;
            throw runtime.newTypeError("invalid callback parameter type: " + paramTypes[i2]);
        }
        if (!NativeCallbackFactory.isReturnTypeValid(cbInfo.getReturnType()) || FFIUtil.getFFIType(cbInfo.getReturnType()) == null) {
            runtime.newTypeError("invalid callback return type: " + cbInfo.getReturnType());
        }
        return new NativeFunctionInfo(runtime, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT);
    }

    private static final boolean isReturnTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case VOID: 
                case BOOL: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isParameterTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case BOOL: 
                case STRING: 
                case TRANSIENT_STRING: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
            if (type2 instanceof MappedType) {
                return NativeCallbackFactory.isParameterTypeValid(((MappedType)type2).getRealType());
            }
        }
        return false;
    }
}

