/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jruby.embed.jsr223.ServiceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyScriptEngineManager {
    private static final String service = "META-INF/services/javax.script.ScriptEngineFactory";
    private HashSet<ScriptEngineFactory> factories;
    private HashMap<String, ScriptEngineFactory> nameMap;
    private HashMap<String, ScriptEngineFactory> extensionMap;
    private HashMap<String, ScriptEngineFactory> mimetypeMap;
    private Bindings globalMap;

    public JRubyScriptEngineManager() throws ScriptException {
        this(null);
    }

    public JRubyScriptEngineManager(ClassLoader loader) throws ScriptException {
        this.init(loader);
    }

    private void init(ClassLoader loader) throws ScriptException {
        this.nameMap = new HashMap();
        this.extensionMap = new HashMap();
        this.mimetypeMap = new HashMap();
        this.globalMap = new SimpleBindings();
        try {
            this.factories = new ServiceFinder(loader, service).getServices();
            if (this.factories.isEmpty()) {
                System.err.println("no factory");
            }
            this.prepareMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ScriptException(e);
        }
    }

    private void prepareMaps() {
        for (ScriptEngineFactory factory : this.factories) {
            List<String> names2 = factory.getNames();
            for (String name2 : names2) {
                this.nameMap.put(name2, factory);
            }
            List<String> extensions2 = factory.getExtensions();
            for (String extension : extensions2) {
                this.extensionMap.put(extension, factory);
            }
            List<String> mimeTypes = factory.getMimeTypes();
            for (String mimeType : mimeTypes) {
                this.mimetypeMap.put(mimeType, factory);
            }
        }
    }

    public void setBindings(Bindings b) {
        if (b == null) {
            throw new IllegalArgumentException("Null bindings");
        }
        this.globalMap = b;
    }

    public Bindings getBindings() {
        return this.globalMap;
    }

    public void put(String key2, Object value2) {
        this.globalMap.put(key2, value2);
    }

    public Object get(String key2) {
        return this.globalMap.get(key2);
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException("Null shortName");
        }
        ScriptEngineFactory factory = this.nameMap.get(shortName);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + shortName);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException("Null extension");
        }
        ScriptEngineFactory factory = this.extensionMap.get(extension);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + extension);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("Null mimeType");
        }
        ScriptEngineFactory factory = this.mimetypeMap.get(mimeType);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + mimeType);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> l = new ArrayList<ScriptEngineFactory>();
        for (ScriptEngineFactory factory : this.factories) {
            l.add(factory);
        }
        return Collections.unmodifiableList(l);
    }

    public void registerEngineName(String name2, ScriptEngineFactory factory) {
        if (name2 == null || factory == null) {
            throw new NullPointerException("name and/or factory is null.");
        }
        this.nameMap.put(name2, factory);
    }

    public void registerEngineMimeType(String type2, ScriptEngineFactory factory) {
        if (type2 == null || factory == null) {
            throw new NullPointerException("type and/or factory is null.");
        }
        this.mimetypeMap.put(type2, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension == null || factory == null) {
            throw new NullPointerException("extension and/or factory is null.");
        }
        this.extensionMap.put(extension, factory);
    }
}

