/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyCompiledScript;
import org.jruby.embed.jsr223.JRubyContext;
import org.jruby.embed.jsr223.JRubyEngineFactory;
import org.jruby.embed.jsr223.Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyEngine
implements Compilable,
Invocable,
ScriptEngine {
    private final ScriptingContainer container;
    private JRubyEngineFactory factory;
    private ScriptContext context;

    JRubyEngine(ScriptingContainer container, JRubyEngineFactory factory) {
        this.container = container;
        this.factory = factory;
        this.context = new JRubyContext(container);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        return new JRubyCompiledScript(this.container, this, script);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        return new JRubyCompiledScript(this.container, this, reader);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        Object object;
        if (script == null || context == null) {
            throw new NullPointerException("either script or context is null");
        }
        this.container.setScriptFilename(Utils.getFilename(context));
        try {
            if (Utils.isClearVariablesOn(context)) {
                this.container.clear();
            }
            Utils.preEval(this.container, context);
            EmbedEvalUnit unit = this.container.parse(script, Utils.getLineNumber(context));
            IRubyObject ret = unit.run();
            object = JavaEmbedUtils.rubyToJava(ret);
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_8 = null;
                    Utils.postEval(this.container, context);
                    boolean termination = Utils.isTerminationOn(context);
                    if (!termination) break block7;
                    this.container.terminate();
                }
                throw throwable;
            }
        }
        Utils.postEval(this.container, context);
        boolean termination = Utils.isTerminationOn(context);
        if (termination) {
            this.container.terminate();
        }
        return object;
    }

    private ScriptException wrapException(Exception e) {
        return new ScriptException(e);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Object object;
        if (reader == null || context == null) {
            throw new NullPointerException("either reader or context is null");
        }
        String filename2 = Utils.getFilename(context);
        try {
            if (Utils.isClearVariablesOn(context)) {
                this.container.clear();
            }
            Utils.preEval(this.container, context);
            EmbedEvalUnit unit = this.container.parse(reader, filename2, Utils.getLineNumber(context));
            IRubyObject ret = unit.run();
            object = JavaEmbedUtils.rubyToJava(ret);
            Object var8_8 = null;
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_9 = null;
                    Utils.postEval(this.container, context);
                    boolean termination = Utils.isTerminationOn(context);
                    if (!termination) break block7;
                    this.container.terminate();
                }
                throw throwable;
            }
        }
        Utils.postEval(this.container, context);
        boolean termination = Utils.isTerminationOn(context);
        if (termination) {
            this.container.terminate();
        }
        return object;
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        ScriptContext context = this.getScriptContext(bindings);
        return this.eval(script, context);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext context = this.getScriptContext(bindings);
        return this.eval(reader, context);
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        if (bindings == null) {
            throw new NullPointerException("null bindings in engine scope");
        }
        SimpleScriptContext newContext = new SimpleScriptContext();
        newContext.setBindings(bindings, 100);
        Bindings global = this.getBindings(200);
        if (global != null) {
            newContext.setBindings(global, 200);
        }
        newContext.setReader(this.context.getReader());
        newContext.setWriter(this.context.getWriter());
        newContext.setErrorWriter(this.context.getErrorWriter());
        return newContext;
    }

    @Override
    public Object get(String key2) {
        return this.context.getAttribute(key2, 100);
    }

    @Override
    public void put(String key2, Object value2) {
        this.context.getBindings(100).put(key2, value2);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("context is null");
        }
        this.context = ctx;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object receiver2, String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        Object object;
        block8: {
            if (method2 == null) {
                throw new NullPointerException("method is null");
            }
            if (receiver2 == null) {
                throw new NullPointerException("receiver is null");
            }
            Utils.preEval(this.container, this.context);
            if (args2 != null && args2.length != 0) break block8;
            Object object2 = this.container.callMethod(receiver2, method2, Object.class);
            Object var6_7 = null;
            Utils.postEval(this.container, this.context);
            return object2;
        }
        try {
            object = this.container.callMethod(receiver2, method2, args2, Object.class);
            Object var6_8 = null;
        }
        catch (Exception e) {
            try {
                if (e.getCause().getMessage().contains("undefined method")) {
                    throw this.wrapMethodException(e);
                }
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                Utils.postEval(this.container, this.context);
                throw throwable;
            }
        }
        Utils.postEval(this.container, this.context);
        return object;
    }

    private NoSuchMethodException wrapMethodException(Exception e) {
        return (NoSuchMethodException)new NoSuchMethodException(e.getCause().getMessage()).initCause(e);
    }

    @Override
    public Object invokeFunction(String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        Object object;
        block7: {
            if (method2 == null) {
                throw new NullPointerException("method is null");
            }
            Utils.preEval(this.container, this.context);
            if (args2 != null && args2.length != 0) break block7;
            Object object2 = this.container.callMethod((Object)this.container.getProvider().getRuntime().getTopSelf(), method2, Object.class);
            Object var5_6 = null;
            Utils.postEval(this.container, this.context);
            return object2;
        }
        try {
            object = this.container.callMethod((Object)this.container.getProvider().getRuntime().getTopSelf(), method2, args2, Object.class);
            Object var5_7 = null;
        }
        catch (Exception e) {
            try {
                if (e.getCause().getMessage().contains("undefined method")) {
                    throw this.wrapMethodException(e);
                }
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                Utils.postEval(this.container, this.context);
                throw throwable;
            }
        }
        Utils.postEval(this.container, this.context);
        return object;
    }

    @Override
    public <T> T getInterface(Class<T> returnType) {
        return this.getInterface(null, returnType);
    }

    @Override
    public <T> T getInterface(Object receiver2, Class<T> returnType) {
        return this.container.getInstance(receiver2, returnType);
    }
}

