/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jcodings.Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean extraPositionInformation = false;
    private boolean isDebug = false;
    private boolean saveData = false;
    private CompatVersion version;
    private Encoding defaultEncoding;
    private Ruby runtime;
    private static final ByteList USASCII = new ByteList(new byte[]{85, 83, 45, 65, 83, 67, 73, 73});

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean inlineSource, CompatVersion version2) {
        this(runtime, lineNumber, false, inlineSource, version2);
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean extraPositionInformation, boolean inlineSource, CompatVersion version2) {
        this(runtime, lineNumber, extraPositionInformation, inlineSource, true, version2, false);
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse, CompatVersion version2, boolean saveData) {
        this.runtime = runtime;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.extraPositionInformation = extraPositionInformation;
        this.isEvalParse = !isFileParse;
        this.version = version2;
        this.saveData = saveData;
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse, RubyInstanceConfig config) {
        this(runtime, lineNumber, extraPositionInformation, inlineSource, isFileParse, false, config);
    }

    public ParserConfiguration(Ruby runtime, int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse, boolean saveData, RubyInstanceConfig config) {
        this(runtime, lineNumber, extraPositionInformation, inlineSource, isFileParse, config.getCompatVersion(), saveData);
        this.isDebug = config.isParserDebug();
    }

    public void setDefaultEncoding(Encoding encoding2) {
        this.defaultEncoding = encoding2;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = this.getEncodingService().loadEncoding(USASCII);
        }
        return this.defaultEncoding;
    }

    public EncodingService getEncodingService() {
        return this.runtime.getEncodingService();
    }

    public void setEvalParse(boolean isEvalParse) {
        this.isEvalParse = isEvalParse;
    }

    public void setExtraPositionInformation(boolean extraPositionInformation) {
        this.extraPositionInformation = extraPositionInformation;
    }

    public boolean hasExtraPositionInformation() {
        return this.extraPositionInformation;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public KCode getKCode() {
        return this.runtime.getKCode();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public DynamicScope getScope() {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new ManyVarsDynamicScope(this.runtime.getStaticScopeFactory().newLocalScope(null), this.existingScope);
    }

    public CompatVersion getVersion() {
        return this.version;
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }
}

