/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.SwappedMemoryIO;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Buffer"}, parent="FFI::AbstractMemory")
public final class Buffer
extends AbstractMemory {
    public static final int IN = 1;
    public static final int OUT = 2;
    private int inout;

    public static RubyClass createBufferClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("Buffer", module.getClass("AbstractMemory"), BufferAllocator.INSTANCE);
        result2.defineAnnotatedMethods(Buffer.class);
        result2.defineAnnotatedConstants(Buffer.class);
        return result2;
    }

    public Buffer(Ruby runtime, RubyClass klass) {
        super(runtime, klass, runtime.getFFI().getNullMemoryIO(), 0L, 0);
        this.inout = 3;
    }

    public Buffer(Ruby runtime, int size2) {
        this(runtime, size2, 3);
    }

    public Buffer(Ruby runtime, int size2, int flags) {
        this(runtime, runtime.getFFI().bufferClass, Buffer.allocateMemoryIO(runtime, size2), size2, 1, flags);
    }

    private Buffer(Ruby runtime, IRubyObject klass, MemoryIO io2, long size2, int typeSize, int inout) {
        super(runtime, (RubyClass)klass, io2, size2, typeSize);
        this.inout = inout;
    }

    private static final int getCount(IRubyObject countArg) {
        return countArg instanceof RubyFixnum ? RubyFixnum.fix2int(countArg) : 1;
    }

    private static Buffer allocate(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, int count2, int flags) {
        int typeSize = Buffer.calculateTypeSize(context, sizeArg);
        int total2 = typeSize * count2;
        return new Buffer(context.runtime, recv2, Buffer.allocateMemoryIO(context.runtime, total2), total2, typeSize, flags);
    }

    private IRubyObject init(ThreadContext context, IRubyObject rbTypeSize, int count2, int flags) {
        this.typeSize = Buffer.calculateTypeSize(context, rbTypeSize);
        this.size = this.typeSize * count2;
        this.inout = flags;
        this.setMemoryIO(Buffer.allocateMemoryIO(context.runtime, (int)this.size));
        return this;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject klass, IRubyObject sizeArg) {
        if (klass == context.runtime.getFFI().bufferClass) {
            return Buffer.allocate(context, klass, sizeArg, 1, 3);
        }
        return ((RubyClass)klass).newInstance(context, sizeArg, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject klass, IRubyObject sizeArg, IRubyObject countArg) {
        if (klass == context.runtime.getFFI().bufferClass) {
            return Buffer.allocate(context, klass, sizeArg, RubyFixnum.fix2int(countArg), 3);
        }
        return ((RubyClass)klass).newInstance(context, sizeArg, countArg, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject klass, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clear2) {
        if (klass == context.runtime.getFFI().bufferClass) {
            return Buffer.allocate(context, klass, sizeArg, RubyFixnum.fix2int(countArg), 3);
        }
        return ((RubyClass)klass).newInstance(context, sizeArg, countArg, clear2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        if (klass == context.runtime.getFFI().bufferClass) {
            switch (args2.length) {
                case 1: {
                    return Buffer.newInstance(context, klass, args2[0]);
                }
                case 2: 
                case 3: {
                    return Buffer.newInstance(context, klass, args2[0], args2[1]);
                }
            }
            return ((RubyClass)klass).newInstance(context, args2, Block.NULL_BLOCK);
        }
        return ((RubyClass)klass).newInstance(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg) {
        return sizeArg instanceof RubyFixnum ? this.init(context, RubyFixnum.one(context.runtime), RubyFixnum.fix2int(sizeArg), 3) : this.init(context, sizeArg, 1, 3);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject arg2) {
        return this.init(context, sizeArg, Buffer.getCount(arg2), 3);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return this.init(context, sizeArg, RubyFixnum.fix2int(countArg), 3);
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        Buffer orig = (Buffer)other;
        this.typeSize = orig.typeSize;
        this.size = orig.size;
        this.inout = orig.inout;
        this.setMemoryIO(orig.getMemoryIO().dup());
        return this;
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 3);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, arg2, 1, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.runtime, String.format("#<Buffer size=%d>", this.size));
    }

    public final AbstractMemory order(Ruby runtime, ByteOrder order2) {
        return new Buffer(runtime, this.getMetaClass(), order2.equals(this.getMemoryIO().order()) ? this.getMemoryIO() : new SwappedMemoryIO(runtime, this.getMemoryIO()), this.size, this.typeSize, this.inout);
    }

    protected AbstractMemory slice(Ruby runtime, long offset2) {
        return new Buffer(runtime, this.getMetaClass(), this.io.slice(offset2), this.size - offset2, this.typeSize, this.inout);
    }

    protected AbstractMemory slice(Ruby runtime, long offset2, long size2) {
        return new Buffer(runtime, this.getMetaClass(), this.io.slice(offset2, size2), size2, this.typeSize, this.inout);
    }

    protected Pointer getPointer(Ruby runtime, long offset2) {
        return new Pointer(runtime, this.getMemoryIO().getMemoryIO(offset2));
    }

    public int getInOutFlags() {
        return this.inout;
    }

    private static MemoryIO allocateMemoryIO(Ruby runtime, int size2) {
        return Factory.getInstance().allocateTransientDirectMemory(runtime, size2, 8, true);
    }

    private static final class NewInstanceMethod
    extends DynamicMethod {
        private final DynamicMethod.NativeCall new1 = new DynamicMethod.NativeCall(Buffer.class, "newInstance", IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class}, true, false);
        private final DynamicMethod.NativeCall new2 = new DynamicMethod.NativeCall(Buffer.class, "newInstance", IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}, true, false);
        private final DynamicMethod.NativeCall new3 = new DynamicMethod.NativeCall(Buffer.class, "newInstance", IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}, true, false);

        private NewInstanceMethod(RubyModule implementationClass) {
            super(implementationClass, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone);
        }

        public DynamicMethod dup() {
            return this;
        }

        public Arity getArity() {
            return Arity.fixed(1);
        }

        public DynamicMethod.NativeCall getNativeCall() {
            return this.new1;
        }

        public void setHandle(Object handle) {
        }

        public DynamicMethod.NativeCall getNativeCall(int args2, boolean block) {
            switch (args2) {
                case 1: {
                    return this.new1;
                }
                case 2: {
                    return this.new2;
                }
                case 3: {
                    return this.new3;
                }
            }
            return super.getNativeCall(args2, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: 
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            return ((RubyClass)self).newInstance(context, args2, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0) {
            return Buffer.newInstance(context, self, arg0);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return Buffer.newInstance(context, self, arg0, arg1);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return Buffer.newInstance(context, self, arg0, arg1);
        }
    }

    private static final class BufferAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new BufferAllocator();

        private BufferAllocator() {
        }

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new Buffer(runtime, klazz);
        }
    }
}

