/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.platform.PRIO;
import jnr.constants.platform.RLIM;
import jnr.constants.platform.RLIMIT;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.posix.POSIX;
import jnr.posix.Times;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ShellLauncher;

@JRubyModule(name={"Process"})
public class RubyProcess {
    private static final NonNativeErrno ECHILD = new NonNativeErrno(){

        public int handle(Ruby runtime, int result2) {
            throw runtime.newErrnoECHILDError();
        }
    };
    private static final NonNativeErrno IGNORE = new NonNativeErrno(){

        public int handle(Ruby runtime, int result2) {
            return result2;
        }
    };

    public static RubyModule createProcessModule(Ruby runtime) {
        RubyModule process = runtime.defineModule("Process");
        runtime.setProcess(process);
        RubyClass process_status = process.defineClassUnder("Status", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setProcStatus(process_status);
        RubyModule process_uid = process.defineModuleUnder("UID");
        runtime.setProcUID(process_uid);
        RubyModule process_gid = process.defineModuleUnder("GID");
        runtime.setProcGID(process_gid);
        RubyModule process_sys = process.defineModuleUnder("Sys");
        runtime.setProcSys(process_sys);
        process.defineAnnotatedMethods(RubyProcess.class);
        process_status.defineAnnotatedMethods(RubyStatus.class);
        process_uid.defineAnnotatedMethods(UserID.class);
        process_gid.defineAnnotatedMethods(GroupID.class);
        process_sys.defineAnnotatedMethods(Sys.class);
        runtime.loadConstantSet(process, PRIO.class);
        runtime.loadConstantSet(process, RLIM.class);
        runtime.loadConstantSet(process, RLIMIT.class);
        process.defineConstant("WNOHANG", runtime.newFixnum(1));
        process.defineConstant("WUNTRACED", runtime.newFixnum(2));
        return process;
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.abort(context, recv2, args2);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit_bang(recv2, args2);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(IRubyObject recv2) {
        throw recv2.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"setrlimit"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(IRubyObject recv2, IRubyObject[] args2) {
        throw recv2.getRuntime().newNotImplementedError("Process#setrlimit not yet implemented");
    }

    @Deprecated
    public static IRubyObject getpgrp(IRubyObject recv2) {
        return RubyProcess.getpgrp(recv2.getRuntime());
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.getpgrp(context.runtime);
    }

    public static IRubyObject getpgrp(Ruby runtime) {
        return runtime.newFixnum(runtime.getPosix().getpgrp());
    }

    @JRubyMethod(name={"groups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @Deprecated
    public static IRubyObject waitpid(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(context.runtime, args2);
    }

    public static IRubyObject waitpid(Ruby runtime, IRubyObject[] args2) {
        int pid2 = -1;
        int flags = 0;
        if (args2.length > 0) {
            pid2 = (int)args2[0].convertToInteger().getLongValue();
        }
        if (args2.length > 1) {
            flags = (int)args2[1].convertToInteger().getLongValue();
        }
        int[] status2 = new int[1];
        runtime.getPosix().errno(0);
        pid2 = runtime.getPosix().waitpid(pid2, status2, flags);
        RubyProcess.raiseErrnoIfSet(runtime, ECHILD);
        runtime.getCurrentContext().setLastExitStatus(RubyStatus.newProcessStatus(runtime, status2[0] >> 8 & 0xFF, pid2));
        return runtime.newFixnum(pid2);
    }

    @Deprecated
    public static IRubyObject wait(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(context.runtime, args2);
    }

    public static IRubyObject wait(Ruby runtime, IRubyObject[] args2) {
        if (args2.length > 0) {
            return RubyProcess.waitpid(runtime, args2);
        }
        int[] status2 = new int[1];
        runtime.getPosix().errno(0);
        int pid2 = runtime.getPosix().wait(status2);
        RubyProcess.raiseErrnoIfSet(runtime, ECHILD);
        runtime.getCurrentContext().setLastExitStatus(RubyStatus.newProcessStatus(runtime, status2[0] >> 8 & 0xFF, pid2));
        return runtime.newFixnum(pid2);
    }

    @Deprecated
    public static IRubyObject waitall(IRubyObject recv2) {
        return RubyProcess.waitall(recv2.getRuntime());
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.waitall(context.runtime);
    }

    public static IRubyObject waitall(Ruby runtime) {
        POSIX posix = runtime.getPosix();
        RubyArray results = runtime.newArray();
        int[] status2 = new int[1];
        int result2 = posix.wait(status2);
        while (result2 != -1) {
            results.append(runtime.newArray((IRubyObject)runtime.newFixnum(result2), (IRubyObject)RubyStatus.newProcessStatus(runtime, status2[0] >> 8 & 0xFF, result2)));
            result2 = posix.wait(status2);
        }
        return results;
    }

    @Deprecated
    public static IRubyObject setsid(IRubyObject recv2) {
        return RubyProcess.setsid(recv2.getRuntime());
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.setsid(context.runtime);
    }

    public static IRubyObject setsid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setsid()));
    }

    @Deprecated
    public static IRubyObject setpgrp(IRubyObject recv2) {
        return RubyProcess.setpgrp(recv2.getRuntime());
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.setpgrp(context.runtime);
    }

    public static IRubyObject setpgrp(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setpgid(0, 0)));
    }

    @Deprecated
    public static IRubyObject egid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"egid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(context.runtime, arg2);
    }

    public static IRubyObject egid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().setegid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject euid(IRubyObject recv2) {
        return RubyProcess.euid(recv2.getRuntime());
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.euid(context.runtime);
    }

    public static IRubyObject euid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().geteuid()));
    }

    @Deprecated
    public static IRubyObject uid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.uid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"uid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.uid_set(context.runtime, arg2);
    }

    public static IRubyObject uid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().setuid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject gid(IRubyObject recv2) {
        return RubyProcess.gid(recv2.getRuntime());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.gid(context.runtime);
    }

    public static IRubyObject gid(Ruby runtime) {
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(runtime);
        }
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getgid()));
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(IRubyObject recv2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups not yet implemented");
    }

    @Deprecated
    public static IRubyObject getpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(recv2.getRuntime(), arg1, arg2);
    }

    @JRubyMethod(name={"getpriority"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(context.runtime, arg1, arg2);
    }

    public static IRubyObject getpriority(Ruby runtime, IRubyObject arg1, IRubyObject arg2) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getpriority(which, who));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject uid(IRubyObject recv2) {
        return RubyProcess.uid(recv2.getRuntime());
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.uid(context.runtime);
    }

    public static IRubyObject uid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getuid()));
    }

    @Deprecated
    public static IRubyObject waitpid2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(context.runtime, args2);
    }

    public static IRubyObject waitpid2(Ruby runtime, IRubyObject[] args2) {
        int pid2 = -1;
        int flags = 0;
        if (args2.length > 0) {
            pid2 = (int)args2[0].convertToInteger().getLongValue();
        }
        if (args2.length > 1) {
            flags = (int)args2[1].convertToInteger().getLongValue();
        }
        int[] status2 = new int[1];
        pid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().waitpid(pid2, status2, flags), ECHILD);
        return runtime.newArray((IRubyObject)runtime.newFixnum(pid2), (IRubyObject)RubyStatus.newProcessStatus(runtime, status2[0] >> 8 & 0xFF, pid2));
    }

    @JRubyMethod(name={"initgroups"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#initgroups not yet implemented");
    }

    @JRubyMethod(name={"maxgroups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups_set not yet implemented");
    }

    @Deprecated
    public static IRubyObject ppid(IRubyObject recv2) {
        return RubyProcess.ppid(recv2.getRuntime());
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.ppid(context.runtime);
    }

    public static IRubyObject ppid(Ruby runtime) {
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getppid());
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject gid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.gid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"gid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.gid_set(context.runtime, arg2);
    }

    public static IRubyObject gid_set(Ruby runtime, IRubyObject arg2) {
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().setgid((int)arg2.convertToInteger().getLongValue()));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject wait2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(context.runtime, args2);
    }

    @Deprecated
    public static IRubyObject euid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"euid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(context.runtime, arg2);
    }

    public static IRubyObject euid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject setpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(recv2.getRuntime(), arg1, arg2, arg3);
    }

    @JRubyMethod(name={"setpriority"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(context.runtime, arg1, arg2, arg3);
    }

    public static IRubyObject setpriority(Ruby runtime, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int prio = (int)arg3.convertToInteger().getLongValue();
        runtime.getPosix().errno(0);
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().setpriority(which, who, prio));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject setpgid(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(recv2.getRuntime(), arg1, arg2);
    }

    @JRubyMethod(name={"setpgid"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(context.runtime, arg1, arg2);
    }

    public static IRubyObject setpgid(Ruby runtime, IRubyObject arg1, IRubyObject arg2) {
        int pid2 = (int)arg1.convertToInteger().getLongValue();
        int gid2 = (int)arg2.convertToInteger().getLongValue();
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setpgid(pid2, gid2)));
    }

    @Deprecated
    public static IRubyObject getpgid(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getpgid(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"getpgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getpgid(context.runtime, arg2);
    }

    public static IRubyObject getpgid(Ruby runtime, IRubyObject arg2) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getpgid((int)arg2.convertToInteger().getLongValue())));
    }

    @Deprecated
    public static IRubyObject getrlimit(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"getrlimit"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(context.runtime, arg2);
    }

    public static IRubyObject getrlimit(Ruby runtime, IRubyObject arg2) {
        throw runtime.newNotImplementedError("Process#getrlimit not yet implemented");
    }

    @Deprecated
    public static IRubyObject egid(IRubyObject recv2) {
        return RubyProcess.egid(recv2.getRuntime());
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.egid(context.runtime);
    }

    public static IRubyObject egid(Ruby runtime) {
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(runtime);
        }
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getegid()));
    }

    private static int parseSignalString(Ruby runtime, String value2) {
        boolean negative = value2.startsWith("-");
        if (negative) {
            value2 = value2.substring(1);
        }
        String signalName = value2.startsWith("SIG") ? value2 : "SIG" + value2;
        try {
            int signalValue = Signal.valueOf((String)signalName).intValue();
            return negative ? -signalValue : signalValue;
        }
        catch (IllegalArgumentException ex) {
            throw runtime.newArgumentError("unsupported name `SIG" + signalName + "'");
        }
    }

    @Deprecated
    public static IRubyObject kill(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.kill(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.kill(context.runtime, args2);
    }

    public static IRubyObject kill(Ruby runtime, IRubyObject[] args2) {
        boolean processGroupKill;
        if (args2.length < 2) {
            throw runtime.newArgumentError("wrong number of arguments -- kill(sig, pid...)");
        }
        if (Platform.IS_WINDOWS) {
            return runtime.getNil();
        }
        int signal2 = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubySymbol ? RubyProcess.parseSignalString(runtime, args2[0].toString()) : (args2[0] instanceof RubyString ? RubyProcess.parseSignalString(runtime, args2[0].toString()) : RubyProcess.parseSignalString(runtime, args2[0].checkStringType().toString())));
        boolean bl = processGroupKill = signal2 < 0;
        if (processGroupKill) {
            signal2 = -signal2;
        }
        POSIX posix = runtime.getPosix();
        for (int i2 = 1; i2 < args2.length; ++i2) {
            int pid2 = RubyNumeric.num2int(args2[i2]);
            if (pid2 == 0) {
                pid2 = runtime.getPosix().getpid();
            }
            RubyProcess.checkErrno(runtime, posix.kill(processGroupKill ? -pid2 : pid2, signal2));
        }
        return runtime.newFixnum(args2.length - 1);
    }

    @JRubyMethod(name={"detach"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        final int pid2 = (int)arg2.convertToInteger().getLongValue();
        Ruby runtime = context.runtime;
        BlockCallback callback = new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                int[] status2 = new int[1];
                Ruby runtime = context.runtime;
                int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().waitpid(pid2, status2, 0));
                return runtime.newFixnum(result2);
            }
        };
        return RubyThread.newInstance(runtime.getThread(), IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(recv2, (RubyModule)recv2, Arity.NO_ARGUMENTS, callback, context));
    }

    @Deprecated
    public static IRubyObject times(IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(recv2.getRuntime());
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(ThreadContext context, IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(context.runtime);
    }

    public static IRubyObject times(Ruby runtime) {
        Times tms = runtime.getPosix().times();
        if (tms == null) {
            throw runtime.newErrnoFromLastPOSIXErrno();
        }
        long hz = runtime.getPosix().sysconf(Sysconf._SC_CLK_TCK);
        if (hz == -1L) {
            throw runtime.newErrnoFromLastPOSIXErrno();
        }
        return RubyStruct.newStruct(runtime.getTmsStruct(), new IRubyObject[]{runtime.newFloat((double)tms.utime() / (double)hz), runtime.newFloat((double)tms.stime() / (double)hz), runtime.newFloat((double)tms.cutime() / (double)hz), runtime.newFloat((double)tms.cstime() / (double)hz)}, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject pid(IRubyObject recv2) {
        return RubyProcess.pid(recv2.getRuntime());
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.pid(context.runtime);
    }

    public static IRubyObject pid(Ruby runtime) {
        return runtime.newFixnum(runtime.getPosix().getpid());
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9, notImplemented=true)
    public static IRubyObject fork19(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(required=4, module=true, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public static RubyFixnum _spawn_internal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject env = args2[0];
        IRubyObject prog = args2[1];
        IRubyObject options2 = args2[2];
        IRubyObject arguments = args2[3];
        RubyIO.checkSpawnOptions(options2);
        long pid2 = ShellLauncher.runExternalWithoutWait(runtime, env, prog, options2, arguments);
        return RubyFixnum.newFixnum(runtime, pid2);
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit(recv2, args2);
    }

    private static int checkErrno(Ruby runtime, int result2) {
        return RubyProcess.checkErrno(runtime, result2, IGNORE);
    }

    private static int checkErrno(Ruby runtime, int result2, NonNativeErrno nonNative) {
        if (result2 == -1) {
            if (runtime.getPosix().isNative()) {
                RubyProcess.raiseErrnoIfSet(runtime, nonNative);
            } else {
                nonNative.handle(runtime, result2);
            }
        }
        return result2;
    }

    private static void raiseErrnoIfSet(Ruby runtime, NonNativeErrno nonNative) {
        if (runtime.getPosix().errno() != 0) {
            throw runtime.newErrnoFromInt(runtime.getPosix().errno());
        }
    }

    private static interface NonNativeErrno {
        public int handle(Ruby var1, int var2);
    }

    @JRubyModule(name={"Process::Sys"})
    public static class Sys {
        @Deprecated
        public static IRubyObject getegid(IRubyObject self) {
            return RubyProcess.egid(self.getRuntime());
        }

        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(ThreadContext context, IRubyObject self) {
            return RubyProcess.egid(context.runtime);
        }

        @Deprecated
        public static IRubyObject geteuid(IRubyObject self) {
            return RubyProcess.euid(self.getRuntime());
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(ThreadContext context, IRubyObject self) {
            return RubyProcess.euid(context.runtime);
        }

        @Deprecated
        public static IRubyObject getgid(IRubyObject self) {
            return RubyProcess.gid(self.getRuntime());
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(ThreadContext context, IRubyObject self) {
            return RubyProcess.gid(context.runtime);
        }

        @Deprecated
        public static IRubyObject getuid(IRubyObject self) {
            return RubyProcess.uid(self.getRuntime());
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(ThreadContext context, IRubyObject self) {
            return RubyProcess.uid(context.runtime);
        }

        @Deprecated
        public static IRubyObject setegid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject seteuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"seteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject setgid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject setuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(context.runtime, arg2);
        }
    }

    @JRubyModule(name={"Process::GID"})
    public static class GroupID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::GID::change_privilege not implemented yet");
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self) {
            return GroupID.eid(self.getRuntime());
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(ThreadContext context, IRubyObject self) {
            return GroupID.eid(context.runtime);
        }

        public static IRubyObject eid(Ruby runtime) {
            return RubyProcess.egid(runtime);
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self, IRubyObject arg2) {
            return GroupID.eid(self.getRuntime(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            return GroupID.eid(context.runtime, arg2);
        }

        public static IRubyObject eid(Ruby runtime, IRubyObject arg2) {
            return RubyProcess.egid_set(runtime, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return GroupID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::re_exchangeable? not implemented yet");
        }

        @Deprecated
        public static IRubyObject rid(IRubyObject self) {
            return GroupID.rid(self.getRuntime());
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(ThreadContext context, IRubyObject self) {
            return GroupID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime) {
            return RubyProcess.gid(runtime);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime = context.runtime;
            int gid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getgid());
            int egid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getegid());
            if (block.isGiven()) {
                IRubyObject iRubyObject;
                try {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(gid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(egid2));
                    iRubyObject = block.yield(context, runtime.getNil());
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(egid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(gid2));
                    throw throwable;
                }
                RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(egid2));
                RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(gid2));
                return iRubyObject;
            }
            RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(gid2));
            RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(egid2));
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyModule(name={"Process::UID"})
    public static class UserID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::UID::change_privilege not implemented yet");
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self) {
            return RubyProcess.euid(self.getRuntime());
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(ThreadContext context, IRubyObject self) {
            return RubyProcess.euid(context.runtime);
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self, IRubyObject arg2) {
            return UserID.eid(self.getRuntime(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            return UserID.eid(context.runtime, arg2);
        }

        public static IRubyObject eid(Ruby runtime, IRubyObject arg2) {
            return RubyProcess.euid_set(runtime, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg2) {
            throw self.getRuntime().newNotImplementedError("Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return UserID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::re_exchangeable? not implemented yet");
        }

        @Deprecated
        public static IRubyObject rid(IRubyObject self) {
            return UserID.rid(self.getRuntime());
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(ThreadContext context, IRubyObject self) {
            return UserID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime) {
            return RubyProcess.uid(runtime);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime = context.runtime;
            int uid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getuid());
            int euid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().geteuid());
            if (block.isGiven()) {
                IRubyObject iRubyObject;
                try {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(uid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(euid2));
                    iRubyObject = block.yield(context, runtime.getNil());
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(euid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(uid2));
                    throw throwable;
                }
                RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(euid2));
                RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(uid2));
                return iRubyObject;
            }
            RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(uid2));
            RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(euid2));
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyClass(name={"Process::Status"})
    public static class RubyStatus
    extends RubyObject {
        private final long status;
        private final long pid;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby runtime, RubyClass metaClass, long status2, long pid2) {
            super(runtime, metaClass);
            this.status = status2;
            this.pid = pid2;
        }

        public static RubyStatus newProcessStatus(Ruby runtime, long status2, long pid2) {
            return new RubyStatus(runtime, runtime.getProcStatus(), status2, pid2);
        }

        @JRubyMethod(name={"to_int", "stopped?"}, frame=true)
        public IRubyObject not_implemented() {
            String error2 = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error2);
        }

        @JRubyMethod(name={"&"}, frame=true)
        public IRubyObject not_implemented1(IRubyObject arg2) {
            String error2 = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error2);
        }

        @JRubyMethod
        public IRubyObject exitstatus() {
            return this.getRuntime().newFixnum(this.status);
        }

        @JRubyMethod(name={"exited?"})
        public IRubyObject exited() {
            return RubyBoolean.newBoolean(this.getRuntime(), this.status == 0L);
        }

        @JRubyMethod(name={"signaled?"})
        public IRubyObject signaled() {
            return RubyBoolean.newBoolean(this.getRuntime(), this.status > 0L);
        }

        @JRubyMethod(name={"termsig"})
        public IRubyObject termsig() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.status & 0x7FL);
        }

        @JRubyMethod(name={"stopsig"})
        public IRubyObject stopsig() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.status);
        }

        @Deprecated
        public IRubyObject op_rshift(IRubyObject other) {
            return this.op_rshift(this.getRuntime(), other);
        }

        @JRubyMethod(name={">>"})
        public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
            return this.op_rshift(context.runtime, other);
        }

        public IRubyObject op_rshift(Ruby runtime, IRubyObject other) {
            long shiftValue = other.convertToInteger().getLongValue();
            return runtime.newFixnum(this.status >> (int)shiftValue);
        }

        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
            return RuntimeHelpers.invokedynamic(context, other, 1, this.to_i(context.runtime));
        }

        @Deprecated
        public IRubyObject to_i() {
            return this.to_i(this.getRuntime());
        }

        @JRubyMethod
        public IRubyObject to_i(ThreadContext context) {
            return this.to_i(context.runtime);
        }

        public IRubyObject to_i(Ruby runtime) {
            return runtime.newFixnum(this.shiftedValue());
        }

        public IRubyObject to_s() {
            return this.to_s(this.getRuntime());
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return this.to_s(context.runtime);
        }

        public IRubyObject to_s(Ruby runtime) {
            return runtime.newString(String.valueOf(this.shiftedValue()));
        }

        public IRubyObject inspect() {
            return this.inspect(this.getRuntime());
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.inspect(context.runtime);
        }

        public IRubyObject inspect(Ruby runtime) {
            return runtime.newString("#<Process::Status: pid=" + this.pid + ",exited(" + String.valueOf(this.status) + ")>");
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p(ThreadContext context) {
            return context.runtime.newBoolean(this.status == 0L);
        }

        @JRubyMethod(name={"coredump?"})
        public IRubyObject coredump_p(ThreadContext context) {
            return context.runtime.getFalse();
        }

        @JRubyMethod
        public IRubyObject pid(ThreadContext context) {
            return context.runtime.newFixnum(this.pid);
        }

        private long shiftedValue() {
            return this.status << 8;
        }
    }
}

