/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jruby.runtime.profile.AbstractProfilePrinter;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.InvocationSet;
import org.jruby.runtime.profile.MethodData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlProfilePrinter
extends AbstractProfilePrinter {
    private static final long LIMIT = 100000000L;
    public static MethodData currentData;
    private final Invocation topInvocation;
    String head = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html>\n<head>\n  <style media=\"all\" type=\"text/css\">\n    table {\n      border-collapse: collapse;\n      border: 1px solid #CCC;\n      font-family: Verdana, Arial, Helvetica, sans-serif;\n      font-size: 9pt;\n      line-height: normal;\n      width: 100%;\n    }\n\n    th {\n      text-align: center;\n      border-top: 1px solid #FB7A31;\n      border-bottom: 1px solid #FB7A31;\n      background: #FFC;\n      padding: 0.3em;\n      border-left: 1px solid silver;\n    }\n\n    tr.break td {\n      border: 0;\n      border-top: 1px solid #FB7A31;\n      padding: 0;\n      margin: 0;\n    }\n\n    tr.method td {\n      font-weight: bold;\n    }\n\n    td {\n      padding: 0.3em;\n    }\n\n    td:first-child {\n      width: 190px;\n      }\n\n    td {\n      border-left: 1px solid #CCC;\n      text-align: center;\n    }\n\n    .method_name {\n      text-align: left;\n    }\n  </style>\n  </head>\n";

    public HtmlProfilePrinter(Invocation topInvocation) {
        this.topInvocation = topInvocation;
    }

    @Override
    public void printProfile(PrintStream out) {
        out.println(this.head);
        out.println("<body>");
        out.println("<h1>Profile Report</h1>");
        out.println("<h3>Total time: " + this.nanoString(this.topInvocation.getDuration()) + "</h3>");
        out.println("<table>\n  <tr>\n    <th> %Total</th>\n    <th> %Self</th>\n    <th> Total</th>\n    <th> Self</th>\n    <th> Children</th>\n    <th> Calls</th>\n    <th>Name</th>\n  </tr>");
        Map<Integer, MethodData> methods2 = this.methodData(this.topInvocation);
        MethodData[] sortedMethods = methods2.values().toArray(new MethodData[0]);
        Arrays.sort(sortedMethods, new Comparator<MethodData>(){

            @Override
            public int compare(MethodData md1, MethodData md2) {
                long time2;
                long time1 = md1.totalTime();
                return time1 == (time2 = md2.totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
            }
        });
        MethodData[] arr$ = sortedMethods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer[] parentSerials;
            MethodData data2;
            currentData = data2 = arr$[i$];
            if (this.isProfilerInvocation((Invocation)data2.invocations.get(0))) continue;
            out.println("<tr class='break'><td colspan='7'></td></tr>");
            int serial2 = data2.serialNumber;
            if (serial2 != 0 && (parentSerials = this.parentSerials(data2)).length > 0) {
                Integer[] arr$2 = parentSerials;
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    int parentSerial = arr$2[i$2];
                    this.printInvocationFromParent(out, data2, parentSerial, this.methodName(parentSerial), data2.rootInvocationsFromParent(parentSerial));
                }
            }
            String displayName = this.methodName(serial2);
            if (data2.totalTime() >= 100000000L) {
                out.println("<tr class='method'>");
                if (this.topInvocation.getDuration() == 0L) {
                    out.println("  <td>100%</td>");
                    out.println("  <td>100%</td>");
                } else {
                    out.println("  <td>" + Long.toString(data2.totalTime() * 100L / this.topInvocation.getDuration()) + "%</td>");
                    out.println("  <td>" + Long.toString(data2.selfTime() * 100L / this.topInvocation.getDuration()) + "%</td>");
                }
                this.printTimingCells(out, data2);
                out.println("  <td>" + Integer.toString(data2.totalCalls()) + "</td>");
                out.println("  <td>" + this.methodAnchor(displayName) + "</td>");
                out.println("</tr>");
            }
            int[] childSerialsInts = data2.children();
            Integer[] childSerials = new Integer[childSerialsInts.length];
            for (int i2 = 0; i2 < childSerialsInts.length; ++i2) {
                childSerials[i2] = childSerialsInts[i2];
            }
            Arrays.sort(childSerials, new Comparator<Integer>(){

                @Override
                public int compare(Integer child1, Integer child2) {
                    long time2;
                    long time1 = currentData.rootInvocationsOfChild(child1).totalTime();
                    return time1 == (time2 = currentData.rootInvocationsOfChild(child2).totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
                }
            });
            if (childSerials.length <= 0) continue;
            Integer[] arr$3 = childSerials;
            int len$3 = arr$3.length;
            for (int i$3 = 0; i$3 < len$3; ++i$3) {
                int childSerial = arr$3[i$3];
                if (this.isThisProfilerInvocation(childSerial)) continue;
                String callerName = this.methodName(childSerial);
                InvocationSet invs = data2.rootInvocationsOfChild(childSerial);
                this.printInvocationOfChild(out, methods2, data2, childSerial, callerName, invs);
            }
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    private void printInvocationOfChild(PrintStream out, Map<Integer, MethodData> methods2, MethodData data2, int childSerial, String callerName, InvocationSet invs) {
        out.print("<!-- " + invs.totalTime() + " -->");
        if (invs.totalTime() < 100000000L) {
            return;
        }
        out.println("<tr>");
        out.println("  <td></td>");
        out.println("  <td></td>");
        this.printTimingCells(out, invs);
        out.println("  <td>" + Integer.toString(data2.invocationsOfChild(childSerial).totalCalls()) + "/" + Integer.toString(methods2.get(childSerial).totalCalls()) + "</td>");
        out.println("  <td>" + this.linkToMethod(callerName) + "</td>");
        out.println("</tr>");
    }

    private void printInvocationFromParent(PrintStream out, MethodData data2, int parentSerial, String callerName, InvocationSet invs) {
        if (invs.totalTime() < 100000000L) {
            return;
        }
        out.println("<tr>");
        out.println("  <td></td>");
        out.println("  <td></td>");
        this.printTimingCells(out, invs);
        out.println("  <td>" + Integer.toString(data2.invocationsFromParent(parentSerial).totalCalls()) + "/" + Integer.toString(data2.totalCalls()) + "</td>");
        out.println("  <td>" + this.linkToMethod(callerName) + "</td>");
        out.println("</tr>");
    }

    private String linkToMethod(String callerName) {
        return "<a href='#" + callerName.replaceAll("[><#\\.\\?=:]", "_") + "'>" + callerName + "</a>";
    }

    private String methodAnchor(String callerName) {
        return "<a name='" + callerName.replaceAll("[><#\\.\\?=:]", "_") + "'>" + callerName + "</a>";
    }

    private void printTimingCells(PrintStream out, InvocationSet invs) {
        out.println("  <td>" + this.nanoString(invs.totalTime()) + "</td>");
        out.println("  <td>" + this.nanoString(invs.selfTime()) + "</td>");
        out.println("  <td>" + this.nanoString(invs.childTime()) + "</td>");
    }

    private Integer[] parentSerials(MethodData data2) {
        int[] parentSerialsInts = data2.parents();
        Integer[] parentSerials = new Integer[parentSerialsInts.length];
        for (int i2 = 0; i2 < parentSerialsInts.length; ++i2) {
            parentSerials[i2] = parentSerialsInts[i2];
        }
        Arrays.sort(parentSerials, new Comparator<Integer>(){

            @Override
            public int compare(Integer parent1, Integer parent2) {
                long time2;
                long time1 = currentData.rootInvocationsFromParent(parent1).totalTime();
                return time1 == (time2 = currentData.rootInvocationsFromParent(parent2).totalTime()) ? 0 : (time1 < time2 ? -1 : 1);
            }
        });
        return parentSerials;
    }
}

