/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ClosureReturnInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.EnsureRubyArrayInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceOfInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpIndirectInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.MethodLookupInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.NotInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.instructions.ReceiveClosureInstr;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SetReturnAddressInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.BackrefIsMatchDataInstr;
import org.jruby.ir.instructions.defined.ClassVarIsDefinedInstr;
import org.jruby.ir.instructions.defined.GetBackrefInstr;
import org.jruby.ir.instructions.defined.GetDefinedConstantOrMethodInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.GlobalIsDefinedInstr;
import org.jruby.ir.instructions.defined.HasInstanceVarInstr;
import org.jruby.ir.instructions.defined.IsMethodBoundInstr;
import org.jruby.ir.instructions.defined.MethodDefinedInstr;
import org.jruby.ir.instructions.defined.MethodIsPublicInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.defined.SetWithinDefinedInstr;
import org.jruby.ir.instructions.defined.SuperMethodBoundInstr;
import org.jruby.ir.instructions.ruby18.ReceiveOptArgInstr18;
import org.jruby.ir.instructions.ruby18.ReceiveRestArgInstr18;
import org.jruby.ir.instructions.ruby19.BuildLambdaInstr;
import org.jruby.ir.instructions.ruby19.GetEncodingInstr;
import org.jruby.ir.instructions.ruby19.ReceiveOptArgInstr19;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ruby19.ReceiveRestArgInstr19;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.BacktickString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.BooleanLiteral;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.CompoundArray;
import org.jruby.ir.operands.CompoundString;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.MethodHandle;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.targets.JVM;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

public class JVMVisitor
extends IRVisitor {
    public static final String DYNAMIC_SCOPE = "$dynamicScope";
    private final JVM jvm = new JVM();
    private IRScriptBody script;

    public static Class compile(Ruby ruby2, IRScope scope, JRubyClassLoader jrubyClassLoader) {
        JVMVisitor target = new JVMVisitor();
        target.codegen(scope);
        return jrubyClassLoader.defineClass(JVM.scriptToClass(scope.getName()), target.code());
    }

    public byte[] code() {
        return this.jvm.code();
    }

    public void codegen(IRScope scope) {
        if (scope instanceof IRScriptBody) {
            this.codegen((IRScriptBody)scope);
        }
    }

    public void codegen(IRScriptBody script) {
        this.script = script;
        this.emit(script);
    }

    public String emitScope(IRScope scope, String name2, int arity2) {
        name2 = name2 + scope.getLineNumber();
        this.jvm.pushmethod(name2, arity2);
        Tuple<Instr[], Map<Integer, Label[]>> t = scope.prepareForCompilation();
        Instr[] instrs = (Instr[])t.a;
        Map jumpTable = (Map)t.b;
        for (int i2 = 0; i2 < instrs.length; ++i2) {
            Instr instr = instrs[i2];
            if (jumpTable.get(i2) != null) {
                for (Label label : (Label[])jumpTable.get(i2)) {
                    this.jvm.method().mark(this.jvm.methodData().getLabel(label));
                }
            }
            this.visit(instr);
        }
        this.jvm.popmethod();
        return name2;
    }

    public void emit(IRScriptBody script) {
        String clsName = JVM.scriptToClass(script.getName());
        this.jvm.pushscript(clsName, script.getFileName());
        this.emitScope(script, "__script__", 0);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    public void emit(IRMethod method2) {
        String name2 = this.emitScope(method2, method2.getName(), method2.getCallArgs().length);
        this.jvm.method().pushHandle(this.jvm.clsData().clsName, name2, method2.getStaticScope().getRequiredArgs());
    }

    public void emit(IRModuleBody method2) {
        String name2 = method2.getName();
        if (name2.indexOf("DUMMY_MC") != -1) {
            name2 = "METACLASS";
        }
        name2 = this.emitScope(method2, name2, 0);
        this.jvm.method().pushHandle(this.jvm.clsData().clsName, name2, method2.getStaticScope().getRequiredArgs());
    }

    public void visit(Instr instr) {
        instr.visit(this);
    }

    public void visit(Operand operand) {
        if (operand.hasKnownValue()) {
            operand.visit(this);
        } else if (operand instanceof Variable) {
            this.emitVariable((Variable)operand);
        } else {
            operand.visit(this);
        }
    }

    public void emitVariable(Variable variable) {
        int index2 = this.jvm.methodData().local(variable);
        this.jvm.method().loadLocal(index2);
    }

    public void AliasInstr(AliasInstr aliasInstr) {
        this.jvm.method().loadLocal(0);
        this.jvm.method().loadLocal(this.jvm.methodData().local(aliasInstr.getReceiver()));
        this.jvm.method().adapter.ldc(((StringLiteral)aliasInstr.getNewName()).string);
        this.jvm.method().adapter.ldc(((StringLiteral)aliasInstr.getOldName()).string);
        this.jvm.method().invokeHelper("defineAlias", IRubyObject.class, ThreadContext.class, IRubyObject.class, Object.class, Object.class);
        this.jvm.method().adapter.pop();
    }

    public void AttrAssignInstr(AttrAssignInstr attrAssignInstr) {
        this.jvm.method().loadLocal(0);
        this.visit(attrAssignInstr.getReceiver());
        for (Operand operand : attrAssignInstr.getCallArgs()) {
            this.visit(operand);
        }
        this.jvm.method().invokeOther(attrAssignInstr.getMethodAddr().getName(), attrAssignInstr.getCallArgs().length);
        this.jvm.method().adapter.pop();
    }

    public void BEQInstr(BEQInstr beqInstr) {
        Operand[] args2 = beqInstr.getOperands();
        this.jvm.method().loadLocal(0);
        this.visit(args2[0]);
        this.visit(args2[1]);
        this.jvm.method().invokeHelper("BEQ", Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvm.method().adapter.iftrue(this.jvm.methodData().getLabel(beqInstr.getJumpTarget()));
    }

    public void BFalseInstr(BFalseInstr bFalseInstr) {
        this.visit(bFalseInstr.getArg1());
        this.jvm.method().isTrue();
        this.jvm.method().bfalse(this.jvm.methodData().getLabel(bFalseInstr.getJumpTarget()));
    }

    public void BlockGivenInstr(BlockGivenInstr blockGivenInstr) {
        super.BlockGivenInstr(blockGivenInstr);
    }

    public void BNEInstr(BNEInstr bneinstr) {
        Operand[] args2 = bneinstr.getOperands();
        this.jvm.method().loadLocal(0);
        this.visit(args2[0]);
        this.visit(args2[1]);
        this.jvm.method().invokeHelper("BNE", Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvm.method().adapter.iftrue(this.jvm.methodData().getLabel(bneinstr.getJumpTarget()));
    }

    public void BNilInstr(BNilInstr bnilinstr) {
        this.visit(bnilinstr.getArg1());
        this.jvm.method().isNil();
        this.jvm.method().btrue(this.jvm.methodData().getLabel(bnilinstr.getJumpTarget()));
    }

    public void BreakInstr(BreakInstr breakinstr) {
        super.BreakInstr(breakinstr);
    }

    public void BTrueInstr(BTrueInstr btrueinstr) {
        this.visit(btrueinstr.getArg1());
        this.jvm.method().isTrue();
        this.jvm.method().btrue(this.jvm.methodData().getLabel(btrueinstr.getJumpTarget()));
    }

    public void BUndefInstr(BUndefInstr bundefinstr) {
        super.BUndefInstr(bundefinstr);
    }

    public void CallInstr(CallInstr callinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(callinstr.getReceiver());
        for (Operand operand : callinstr.getCallArgs()) {
            this.visit(operand);
        }
        switch (callinstr.getCallType()) {
            case FUNCTIONAL: 
            case VARIABLE: {
                this.jvm.method().invokeSelf(callinstr.getMethodAddr().getName(), callinstr.getCallArgs().length);
                break;
            }
            case NORMAL: {
                this.jvm.method().invokeOther(callinstr.getMethodAddr().getName(), callinstr.getCallArgs().length);
                break;
            }
            case SUPER: {
                this.jvm.method().invokeSuper(callinstr.getMethodAddr().getName(), callinstr.getCallArgs().length);
            }
        }
        int index2 = this.jvm.methodData().local(callinstr.getResult());
        this.jvm.method().storeLocal(index2);
    }

    public void CheckArgsArrayArityInstr(CheckArgsArrayArityInstr checkargsarrayarityinstr) {
        super.CheckArgsArrayArityInstr(checkargsarrayarityinstr);
    }

    public void CheckArityInstr(CheckArityInstr checkarityinstr) {
    }

    public void ClassSuperInstr(ClassSuperInstr classsuperinstr) {
        super.ClassSuperInstr(classsuperinstr);
    }

    public void ClosureReturnInstr(ClosureReturnInstr closurereturninstr) {
        super.ClosureReturnInstr(closurereturninstr);
    }

    public void ConstMissingInstr(ConstMissingInstr constmissinginstr) {
        this.CallInstr(constmissinginstr);
    }

    public void CopyInstr(CopyInstr copyinstr) {
        int index2 = this.jvm.methodData().local(copyinstr.getResult());
        this.visit(copyinstr.getSource());
        this.jvm.method().storeLocal(index2);
    }

    public void DefineClassInstr(DefineClassInstr defineclassinstr) {
        IRClassBody newIRClassBody = defineclassinstr.getNewIRClassBody();
        StaticScope scope = newIRClassBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = RuntimeHelpers.encodeScope(scope);
        this.jvm.method().adapter.newobj(CodegenUtils.p(CompiledIRMethod.class));
        this.jvm.method().adapter.dup();
        this.emit(newIRClassBody);
        this.jvm.method().adapter.ldc(newIRClassBody.getName());
        this.jvm.method().adapter.ldc(newIRClassBody.getFileName());
        this.jvm.method().adapter.ldc(newIRClassBody.getLineNumber());
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.ldc(newIRClassBody.getName());
        this.jvm.method().loadLocal(2);
        this.jvm.method().loadLocal(0);
        this.visit(defineclassinstr.getContainer());
        this.jvm.method().invokeHelper("checkIsRubyModule", RubyModule.class, ThreadContext.class, Object.class);
        if (defineclassinstr.getSuperClass() instanceof Nil) {
            this.jvm.method().adapter.aconst_null();
        } else {
            this.visit(defineclassinstr.getSuperClass());
        }
        this.jvm.method().adapter.ldc(newIRClassBody instanceof IRMetaClassBody);
        this.jvm.method().invokeHelper("newClassForIR", RubyClass.class, ThreadContext.class, String.class, IRubyObject.class, RubyModule.class, Object.class, Boolean.TYPE);
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.ldc(scopeString);
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "decodeLocalScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        this.jvm.method().adapter.swap();
        this.jvm.method().adapter.dup2();
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        this.jvm.method().adapter.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        this.jvm.method().adapter.swap();
        this.jvm.method().adapter.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvm.method().storeLocal(this.jvm.methodData().local(defineclassinstr.getResult()));
    }

    public void DefineClassMethodInstr(DefineClassMethodInstr defineclassmethodinstr) {
        super.DefineClassMethodInstr(defineclassmethodinstr);
    }

    public void DefineInstanceMethodInstr(DefineInstanceMethodInstr defineinstancemethodinstr) {
        IRMethod method2 = defineinstancemethodinstr.getMethod();
        StaticScope scope = method2.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = RuntimeHelpers.encodeScope(scope);
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRubyClass", "()Lorg/jruby/RubyModule;");
        this.jvm.method().adapter.ldc(method2.getName());
        this.jvm.method().adapter.newobj(CodegenUtils.p(CompiledIRMethod.class));
        this.jvm.method().adapter.dup();
        this.emit(method2);
        this.jvm.method().adapter.ldc(method2.getName());
        this.jvm.method().adapter.ldc(method2.getFileName());
        this.jvm.method().adapter.ldc(method2.getLineNumber());
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.ldc(scopeString);
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "decodeLocalScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentVisibility", "()Lorg/jruby/runtime/Visibility;");
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRubyClass", "()Lorg/jruby/RubyModule;");
        this.jvm.method().adapter.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "addMethod", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
    }

    public void DefineMetaClassInstr(DefineMetaClassInstr definemetaclassinstr) {
        IRModuleBody metaClassBody = definemetaclassinstr.getMetaClassBody();
        StaticScope scope = metaClassBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = RuntimeHelpers.encodeScope(scope);
        this.jvm.method().adapter.newobj(CodegenUtils.p(CompiledIRMethod.class));
        this.jvm.method().adapter.dup();
        this.emit(metaClassBody);
        this.jvm.method().adapter.ldc(metaClassBody.getName());
        this.jvm.method().adapter.ldc(metaClassBody.getFileName());
        this.jvm.method().adapter.ldc(metaClassBody.getLineNumber());
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.ldc(scopeString);
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "decodeLocalScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        this.jvm.method().pushRuntime();
        this.visit(definemetaclassinstr.getObject());
        this.jvm.method().invokeHelper("getSingletonClass", RubyClass.class, Ruby.class, IRubyObject.class);
        this.jvm.method().adapter.dup2();
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        this.jvm.method().adapter.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        this.jvm.method().adapter.swap();
        this.jvm.method().adapter.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvm.method().storeLocal(this.jvm.methodData().local(definemetaclassinstr.getResult()));
    }

    public void DefineModuleInstr(DefineModuleInstr definemoduleinstr) {
        IRModuleBody newIRModuleBody = definemoduleinstr.getNewIRModuleBody();
        StaticScope scope = newIRModuleBody.getStaticScope();
        if (scope.getRequiredArgs() > 3 || scope.getRestArg() >= 0 || scope.getOptionalArgs() != 0) {
            throw new RuntimeException("can't compile variable method: " + this);
        }
        String scopeString = RuntimeHelpers.encodeScope(scope);
        this.jvm.method().adapter.newobj(CodegenUtils.p(CompiledIRMethod.class));
        this.jvm.method().adapter.dup();
        this.emit(newIRModuleBody);
        this.jvm.method().adapter.ldc(newIRModuleBody.getName());
        this.jvm.method().adapter.ldc(newIRModuleBody.getFileName());
        this.jvm.method().adapter.ldc(newIRModuleBody.getLineNumber());
        this.jvm.method().adapter.aload(0);
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.ldc(scopeString);
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "decodeLocalScope", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/parser/StaticScope;Ljava/lang/String;)Lorg/jruby/parser/StaticScope;");
        this.jvm.method().loadLocal(0);
        this.visit(definemoduleinstr.getContainer());
        this.jvm.method().invokeHelper("checkIsRubyModule", RubyModule.class, ThreadContext.class, Object.class);
        this.jvm.method().adapter.ldc(newIRModuleBody.getName());
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, String.class));
        this.jvm.method().adapter.dup2();
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        this.jvm.method().adapter.getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        this.jvm.method().adapter.swap();
        this.jvm.method().adapter.invokespecial(CodegenUtils.p(CompiledIRMethod.class), "<init>", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/String;ILorg/jruby/parser/StaticScope;Lorg/jruby/runtime/Visibility;Lorg/jruby/RubyModule;)V");
        this.jvm.method().storeLocal(this.jvm.methodData().local(definemoduleinstr.getResult()));
    }

    public void EnsureRubyArrayInstr(EnsureRubyArrayInstr ensurerubyarrayinstr) {
        super.EnsureRubyArrayInstr(ensurerubyarrayinstr);
    }

    public void EQQInstr(EQQInstr eqqinstr) {
        super.EQQInstr(eqqinstr);
    }

    public void ExceptionRegionEndMarkerInstr(ExceptionRegionEndMarkerInstr exceptionregionendmarkerinstr) {
        super.ExceptionRegionEndMarkerInstr(exceptionregionendmarkerinstr);
    }

    public void ExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr exceptionregionstartmarkerinstr) {
        super.ExceptionRegionStartMarkerInstr(exceptionregionstartmarkerinstr);
    }

    public void GetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr getclassvarcontainermoduleinstr) {
        super.GetClassVarContainerModuleInstr(getclassvarcontainermoduleinstr);
    }

    public void GetClassVariableInstr(GetClassVariableInstr getclassvariableinstr) {
        super.GetClassVariableInstr(getclassvariableinstr);
    }

    public void GetFieldInstr(GetFieldInstr getfieldinstr) {
        String field2 = getfieldinstr.getRef();
        this.visit(getfieldinstr.getSource());
        this.jvm.method().getField(field2);
        this.jvm.method().storeLocal(this.jvm.methodData().local(getfieldinstr.getResult()));
    }

    public void GetGlobalVariableInstr(GetGlobalVariableInstr getglobalvariableinstr) {
        super.GetGlobalVariableInstr(getglobalvariableinstr);
    }

    public void GVarAliasInstr(GVarAliasInstr gvaraliasinstr) {
        super.GVarAliasInstr(gvaraliasinstr);
    }

    public void InheritanceSearchConstInstr(InheritanceSearchConstInstr inheritancesearchconstinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(inheritancesearchconstinstr.getCurrentModule());
        this.jvm.method().inheritanceSearchConst(inheritancesearchconstinstr.getConstName());
        this.jvm.method().storeLocal(this.jvm.methodData().local(inheritancesearchconstinstr.getResult()));
    }

    public void InstanceOfInstr(InstanceOfInstr instanceofinstr) {
        super.InstanceOfInstr(instanceofinstr);
    }

    public void InstanceSuperInstr(InstanceSuperInstr instancesuperinstr) {
        super.InstanceSuperInstr(instancesuperinstr);
    }

    public void JumpIndirectInstr(JumpIndirectInstr jumpindirectinstr) {
        super.JumpIndirectInstr(jumpindirectinstr);
    }

    public void JumpInstr(JumpInstr jumpinstr) {
        this.jvm.method().goTo(this.jvm.methodData().getLabel(jumpinstr.getJumpTarget()));
    }

    public void LabelInstr(LabelInstr labelinstr) {
        this.jvm.method().mark(this.jvm.methodData().getLabel(labelinstr.getLabel()));
    }

    public void LexicalSearchConstInstr(LexicalSearchConstInstr lexicalsearchconstinstr) {
        super.LexicalSearchConstInstr(lexicalsearchconstinstr);
    }

    public void LineNumberInstr(LineNumberInstr linenumberinstr) {
        this.jvm.method().adapter.line(linenumberinstr.getLineNumber());
    }

    public void LoadLocalVarInstr(LoadLocalVarInstr loadlocalvarinstr) {
        this.jvm.method().loadLocal(this.jvm.methodData().local(DYNAMIC_SCOPE));
        int depth = loadlocalvarinstr.getLocalVar().getScopeDepth();
        int location = loadlocalvarinstr.getLocalVar().getLocation() - 1;
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        this.jvm.method().pushNil();
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 1: {
                        this.jvm.method().pushNil();
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 2: {
                        this.jvm.method().pushNil();
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                    case 3: {
                        this.jvm.method().pushNil();
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        return;
                    }
                }
                this.jvm.method().adapter.pushInt(location);
                this.jvm.method().pushNil();
                this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class));
                return;
            }
        }
        this.jvm.method().adapter.pushInt(location);
        this.jvm.method().adapter.pushInt(depth);
        this.jvm.method().pushNil();
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject.class));
    }

    public void Match2Instr(Match2Instr match2instr) {
        super.Match2Instr(match2instr);
    }

    public void Match3Instr(Match3Instr match3instr) {
        super.Match3Instr(match3instr);
    }

    public void MatchInstr(MatchInstr matchinstr) {
        super.MatchInstr(matchinstr);
    }

    public void MethodLookupInstr(MethodLookupInstr methodlookupinstr) {
        super.MethodLookupInstr(methodlookupinstr);
    }

    public void ModuleVersionGuardInstr(ModuleVersionGuardInstr moduleversionguardinstr) {
        super.ModuleVersionGuardInstr(moduleversionguardinstr);
    }

    public void NopInstr(NopInstr nopinstr) {
    }

    public void NoResultCallInstr(NoResultCallInstr noResultCallInstr) {
        this.jvm.method().loadLocal(0);
        this.visit(noResultCallInstr.getReceiver());
        for (Operand operand : noResultCallInstr.getCallArgs()) {
            this.visit(operand);
        }
        switch (noResultCallInstr.getCallType()) {
            case FUNCTIONAL: 
            case VARIABLE: {
                this.jvm.method().invokeSelf(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
                break;
            }
            case NORMAL: {
                this.jvm.method().invokeOther(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
                break;
            }
            case SUPER: {
                this.jvm.method().invokeSuper(noResultCallInstr.getMethodAddr().getName(), noResultCallInstr.getCallArgs().length);
            }
        }
        this.jvm.method().adapter.pop();
    }

    public void NotInstr(NotInstr notinstr) {
        super.NotInstr(notinstr);
    }

    public void OptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr optargmultipleasgninstr) {
        super.OptArgMultipleAsgnInstr(optargmultipleasgninstr);
    }

    public void PopBindingInstr(PopBindingInstr popbindinginstr) {
    }

    public void ProcessModuleBodyInstr(ProcessModuleBodyInstr processmodulebodyinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(processmodulebodyinstr.getModuleBody());
        this.jvm.method().invokeHelper("invokeModuleBody", IRubyObject.class, ThreadContext.class, CompiledIRMethod.class);
        this.jvm.method().storeLocal(this.jvm.methodData().local(processmodulebodyinstr.getResult()));
    }

    public void PushBindingInstr(PushBindingInstr pushbindinginstr) {
        this.jvm.method().loadStaticScope();
        this.jvm.method().adapter.invokestatic(CodegenUtils.p(DynamicScope.class), "newDynamicScope", CodegenUtils.sig(DynamicScope.class, StaticScope.class));
        this.jvm.method().storeLocal(this.jvm.methodData().local(DYNAMIC_SCOPE));
    }

    public void PutClassVariableInstr(PutClassVariableInstr putclassvariableinstr) {
        super.PutClassVariableInstr(putclassvariableinstr);
    }

    public void PutConstInstr(PutConstInstr putconstinstr) {
        this.visit(putconstinstr.getTarget());
        this.jvm.method().adapter.checkcast(CodegenUtils.p(RubyModule.class));
        this.jvm.method().adapter.ldc(putconstinstr.getRef());
        this.visit(putconstinstr.getValue());
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "setConstant", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        this.jvm.method().adapter.pop();
    }

    public void PutFieldInstr(PutFieldInstr putfieldinstr) {
        String field2 = putfieldinstr.getRef();
        this.visit(putfieldinstr.getTarget());
        this.visit(putfieldinstr.getValue());
        this.jvm.method().putField(field2);
    }

    public void PutGlobalVarInstr(PutGlobalVarInstr putglobalvarinstr) {
        super.PutGlobalVarInstr(putglobalvarinstr);
    }

    public void RaiseArgumentErrorInstr(RaiseArgumentErrorInstr raiseargumenterrorinstr) {
        super.RaiseArgumentErrorInstr(raiseargumenterrorinstr);
    }

    public void ReceiveClosureInstr(ReceiveClosureInstr receiveclosureinstr) {
        this.jvm.method().loadLocal(this.jvm.methodData().local("$block"));
        this.jvm.method().storeLocal(this.jvm.methodData().local(receiveclosureinstr.getResult()));
    }

    public void ReceiveExceptionInstr(ReceiveExceptionInstr receiveexceptioninstr) {
    }

    public void ReceivePreReqdArgInstr(ReceivePreReqdArgInstr receiveprereqdarginstr) {
        int index2 = this.jvm.methodData().local(receiveprereqdarginstr.getResult());
        this.jvm.method().loadLocal(3 + receiveprereqdarginstr.getArgIndex());
        this.jvm.method().storeLocal(index2);
    }

    public void ReceiveSelfInstr(ReceiveSelfInstr receiveselfinstr) {
        int $selfIndex = this.jvm.methodData().local(receiveselfinstr.getResult());
        this.jvm.method().loadLocal(2);
        this.jvm.method().storeLocal($selfIndex);
    }

    public void RecordEndBlockInstr(RecordEndBlockInstr recordendblockinstr) {
        super.RecordEndBlockInstr(recordendblockinstr);
    }

    public void ReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr reqdargmultipleasgninstr) {
        super.ReqdArgMultipleAsgnInstr(reqdargmultipleasgninstr);
    }

    public void RescueEQQInstr(RescueEQQInstr rescueeqqinstr) {
        super.RescueEQQInstr(rescueeqqinstr);
    }

    public void RestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr restargmultipleasgninstr) {
        super.RestArgMultipleAsgnInstr(restargmultipleasgninstr);
    }

    public void ReturnInstr(ReturnInstr returninstr) {
        this.visit(returninstr.getReturnValue());
        this.jvm.method().returnValue();
    }

    public void SearchConstInstr(SearchConstInstr searchconstinstr) {
        this.jvm.method().loadLocal(0);
        this.visit(searchconstinstr.getStartingScope());
        this.jvm.method().searchConst(searchconstinstr.getConstName());
        this.jvm.method().storeLocal(this.jvm.methodData().local(searchconstinstr.getResult()));
    }

    public void SetReturnAddressInstr(SetReturnAddressInstr setreturnaddressinstr) {
        super.SetReturnAddressInstr(setreturnaddressinstr);
    }

    public void StoreLocalVarInstr(StoreLocalVarInstr storelocalvarinstr) {
        this.jvm.method().loadLocal(this.jvm.methodData().local(DYNAMIC_SCOPE));
        int depth = storelocalvarinstr.getLocalVar().getScopeDepth();
        int location = storelocalvarinstr.getLocalVar().getLocation() - 1;
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        storelocalvarinstr.getValue().visit(this);
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        this.jvm.method().adapter.pop();
                        return;
                    }
                    case 1: {
                        storelocalvarinstr.getValue().visit(this);
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        this.jvm.method().adapter.pop();
                        return;
                    }
                    case 2: {
                        storelocalvarinstr.getValue().visit(this);
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        this.jvm.method().adapter.pop();
                        return;
                    }
                    case 3: {
                        storelocalvarinstr.getValue().visit(this);
                        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        this.jvm.method().adapter.pop();
                        return;
                    }
                }
                storelocalvarinstr.getValue().visit(this);
                this.jvm.method().adapter.pushInt(location);
                this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Integer.TYPE));
                this.jvm.method().adapter.pop();
                return;
            }
        }
        this.jvm.method().adapter.pushInt(depth);
        storelocalvarinstr.getValue().visit(this);
        this.jvm.method().adapter.pushInt(location);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class, Integer.TYPE));
        this.jvm.method().adapter.pop();
    }

    public void ThreadPollInstr(ThreadPollInstr threadpollinstr) {
        this.jvm.method().poll();
    }

    public void ThrowExceptionInstr(ThrowExceptionInstr throwexceptioninstr) {
    }

    public void ToAryInstr(ToAryInstr toaryinstr) {
        super.ToAryInstr(toaryinstr);
    }

    public void UndefMethodInstr(UndefMethodInstr undefmethodinstr) {
        super.UndefMethodInstr(undefmethodinstr);
    }

    public void UnresolvedSuperInstr(UnresolvedSuperInstr unresolvedsuperinstr) {
        super.UnresolvedSuperInstr(unresolvedsuperinstr);
    }

    public void YieldInstr(YieldInstr yieldinstr) {
        this.visit(yieldinstr.getBlockArg());
        this.jvm.method().loadLocal(0);
        if (yieldinstr.getYieldArg() == UndefinedValue.UNDEFINED) {
            this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Block.class), "yieldSpecific", CodegenUtils.sig(IRubyObject.class, ThreadContext.class));
        } else {
            this.visit(yieldinstr.getYieldArg());
            this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
        this.jvm.method().storeLocal(this.jvm.methodData().local(yieldinstr.getResult()));
    }

    public void ZSuperInstr(ZSuperInstr zsuperinstr) {
        super.ZSuperInstr(zsuperinstr);
    }

    public void BackrefIsMatchDataInstr(BackrefIsMatchDataInstr backrefismatchdatainstr) {
        super.BackrefIsMatchDataInstr(backrefismatchdatainstr);
    }

    public void ClassVarIsDefinedInstr(ClassVarIsDefinedInstr classvarisdefinedinstr) {
        super.ClassVarIsDefinedInstr(classvarisdefinedinstr);
    }

    public void GetBackrefInstr(GetBackrefInstr getbackrefinstr) {
        super.GetBackrefInstr(getbackrefinstr);
    }

    public void GetDefinedConstantOrMethodInstr(GetDefinedConstantOrMethodInstr getdefinedconstantormethodinstr) {
        super.GetDefinedConstantOrMethodInstr(getdefinedconstantormethodinstr);
    }

    public void GetErrorInfoInstr(GetErrorInfoInstr geterrorinfoinstr) {
        super.GetErrorInfoInstr(geterrorinfoinstr);
    }

    public void GlobalIsDefinedInstr(GlobalIsDefinedInstr globalisdefinedinstr) {
        super.GlobalIsDefinedInstr(globalisdefinedinstr);
    }

    public void HasInstanceVarInstr(HasInstanceVarInstr hasinstancevarinstr) {
        this.jvm.method().pushRuntime();
        this.visit(hasinstancevarinstr.getObject());
        this.jvm.method().adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        this.jvm.method().adapter.ldc(hasinstancevarinstr.getName().string);
        this.jvm.method().adapter.invokeinterface(CodegenUtils.p(InstanceVariables.class), "hasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, String.class));
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newBoolean", CodegenUtils.sig(RubyBoolean.class, Boolean.TYPE));
        this.jvm.method().storeLocal(this.jvm.methodData().local(hasinstancevarinstr.getResult()));
    }

    public void IsMethodBoundInstr(IsMethodBoundInstr ismethodboundinstr) {
        super.IsMethodBoundInstr(ismethodboundinstr);
    }

    public void MethodDefinedInstr(MethodDefinedInstr methoddefinedinstr) {
        super.MethodDefinedInstr(methoddefinedinstr);
    }

    public void MethodIsPublicInstr(MethodIsPublicInstr methodispublicinstr) {
        super.MethodIsPublicInstr(methodispublicinstr);
    }

    public void RestoreErrorInfoInstr(RestoreErrorInfoInstr restoreerrorinfoinstr) {
        super.RestoreErrorInfoInstr(restoreerrorinfoinstr);
    }

    public void SetWithinDefinedInstr(SetWithinDefinedInstr setwithindefinedinstr) {
        super.SetWithinDefinedInstr(setwithindefinedinstr);
    }

    public void SuperMethodBoundInstr(SuperMethodBoundInstr supermethodboundinstr) {
        super.SuperMethodBoundInstr(supermethodboundinstr);
    }

    public void ReceiveOptArgInstr18(ReceiveOptArgInstr18 receiveoptarginstr) {
        super.ReceiveOptArgInstr18(receiveoptarginstr);
    }

    public void ReceiveRestArgInstr18(ReceiveRestArgInstr18 receiverestarginstr) {
        super.ReceiveRestArgInstr18(receiverestarginstr);
    }

    public void BuildLambdaInstr(BuildLambdaInstr buildlambdainstr) {
        super.BuildLambdaInstr(buildlambdainstr);
    }

    public void GetEncodingInstr(GetEncodingInstr getencodinginstr) {
        super.GetEncodingInstr(getencodinginstr);
    }

    public void ReceiveOptArgInstr19(ReceiveOptArgInstr19 receiveoptarginstr) {
        super.ReceiveOptArgInstr19(receiveoptarginstr);
    }

    public void ReceivePostReqdArgInstr(ReceivePostReqdArgInstr receivepostreqdarginstr) {
        super.ReceivePostReqdArgInstr(receivepostreqdarginstr);
    }

    public void ReceiveRestArgInstr19(ReceiveRestArgInstr19 receiverestarginstr) {
        super.ReceiveRestArgInstr19(receiverestarginstr);
    }

    public void Array(Array array) {
        this.jvm.method().loadLocal(0);
        for (Operand operand : array.getElts()) {
            this.visit(operand);
        }
        this.jvm.method().array(array.getElts().length);
    }

    public void AsString(AsString asstring) {
        super.AsString(asstring);
    }

    public void Backref(Backref backref) {
        super.Backref(backref);
    }

    public void BacktickString(BacktickString backtickstring) {
        super.BacktickString(backtickstring);
    }

    public void Bignum(Bignum bignum) {
        super.Bignum(bignum);
    }

    public void BooleanLiteral(BooleanLiteral booleanliteral) {
        this.jvm.method().pushBoolean(booleanliteral.isTrue());
    }

    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        super.ClosureLocalVariable(closurelocalvariable);
    }

    public void CompoundArray(CompoundArray compoundarray) {
        super.CompoundArray(compoundarray);
    }

    public void CompoundString(CompoundString compoundstring) {
        super.CompoundString(compoundstring);
    }

    public void CurrentScope(CurrentScope currentscope) {
        this.jvm.method().adapter.aload(1);
    }

    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        super.DynamicSymbol(dynamicsymbol);
    }

    public void Fixnum(Fixnum fixnum) {
        this.jvm.method().push(fixnum.getValue());
    }

    public void Float(Float flote) {
        super.Float(flote);
    }

    public void GlobalVariable(GlobalVariable globalvariable) {
        super.GlobalVariable(globalvariable);
    }

    public void Hash(Hash hash2) {
        super.Hash(hash2);
    }

    public void IRException(IRException irexception) {
        super.IRException(irexception);
    }

    public void Label(Label label) {
        super.Label(label);
    }

    public void LocalVariable(LocalVariable localvariable) {
        super.LocalVariable(localvariable);
    }

    public void MethAddr(MethAddr methaddr) {
        super.MethAddr(methaddr);
    }

    public void MethodHandle(MethodHandle methodhandle) {
        super.MethodHandle(methodhandle);
    }

    public void Nil(Nil nil) {
        this.jvm.method().pushNil();
    }

    public void NthRef(NthRef nthref) {
        super.NthRef(nthref);
    }

    public void ObjectClass(ObjectClass objectclass) {
        this.jvm.method().pushObjectClass();
    }

    public void Range(Range range) {
        super.Range(range);
    }

    public void Regexp(Regexp regexp2) {
        super.Regexp(regexp2);
    }

    public void ScopeModule(ScopeModule scopemodule) {
        this.jvm.method().adapter.aload(1);
        this.jvm.method().adapter.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    public void Self(Self self) {
        super.Self(self);
    }

    public void Splat(Splat splat) {
        super.Splat(splat);
    }

    public void StandardError(StandardError standarderror) {
        super.StandardError(standarderror);
    }

    public void StringLiteral(StringLiteral stringliteral) {
        this.jvm.method().push(stringliteral.getByteList());
    }

    public void SValue(SValue svalue) {
        super.SValue(svalue);
    }

    public void Symbol(Symbol symbol) {
        this.jvm.method().push(symbol.getName());
    }

    public void TemporaryClosureVariable(TemporaryClosureVariable temporaryclosurevariable) {
        super.TemporaryClosureVariable(temporaryclosurevariable);
    }

    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.jvm.method().loadLocal(this.jvm.methodData().local(temporaryvariable));
    }

    public void UndefinedValue(UndefinedValue undefinedvalue) {
        this.jvm.method().pushUndefined();
    }

    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
        super.UnexecutableNil(unexecutablenil);
    }

    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        super.WrappedIRClosure(wrappedirclosure);
    }
}

