/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetClassVarContainerModuleInstr
extends Instr
implements ResultInstr {
    private Operand startingScope;
    private Operand object;
    private Variable result;

    public GetClassVarContainerModuleInstr(Variable result2, Operand startingScope, Operand object) {
        super(Operation.CLASS_VAR_MODULE);
        assert (result2 != null);
        this.startingScope = startingScope;
        this.object = object;
        this.result = result2;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new GetClassVarContainerModuleInstr(ii.getRenamedVariable(this.result), this.startingScope.cloneForInlining(ii), this.object == null ? null : this.object.cloneForInlining(ii));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.startingScope + ", " + this.object + ")";
    }

    @Override
    public Operand[] getOperands() {
        Operand[] operandArray;
        if (this.object == null) {
            Operand[] operandArray2 = new Operand[1];
            operandArray = operandArray2;
            operandArray2[0] = this.startingScope;
        } else {
            Operand[] operandArray3 = new Operand[2];
            operandArray3[0] = this.startingScope;
            operandArray = operandArray3;
            operandArray3[1] = this.object;
        }
        return operandArray;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.startingScope = this.startingScope.getSimplifiedOperand(valueMap, force);
        if (this.object != null) {
            this.object = this.object.getSimplifiedOperand(valueMap, force);
        }
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        StaticScope scope;
        Ruby runtime = context.getRuntime();
        RubyModule rubyClass = scope.getModule();
        for (scope = (StaticScope)this.startingScope.retrieve(context, self, currDynScope, temp); scope != null && (rubyClass.isSingleton() || rubyClass == runtime.getDummy()); scope = scope.getPreviousCRefScope()) {
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        if (scope == null && this.object != null) {
            IRubyObject arg2 = (IRubyObject)this.object.retrieve(context, self, currDynScope, temp);
            rubyClass = arg2.getMetaClass();
        }
        if (rubyClass == null) {
            throw context.getRuntime().newTypeError("no class/module to define class variable");
        }
        return rubyClass;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GetClassVarContainerModuleInstr(this);
    }
}

