/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jnr.constants.platform.Fcntl;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.EncodingOption;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.SelectBlob;
import org.jruby.util.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject {
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };
    private static String vendor;
    private static String msgEINTR;
    private static final ByteList NIL_BYTELIST;
    private static final ByteList RECURSIVE_BYTELIST;
    private static final Set<String> UNSUPPORTED_SPAWN_OPTIONS;
    private static final Set<String> ALL_SPAWN_OPTIONS;
    protected OpenFile openFile;
    protected List<RubyThread> blockingThreads;
    protected Encoding externalEncoding;
    protected Encoding internalEncoding;
    protected boolean popenSpecial;

    public RubyIO(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        this(runtime, outputStream, true);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream, boolean autoclose2) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(Channels.newChannel(outputStream)), autoclose2));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(Channels.newChannel(inputStream))));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
    }

    public RubyIO(Ruby runtime, Channel channel) {
        super(runtime, runtime.getIO());
        if (channel == null) {
            throw runtime.newRuntimeError("Opening null channelpo");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime, new ChannelDescriptor(channel)));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
    }

    public RubyIO(Ruby runtime, ShellLauncher.POpenProcess process, IOOptions ioOptions) {
        this(runtime, runtime.getIO(), process, null, ioOptions);
    }

    public RubyIO(Ruby runtime, RubyClass cls, ShellLauncher.POpenProcess process, RubyHash options2, IOOptions ioOptions) {
        super(runtime, cls);
        ioOptions = this.updateIOOptionsFromOptions(runtime.getCurrentContext(), options2, ioOptions);
        this.setEncodingFromOptions(ioOptions.getEncodingOption());
        this.openFile = new OpenFile();
        this.openFile.setMode(ioOptions.getModeFlags().getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        try {
            if (this.openFile.isReadable()) {
                ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
                ChannelDescriptor main2 = new ChannelDescriptor(inChannel);
                main2.setCanBeSeekable(false);
                this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), main2));
            }
            if (this.openFile.isWritable() && process.hasOutput()) {
                WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
                ChannelDescriptor pipe2 = new ChannelDescriptor(outChannel);
                pipe2.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(ChannelStream.open(this.getRuntime(), pipe2));
                } else {
                    this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), pipe2));
                }
            }
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    public RubyIO(Ruby runtime, STDIO stdio) {
        super(runtime, runtime.getIO());
        this.openFile = new OpenFile();
        switch (stdio) {
            case IN: {
                ChannelDescriptor descriptor = new ChannelDescriptor(runtime.getIn(), RubyIO.newModeFlags(runtime, ModeFlags.RDONLY), FileDescriptor.in);
                runtime.putFilenoMap(0, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                break;
            }
            case OUT: {
                ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime.getOut()), RubyIO.newModeFlags(runtime, ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.out);
                runtime.putFilenoMap(1, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                this.openFile.getMainStream().setSync(true);
                break;
            }
            case ERR: {
                ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime.getErr()), RubyIO.newModeFlags(runtime, ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.err);
                runtime.putFilenoMap(2, descriptor.getFileno());
                Stream mainStream = ChannelStream.open(runtime, descriptor);
                this.openFile.setMainStream(mainStream);
                this.openFile.getMainStream().setSync(true);
            }
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.openFile.setAutoclose(false);
    }

    public static RubyIO newIO(Ruby runtime, Channel channel) {
        return new RubyIO(runtime, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    @Override
    public int getNativeTypeIndex() {
        return 26;
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        ioClass.index = 31;
        ioClass.setReifiedClass(RubyIO.class);
        ioClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.setConstant("SEEK_SET", runtime.newFixnum(0));
        ioClass.setConstant("SEEK_CUR", runtime.newFixnum(1));
        ioClass.setConstant("SEEK_END", runtime.newFixnum(2));
        if (runtime.is1_9()) {
            ioClass.defineModuleUnder("WaitReadable");
            ioClass.defineModuleUnder("WaitWritable");
        }
        return ioClass;
    }

    public OutputStream getOutStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newOutputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public InputStream getInStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newInputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public Channel getChannel() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().getChannel();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @Deprecated
    public Stream getHandler() throws BadDescriptorException {
        return this.getOpenFileChecked().getMainStreamSafe();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reopenPath(Ruby runtime, IRubyObject[] args2) {
        if (runtime.is1_9() && !(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(runtime.getCurrentContext(), "to_path");
        }
        RubyString pathString = args2[0].convertToString();
        try {
            IOOptions modes;
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.newIOOptions(runtime, ((Object)modeString).toString());
                this.openFile.setMode(modes.getModeFlags().getOpenFileFlags());
            } else {
                modes = RubyIO.newIOOptions(runtime, "r");
            }
            String path2 = ((Object)pathString).toString();
            this.openFile.setPath(path2);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(runtime, path2, modes.getModeFlags()));
                }
                catch (FileExistsException fee) {
                    throw runtime.newErrnoEEXISTError(path2);
                }
                if (this.openFile.getPipeStream() == null) return;
                this.openFile.getPipeStream().fclose();
                this.openFile.setPipeStream(null);
                return;
            }
            this.openFile.getMainStreamSafe().freopen(runtime, path2, RubyIO.newIOOptions(runtime, this.openFile.getModeAsString(runtime)).getModeFlags());
            if (this.openFile.getPipeStream() == null) return;
        }
        catch (PipeException pe) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime.newErrnoEINVALError();
        }
    }

    protected void reopenIO(Ruby runtime, RubyIO ios) {
        try {
            if (ios.openFile == this.openFile) {
                return;
            }
            OpenFile origFile = ios.getOpenFileChecked();
            OpenFile selfFile = this.getOpenFileChecked();
            long pos2 = 0L;
            Stream origStream = origFile.getMainStreamSafe();
            ChannelDescriptor origDescriptor = origStream.getDescriptor();
            boolean origIsSeekable = origDescriptor.isSeekable();
            if (origFile.isReadable() && origIsSeekable) {
                pos2 = origFile.getMainStreamSafe().fgetpos();
            }
            if (origFile.getPipeStream() != null) {
                origFile.getPipeStream().fflush();
            } else if (origFile.isWritable()) {
                origStream.fflush();
            }
            if (selfFile.isWritable()) {
                selfFile.getWriteStreamSafe().fflush();
            }
            selfFile.setMode(origFile.getMode());
            selfFile.setProcess(origFile.getProcess());
            selfFile.setLineNumber(origFile.getLineNumber());
            selfFile.setPath(origFile.getPath());
            selfFile.setFinalizer(origFile.getFinalizer());
            Stream selfStream = selfFile.getMainStreamSafe();
            ChannelDescriptor selfDescriptor = selfFile.getMainStreamSafe().getDescriptor();
            boolean selfIsSeekable = selfDescriptor.isSeekable();
            if (selfDescriptor.getChannel() != origDescriptor.getChannel()) {
                if (runtime.getFileno(selfDescriptor) >= 0 && runtime.getFileno(selfDescriptor) <= 2) {
                    selfFile.getMainStreamSafe().clearerr();
                    origDescriptor.dup2Into(selfDescriptor);
                } else {
                    Stream pipeFile = selfFile.getPipeStream();
                    int mode2 = selfFile.getMode();
                    selfFile.getMainStreamSafe().fclose();
                    selfFile.setPipeStream(null);
                    if (pipeFile != null) {
                        selfFile.setMainStream(ChannelStream.fdopen(runtime, origDescriptor, origDescriptor.getOriginalModes()));
                        selfFile.setPipeStream(pipeFile);
                    } else {
                        selfFile.setMainStream(ChannelStream.open(runtime, origDescriptor.dup2(selfDescriptor.getFileno())));
                        selfFile.getMainStreamSafe().setSync(selfFile.getMainStreamSafe().isSync());
                    }
                    selfFile.setMode(mode2);
                }
                if (origFile.isReadable() && pos2 >= 0L) {
                    if (selfIsSeekable) {
                        selfFile.seek(pos2, 0);
                    }
                    if (origIsSeekable) {
                        origFile.seek(pos2, 0);
                    }
                }
            }
            if (selfFile.getPipeStream() != null && selfDescriptor.getFileno() != selfFile.getPipeStream().getDescriptor().getFileno()) {
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (origFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                } else if (fd != origFile.getPipeStream().getDescriptor().getFileno()) {
                    selfFile.getPipeStream().fclose();
                    ChannelDescriptor newFD2 = origFile.getPipeStream().getDescriptor().dup2(fd);
                    selfFile.setPipeStream(ChannelStream.fdopen(runtime, newFD2, RubyIO.newIOOptions(runtime, "w").getModeFlags()));
                }
            }
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (PipeException ex) {
            ex.printStackTrace();
            throw runtime.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.getRuntime();
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime.getIO(), "to_io");
        if (!tmp.isNil()) {
            this.reopenIO(runtime, (RubyIO)tmp);
        } else {
            this.reopenPath(runtime, args2);
        }
        return this;
    }

    @Deprecated
    public static ModeFlags getIOModes(Ruby runtime, String modesString) {
        return RubyIO.newModeFlags(runtime, modesString);
    }

    @Deprecated
    public static int getIOModesIntFromString(Ruby runtime, String modesString) {
        try {
            return ModeFlags.getOFlagsFromString(modesString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode");
        }
    }

    private ByteList separator(Ruby runtime) {
        return this.separator(runtime, runtime.getRecordSeparatorVar().get());
    }

    private ByteList separator(Ruby runtime, IRubyObject separatorValue) {
        ByteList separator;
        ByteList byteList = separator = separatorValue.isNil() ? null : separatorValue.convertToString().getByteList();
        if (separator != null) {
            Encoding internal;
            if (separator.getRealSize() == 0) {
                separator = Stream.PARAGRAPH_DELIMETER;
            }
            if (runtime.is1_9() && (internal = this.getInternalEncoding(runtime)) != null) {
                separator = RubyString.transcode(runtime.getCurrentContext(), separator, internal, this.getExternalEncoding(runtime), runtime.getNil());
            }
        }
        return separator;
    }

    private ByteList getSeparatorFromArgs(Ruby runtime, IRubyObject[] args2, int idx) {
        return this.separator(runtime, args2.length > idx ? args2[idx] : runtime.getRecordSeparatorVar().get());
    }

    private ByteList getSeparatorForGets(Ruby runtime, IRubyObject[] args2) {
        return this.getSeparatorFromArgs(runtime, args2, 0);
    }

    private IRubyObject getline(Ruby runtime, ByteList separator, ByteListCache cache) {
        return this.getline(runtime, separator, -1L, cache);
    }

    public IRubyObject getline(Ruby runtime, ByteList separator) {
        return this.getline(runtime, separator, -1L, null);
    }

    public IRubyObject getline(Ruby runtime, ByteList separator, long limit2) {
        return this.getline(runtime, separator, limit2, null);
    }

    private IRubyObject getline(Ruby runtime, ByteList separator, long limit2, ByteListCache cache) {
        Encoding external;
        Encoding internal;
        IRubyObject result2 = this.getlineInner(runtime, separator, limit2, cache);
        if (runtime.is1_9() && !result2.isNil() && (internal = this.internalEncoding) != (external = this.externalEncoding)) {
            ByteList transcoded = RubyString.transcode(runtime.getCurrentContext(), ((RubyString)result2).getByteList(), external, internal, runtime.getNil());
            RubyString newResult = RubyString.newStringNoCopy(runtime, transcoded);
            newResult.infectBy(result2);
            result2 = newResult;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject getlineInner(Ruby runtime, ByteList separator, long limit2, ByteListCache cache) {
        try {
            RubyString rubyString;
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = isParagraph ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null && limit2 < 0L) {
                RubyString str = this.readAll();
                if (str.getByteList().length() == 0) {
                    return runtime.getNil();
                }
                this.incrementLineno(runtime, myOpenFile);
                return str;
            }
            if (limit2 == 0L) {
                if (runtime.is1_9()) {
                    return RubyString.newEmptyString(runtime, this.externalEncoding);
                }
                return RubyString.newEmptyString(runtime);
            }
            if (separator != null && separator.length() == 1 && limit2 < 0L) {
                return this.getlineFast(runtime, separator.get(0) & 0xFF, cache);
            }
            Stream readStream = myOpenFile.getMainStreamSafe();
            int c = -1;
            int n = -1;
            int newline = separator != null ? separator.get(separator.length() - 1) & 0xFF : -1;
            ByteList buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                boolean update2 = false;
                boolean limitReached = false;
                while (true) {
                    block28: {
                        block32: {
                            block31: {
                                block30: {
                                    Object var17_22;
                                    this.readCheck(readStream);
                                    readStream.clearerr();
                                    try {
                                        try {
                                            runtime.getCurrentContext().getThread().beforeBlockingCall();
                                            if (limit2 == -1L) {
                                                n = readStream.getline(buf, (byte)newline);
                                            } else if ((limit2 -= (long)(n = readStream.getline(buf, (byte)newline, limit2))) <= 0L) {
                                                limitReached = true;
                                                update2 = true;
                                                var17_22 = null;
                                                runtime.getCurrentContext().getThread().afterBlockingCall();
                                                break block28;
                                            }
                                            c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                                        }
                                        catch (EOFException e) {
                                            n = -1;
                                            var17_22 = null;
                                            runtime.getCurrentContext().getThread().afterBlockingCall();
                                            break block30;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var17_22 = null;
                                        runtime.getCurrentContext().getThread().afterBlockingCall();
                                        throw throwable;
                                    }
                                    var17_22 = null;
                                    runtime.getCurrentContext().getThread().afterBlockingCall();
                                }
                                if (n != 0) break block31;
                                this.waitReadable(readStream);
                                break block32;
                            }
                            if (n == -1) break block28;
                            update2 = true;
                        }
                        if (c != newline) continue;
                    }
                    if (n == -1 || limitReached || c == newline && separator != null && buf.length() >= separator.length() && 0 == ByteList.memcmp((byte[])buf.getUnsafeBytes(), (int)(buf.getBegin() + buf.getRealSize() - separator.length()), (byte[])separator.getUnsafeBytes(), (int)separator.getBegin(), (int)separator.getRealSize())) break;
                }
                if (isParagraph && c != -1) {
                    this.swallow(10);
                }
                if (!update2) {
                    IRubyObject iRubyObject = runtime.getNil();
                    Object var19_24 = null;
                    if (cache == null) return iRubyObject;
                    cache.release(buf);
                    return iRubyObject;
                }
                this.incrementLineno(runtime, myOpenFile);
                rubyString = this.makeString(runtime, buf, cache != null);
            }
            catch (Throwable throwable) {
                Object var19_26 = null;
                if (cache != null) {
                    cache.release(buf);
                }
                throw throwable;
            }
            Object var19_25 = null;
            if (cache == null) return rubyString;
            cache.release(buf);
            return rubyString;
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    private Encoding getExternalEncoding(Ruby runtime) {
        return this.externalEncoding != null ? this.externalEncoding : runtime.getDefaultExternalEncoding();
    }

    private Encoding getInternalEncoding(Ruby runtime) {
        return this.internalEncoding != null ? this.internalEncoding : runtime.getDefaultInternalEncoding();
    }

    private RubyString makeString(Ruby runtime, ByteList buffer, boolean isCached) {
        ByteList newBuf;
        ByteList byteList = newBuf = isCached ? new ByteList(buffer) : buffer;
        if (runtime.is1_9()) {
            newBuf.setEncoding(this.getExternalEncoding(runtime));
        }
        RubyString str = RubyString.newString(runtime, newBuf);
        str.setTaint(true);
        return str;
    }

    private void incrementLineno(Ruby runtime, OpenFile myOpenFile) {
        int lineno2 = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno2);
        runtime.setCurrentLine(lineno2);
        RubyArgsFile.setCurrentLineNumber(runtime.getArgsFile(), lineno2);
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStreamSafe();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public static boolean restartSystemCall(Exception e) {
        return vendor.startsWith("Apple") && e.getMessage().equals(msgEINTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getlineFast(Ruby runtime, int delim, ByteListCache cache) throws IOException, BadDescriptorException {
        ByteList buf;
        block12: {
            Stream readStream = this.openFile.getMainStreamSafe();
            int c = -1;
            buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                boolean update2 = false;
                do {
                    Object var11_12;
                    int n;
                    this.readCheck(readStream);
                    readStream.clearerr();
                    try {
                        try {
                            runtime.getCurrentContext().getThread().beforeBlockingCall();
                            n = readStream.getline(buf, (byte)delim);
                            c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                        }
                        catch (EOFException e) {
                            n = -1;
                            var11_12 = null;
                            runtime.getCurrentContext().getThread().afterBlockingCall();
                        }
                        var11_12 = null;
                        runtime.getCurrentContext().getThread().afterBlockingCall();
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        runtime.getCurrentContext().getThread().afterBlockingCall();
                        throw throwable;
                    }
                    if (n == 0) {
                        this.waitReadable(readStream);
                        continue;
                    }
                    if (n == -1) break;
                    update2 = true;
                } while (c != delim);
                if (update2) break block12;
                IRubyObject iRubyObject = runtime.getNil();
                Object var13_14 = null;
                if (cache != null) {
                    cache.release(buf);
                }
                return iRubyObject;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var13_16 = null;
                    if (cache == null) break block13;
                    cache.release(buf);
                }
                throw throwable;
            }
        }
        this.incrementLineno(runtime, this.openFile);
        RubyString rubyString = this.makeString(runtime, buf, cache != null);
        Object var13_15 = null;
        if (cache != null) {
            cache.release(buf);
        }
        return rubyString;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            String className = klass.getName();
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead");
        }
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon19(ThreadContext context, int fileno2, IRubyObject options2, IOOptions ioOptions) {
        Ruby runtime = context.runtime;
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(runtime.getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            descriptor.checkOpen();
            if (options2 != null && !(options2 instanceof RubyHash)) {
                throw context.runtime.newTypeError(options2, runtime.getHash());
            }
            if (ioOptions == null) {
                ioOptions = RubyIO.newIOOptions(runtime, descriptor.getOriginalModes());
            }
            ioOptions = this.updateIOOptionsFromOptions(context, (RubyHash)options2, ioOptions);
            this.setEncodingFromOptions(ioOptions.getEncodingOption());
            if (ioOptions == null) {
                ioOptions = RubyIO.newIOOptions(runtime, descriptor.getOriginalModes());
            }
            if (this.openFile.isOpen()) {
                this.openFile.cleanup(runtime, false);
            }
            this.openFile.setMode(ioOptions.getModeFlags().getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, ioOptions.getModeFlags()));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, Block unused2) {
        return this.initializeCommon19(context, RubyNumeric.fix2int(fileNumber), null, null);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject second, Block unused2) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        IOOptions ioOptions = null;
        RubyHash options2 = null;
        if (second instanceof RubyHash) {
            options2 = (RubyHash)second;
        } else {
            ioOptions = this.parseIOOptions19(second);
        }
        return this.initializeCommon19(context, fileno2, options2, ioOptions);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unused2) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        IOOptions ioOptions = this.parseIOOptions19(modeValue);
        return this.initializeCommon19(context, fileno2, options2, ioOptions);
    }

    protected IOOptions parseIOOptions(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return RubyIO.newIOOptions(runtime, (int)RubyFixnum.fix2long(arg2));
        }
        return RubyIO.newIOOptions(runtime, RubyIO.newModeFlags(runtime, arg2.convertToString().toString()));
    }

    protected IOOptions parseIOOptions19(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return RubyIO.newIOOptions(runtime, (int)RubyFixnum.fix2long(arg2));
        }
        String modeString = arg2.convertToString().toString();
        try {
            return new IOOptions(runtime, modeString);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("invalid access mode " + modeString);
        }
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        int argCount = args2.length;
        int fileno2 = RubyNumeric.fix2int(args2[0]);
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(runtime.getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            descriptor.checkOpen();
            IOOptions ioOptions = argCount == 2 ? (args2[1] instanceof RubyFixnum ? RubyIO.newIOOptions(runtime, RubyFixnum.fix2long(args2[1])) : RubyIO.newIOOptions(runtime, args2[1].convertToString().toString())) : RubyIO.newIOOptions(runtime, descriptor.getOriginalModes());
            if (this.openFile.isOpen()) {
                this.openFile.cleanup(runtime, false);
            }
            this.openFile.setMode(ioOptions.getModeFlags().getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, ioOptions.getModeFlags()));
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) {
        Ruby runtime = this.getRuntime();
        if (existingDescriptor == null) {
            throw runtime.newErrnoEBADFError();
        }
        try {
            return ChannelStream.fdopen(runtime, existingDescriptor, modes);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject external_encoding(ThreadContext context) {
        return this.externalEncoding != null ? context.getRuntime().getEncodingService().getEncoding(this.externalEncoding) : context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject internal_encoding(ThreadContext context) {
        return this.internalEncoding != null ? context.getRuntime().getEncodingService().getEncoding(this.internalEncoding) : context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingObj) {
        if (encodingObj instanceof RubyString) {
            EncodingOption encodingOption = EncodingOption.getEncodingOptionFromString(context.runtime, encodingObj.convertToString().toString());
            this.setEncodingFromOptions(encodingOption);
        } else {
            this.setExternalEncoding(context, encodingObj);
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        this.setExternalEncoding(context, encodingString);
        this.setInternalEncoding(context, internalEncoding);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        this.setExternalEncoding(context, encodingString);
        this.setInternalEncoding(context, internalEncoding);
        return context.getRuntime().getNil();
    }

    private void setExternalEncoding(ThreadContext context, IRubyObject encoding2) {
        this.externalEncoding = RubyIO.getEncodingCommon(context, encoding2);
    }

    private void setInternalEncoding(ThreadContext context, IRubyObject encoding2) {
        Encoding internalEncodingOption = RubyIO.getEncodingCommon(context, encoding2);
        if (internalEncodingOption == this.externalEncoding) {
            context.getRuntime().getWarnings().warn("Ignoring internal encoding " + encoding2 + ": it is identical to external encoding " + this.external_encoding(context));
        } else {
            this.internalEncoding = internalEncodingOption;
        }
    }

    private static Encoding getEncodingCommon(ThreadContext context, IRubyObject encoding2) {
        if (encoding2 instanceof RubyEncoding) {
            return ((RubyEncoding)encoding2).getEncoding();
        }
        return context.getRuntime().getEncodingService().getEncodingFromObject(encoding2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        RubyClass klass = (RubyClass)recv2;
        RubyIO io2 = (RubyIO)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            IRubyObject iRubyObject;
            block8: {
                try {
                    iRubyObject = block.yield(context, io2);
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var9_9 = null;
                        try {
                            io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                        }
                        catch (RaiseException re) {
                            RubyException rubyEx = re.getException();
                            if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                                runtime.getGlobalVariables().clear("$!");
                                break block9;
                            }
                            throw re;
                        }
                    }
                    throw throwable;
                }
                try {
                    io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                }
                catch (RaiseException re) {
                    RubyException rubyEx = re.getException();
                    if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                        runtime.getGlobalVariables().clear("$!");
                        break block8;
                    }
                    throw re;
                }
            }
            return iRubyObject;
        }
        return io2;
    }

    @JRubyMethod(required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        StringSupport.checkStringSafety(recv2.getRuntime(), args2[0]);
        RubyString pathString = args2[0].convertToString();
        return RubyIO.sysopenCommon(recv2, args2, block, pathString);
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject sysopen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        StringSupport.checkStringSafety(context.getRuntime(), args2[0]);
        IRubyObject pathString = !(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path") ? args2[0].callMethod(context, "to_path") : args2[0].convertToString();
        return RubyIO.sysopenCommon(recv2, args2, block, pathString);
    }

    private static IRubyObject sysopenCommon(IRubyObject recv2, IRubyObject[] args2, Block block, IRubyObject pathString) {
        Ruby runtime = recv2.getRuntime();
        runtime.checkSafeString(pathString);
        String path2 = pathString.toString();
        IOOptions modes = null;
        int perms = -1;
        if (args2.length > 1) {
            RubyString modeString = args2[1].convertToString();
            modes = RubyIO.newIOOptions(runtime, ((Object)modeString).toString());
        } else {
            modes = RubyIO.newIOOptions(runtime, "r");
        }
        if (args2.length > 2) {
            RubyInteger permsInt = args2.length >= 3 ? args2[2].convertToInteger() : null;
            perms = RubyNumeric.fix2int(permsInt);
        }
        int fileno2 = -1;
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(runtime.getCurrentDirectory(), path2, modes.getModeFlags(), perms, runtime.getPosix(), runtime.getJRubyClassLoader());
            fileno2 = descriptor.getFileno();
        }
        catch (FileNotFoundException fnfe) {
            throw runtime.newErrnoENOENTError(path2);
        }
        catch (DirectoryAsFileException dafe) {
            throw runtime.newErrnoEISDirError(path2);
        }
        catch (FileExistsException fee) {
            throw runtime.newErrnoEEXISTError(path2);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return runtime.newFixnum(fileno2);
    }

    public boolean isAutoclose() {
        return this.openFile.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        this.openFile.setAutoclose(autoclose2);
    }

    @JRubyMethod
    public IRubyObject autoclose(ThreadContext context) {
        return context.runtime.newBoolean(this.isAutoclose());
    }

    @JRubyMethod(name={"autoclose="})
    public IRubyObject autoclose_set(ThreadContext context, IRubyObject autoclose2) {
        this.setAutoclose(autoclose2.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        if (this.isClosed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
        Ruby runtime = this.getRuntime();
        if (this.getExternalEncoding(runtime) == USASCIIEncoding.INSTANCE) {
            this.externalEncoding = ASCIIEncoding.INSTANCE;
        }
        this.openFile.setBinmode();
        return this;
    }

    @JRubyMethod(name={"binmode?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_binmode(ThreadContext context) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.openFile.isBinmode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.getRuntime();
        try {
            try {
                RubyString string2 = obj.asString();
                OpenFile myOpenFile = this.getOpenFileChecked();
                myOpenFile.checkWritable(runtime);
                Stream writeStream = myOpenFile.getWriteStream();
                if (myOpenFile.isWriteBuffered()) {
                    runtime.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO");
                }
                if (!writeStream.getDescriptor().isWritable()) {
                    myOpenFile.checkClosed(runtime);
                }
                context.getThread().beforeBlockingCall();
                int read2 = writeStream.getDescriptor().write(string2.getByteList());
                if (read2 == -1) {
                    // empty if block
                }
                RubyFixnum rubyFixnum = runtime.newFixnum(read2);
                Object var10_12 = null;
                context.getThread().afterBlockingCall();
                return rubyFixnum;
            }
            catch (InvalidValueException ex) {
                throw runtime.newErrnoEINVALError();
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
            catch (IOException e) {
                if (e.getMessage().equals("Broken pipe")) {
                    throw runtime.newErrnoEPIPEError();
                }
                if (!e.getMessage().equals("Connection reset by peer")) throw runtime.newSystemCallError(e.getMessage());
                throw runtime.newErrnoEPIPEError();
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            context.getThread().afterBlockingCall();
            throw throwable;
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            ChannelStream stream;
            int written;
            myOpenFile.checkWritable(context.getRuntime());
            RubyString str = obj.asString();
            if (str.getByteList().length() == 0) {
                return context.getRuntime().newFixnum(0);
            }
            if (myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "write_nonblock for buffered IO");
            }
            if ((written = (stream = (ChannelStream)myOpenFile.getWriteStream()).writenonblock(str.getByteList())) == 0) {
                if (runtime.is1_9()) {
                    throw runtime.newErrnoEAGAINWritableError("");
                }
                throw runtime.newErrnoEWOULDBLOCKError();
            }
            return context.getRuntime().newFixnum(written);
        }
        catch (IOException ex) {
            throw context.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.getRuntime();
        runtime.secure(4);
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return runtime.newFixnum(0);
        }
        try {
            try {
                OpenFile myOpenFile = this.getOpenFileChecked();
                myOpenFile.checkWritable(runtime);
                context.getThread().beforeBlockingCall();
                int written = this.fwrite(str.getByteList());
                if (written == -1) {
                    // empty if block
                }
                if (!myOpenFile.isSync()) {
                    myOpenFile.setWriteBuffered();
                }
                RubyFixnum rubyFixnum = runtime.newFixnum(written);
                Object var9_11 = null;
                context.getThread().afterBlockingCall();
                return rubyFixnum;
            }
            catch (IOException ex) {
                throw runtime.newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw runtime.newErrnoEBADFError();
            }
            catch (InvalidValueException ex) {
                throw runtime.newErrnoEINVALError();
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            context.getThread().afterBlockingCall();
            throw throwable;
        }
    }

    private boolean waitWritable(Stream stream) {
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 4);
            return true;
        }
        return false;
    }

    private boolean waitReadable(Stream stream) {
        if (stream.readDataBuffered()) {
            return true;
        }
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 1);
            return true;
        }
        return false;
    }

    protected int fwrite(ByteList buffer) {
        int offset2 = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        int len = buffer.length();
        int n = len;
        if (n <= 0) {
            return n;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset2 < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer, offset2, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset2 += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream)) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset2 >= buffer.length()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            return runtime.newFixnum(runtime.getFileno(this.getOpenFileChecked().getMainStreamSafe().getDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync(ThreadContext context) {
        try {
            return context.getRuntime().newBoolean(this.getOpenFileChecked().getMainStreamSafe().isSync());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.getRuntime().getNil();
        }
        long pid2 = myOpenFile.getPid();
        return context.getRuntime().newFixnum(pid2);
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        try {
            return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStreamSafe().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject newPosition) {
        long offset2 = RubyNumeric.num2long(newPosition);
        if (offset2 < 0L) {
            throw context.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStreamSafe().lseek(offset2, 0);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return context.getRuntime().newFixnum(offset2);
    }

    @JRubyMethod(name={"print"}, rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.print(context, this, args2);
    }

    public static IRubyObject print(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getCurrentScope().getLastLine(context.getRuntime())};
        }
        Ruby runtime = context.getRuntime();
        IRubyObject fs = runtime.getGlobalVariables().get("$,");
        IRubyObject rs = runtime.getGlobalVariables().get("$\\");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (i2 > 0 && !fs.isNil()) {
                maybeIO.callMethod(context, "write", fs);
            }
            if (args2[i2].isNil()) {
                maybeIO.callMethod(context, "write", runtime.newString("nil"));
                continue;
            }
            maybeIO.callMethod(context, "write", args2[i2]);
        }
        if (!rs.isNil()) {
            maybeIO.callMethod(context, "write", rs);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args2));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        return RubyIO.putc(context, this, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject putc(ThreadContext context, IRubyObject maybeIO, IRubyObject object) {
        byte c = RubyNumeric.num2chr(object);
        if (maybeIO instanceof RubyIO) {
            RubyIO io2 = (RubyIO)maybeIO;
            try {
                OpenFile myOpenFile = io2.getOpenFileChecked();
                myOpenFile.checkWritable(context.getRuntime());
                Stream writeStream = myOpenFile.getWriteStream();
                writeStream.fputc(c);
                if (!myOpenFile.isSync()) return object;
                myOpenFile.fflush(writeStream);
                return object;
            }
            catch (IOException ex) {
                throw context.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException e) {
                throw context.getRuntime().newErrnoEBADFError();
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
        } else {
            maybeIO.callMethod(context, "write", RubyString.newStringNoCopy(context.getRuntime(), new byte[]{c}));
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = 0;
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = RubyNumeric.fix2int(arg1.convertToInteger());
        return this.doSeek(context, offset2, whence);
    }

    private RubyFixnum doSeek(ThreadContext context, long offset2, int whence) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        long pos2;
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw context.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO");
            }
            pos2 = myOpenFile.getMainStreamSafe().getDescriptor().lseek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return context.getRuntime().newFixnum(pos2);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind(ThreadContext context) {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStreamSafe().lseek(0L, 0);
            myOpenfile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime);
            Stream writeStream = myOpenFile.getWriteStream();
            writeStream.fflush();
            writeStream.sync();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        try {
            this.getOpenFileChecked().setSync(newSync.isTrue());
            this.getOpenFileChecked().getMainStreamSafe().setSync(newSync.isTrue());
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return runtime.getTrue();
            }
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                return runtime.getFalse();
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.getMainStreamSafe().clearerr();
            int c = myOpenFile.getMainStreamSafe().fgetc();
            if (c != -1) {
                myOpenFile.getMainStreamSafe().ungetc(c);
                return runtime.getFalse();
            }
            myOpenFile.checkClosed(runtime);
            myOpenFile.getMainStreamSafe().clearerr();
            return runtime.getTrue();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        try {
            return context.getRuntime().newBoolean(context.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime = this.getRuntime();
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, runtime.getIO(), "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        OpenFile newFile = this.openFile;
        try {
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStreamSafe().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStreamSafe().fflush();
            } else {
                originalFile.getMainStreamSafe().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            IOOptions modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? RubyIO.newIOOptions(runtime, ModeFlags.RDONLY) : RubyIO.newIOOptions(runtime, ModeFlags.RDWR)) : RubyIO.newIOOptions(runtime, ModeFlags.RDONLY)) : (newFile.isWritable() ? RubyIO.newIOOptions(runtime, ModeFlags.WRONLY) : RubyIO.newIOOptions(runtime, originalFile.getMainStreamSafe().getModes()));
            ChannelDescriptor descriptor = originalFile.getMainStreamSafe().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(runtime, descriptor, modes.getModeFlags()));
            newFile.getMainStream().setSync(originalFile.getMainStreamSafe().isSync());
            if (originalFile.getMainStreamSafe().isBinmode()) {
                newFile.getMainStream().setBinmode();
            }
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw runtime.newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isClosed());
    }

    public boolean isClosed() {
        return this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        Ruby runtime = this.getRuntime();
        if (runtime.getSafeLevel() >= 4 && this.isTaint()) {
            throw runtime.newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(runtime);
        return this.close2(runtime);
    }

    protected IRubyObject close2(Ruby runtime) {
        if (this.openFile == null) {
            return runtime.getNil();
        }
        this.interruptBlockingThreads();
        this.openFile.cleanup(runtime, true);
        if (!this.popenSpecial && this.openFile.getProcess() != null) {
            RubyIO.obliterateProcess(this.openFile.getProcess());
            RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime, this.openFile.getProcess().exitValue(), this.openFile.getPid());
            runtime.getCurrentContext().setLastExitStatus(processResult);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write(ThreadContext context) {
        try {
            if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw context.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw context.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            if (runtime.getSafeLevel() >= 4 && this.isTaint()) {
                throw runtime.newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw runtime.newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStreamSafe().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (BadDescriptorException bde) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        IRubyObject result2 = this.getline(runtime, this.separator(runtime, runtime.getRecordSeparatorVar().get()));
        if (!result2.isNil()) {
            context.getCurrentScope().setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context, IRubyObject separatorArg) {
        Ruby runtime = context.getRuntime();
        IRubyObject result2 = this.getline(runtime, this.separator(runtime, separatorArg));
        if (!result2.isNil()) {
            context.getCurrentScope().setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        IRubyObject result2 = this.getline(runtime, this.separator(runtime));
        if (!result2.isNil()) {
            context.getCurrentScope().setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject arg2) {
        ByteList separator;
        Ruby runtime = context.getRuntime();
        long limit2 = -1L;
        if (arg2 instanceof RubyInteger) {
            limit2 = RubyInteger.fix2long(arg2);
            separator = this.separator(runtime);
        } else {
            separator = this.separator(runtime, arg2);
        }
        IRubyObject result2 = this.getline(runtime, separator, limit2);
        if (!result2.isNil()) {
            context.getCurrentScope().setLastLine(result2);
        }
        return result2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject separator, IRubyObject limit_arg) {
        Ruby runtime = context.getRuntime();
        long limit2 = limit_arg.isNil() ? -1L : RubyNumeric.fix2long(limit_arg);
        IRubyObject result2 = this.getline(runtime, this.separator(runtime, separator), limit2);
        if (!result2.isNil()) {
            context.getCurrentScope().setLastLine(result2);
        }
        return result2;
    }

    public boolean getBlocking() {
        try {
            return ((ChannelStream)this.openFile.getMainStreamSafe()).isBlocking();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd) {
        return this.ctl(context.getRuntime(), cmd, null);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = args2.length == 2 ? args2[1] : context.getRuntime().getNil();
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    public IRubyObject ctl(Ruby runtime, IRubyObject cmd, IRubyObject arg2) {
        block12: {
            long realCmd = cmd.convertToInteger().getLongValue();
            long nArg = 0L;
            if (arg2 == null || arg2.isNil() || arg2 == runtime.getFalse()) {
                nArg = 0L;
            } else if (arg2 instanceof RubyFixnum) {
                nArg = RubyFixnum.fix2long(arg2);
            } else if (arg2 == runtime.getTrue()) {
                nArg = 1L;
            } else {
                throw runtime.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            try {
                if (realCmd == 1L) break block12;
                if (realCmd == (long)Fcntl.F_SETFL.intValue() || realCmd == (long)Fcntl.F_SETFD.intValue()) {
                    if ((nArg & 1L) != 1L) {
                        boolean block = (nArg & (long)ModeFlags.NONBLOCK) != (long)ModeFlags.NONBLOCK;
                        myOpenFile.getMainStreamSafe().setBlocking(block);
                    }
                    break block12;
                }
                if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
                    return myOpenFile.getMainStreamSafe().isBlocking() ? RubyFixnum.zero(runtime) : RubyFixnum.newFixnum(runtime, ModeFlags.NONBLOCK);
                }
                throw runtime.newNotImplementedError("JRuby only supports F_SETFL and F_GETFL with NONBLOCK for fcntl/ioctl");
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            return RubyIO.writeSeparator(context, maybeIO);
        }
        return RubyIO.putsArray(context, maybeIO, args2);
    }

    private static IRubyObject writeSeparator(ThreadContext context, IRubyObject maybeIO) {
        Ruby runtime = context.getRuntime();
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        RubyIO.write(context, maybeIO, separator.getByteList());
        return runtime.getNil();
    }

    private static IRubyObject putsArray(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime = context.getRuntime();
        assert (runtime.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime.getGlobalVariables().getDefaultSeparator();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ByteList line;
            if (args2[i2].isNil()) {
                line = RubyIO.getNilByteList(runtime);
            } else if (runtime.isInspecting(args2[i2])) {
                line = RECURSIVE_BYTELIST;
            } else {
                if (args2[i2] instanceof RubyArray) {
                    RubyIO.inspectPuts(context, maybeIO, (RubyArray)args2[i2]);
                    continue;
                }
                line = args2[i2].asString().getByteList();
            }
            RubyIO.write(context, maybeIO, line);
            if (line.length() != 0 && line.endsWith(separator.getByteList())) continue;
            RubyIO.write(context, maybeIO, separator.getByteList());
        }
        return runtime.getNil();
    }

    protected void write(ThreadContext context, ByteList byteList) {
        this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(context.getRuntime(), byteList));
    }

    protected static void write(ThreadContext context, IRubyObject maybeIO, ByteList byteList) {
        maybeIO.callMethod(context, "write", RubyString.newStringShared(context.getRuntime(), byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array) {
        try {
            context.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = RubyIO.putsArray(context, maybeIO, array.toJavaArray());
            Object var5_4 = null;
            context.getRuntime().unregisterInspecting(array);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.getRuntime().unregisterInspecting(array);
            throw throwable;
        }
    }

    @Override
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        if (!runtime.is1_9()) {
            return super.inspect();
        }
        OpenFile openFile = this.getOpenFile();
        if (openFile == null) {
            return super.inspect();
        }
        Stream stream = openFile.getMainStream();
        String className = this.getMetaClass().getRealClass().getName();
        String path2 = openFile.getPath();
        String status2 = "";
        if (path2 == null) {
            if (stream == null) {
                path2 = "";
                status2 = "(closed)";
            } else {
                path2 = "fd " + runtime.getFileno(stream.getDescriptor());
            }
        } else if (!openFile.isOpen()) {
            status2 = " (closed)";
        }
        String inspectStr = "#<" + className + ":" + path2 + status2 + ">";
        return runtime.newString(inspectStr);
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject line = this.gets(context);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject separator) {
        IRubyObject line = this.gets(context, separator);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc", "getbyte"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject getc() {
        int c = this.getcCommon();
        if (c == -1) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(c);
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject readchar19(ThreadContext context) {
        IRubyObject value2 = this.getc19(context);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte19(ThreadContext context) {
        return this.getc();
    }

    @JRubyMethod
    public IRubyObject readbyte(ThreadContext context) {
        int c = this.getcCommon();
        if (c == -1) {
            throw this.getRuntime().newEOFError();
        }
        return context.runtime.newFixnum(c);
    }

    @JRubyMethod(name={"getc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getc19(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStreamSafe();
            this.readCheck(stream);
            this.waitReadable(stream);
            stream.clearerr();
            int c = stream.fgetc();
            if (c == -1) {
                return runtime.getNil();
            }
            Encoding external = this.getExternalEncoding(runtime);
            Encoding internal = this.getInternalEncoding(runtime);
            ByteList bytes2 = null;
            boolean shared = false;
            int cr = 0;
            if (Encoding.isAscii((int)c)) {
                if (internal == ASCIIEncoding.INSTANCE) {
                    bytes2 = RubyInteger.SINGLE_CHAR_BYTELISTS[c];
                    shared = true;
                } else {
                    bytes2 = new ByteList(new byte[]{(byte)c}, external, false);
                    shared = false;
                    cr = 32;
                }
            } else {
                int len = external.length((byte)c);
                byte[] byteAry = new byte[len];
                byteAry[0] = (byte)c;
                for (int i2 = 1; i2 < len; ++i2) {
                    c = (byte)stream.fgetc();
                    if (c == -1) {
                        bytes2 = new ByteList(byteAry, 0, i2 - 1, external, false);
                        cr = 96;
                    }
                    byteAry[i2] = (byte)c;
                }
                if (bytes2 == null) {
                    cr = 64;
                    bytes2 = new ByteList(byteAry, external, false);
                }
            }
            if (cr != 96 && external != internal) {
                bytes2 = RubyString.transcode(context, bytes2, external, internal, runtime.getNil());
            }
            if (internal == null) {
                internal = external;
            }
            if (shared) {
                return RubyString.newStringShared(runtime, bytes2, cr);
            }
            return RubyString.newStringNoCopy(runtime, bytes2, internal, cr);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    public int getcCommon() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStreamSafe();
            this.readCheck(stream);
            this.waitReadable(stream);
            stream.clearerr();
            return myOpenFile.getMainStreamSafe().fgetc();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject ungetc(IRubyObject number) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        this.ungetcCommon((int)number.convertToInteger().getLongValue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject ungetc19(IRubyObject number) {
        Ruby runtime = this.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            return runtime.getNil();
        }
        if (number instanceof RubyFixnum) {
            int c = (int)number.convertToInteger().getLongValue();
            this.ungetcCommon(c);
        } else if (number instanceof RubyString) {
            RubyString str = (RubyString)number;
            if (str.isEmpty()) {
                return runtime.getNil();
            }
            int c = str.getEncoding().mbcToCode(str.getBytes(), 0, 1);
            this.ungetcCommon(c);
        } else {
            throw runtime.newTypeError(number, runtime.getFixnum());
        }
        return runtime.getNil();
    }

    public void ungetcCommon(int ch) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        RubyString str;
        IRubyObject value2 = this.getPartial(context, args2, true);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        if (value2 instanceof RubyString && (str = (RubyString)value2).isEmpty()) {
            Ruby ruby2 = context.getRuntime();
            if (ruby2.is1_9()) {
                throw ruby2.newErrnoEAGAINReadableError("");
            }
            throw ruby2.newErrnoEAGAINError("");
        }
        return value2;
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, false);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    private IRubyObject getPartial(ThreadContext context, IRubyObject[] args2, boolean isNonblocking) {
        Ruby runtime = context.getRuntime();
        int length2 = RubyNumeric.fix2int(args2[0]);
        if (length2 < 0) {
            throw runtime.newArgumentError("negative length " + length2 + " given");
        }
        IRubyObject stringArg = args2.length > 1 ? args2[1] : runtime.getNil();
        RubyString string2 = stringArg.isNil() ? RubyString.newEmptyString(runtime) : stringArg.convertToString();
        string2.empty();
        string2.setTaint(true);
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime);
            if (length2 == 0) {
                return string2;
            }
            if (!(myOpenFile.getMainStreamSafe() instanceof ChannelStream)) {
                throw runtime.newNotImplementedError("readpartial only works with Nio based handlers");
            }
            ChannelStream stream = (ChannelStream)myOpenFile.getMainStreamSafe();
            ByteList buf = null;
            if (isNonblocking) {
                buf = stream.readnonblock(length2);
            } else {
                while (!(buf != null && buf.length() != 0 || stream.feof())) {
                    this.waitReadable(stream);
                    buf = stream.readpartial(length2);
                }
            }
            boolean empty2 = buf == null || buf.length() == 0;
            ByteList newBuf = empty2 ? ByteList.EMPTY_BYTELIST.dup() : buf;
            string2.view(newBuf);
            if (stream.feof() && empty2) {
                return runtime.getNil();
            }
            return string2;
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw runtime.newEOFError(e.getMessage());
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int len = (int)RubyNumeric.num2long(args2[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args2.length == 1 || args2[1].isNil()) {
                if (len == 0) {
                    return RubyString.newEmptyString(this.getRuntime());
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args2[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    return str;
                }
                ByteList buffer = str.getByteList();
                buffer.length(0);
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStreamSafe().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            return str;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            this.synthesizeSystemCallError(e);
            return null;
        }
    }

    private void synthesizeSystemCallError(IOException e) {
        String errorMessage = e.getMessage();
        if ("File not open".equals(errorMessage)) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
            throw this.getRuntime().newErrnoECONNABORTEDError();
        }
        if ("Connection reset by peer".equals(e.getMessage()) || "An existing connection was forcibly closed by the remote host".equals(e.getMessage())) {
            throw this.getRuntime().newErrnoECONNRESETError();
        }
        throw this.getRuntime().newSystemCallError(e.getMessage());
    }

    public IRubyObject read(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args2[0]);
            }
            case 2: {
                return this.read(context, args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            return this.readAll();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        if (arg0.isNil()) {
            return this.read(context);
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        RubyString str = RubyString.newEmptyString(this.getRuntime());
        return this.readNotAll(context, myOpenFile, length2, str);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (arg0.isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                myOpenFile.setReadBuffered();
                if (arg1.isNil()) {
                    return this.readAll();
                }
                return this.readAll(arg1.convertToString());
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        if (arg1.isNil()) {
            return this.readNotAll(context, myOpenFile, length2);
        }
        return this.readNotAll(context, myOpenFile, length2, arg1.convertToString());
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2, RubyString str) {
        Ruby runtime = context.getRuntime();
        str.empty();
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime.getNil();
            }
            str.setValue(newBuffer);
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime = context.getRuntime();
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime.getNil();
            }
            RubyString str = RubyString.newString(runtime, newBuffer);
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    private ByteList readNotAllCommon(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime = context.getRuntime();
        try {
            myOpenFile.checkReadable(runtime);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return null;
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            ByteList newBuffer = this.fread(context.getThread(), length2);
            return newBuffer;
        }
        catch (EOFException ex) {
            throw runtime.newEOFError();
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
    }

    protected static boolean emptyBufferOrEOF(ByteList buffer, OpenFile myOpenFile) throws BadDescriptorException, IOException {
        if (buffer == null) {
            return true;
        }
        if (buffer.length() == 0) {
            if (myOpenFile.getMainStreamSafe() == null) {
                return true;
            }
            if (myOpenFile.getMainStreamSafe().feof()) {
                return true;
            }
        }
        return false;
    }

    protected RubyString readAll(RubyString str) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime = this.getRuntime();
        ByteList buf = this.readAllCommon(runtime);
        if (buf == null) {
            str.empty();
        } else {
            str.setValue(buf);
        }
        str.setTaint(true);
        return str;
    }

    protected RubyString readAll() throws BadDescriptorException, EOFException, IOException {
        Ruby runtime = this.getRuntime();
        ByteList buf = this.readAllCommon(runtime);
        RubyString str = buf == null ? RubyString.newEmptyString(runtime) : this.makeString(runtime, buf, false);
        str.setTaint(true);
        return str;
    }

    protected ByteList readAllCommon(Ruby runtime) throws BadDescriptorException, EOFException, IOException {
        ByteList buf;
        block8: {
            buf = null;
            ChannelDescriptor descriptor = this.openFile.getMainStreamSafe().getDescriptor();
            try {
                if (descriptor.isSeekable() && descriptor.getChannel() instanceof FileChannel) {
                    buf = this.openFile.getMainStreamSafe().readall();
                    break block8;
                }
                RubyThread thread2 = runtime.getCurrentContext().getThread();
                try {
                    while (true) {
                        Stream stream = this.openFile.getMainStreamSafe();
                        this.readCheck(stream);
                        this.openFile.checkReadable(runtime);
                        ByteList read2 = this.fread(thread2, 4096);
                        if (read2.length() != 0) {
                            if (buf == null) {
                                buf = read2;
                                continue;
                            }
                            buf.append(read2);
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidValueException ex) {
                    throw runtime.newErrnoEINVALError();
                }
            }
            catch (NonReadableChannelException ex) {
                throw runtime.newIOError("not opened for reading");
            }
        }
        return buf;
    }

    private ByteList fread(RubyThread thread2, int length2) throws IOException, BadDescriptorException {
        Stream stream = this.openFile.getMainStreamSafe();
        int rest2 = length2;
        this.waitReadable(stream);
        ByteList buf = this.blockingFRead(stream, thread2, length2);
        if (buf != null) {
            rest2 -= buf.length();
        }
        while (rest2 > 0) {
            this.waitReadable(stream);
            this.openFile.checkClosed(this.getRuntime());
            stream.clearerr();
            ByteList newBuffer = this.blockingFRead(stream, thread2, rest2);
            if (newBuffer == null) break;
            int len = newBuffer.length();
            if (len == 0) continue;
            if (buf == null) {
                buf = newBuffer;
            } else {
                buf.append(newBuffer);
            }
            rest2 -= len;
        }
        if (buf == null) {
            return ByteList.EMPTY_BYTELIST.dup();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteList blockingFRead(Stream stream, RubyThread thread2, int length2) throws IOException, BadDescriptorException {
        try {
            thread2.beforeBlockingCall();
            ByteList byteList = stream.fread(length2);
            Object var6_5 = null;
            thread2.afterBlockingCall();
            return byteList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread2.afterBlockingCall();
            throw throwable;
        }
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.getRuntime());
        try {
            return context.getRuntime().newFileStat(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    public IRubyObject each_byteInternal(ThreadContext context, Block block) {
        Ruby runtime = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime);
                myOpenFile.setReadBuffered();
                this.waitReadable(myOpenFile.getMainStream());
                int c = myOpenFile.getMainStreamSafe().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime.getNil();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byteInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context) {
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines(ThreadContext context, Block block) {
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lines19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
        }
        return this.each_lineInternal(context, NULL_ARRAY, block);
    }

    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        IRubyObject ch;
        Ruby runtime = context.getRuntime();
        while (!(ch = this.getc()).isNil()) {
            byte c = (byte)RubyNumeric.fix2int(ch);
            int n = runtime.getKCode().getEncoding().length(c);
            RubyString str = runtime.newString();
            if (runtime.is1_9()) {
                str.setEncoding(this.getExternalEncoding(runtime));
            }
            str.setTaint(true);
            str.cat(c);
            while (--n > 0) {
                ch = this.getc();
                if (ch.isNil()) {
                    block.yield(context, str);
                    return this;
                }
                c = (byte)RubyNumeric.fix2int(ch);
                str.cat(c);
            }
            block.yield(context, str);
        }
        return this;
    }

    public IRubyObject each_charInternal19(ThreadContext context, Block block) {
        IRubyObject ch;
        while (!(ch = this.getc19(context)).isNil()) {
            block.yield(context, ch);
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject each_char(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod(name={"each_char"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject chars(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    @JRubyMethod(name={"chars"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chars19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "codepoints");
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    private IRubyObject eachCharCommon(ThreadContext context, Block block, String methodName) {
        return block.isGiven() ? this.each_char(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, methodName);
    }

    private IRubyObject eachCodePointCommon(ThreadContext context, Block block, String methodName) {
        IRubyObject ch;
        Ruby runtime = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, methodName);
        }
        while (!(ch = this.getc()).isNil()) {
            block.yield(context, ch);
        }
        return this;
    }

    public RubyIO each_lineInternal(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        ByteList separator = this.getSeparatorForGets(runtime, args2);
        ByteListCache cache = new ByteListCache();
        IRubyObject line = this.getline(runtime, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(runtime, separator, cache);
        }
        return this;
    }

    @JRubyMethod(optional=1)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(optional=1)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        IRubyObject[] iRubyObjectArray;
        Ruby runtime = context.getRuntime();
        if (args2.length > 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[0];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArgs = iRubyObjectArray;
        ByteList separator = this.getSeparatorForGets(runtime, separatorArgs);
        RubyArray result2 = runtime.newArray();
        while (!(line = this.getline(runtime, separator)).isNil()) {
            result2.append(line);
        }
        return result2;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        try {
            return "RubyIO(" + this.openFile.getMode() + ", " + this.getRuntime().getFileno(this.openFile.getMainStreamSafe().getDescriptor()) + ")";
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject foreachInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        RubyString filename2 = args2[0].convertToString();
        runtime.checkSafeString(filename2);
        RubyIO io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                ByteList separator = io2.getSeparatorFromArgs(runtime, args2, 1);
                IRubyObject str = io2.getline(runtime, separator, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(runtime, separator, cache);
                    if (!runtime.is1_9()) continue;
                    separator = io2.getSeparatorFromArgs(runtime, args2, 1);
                }
                Object var11_10 = null;
                io2.close();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                io2.close();
                throw throwable;
            }
            {
            }
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject foreachInternal19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyIO io2;
        Ruby runtime = context.getRuntime();
        RubyString filename2 = args2[0].convertToString();
        runtime.checkSafeString(filename2);
        boolean hasOptions = false;
        switch (args2.length) {
            case 1: {
                io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            case 2: {
                if (args2[1] instanceof RubyHash) {
                    io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2, args2[1]}, Block.NULL_BLOCK);
                    args2 = new IRubyObject[]{args2[0]};
                    break;
                }
                io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            case 3: {
                if (args2[1] instanceof RubyHash) {
                    io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2, args2[2]}, Block.NULL_BLOCK);
                    args2 = new IRubyObject[]{args2[0], args2[1]};
                    break;
                }
                io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            default: {
                Arity.checkArgumentCount(runtime, args2.length, 1, 3);
                throw runtime.newRuntimeError("invalid argument count in IO.foreach: " + args2.length);
            }
        }
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                ByteList separator = io2.getSeparatorFromArgs(runtime, args2, 1);
                IRubyObject str = io2.getline(runtime, separator, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(runtime, separator, cache);
                    if (!runtime.is1_9()) continue;
                    separator = io2.getSeparatorFromArgs(runtime, args2, 1);
                }
                Object var12_11 = null;
                io2.close();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                io2.close();
                throw throwable;
            }
            {
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", args2);
        }
        if (!(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(context, "to_path");
        }
        return RubyIO.foreachInternal(context, recv2, args2, block);
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", args2);
        }
        if (!(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(context, "to_path");
        }
        return RubyIO.foreachInternal19(context, recv2, args2, block);
    }

    public static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return (RubyIO)obj;
        }
        return (RubyIO)TypeConverter.convertToType(obj, context.getRuntime().getIO(), "to_io");
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.getRuntime(), args2);
    }

    public static IRubyObject select_static(ThreadContext context, Ruby runtime, IRubyObject[] args2) {
        return new SelectBlob().goForIt(context, runtime, args2);
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return RubyIO.readStatic(context, recv2, args2[0]);
            }
            case 2: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1], args2[2]);
            }
        }
        throw context.getRuntime().newArgumentError(args2.length, 3);
    }

    private static RubyIO newFile(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return (RubyIO)RubyKernel.open(context, recv2, args2, Block.NULL_BLOCK);
    }

    private static RubyIO newFile19(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return (RubyIO)RubyKernel.open19(context, recv2, args2, Block.NULL_BLOCK);
    }

    public static void failIfDirectory(Ruby runtime, RubyString pathStr) {
        if (RubyFileTest.directory_p(runtime, (IRubyObject)pathStr).isTrue()) {
            if (Platform.IS_WINDOWS) {
                throw runtime.newErrnoEACCESError(pathStr.asJavaString());
            }
            throw runtime.newErrnoEISDirError(pathStr.asJavaString());
        }
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block unusedBlock) {
        return RubyIO.readStatic(context, recv2, path2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        return RubyIO.readStatic(context, recv2, path2, length2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        return RubyIO.readStatic(context, recv2, path2, length2, offset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        IRubyObject iRubyObject;
        StringSupport.checkStringSafety(context.getRuntime(), path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.getRuntime();
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            iRubyObject = file2.read(context);
            Object var8_7 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        IRubyObject iRubyObject;
        StringSupport.checkStringSafety(context.getRuntime(), path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.getRuntime();
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var9_8 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        IRubyObject iRubyObject;
        StringSupport.checkStringSafety(context.getRuntime(), path2);
        RubyString pathStr = path2.convertToString();
        Ruby runtime = context.getRuntime();
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var10_9 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2, RubyHash options2) {
        IRubyObject iRubyObject;
        RubyString pathStr = RubyFile.get_path(context, path2);
        Ruby runtime = context.getRuntime();
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile19(context, recv2, pathStr, options2);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject write19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject str, IRubyObject offset2, RubyHash options2) {
        IRubyObject iRubyObject;
        RubyString pathStr = RubyFile.get_path(context, path2);
        Ruby runtime = context.getRuntime();
        RubyIO.failIfDirectory(runtime, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr, context.runtime.newString("w"));
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = file2.write(context, str);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=1, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject binread(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject iRubyObject;
        IRubyObject nil = context.getRuntime().getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        Ruby runtime = context.runtime;
        if (args2.length > 2) {
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 1) {
            length2 = args2[1];
        }
        RubyIO file2 = (RubyIO)RuntimeHelpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)runtime.newString("rb:ASCII-8BIT"));
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"read"}, meta=true, required=1, optional=3, compat=CompatVersion.RUBY1_9)
    public static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = context.runtime;
        IRubyObject nil = runtime.getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        RubyHash options2 = null;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw runtime.newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
            length2 = args2[1];
        } else if (args2.length > 1) {
            if (args2[1] instanceof RubyHash) {
                options2 = (RubyHash)args2[1];
            } else {
                length2 = args2[1];
            }
        }
        if (options2 == null) {
            options2 = RubyHash.newHash(runtime);
        }
        return RubyIO.read19(context, recv2, path2, length2, offset2, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=2, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject binwrite(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject iRubyObject;
        IRubyObject nil = context.getRuntime().getNil();
        IRubyObject path2 = args2[0];
        IRubyObject str = args2[1];
        IRubyObject offset2 = nil;
        Ruby runtime = context.runtime;
        if (args2.length > 2) {
            offset2 = args2[2];
        }
        RubyIO file2 = (RubyIO)RuntimeHelpers.invoke(context, (IRubyObject)runtime.getFile(), "new", path2, (IRubyObject)runtime.newString("wb:ASCII-8BIT"));
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = file2.write(context, str);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"write"}, meta=true, required=2, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject writeStatic(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject nil = context.nil;
        IRubyObject path2 = args2[0];
        IRubyObject str = args2[1];
        IRubyObject offset2 = nil;
        RubyHash options2 = null;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw context.getRuntime().newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
        }
        return RubyIO.write19(context, recv2, path2, str, offset2, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        RubyArray rubyArray;
        IRubyObject[] iRubyObjectArray;
        int count2 = args2.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args2[0].convertToString()};
        if (count2 >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        try {
            rubyArray = file2.readlines(context, separatorArguments);
            Object var10_9 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            file2.close();
            throw throwable;
        }
        return rubyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        RubyString cmdObj = null;
        if (Platform.IS_WINDOWS) {
            String[] tokens = args2[0].convertToString().toString().split(" ", 2);
            String commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
            cmdObj = runtime.newString(commandString);
        } else {
            cmdObj = args2[0].convertToString();
        }
        runtime.checkSafeString(cmdObj);
        if ("-".equals(((Object)cmdObj).toString())) {
            throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        try {
            IOOptions ioOptions = args2.length == 1 ? RubyIO.newIOOptions(runtime, ModeFlags.RDONLY) : (args2[1] instanceof RubyFixnum ? RubyIO.newIOOptions(runtime, RubyFixnum.num2int(args2[1])) : RubyIO.newIOOptions(runtime, args2[1].convertToString().toString()));
            ShellLauncher.POpenProcess process = ShellLauncher.popen(runtime, cmdObj, ioOptions);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                ShellLauncher.POpenProcess pOpenProcess = process;
                synchronized (pOpenProcess) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO io2 = new RubyIO(runtime, process, ioOptions);
            if (recv2 instanceof RubyClass) {
                io2.setMetaClass((RubyClass)recv2);
            }
            if (!block.isGiven()) {
                return io2;
            }
            try {
                IRubyObject iRubyObject = block.yield(context, io2);
                Object var12_12 = null;
                if (!io2.openFile.isOpen()) return iRubyObject;
                io2.close();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (!io2.openFile.isOpen()) throw throwable;
                io2.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject popen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        RubyHash options2 = null;
        if (args2.length > 1 && args2[args2.length - 1] instanceof RubyHash) {
            options2 = (RubyHash)args2[args2.length - 1];
            IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
            args2 = newArgs;
        }
        Ruby19POpen r19Popen = new Ruby19POpen(runtime, args2);
        if ("-".equals(r19Popen.cmd.toString())) {
            throw runtime.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        try {
            IRubyObject iRubyObject;
            IOOptions ioOptions = args2.length == 1 ? RubyIO.newIOOptions(runtime, ModeFlags.RDONLY) : (args2[1] instanceof RubyFixnum ? RubyIO.newIOOptions(runtime, RubyFixnum.num2int(args2[1])) : RubyIO.newIOOptions(runtime, args2[1].convertToString().toString()));
            ShellLauncher.POpenProcess process = r19Popen.cmdPlusArgs == null ? ShellLauncher.popen(runtime, r19Popen.cmd, ioOptions) : ShellLauncher.popen(runtime, r19Popen.cmdPlusArgs, r19Popen.env, ioOptions);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                ShellLauncher.POpenProcess pOpenProcess = process;
                synchronized (pOpenProcess) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO.checkPopenOptions(options2);
            RubyIO io2 = new RubyIO(runtime, (RubyClass)recv2, process, options2, ioOptions);
            if (!block.isGiven()) {
                return io2;
            }
            try {
                iRubyObject = block.yield(context, io2);
                Object var13_14 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
                throw throwable;
            }
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
            return iRubyObject;
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject popen3(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            POpenTuple tuple = RubyIO.popenSpecial(context, args2);
            RubyArray yieldArgs = RubyArray.newArrayLight(runtime, tuple.output, tuple.input, tuple.error);
            if (!block.isGiven()) {
                return yieldArgs;
            }
            try {
                iRubyObject = block.yield(context, yieldArgs);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            RubyIO.cleanupPOpen(tuple);
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
            return iRubyObject;
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject popen4(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            POpenTuple tuple = RubyIO.popenSpecial(context, args2);
            RubyArray yieldArgs = RubyArray.newArrayLight(runtime, runtime.newFixnum(ShellLauncher.getPidFromProcess(tuple.process)), tuple.output, tuple.input, tuple.error);
            if (!block.isGiven()) {
                return yieldArgs;
            }
            try {
                iRubyObject = block.yield(context, yieldArgs);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            RubyIO.cleanupPOpen(tuple);
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
            return iRubyObject;
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    private static void cleanupPOpen(POpenTuple tuple) {
        if (tuple.input.openFile.isOpen()) {
            tuple.input.close();
        }
        if (tuple.output.openFile.isOpen()) {
            tuple.output.close();
        }
        if (tuple.error.openFile.isOpen()) {
            tuple.error.close();
        }
    }

    public static POpenTuple popenSpecial(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.getRuntime();
        try {
            ShellLauncher.POpenProcess process = ShellLauncher.popen3(runtime, args2, false);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime, process.getInput()) : new RubyIO(runtime, process.getInputStream());
            RubyIO output = process.getOutput() != null ? new RubyIO(runtime, process.getOutput()) : new RubyIO(runtime, process.getOutputStream());
            RubyIO error2 = process.getError() != null ? new RubyIO(runtime, process.getError()) : new RubyIO(runtime, process.getErrorStream());
            input.getOpenFile().setProcess(process);
            output.getOpenFile().setProcess(process);
            error2.getOpenFile().setProcess(process);
            input.popenSpecial = true;
            output.popenSpecial = true;
            error2.popenSpecial = true;
            input.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            output.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            error2.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            return new POpenTuple(input, output, error2, process);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.getRuntime();
        try {
            Pipe pipe2 = Pipe.open();
            RubyIO source2 = new RubyIO(runtime, pipe2.source());
            RubyIO sink = new RubyIO(runtime, pipe2.sink());
            sink.openFile.getMainStreamSafe().setSync(true);
            return runtime.newArrayNoCopy(source2, sink);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2) {
        return RubyIO.pipe(context, recv2);
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2, IRubyObject modes) {
        Ruby runtime = context.getRuntime();
        try {
            Pipe pipe2 = Pipe.open();
            RubyIO source2 = new RubyIO(runtime, pipe2.source());
            source2.setEncodingFromOptions(EncodingOption.getEncodingOptionFromString(runtime, modes.toString()));
            RubyIO sink = new RubyIO(runtime, pipe2.sink());
            sink.openFile.getMainStreamSafe().setSync(true);
            return runtime.newArrayNoCopy(source2, sink);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject pipe19(ThreadContext context, IRubyObject recv2, IRubyObject modes, IRubyObject options2) {
        return RubyIO.pipe19(context, recv2, modes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"copy_stream"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.getRuntime();
        RubyIO io1 = null;
        RubyIO io2 = null;
        try {
            try {
                RubyFixnum rubyFixnum;
                if (arg1 instanceof RubyString) {
                    io1 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg1}, Block.NULL_BLOCK);
                } else {
                    if (!(arg1 instanceof RubyIO)) throw runtime.newTypeError("Should be String or IO");
                    io1 = (RubyIO)arg1;
                }
                if (arg2 instanceof RubyString) {
                    io2 = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{arg2, runtime.newString("w")}, Block.NULL_BLOCK);
                } else {
                    if (!(arg2 instanceof RubyIO)) throw runtime.newTypeError("Should be String or IO");
                    io2 = (RubyIO)arg2;
                }
                ChannelDescriptor d1 = io1.openFile.getMainStreamSafe().getDescriptor();
                ChannelDescriptor d2 = io2.openFile.getMainStreamSafe().getDescriptor();
                if (!d1.isReadable()) {
                    throw runtime.newIOError("from IO is not readable");
                }
                if (!d2.isWritable()) {
                    throw runtime.newIOError("from IO is not writable");
                }
                try {
                    ReadableByteChannel from;
                    long size2 = 0L;
                    if (!d1.isSeekable()) {
                        if (!d2.isSeekable()) {
                            throw context.getRuntime().newTypeError("only supports to file or from file copy");
                        }
                        from = (ReadableByteChannel)d1.getChannel();
                        FileChannel to = (FileChannel)d2.getChannel();
                        size2 = RubyIO.transfer(from, to);
                    } else {
                        from = (FileChannel)d1.getChannel();
                        WritableByteChannel to = (WritableByteChannel)d2.getChannel();
                        size2 = RubyIO.transfer(from, to);
                    }
                    rubyFixnum = context.getRuntime().newFixnum(size2);
                }
                catch (IOException ioe) {
                    throw runtime.newIOErrorFromException(ioe);
                }
                Object var15_14 = null;
                try {
                    if (io1 != null) {
                        io1.close();
                    }
                    Object var17_16 = null;
                    if (io2 == null) return rubyFixnum;
                    io2.close();
                    return rubyFixnum;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    if (io2 == null) throw throwable;
                    io2.close();
                    throw throwable;
                }
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            try {}
            catch (Throwable throwable2) {
                Object var17_19 = null;
                if (io2 == null) throw throwable2;
                io2.close();
                throw throwable2;
            }
            if (io1 != null) {
                io1.close();
            }
            Object var17_18 = null;
            if (io2 == null) throw throwable;
            io2.close();
            throw throwable;
        }
    }

    private static long transfer(ReadableByteChannel from, FileChannel to) throws IOException {
        long bytes2;
        long transferred = 0L;
        while ((bytes2 = to.transferFrom(from, to.position(), 4196L)) > 0L) {
            transferred += bytes2;
        }
        return transferred;
    }

    private static long transfer(FileChannel from, WritableByteChannel to) throws IOException {
        long size2;
        try {
            from.transferTo(from.position(), size2, to);
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals("Cannot allocate memory")) {
                long _100M = 0x6400000L;
                for (size2 = from.size(); size2 > 0L; size2 -= _100M) {
                    if (size2 > _100M) {
                        from.transferTo(from.position(), _100M, to);
                        continue;
                    }
                    from.transferTo(from.position(), size2, to);
                }
            }
            throw ioe;
        }
        return size2;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject tryConvert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return arg2.respondsTo("to_io") ? RubyIO.convertToIO(context, arg2) : context.getRuntime().getNil();
    }

    private static ByteList getNilByteList(Ruby runtime) {
        return runtime.is1_9() ? ByteList.EMPTY_BYTELIST : NIL_BYTELIST;
    }

    public synchronized void addBlockingThread(RubyThread thread2) {
        if (this.blockingThreads == null) {
            this.blockingThreads = new ArrayList<RubyThread>(1);
        }
        this.blockingThreads.add(thread2);
    }

    public synchronized void removeBlockingThread(RubyThread thread2) {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            if (this.blockingThreads.get(i2) != thread2) continue;
            this.blockingThreads.remove(i2);
        }
    }

    protected synchronized void interruptBlockingThreads() {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            RubyThread thread2 = this.blockingThreads.get(i2);
            thread2.raise(new IRubyObject[]{this.getRuntime().newIOError("stream closed").getException()}, Block.NULL_BLOCK);
        }
    }

    protected IOOptions updateIOOptionsFromOptions(ThreadContext context, RubyHash options2, IOOptions ioOptions) {
        EncodingOption encodingOption;
        if (options2 == null || options2.isNil()) {
            return ioOptions;
        }
        Ruby runtime = context.getRuntime();
        if (options2.containsKey(runtime.newSymbol("mode"))) {
            ioOptions = this.parseIOOptions19(options2.fastARef(runtime.newSymbol("mode")));
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("binmode")) && options2.fastARef(runtime.newSymbol("binmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, ModeFlags.BINARY);
        }
        if (options2.containsKey(runtime.newSymbol("textmode")) && options2.fastARef(runtime.newSymbol("textmode")).isTrue()) {
            ioOptions = RubyIO.newIOOptions(runtime, ioOptions, 4096);
        }
        if ((encodingOption = EncodingOption.getEncodingOptionFromObject(options2)) != null) {
            ioOptions.setEncodingOption(encodingOption);
        }
        return ioOptions;
    }

    public void setEncodingFromOptions(EncodingOption encodingOption) {
        Encoding external = null;
        Encoding internal = null;
        if (encodingOption.hasBom()) {
            external = this.encodingFromBOM();
        }
        if (external == null && encodingOption.getExternalEncoding() != null) {
            external = encodingOption.getExternalEncoding();
        }
        if (encodingOption.getInternalEncoding() != null) {
            internal = encodingOption.getInternalEncoding();
        }
        this.externalEncoding = external;
        if (internal == this.externalEncoding) {
            return;
        }
        this.internalEncoding = internal;
    }

    public Encoding encodingFromBOM() {
        int b1 = this.getcCommon();
        switch (b1) {
            case 239: {
                int b2 = this.getcCommon();
                if (b2 == 187) {
                    int b3 = this.getcCommon();
                    if (b3 == 191) {
                        return UTF8Encoding.INSTANCE;
                    }
                    this.ungetcCommon(b3);
                }
                this.ungetcCommon(b2);
                break;
            }
            case 254: {
                int b2 = this.getcCommon();
                if (b2 == 255) {
                    return UTF16BEEncoding.INSTANCE;
                }
                this.ungetcCommon(b2);
                break;
            }
            case 255: {
                int b2 = this.getcCommon();
                if (b2 == 254) {
                    int b4;
                    int b3 = this.getcCommon();
                    if (b3 == 0) {
                        b4 = this.getcCommon();
                        if (b4 == 0) {
                            return UTF32LEEncoding.INSTANCE;
                        }
                    } else {
                        this.ungetcCommon(b3);
                        return UTF16LEEncoding.INSTANCE;
                    }
                    this.ungetcCommon(b4);
                    this.ungetcCommon(b3);
                }
                this.ungetcCommon(b2);
                break;
            }
            case 0: {
                int b2 = this.getcCommon();
                if (b2 == 0) {
                    int b3 = this.getcCommon();
                    if (b3 == 254) {
                        int b4 = this.getcCommon();
                        if (b4 == 255) {
                            return UTF32BEEncoding.INSTANCE;
                        }
                        this.ungetcCommon(b4);
                    }
                    this.ungetcCommon(b3);
                }
                this.ungetcCommon(b2);
            }
        }
        this.ungetcCommon(b1);
        return null;
    }

    public static void checkExecOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported exec option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkSpawnOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported spawn option");
        RubyIO.checkValidOptions(options2, ALL_SPAWN_OPTIONS);
    }

    public static void checkPopenOptions(IRubyObject options2) {
        RubyIO.checkUnsupportedOptions(options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported popen option");
    }

    private static void checkUnsupportedOptions(IRubyObject options2, Set<String> unsupported, String error2) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (String key2 : unsupported) {
            if (!optsHash.containsKey(runtime.newSymbol(key2))) continue;
            runtime.getWarnings().warn(error2 + ": " + key2);
        }
    }

    private static void checkValidOptions(IRubyObject options2, Set<String> valid) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return;
        }
        RubyHash optsHash = (RubyHash)options2;
        Ruby runtime = optsHash.getRuntime();
        for (Object opt : optsHash.keySet()) {
            if (opt instanceof RubySymbol || opt instanceof RubyFixnum || valid.contains(opt.toString())) continue;
            throw runtime.newTypeError("wrong exec option: " + opt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obliterateProcess(Process process) {
        int i2 = 0;
        Object waitLock = new Object();
        while (true) {
            if (i2 >= 1000) {
                return;
            }
            process.destroy();
            try {
                process.exitValue();
                break;
            }
            catch (IllegalThreadStateException itse) {
                ++i2;
                Object object = waitLock;
                synchronized (object) {
                    try {
                        waitLock.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, long mode2) {
        return RubyIO.newModeFlags(runtime, (int)mode2);
    }

    public static ModeFlags newModeFlags(Ruby runtime, int mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime, String mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, ModeFlags modeFlags) {
        return new IOOptions(modeFlags, EncodingOption.getEncodingNoOption(runtime, modeFlags));
    }

    public static IOOptions newIOOptions(Ruby runtime, long mode2) {
        return RubyIO.newIOOptions(runtime, (int)mode2);
    }

    public static IOOptions newIOOptions(Ruby runtime, int mode2) {
        try {
            ModeFlags modeFlags = new ModeFlags(mode2);
            return new IOOptions(modeFlags, EncodingOption.getEncodingNoOption(runtime, modeFlags));
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, String mode2) {
        try {
            return new IOOptions(runtime, mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime.newArgumentError("illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime, IOOptions oldFlags, int orOflags) {
        try {
            return new IOOptions(new ModeFlags(oldFlags.getModeFlags().getFlags() | orOflags), oldFlags.getEncodingOption());
        }
        catch (InvalidValueException ive) {
            throw runtime.newErrnoEINVALError();
        }
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor, boolean isRetained) {
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor) {
    }

    @Deprecated
    public void unregisterDescriptor(int aFileno) {
    }

    @Deprecated
    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return ChannelDescriptor.getDescriptorByFileno(aFileno);
    }

    @Deprecated
    public static int getNewFileno() {
        return ChannelDescriptor.getNewFileno();
    }

    @Deprecated
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.gets(context) : this.gets(context, args2[0]);
    }

    @Deprecated
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.readline(context) : this.readline(context, args2[0]);
    }

    static {
        String v = SafePropertyAccessor.getProperty("java.vendor");
        vendor = v == null ? "" : v;
        msgEINTR = "Interrupted system call";
        NIL_BYTELIST = ByteList.create((CharSequence)"nil");
        RECURSIVE_BYTELIST = ByteList.create((CharSequence)"[...]");
        UNSUPPORTED_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
        ALL_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList("unsetenv_others", "prgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"));
    }

    private static class ByteListCache {
        private byte[] buffer = new byte[0];

        private ByteListCache() {
        }

        public void release(ByteList l) {
            this.buffer = l.getUnsafeBytes();
        }

        public ByteList allocate(int size2) {
            ByteList l = new ByteList(this.buffer, 0, size2, false);
            return l;
        }
    }

    private static class POpenTuple {
        public final RubyIO input;
        public final RubyIO output;
        public final RubyIO error;
        public final Process process;

        public POpenTuple(RubyIO i2, RubyIO o, RubyIO e, Process p2) {
            this.input = i2;
            this.output = o;
            this.error = e;
            this.process = p2;
        }
    }

    private static class Ruby19POpen {
        public final RubyString cmd;
        public final IRubyObject[] cmdPlusArgs;
        public final RubyHash env;

        public Ruby19POpen(Ruby runtime, IRubyObject[] args2) {
            IRubyObject[] _cmdPlusArgs = null;
            RubyHash _env = null;
            IRubyObject _cmd = null;
            IRubyObject arg0 = args2[0].checkArrayType();
            if (args2[0] instanceof RubyHash) {
                if (args2.length > 1) {
                    _env = (RubyHash)args2[0];
                } else {
                    Arity.raiseArgumentError(runtime, 0, 1, 2);
                }
                if (Platform.IS_WINDOWS) {
                    String[] tokens = args2[1].convertToString().toString().split(" ", 2);
                    String commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
                    _cmd = runtime.newString(commandString);
                } else {
                    _cmd = args2[1].convertToString();
                }
            } else if (args2[0] instanceof RubyArray) {
                RubyArray arg0Ary = (RubyArray)arg0;
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.eltOk(0L) instanceof RubyHash) {
                    _env = (RubyHash)arg0Ary.delete_at(0);
                }
                if (arg0Ary.isEmpty()) {
                    throw runtime.newArgumentError("wrong number of arguments");
                }
                if (arg0Ary.size() > 1 && arg0Ary.eltOk(arg0Ary.size() - 1) instanceof RubyHash) {
                    _env = (RubyHash)arg0Ary.eltOk(arg0Ary.size() - 1);
                }
                _cmdPlusArgs = arg0Ary.toJavaArray();
                if (Platform.IS_WINDOWS) {
                    String commandString = _cmdPlusArgs[0].convertToString().toString().replace('/', '\\');
                    _cmdPlusArgs[0] = runtime.newString(commandString);
                } else {
                    _cmdPlusArgs[0] = _cmdPlusArgs[0].convertToString();
                }
                _cmd = _cmdPlusArgs[0];
            } else if (Platform.IS_WINDOWS) {
                String[] tokens = args2[0].convertToString().toString().split(" ", 2);
                String commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
                _cmd = runtime.newString(commandString);
            } else {
                _cmd = args2[0].convertToString();
            }
            runtime.checkSafeString(_cmd);
            this.cmd = _cmd;
            this.cmdPlusArgs = _cmdPlusArgs;
            this.env = _env;
        }
    }
}

