/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Converter"})
public class RubyConverter
extends RubyObject {
    private RubyEncoding srcEncoding;
    private RubyEncoding destEncoding;
    private CharsetDecoder srcDecoder;
    private CharsetEncoder destEncoder;
    private static ObjectAllocator CONVERTER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyConverter(runtime, klass);
        }
    };
    private static final Encoding UTF16 = UTF16BEEncoding.INSTANCE;

    public static RubyClass createConverterClass(Ruby runtime) {
        RubyClass converterc = runtime.defineClassUnder("Converter", runtime.getClass("Data"), CONVERTER_ALLOCATOR, runtime.getEncoding());
        runtime.setConverter(converterc);
        converterc.index = 23;
        converterc.setReifiedClass(RubyConverter.class);
        converterc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyConverter;
            }
        };
        converterc.defineAnnotatedMethods(RubyConverter.class);
        return converterc;
    }

    public RubyConverter(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RubyConverter(Ruby runtime) {
        super(runtime, runtime.getConverter());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject convpath2) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject dest) {
        this.srcEncoding = (RubyEncoding)context.runtime.getEncodingService().rubyEncodingFromObject(src);
        this.destEncoding = (RubyEncoding)context.runtime.getEncodingService().rubyEncodingFromObject(dest);
        this.srcDecoder = context.runtime.getEncodingService().charsetForEncoding(this.srcEncoding.getEncoding()).newDecoder();
        this.destEncoder = context.runtime.getEncodingService().charsetForEncoding(this.destEncoding.getEncoding()).newEncoder();
        return context.getRuntime().getNil();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject dest, IRubyObject opt) {
        this.initialize(context, src, dest);
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.runtime, "#<Encoding::Converter: " + this.srcDecoder.charset().name() + " to " + this.destEncoder.charset().name());
    }

    @JRubyMethod
    public IRubyObject convpath(ThreadContext context) {
        IRubyObject utf16Encoding = context.runtime.getEncodingService().getEncodingList()[UTF16.getIndex()];
        return RubyArray.newArray(context.runtime, RubyArray.newArray(context.runtime, this.srcEncoding, utf16Encoding), RubyArray.newArray(context.runtime, utf16Encoding, this.destEncoding));
    }

    @JRubyMethod
    public IRubyObject source_encoding() {
        return this.srcEncoding;
    }

    @JRubyMethod
    public IRubyObject destination_encoding() {
        return this.destEncoding;
    }

    @JRubyMethod
    public IRubyObject primitive_convert(ThreadContext context, IRubyObject src, IRubyObject dest) {
        RubyString result2 = (RubyString)this.convert(context, src);
        dest.convertToString().replace19(result2);
        return context.runtime.newSymbol("finished");
    }

    @JRubyMethod
    public IRubyObject convert(ThreadContext context, IRubyObject srcBuffer) {
        if (!(srcBuffer instanceof RubyString)) {
            throw context.runtime.newTypeError(srcBuffer, context.runtime.getString());
        }
        RubyString srcString = (RubyString)srcBuffer;
        ByteList srcBL = srcString.getByteList();
        if (srcBL.getRealSize() == 0) {
            return context.runtime.newSymbol("source_buffer_empty");
        }
        ByteBuffer srcBB = ByteBuffer.wrap(srcBL.getUnsafeBytes(), srcBL.begin(), srcBL.getRealSize());
        try {
            CharBuffer srcCB = CharBuffer.allocate((int)(this.srcDecoder.maxCharsPerByte() * (float)srcBL.getRealSize()) + 1);
            CoderResult decodeResult = this.srcDecoder.decode(srcBB, srcCB, true);
            srcCB.flip();
            ByteBuffer destBB = ByteBuffer.allocate((int)(this.destEncoder.maxBytesPerChar() * (float)srcCB.limit()) + 1);
            CoderResult encodeResult = this.destEncoder.encode(srcCB, destBB, true);
            destBB.flip();
            byte[] destBytes = new byte[destBB.limit()];
            destBB.get(destBytes);
            this.srcDecoder.reset();
            this.destEncoder.reset();
            return context.runtime.newString(new ByteList(destBytes, this.destEncoding.getEncoding(), false));
        }
        catch (Exception e) {
            throw context.runtime.newRuntimeError(e.getLocalizedMessage());
        }
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject replacement(ThreadContext context) {
        return RubyString.newString(context.runtime, this.srcDecoder.replacement());
    }

    @JRubyMethod(name={"replacement="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject replacement_set(ThreadContext context, IRubyObject replacement2) {
        this.srcDecoder.replaceWith(replacement2.convertToString().asJavaString());
        return replacement2;
    }
}

