/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Continuation"})
public class RubyContinuation
extends RubyObject {
    private final Continuation continuation;
    private boolean disabled;

    public static void createContinuation(Ruby runtime) {
        RubyClass cContinuation = runtime.defineClass("Continuation", runtime.getObject(), runtime.getObject().getAllocator());
        cContinuation.index = 37;
        cContinuation.setReifiedClass(RubyContinuation.class);
        cContinuation.defineAnnotatedMethods(RubyContinuation.class);
        cContinuation.getSingletonClass().undefineMethod("new");
        runtime.setContinuation(cContinuation);
    }

    public RubyContinuation(Ruby runtime) {
        super(runtime, runtime.getContinuation());
        this.continuation = new Continuation();
    }

    public RubyContinuation(Ruby runtime, IRubyObject tag2) {
        super(runtime, runtime.getContinuation());
        this.continuation = new Continuation(tag2);
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        if (this.disabled) {
            RubyKernel.raise(context, context.runtime.getThreadError(), new IRubyObject[]{context.runtime.newString("continuations can not be called from outside their scope")}, Block.NULL_BLOCK);
        }
        this.continuation.args = args2;
        throw this.continuation;
    }

    public IRubyObject enter(ThreadContext context, IRubyObject yielded, Block block) {
        try {
            IRubyObject iRubyObject = block.yield(context, yielded);
            return iRubyObject;
        }
        catch (Continuation c) {
            if (c == this.continuation) {
                if (this.continuation.args.length == 0) {
                    IRubyObject iRubyObject = context.getRuntime().getNil();
                    return iRubyObject;
                }
                if (this.continuation.args.length == 1) {
                    IRubyObject iRubyObject = this.continuation.args[0];
                    return iRubyObject;
                }
                RubyArray rubyArray = context.getRuntime().newArrayNoCopy(this.continuation.args);
                return rubyArray;
            }
            throw c;
        }
        finally {
            this.disabled = true;
        }
    }

    public static class Continuation
    extends Error
    implements Unrescuable {
        public IRubyObject[] args = IRubyObject.NULL_ARRAY;
        public final IRubyObject tag;

        public Continuation() {
            this.tag = null;
        }

        public Continuation(IRubyObject tag2) {
            this.tag = tag2;
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

