/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.util.FieldAccess;
import jnr.posix.util.Platform;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.WindowsFFI;
import org.jruby.util.io.IOOptions;

public class ShellLauncher {
    private static final boolean DEBUG = false;
    private static final String PATH_ENV = "PATH";
    private static final String[] DEFAULT_PATH = new String[]{"/usr/local/bin", "/usr/ucb", "/usr/bin", "/bin"};
    private static final String[] WINDOWS_EXE_SUFFIXES = new String[]{".exe", ".com", ".bat", ".cmd"};
    private static final String[] WINDOWS_INTERNAL_CMDS = new String[]{"assoc", "break", "call", "cd", "chcp", "chdir", "cls", "color", "copy", "ctty", "date", "del", "dir", "echo", "endlocal", "erase", "exit", "for", "ftype", "goto", "if", "lfnfor", "lh", "lock", "md", "mkdir", "move", "path", "pause", "popd", "prompt", "pushd", "rd", "rem", "ren", "rename", "rmdir", "set", "setlocal", "shift", "start", "time", "title", "truename", "type", "unlock", "ver", "verify", "vol"};
    private static final Pattern SHELL_METACHARACTER_PATTERN = Pattern.compile("[*?{}\\[\\]<>()~&|$;'`\\\\\"\\n]");
    private static final Pattern WIN_ENVVAR_PATTERN = Pattern.compile("%\\w+%");
    private static final Class UNIXProcess;
    private static final Field UNIXProcess_pid;
    private static final Class ProcessImpl;
    private static final Field ProcessImpl_handle;
    private static final PidGetter PID_GETTER;

    public static String[] getCurrentEnv(Ruby runtime) {
        return ShellLauncher.getCurrentEnv(runtime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCurrentEnv(Ruby runtime, Map mergeEnv) {
        ThreadContext context = runtime.getCurrentContext();
        boolean traceEnabled = context.isEventHooksEnabled();
        context.setEventHooksEnabled(false);
        try {
            RubyHash hash2 = (RubyHash)runtime.getObject().getConstant("ENV").dup();
            String[] ret = mergeEnv != null && !mergeEnv.isEmpty() ? new String[hash2.size() + mergeEnv.size()] : new String[hash2.size()];
            int i2 = 0;
            for (Map.Entry entry : hash2.directEntrySet()) {
                ret[i2] = entry.getKey().toString() + "=" + entry.getValue().toString();
                ++i2;
            }
            if (mergeEnv != null) {
                for (Map.Entry entry : mergeEnv.entrySet()) {
                    ret[i2] = entry.getKey().toString() + "=" + entry.getValue().toString();
                    ++i2;
                }
            }
            String[] stringArray = ret;
            Object var10_11 = null;
            context.setEventHooksEnabled(traceEnabled);
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            context.setEventHooksEnabled(traceEnabled);
            throw throwable;
        }
    }

    private static boolean filenameIsPathSearchable(String fname, boolean forExec) {
        boolean isSearchable = true;
        if (fname.startsWith("/") || fname.startsWith("./") || fname.startsWith("../") || forExec && fname.indexOf("/") != -1) {
            isSearchable = false;
        }
        if (Platform.IS_WINDOWS && (fname.startsWith("\\") || fname.startsWith(".\\") || fname.startsWith("..\\") || fname.length() > 2 && fname.startsWith(":", 1) || forExec && fname.indexOf("\\") != -1)) {
            isSearchable = false;
        }
        return isSearchable;
    }

    private static File tryFile(Ruby runtime, String fdir, String fname) {
        File pathFile = fdir == null ? new File(fname) : new File(fdir, fname);
        if (!pathFile.isAbsolute()) {
            pathFile = new File(runtime.getCurrentDirectory(), pathFile.getPath());
        }
        ShellLauncher.log(runtime, "Trying file " + pathFile);
        if (pathFile.exists()) {
            return pathFile;
        }
        return null;
    }

    private static boolean withExeSuffix(String fname) {
        String lowerCaseFname = fname.toLowerCase();
        for (String suffix : WINDOWS_EXE_SUFFIXES) {
            if (!lowerCaseFname.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static File isValidFile(Ruby runtime, String fdir, String fname, boolean isExec) {
        File validFile = null;
        if (isExec && Platform.IS_WINDOWS) {
            if (ShellLauncher.withExeSuffix(fname)) {
                validFile = ShellLauncher.tryFile(runtime, fdir, fname);
            } else {
                for (String suffix : WINDOWS_EXE_SUFFIXES) {
                    validFile = ShellLauncher.tryFile(runtime, fdir, fname + suffix);
                    if (validFile == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            validFile = ShellLauncher.tryFile(runtime, fdir, fname);
            if (validFile != null && isExec && (validFile.isDirectory() || !runtime.getPosix().stat(validFile.getAbsolutePath()).isExecutable())) {
                throw runtime.newErrnoEACCESError(validFile.getAbsolutePath());
            }
        }
        return validFile;
    }

    private static File isValidFile(Ruby runtime, String fname, boolean isExec) {
        String fdir = null;
        return ShellLauncher.isValidFile(runtime, fdir, fname, isExec);
    }

    private static File findPathFile(Ruby runtime, String fname, String[] path2, boolean isExec) {
        File pathFile = null;
        boolean doPathSearch = ShellLauncher.filenameIsPathSearchable(fname, isExec);
        if (doPathSearch) {
            String fdir;
            String[] arr$ = path2;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (pathFile = ShellLauncher.isValidFile(runtime, fdir = arr$[i$], fname, isExec)) == null; ++i$) {
            }
        } else {
            pathFile = ShellLauncher.isValidFile(runtime, fname, isExec);
        }
        return pathFile;
    }

    private static File findPathExecutable(Ruby runtime, String fname) {
        RubyHash env = (RubyHash)runtime.getObject().getConstant("ENV");
        IRubyObject pathObject = env.op_aref(runtime.getCurrentContext(), RubyString.newString(runtime, PATH_ENV));
        String[] pathNodes = null;
        if (pathObject == null) {
            pathNodes = DEFAULT_PATH;
        } else {
            String pathSeparator = System.getProperty("path.separator");
            String path2 = pathObject.toString();
            if (Platform.IS_WINDOWS) {
                path2 = "." + pathSeparator + path2;
            }
            pathNodes = path2.split(pathSeparator);
        }
        return ShellLauncher.findPathFile(runtime, fname, pathNodes, true);
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime, rawArgs, runtime.getOutputStream());
    }

    public static long[] runAndWaitPid(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWaitPid(runtime, rawArgs, runtime.getOutputStream(), true);
    }

    public static long runWithoutWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime, rawArgs, runtime.getOutputStream());
    }

    public static int runExternalAndWait(Ruby runtime, IRubyObject[] rawArgs, Map mergeEnv) {
        PrintStream output = runtime.getOutputStream();
        PrintStream error2 = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        Process aProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime, rawArgs, true);
        try {
            try {
                if (cfg.shouldRunInShell()) {
                    ShellLauncher.log(runtime, "Launching with shell");
                    cfg.verifyExecutableForShell();
                    aProcess = ShellLauncher.buildProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime, mergeEnv), pwd);
                } else {
                    ShellLauncher.log(runtime, "Launching directly (no shell)");
                    cfg.verifyExecutableForDirect();
                    aProcess = ShellLauncher.buildProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime, mergeEnv), pwd);
                }
            }
            catch (SecurityException se) {
                throw runtime.newSecurityError(se.getLocalizedMessage());
            }
            ShellLauncher.handleStreams(runtime, aProcess, input, output, error2);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    public static long runExternalWithoutWait(Ruby runtime, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject args2) {
        return ShellLauncher.runExternal(runtime, env, prog, options2, args2, false);
    }

    public static long runExternal(Ruby runtime, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject args2, boolean wait3) {
        if (env.isNil() || !(env instanceof Map)) {
            env = null;
        }
        IRubyObject[] rawArgs = args2.convertToArray().toJavaArray();
        PrintStream output = runtime.getOutputStream();
        PrintStream error2 = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        try {
            Process aProcess = null;
            File pwd = new File(runtime.getCurrentDirectory());
            LaunchConfig cfg = new LaunchConfig(runtime, rawArgs, true);
            try {
                if (cfg.shouldRunInShell()) {
                    ShellLauncher.log(runtime, "Launching with shell");
                    cfg.verifyExecutableForShell();
                    aProcess = ShellLauncher.buildProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime, (Map)((Object)env)), pwd);
                } else {
                    ShellLauncher.log(runtime, "Launching directly (no shell)");
                    cfg.verifyExecutableForDirect();
                    aProcess = ShellLauncher.buildProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime, (Map)((Object)env)), pwd);
                }
            }
            catch (SecurityException se) {
                throw runtime.newSecurityError(se.getLocalizedMessage());
            }
            if (wait3) {
                ShellLauncher.handleStreams(runtime, aProcess, input, output, error2);
                try {
                    return aProcess.waitFor();
                }
                catch (InterruptedException e) {
                    throw runtime.newThreadError("unexpected interrupt");
                }
            }
            ShellLauncher.handleStreamsNonblocking(runtime, aProcess, runtime.getOutputStream(), error2);
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    public static Process buildProcess(Ruby runtime, String[] args2, String[] env, File pwd) throws IOException {
        return runtime.getPosix().newProcessMaker(args2).environment(env).directory(pwd).start();
    }

    public static long runExternalWithoutWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime, rawArgs, runtime.getOutputStream());
    }

    public static int execAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.execAndWait(runtime, rawArgs, Collections.EMPTY_MAP);
    }

    public static int execAndWait(Ruby runtime, IRubyObject[] rawArgs, Map mergeEnv) {
        File pwd = new File(runtime.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime, rawArgs, true);
        if (cfg.shouldRunInProcess()) {
            ShellLauncher.log(runtime, "ExecAndWait in-process");
            try {
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime, mergeEnv), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runExternalAndWait(runtime, rawArgs, mergeEnv);
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output) {
        return ShellLauncher.runAndWait(runtime, rawArgs, output, true);
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output, boolean doExecutableSearch) {
        return (int)ShellLauncher.runAndWaitPid(runtime, rawArgs, output, doExecutableSearch)[0];
    }

    public static long[] runAndWaitPid(Ruby runtime, IRubyObject[] rawArgs, OutputStream output, boolean doExecutableSearch) {
        PrintStream error2 = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime, rawArgs, doExecutableSearch);
            ShellLauncher.handleStreams(runtime, aProcess, input, output, error2);
            return new long[]{aProcess.waitFor(), ShellLauncher.getPidFromProcess(aProcess)};
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    private static long runWithoutWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error2 = runtime.getErrorStream();
        try {
            Process aProcess = ShellLauncher.run(runtime, rawArgs, true);
            ShellLauncher.handleStreamsNonblocking(runtime, aProcess, output, error2);
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    private static long runExternalWithoutWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error2 = runtime.getErrorStream();
        try {
            Process aProcess = ShellLauncher.run(runtime, rawArgs, true, true);
            ShellLauncher.handleStreamsNonblocking(runtime, aProcess, output, error2);
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    public static long getPidFromProcess(Process process) {
        if (process instanceof ScriptThreadProcess) {
            return process.hashCode();
        }
        if (process instanceof POpenProcess) {
            return ShellLauncher.reflectPidFromProcess(((POpenProcess)process).getChild());
        }
        return ShellLauncher.reflectPidFromProcess(process);
    }

    public static long reflectPidFromProcess(Process process) {
        return PID_GETTER.getPid(process);
    }

    public static Process run(Ruby runtime, IRubyObject string2) throws IOException {
        return ShellLauncher.run(runtime, new IRubyObject[]{string2}, false);
    }

    public static POpenProcess popen(Ruby runtime, IRubyObject string2, IOOptions modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime, new IRubyObject[]{string2}, null, true), runtime, modes);
    }

    public static POpenProcess popen(Ruby runtime, IRubyObject[] strings, Map env, IOOptions modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime, strings, env), runtime, modes);
    }

    public static POpenProcess popen3(Ruby runtime, IRubyObject[] strings) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime, strings));
    }

    public static POpenProcess popen3(Ruby runtime, IRubyObject[] strings, boolean addShell) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime, strings, null, addShell));
    }

    private static Process popenShared(Ruby runtime, IRubyObject[] strings) throws IOException {
        return ShellLauncher.popenShared(runtime, strings, null);
    }

    private static Process popenShared(Ruby runtime, IRubyObject[] strings, Map env) throws IOException {
        return ShellLauncher.popenShared(runtime, strings, env, false);
    }

    private static Process popenShared(Ruby runtime, IRubyObject[] strings, Map env, boolean addShell) throws IOException {
        String shell = ShellLauncher.getShell(runtime);
        Process childProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        try {
            String[] argArray;
            String[] args2 = ShellLauncher.parseCommandLine(runtime.getCurrentContext(), runtime, strings);
            boolean useShell = false;
            if (addShell) {
                for (String arg2 : args2) {
                    useShell |= ShellLauncher.shouldUseShell(arg2);
                }
            }
            if (strings.length == 1) {
                if (useShell) {
                    argArray = new String[]{shell, shell.endsWith("sh") ? "-c" : "/c", strings[0].asJavaString()};
                    childProcess = ShellLauncher.buildProcess(runtime, argArray, ShellLauncher.getCurrentEnv(runtime, env), pwd);
                } else {
                    childProcess = ShellLauncher.buildProcess(runtime, args2, ShellLauncher.getCurrentEnv(runtime, env), pwd);
                }
            } else if (useShell) {
                argArray = new String[args2.length + 2];
                argArray[0] = shell;
                argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
                System.arraycopy(args2, 0, argArray, 2, args2.length);
                childProcess = ShellLauncher.buildProcess(runtime, argArray, ShellLauncher.getCurrentEnv(runtime, env), pwd);
            } else {
                childProcess = ShellLauncher.buildProcess(runtime, args2, ShellLauncher.getCurrentEnv(runtime, env), pwd);
            }
        }
        catch (SecurityException se) {
            throw runtime.newSecurityError(se.getLocalizedMessage());
        }
        return childProcess;
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        while (filteredStream instanceof FilterOutputStream) {
            try {
                filteredStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, (String)"out", (Object)filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        while (filteredStream instanceof BufferedInputStream) {
            try {
                filteredStream = (InputStream)FieldAccess.getProtectedFieldValue(BufferedInputStream.class, (String)"in", (Object)filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static Process run(Ruby runtime, IRubyObject[] rawArgs, boolean doExecutableSearch) throws IOException {
        return ShellLauncher.run(runtime, rawArgs, doExecutableSearch, false);
    }

    public static Process run(Ruby runtime, IRubyObject[] rawArgs, boolean doExecutableSearch, boolean forceExternalProcess) throws IOException {
        Process aProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime, rawArgs, doExecutableSearch);
        try {
            if (!forceExternalProcess && cfg.shouldRunInProcess()) {
                ShellLauncher.log(runtime, "Launching in-process");
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime), pwd);
                ipScript.start();
                return ipScript;
            }
            if (cfg.shouldRunInShell()) {
                ShellLauncher.log(runtime, "Launching with shell");
                cfg.verifyExecutableForShell();
            } else {
                ShellLauncher.log(runtime, "Launching directly (no shell)");
                cfg.verifyExecutableForDirect();
            }
            aProcess = ShellLauncher.buildProcess(runtime, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime), pwd);
        }
        catch (SecurityException se) {
            throw runtime.newSecurityError(se.getLocalizedMessage());
        }
        return aProcess;
    }

    private static void handleStreams(Ruby runtime, Process p2, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(runtime, pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(runtime, pErr, err, false, Pumper.Slave.IN, p2);
        StreamPumper t3 = new StreamPumper(runtime, in, pIn, true, Pumper.Slave.OUT, p2);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io5) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io6) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        t1.stop();
        t2.stop();
        t3.stop();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t3.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private static void handleStreamsNonblocking(Ruby runtime, Process p2, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        StreamPumper t1 = new StreamPumper(runtime, pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(runtime, pErr, err, false, Pumper.Slave.IN, p2);
        t1.start();
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseCommandLine(ThreadContext context, Ruby runtime, IRubyObject[] rawArgs) {
        String[] args2;
        if (rawArgs.length == 1) {
            if (ShellLauncher.hasLeadingArgvArray(rawArgs)) {
                args2 = new String[]{ShellLauncher.getPathEntry((RubyArray)rawArgs[0])};
            } else {
                LoadService loadService = runtime.getLoadService();
                synchronized (loadService) {
                    runtime.getLoadService().require("jruby/path_helper");
                }
                RubyModule pathHelper = runtime.getClassFromPath("JRuby::PathHelper");
                RubyArray parts = (RubyArray)RuntimeHelpers.invoke(context, (IRubyObject)pathHelper, "smart_split_command", rawArgs);
                args2 = new String[parts.getLength()];
                for (int i2 = 0; i2 < parts.getLength(); ++i2) {
                    args2[i2] = parts.entry(i2).toString();
                }
            }
        } else {
            args2 = new String[rawArgs.length];
            int start2 = 0;
            if (ShellLauncher.hasLeadingArgvArray(rawArgs)) {
                start2 = 1;
                args2[0] = ShellLauncher.getPathEntry((RubyArray)rawArgs[0]);
            }
            for (int i3 = start2; i3 < rawArgs.length; ++i3) {
                args2[i3] = rawArgs[i3].toString();
            }
        }
        return args2;
    }

    private static boolean hasLeadingArgvArray(IRubyObject[] rawArgs) {
        return rawArgs.length >= 1 && rawArgs[0] instanceof RubyArray && ((RubyArray)rawArgs[0]).getLength() == 2;
    }

    private static String getPathEntry(RubyArray initArray) {
        return initArray.entry(0).toString();
    }

    private static String getShell(Ruby runtime) {
        return RbConfigLibrary.jrubyShell();
    }

    private static boolean shouldUseShell(String command) {
        boolean useShell = false;
        for (char c : command.toCharArray()) {
            if (c == ' ' || Character.isLetter(c) || "*?{}[]<>()~&|\\$;'`\"\n".indexOf(c) == -1) continue;
            useShell = true;
        }
        if (Platform.IS_WINDOWS && command.charAt(0) == '@') {
            useShell = true;
        }
        return useShell;
    }

    static void log(Ruby runtime, String msg) {
        if (RubyInstanceConfig.DEBUG_LAUNCHING) {
            runtime.getErr().println("ShellLauncher: " + msg);
        }
    }

    static {
        PidGetter pg = new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        };
        Class<?> up = null;
        Field pid2 = null;
        try {
            up = Class.forName("java.lang.UNIXProcess");
            pid2 = up.getDeclaredField("pid");
            pid2.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        UNIXProcess = up;
        UNIXProcess_pid = pid2;
        Class<?> pi = null;
        Field handle = null;
        try {
            pi = Class.forName("java.lang.ProcessImpl");
            handle = pi.getDeclaredField("handle");
            handle.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        ProcessImpl = pi;
        ProcessImpl_handle = handle;
        pg = UNIXProcess_pid != null ? (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                    if (ProcessImpl.isInstance(process)) {
                        Long hproc = (Long)ProcessImpl_handle.get(process);
                        return WindowsFFI.getKernel32().GetProcessId(hproc.intValue());
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        }) : (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (ProcessImpl.isInstance(process)) {
                        Long hproc = (Long)ProcessImpl_handle.get(process);
                        return WindowsFFI.getKernel32().GetProcessId(hproc.intValue());
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        });
        PID_GETTER = pg;
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private final FileChannel inChannel;
        private final FileChannel outChannel;
        private final Pumper.Slave slave;
        private final Object sync;
        private volatile boolean quit;
        private final Ruby runtime;

        ChannelPumper(Ruby runtime, FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave, Object sync2) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int read2;
            this.runtime.getCurrentContext().setEventHooksEnabled(false);
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            buf.clear();
            try {
                try {}
                catch (Exception exception2) {
                    Object var4_5 = null;
                    Object object3 = this.sync;
                    // MONITORENTER : object3
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                                return;
                            }
                            catch (IOException ioe) {
                                return;
                            }
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                return;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                                return;
                            }
                        }
                    }
                    // MONITOREXIT : object3
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Object object2 = this.sync;
                // MONITORENTER : object2
                switch (this.slave) {
                    case OUT: {
                        try {}
                        catch (IOException ioe) {
                            throw throwable;
                        }
                        this.outChannel.close();
                        throw throwable;
                    }
                    case IN: {
                        try {}
                        catch (IOException ioe) {
                            // empty catch block
                            throw throwable;
                        }
                        this.inChannel.close();
                        throw throwable;
                    }
                }
                // MONITOREXIT : object2
                throw throwable;
            }
            while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen() && (read2 = this.inChannel.read(buf)) != -1) {
                buf.flip();
                this.outChannel.write(buf);
                buf.clear();
            }
            Object var4_4 = null;
            Object object = this.sync;
            // MONITORENTER : object
            switch (this.slave) {
                case OUT: {
                    try {}
                    catch (IOException ioe) {
                        return;
                    }
                    this.outChannel.close();
                    return;
                }
                case IN: {
                    try {}
                    catch (IOException ioe) {
                        // empty catch block
                        return;
                    }
                    this.inChannel.close();
                    return;
                }
            }
            // MONITOREXIT : object
        }

        public void quit() {
            this.interrupt();
            this.quit = true;
            this.stop();
        }
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private final InputStream in;
        private final OutputStream out;
        private final boolean onlyIfAvailable;
        private final Object waitLock = new Object();
        private final Object sync;
        private final Pumper.Slave slave;
        private volatile boolean quit;
        private final Ruby runtime;

        StreamPumper(Ruby runtime, InputStream in, OutputStream out, boolean avail, Pumper.Slave slave, Object sync2) {
            this.in = ShellLauncher.unwrapBufferedStream(in);
            this.out = ShellLauncher.unwrapBufferedStream(out);
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block25: {
                Object object;
                this.runtime.getCurrentContext().setEventHooksEnabled(false);
                byte[] buf = new byte[1024];
                boolean hasReadSomething = false;
                try {
                    while (!this.quit) {
                        int numRead;
                        if (this.onlyIfAvailable && !hasReadSomething) {
                            if (this.in.available() == 0) {
                                Object object2 = this.waitLock;
                                synchronized (object2) {
                                    this.waitLock.wait(10L);
                                    continue;
                                }
                            }
                            hasReadSomething = true;
                        }
                        if ((numRead = this.in.read(buf)) == -1) break;
                        this.out.write(buf, 0, numRead);
                    }
                    Object var7_7 = null;
                    if (!this.onlyIfAvailable) break block25;
                    object = this.sync;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (this.onlyIfAvailable) {
                        Object object3 = this.sync;
                        synchronized (object3) {
                            if (this.slave == Pumper.Slave.OUT) {
                                try {
                                    this.out.close();
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (object) {
                    if (this.slave == Pumper.Slave.OUT) {
                        try {
                            this.out.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
                {
                    catch (Exception exception2) {
                        Object var7_8 = null;
                        if (!this.onlyIfAvailable) break block25;
                        Object object4 = this.sync;
                        synchronized (object4) {
                            if (this.slave == Pumper.Slave.OUT) {
                                try {
                                    this.out.close();
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
            this.stop();
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Slave {
            IN,
            OUT;

        }
    }

    public static class LaunchConfig {
        private Ruby runtime;
        private boolean doExecutableSearch;
        private IRubyObject[] rawArgs;
        private String shell;
        private String[] args;
        private String[] execArgs;
        private boolean cmdBuiltin = false;
        private String executable;
        private File executableFile;

        public LaunchConfig(Ruby runtime, IRubyObject[] rawArgs, boolean doExecutableSearch) {
            this.runtime = runtime;
            this.rawArgs = rawArgs;
            this.doExecutableSearch = doExecutableSearch;
            this.shell = ShellLauncher.getShell(runtime);
            this.args = ShellLauncher.parseCommandLine(runtime.getCurrentContext(), runtime, rawArgs);
        }

        public boolean shouldRunInProcess() {
            int startIndex;
            String[] slashDelimitedTokens;
            String finalToken;
            boolean inProc;
            if (!this.runtime.getInstanceConfig().isRunRubyInProcess() || RubyInstanceConfig.hasLoadedNativeExtensions()) {
                return false;
            }
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                String c = this.args[i2];
                if (c.trim().length() == 0) continue;
                char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
                block5: for (int j = 0; j < firstLast.length; ++j) {
                    switch (firstLast[j]) {
                        case '\n': 
                        case '\"': 
                        case '$': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '`': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            return false;
                        }
                        case '2': {
                            if (c.length() <= 1 || c.charAt(1) != '>') continue block5;
                            return false;
                        }
                    }
                }
            }
            String command = this.args[0];
            if (Platform.IS_WINDOWS) {
                command = command.toLowerCase();
            }
            boolean bl = inProc = (finalToken = (slashDelimitedTokens = command.split("[/\\\\]"))[slashDelimitedTokens.length - 1]).endsWith("ruby") || Platform.IS_WINDOWS && finalToken.endsWith("ruby.exe") || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
            if (!inProc) {
                return false;
            }
            if (this.args.length > 1) {
                for (int i3 = 1; i3 < this.args.length; ++i3) {
                    this.checkGlobChar(this.args[i3]);
                }
            }
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                this.args[0] = this.runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            this.execArgs = new String[this.args.length - startIndex];
            System.arraycopy(this.args, startIndex, this.execArgs, 0, this.execArgs.length);
            return true;
        }

        public boolean shouldRunInShell() {
            if (this.rawArgs.length != 1) {
                return false;
            }
            if (!Platform.IS_WINDOWS) {
                return true;
            }
            if (this.shell == null) {
                return false;
            }
            for (String arg2 : this.args) {
                if (LaunchConfig.shouldVerifyPathExecutable(arg2.trim())) continue;
                return true;
            }
            this.executable = this.args[0].trim();
            this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            if (this.executableFile != null) {
                ShellLauncher.log(this.runtime, "Got it: " + this.executableFile);
                return false;
            }
            ShellLauncher.log(this.runtime, "Didn't find executable: " + this.executable);
            if (this.isCmdBuiltin(this.executable)) {
                this.cmdBuiltin = true;
                return true;
            }
            return false;
        }

        public void verifyExecutableForShell() {
            String cmdline = this.rawArgs[0].toString().trim();
            if (this.doExecutableSearch && LaunchConfig.shouldVerifyPathExecutable(cmdline) && !this.cmdBuiltin) {
                this.verifyExecutable();
            }
            this.execArgs = new String[3];
            this.execArgs[0] = this.shell;
            this.execArgs[1] = this.shell.endsWith("sh") ? "-c" : "/c";
            this.execArgs[2] = Platform.IS_WINDOWS ? "\"" + cmdline + "\"" : cmdline;
        }

        public void verifyExecutableForDirect() {
            this.verifyExecutable();
            this.execArgs = this.args;
            try {
                this.execArgs[0] = this.executableFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void verifyExecutable() {
            if (this.executableFile == null) {
                if (this.executable == null) {
                    this.executable = this.args[0].trim();
                }
                this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            }
            if (this.executableFile == null) {
                throw this.runtime.newErrnoENOENTError(this.executable);
            }
        }

        public String[] getExecArgs() {
            return this.execArgs;
        }

        private static boolean isBatch(File f) {
            String path2 = f.getPath();
            return path2.endsWith(".bat") || path2.endsWith(".cmd");
        }

        private boolean isCmdBuiltin(String cmd) {
            int idx;
            if (!this.shell.endsWith("sh") && (idx = Arrays.binarySearch(WINDOWS_INTERNAL_CMDS, cmd.toLowerCase())) >= 0) {
                ShellLauncher.log(this.runtime, "Found Windows shell's built-in command: " + cmd);
                return true;
            }
            return false;
        }

        private static boolean hasRedirection(String cmdline) {
            if (Platform.IS_WINDOWS) {
                char quote2 = '\u0000';
                int idx = 0;
                block6: while (idx < cmdline.length()) {
                    char ptr = cmdline.charAt(idx);
                    switch (ptr) {
                        case '\"': 
                        case '\'': {
                            if (quote2 == '\u0000') {
                                quote2 = ptr;
                            } else if (quote2 == ptr) {
                                quote2 = '\u0000';
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\n': 
                        case '<': 
                        case '>': 
                        case '|': {
                            if (quote2 == '\u0000') {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '%': {
                            Matcher envVarMatcher = WIN_ENVVAR_PATTERN.matcher(cmdline.substring(idx));
                            if (envVarMatcher.find()) {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\\': {
                            ++idx;
                        }
                    }
                    ++idx;
                }
                return false;
            }
            Matcher metaMatcher = SHELL_METACHARACTER_PATTERN.matcher(cmdline);
            return metaMatcher.find();
        }

        private static boolean shouldVerifyPathExecutable(String cmdline) {
            boolean verifyPathExecutable = true;
            if (LaunchConfig.hasRedirection(cmdline)) {
                return false;
            }
            return verifyPathExecutable;
        }

        private void checkGlobChar(String word) {
            if (word.contains("*") || word.contains("?") || word.contains("[") || word.contains("{")) {
                this.runtime.getErr().println("Warning: treating '" + word + "' literally." + " Consider passing -J-Djruby.launch.inproc=false.");
            }
        }
    }

    public static class POpenProcess
    extends Process {
        private final Process child;
        private final boolean waitForChild;
        private InputStream realInput;
        private OutputStream realOutput;
        private InputStream realInerr;
        private InputStream input;
        private OutputStream output;
        private InputStream inerr;
        private FileChannel inputChannel;
        private FileChannel outputChannel;
        private FileChannel inerrChannel;
        private Pumper inputPumper;
        private Pumper inerrPumper;

        public POpenProcess(Process child, Ruby runtime, IOOptions modes) {
            this.child = child;
            if (modes.getModeFlags().isWritable()) {
                this.waitForChild = true;
                this.prepareOutput(child);
            } else {
                this.waitForChild = false;
                try {
                    child.getOutputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (modes.getModeFlags().isReadable()) {
                this.prepareInput(child);
            } else {
                this.pumpInput(child, runtime);
            }
            this.pumpInerr(child, runtime);
        }

        public POpenProcess(Process child) {
            this.child = child;
            this.waitForChild = false;
            this.prepareOutput(child);
            this.prepareInput(child);
            this.prepareInerr(child);
        }

        public OutputStream getOutputStream() {
            return this.output;
        }

        public InputStream getInputStream() {
            return this.input;
        }

        public InputStream getErrorStream() {
            return this.inerr;
        }

        public FileChannel getInput() {
            return this.inputChannel;
        }

        public FileChannel getOutput() {
            return this.outputChannel;
        }

        public FileChannel getError() {
            return this.inerrChannel;
        }

        public boolean hasOutput() {
            return this.output != null || this.outputChannel != null;
        }

        public Process getChild() {
            return this.child;
        }

        public int waitFor() throws InterruptedException {
            return this.child.waitFor();
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            try {
                try {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.inerr != null) {
                        this.inerr.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.inputChannel != null) {
                        this.inputChannel.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.inerrChannel != null) {
                        this.inerrChannel.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.outputChannel != null) {
                        this.outputChannel.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                POpenProcess e = this;
                synchronized (e) {
                    Pumper pumper;
                    if (this.inputPumper != null) {
                        pumper = this.inputPumper;
                        synchronized (pumper) {
                            this.inputPumper.quit();
                        }
                    }
                    if (this.inerrPumper != null) {
                        pumper = this.inerrPumper;
                        synchronized (pumper) {
                            this.inerrPumper.quit();
                        }
                    }
                    if (this.waitForChild) {
                        this.waitFor();
                    } else {
                        RubyIO.obliterateProcess(this.child);
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }

        private void prepareInput(Process child) {
            this.realInput = child.getInputStream();
            this.input = ShellLauncher.unwrapBufferedStream(this.realInput);
            this.inputChannel = this.input instanceof FileInputStream ? ((FileInputStream)this.input).getChannel() : null;
            this.inputPumper = null;
        }

        private void prepareInerr(Process child) {
            this.realInerr = child.getErrorStream();
            this.inerr = ShellLauncher.unwrapBufferedStream(this.realInerr);
            this.inerrChannel = this.inerr instanceof FileInputStream ? ((FileInputStream)this.inerr).getChannel() : null;
            this.inerrPumper = null;
        }

        private void prepareOutput(Process child) {
            this.realOutput = child.getOutputStream();
            this.output = ShellLauncher.unwrapBufferedStream(this.realOutput);
            this.outputChannel = this.output instanceof FileOutputStream ? ((FileOutputStream)this.output).getChannel() : null;
        }

        private void pumpInput(Process child, Ruby runtime) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getInputStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inputPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inputPumper.start();
            this.input = null;
            this.inputChannel = null;
        }

        private void pumpInerr(Process child, Ruby runtime) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getErrorStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inerrPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inerrPumper.start();
            this.inerr = null;
            this.inerrChannel = null;
        }
    }

    private static interface PidGetter {
        public long getPid(Process var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private final String[] argArray;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;
        private final PipedInputStream processOutput;
        private final PipedInputStream processError;
        private final PipedOutputStream processInput;
        private RubyInstanceConfig config;
        private Thread processThread;
        private int result;
        private Ruby parentRuntime;

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir) {
            this(parentRuntime, argArray, env, dir, true);
        }

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.parentRuntime = parentRuntime;
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            } else {
                this.processError = null;
                this.processOutput = null;
                this.processInput = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block8: {
                this.result = new Main(this.config).run(this.argArray).getStatus();
                Object var3_1 = null;
                this.config.getOutput().close();
                this.config.getError().close();
                try {
                    this.config.getInput().close();
                }
                catch (IOException ioe) {}
                break block8;
                {
                    catch (Throwable throwable) {
                        throwable.printStackTrace(this.config.getError());
                        this.result = -1;
                        Object var3_2 = null;
                        this.config.getOutput().close();
                        this.config.getError().close();
                        try {
                            this.config.getInput().close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.config.getOutput().close();
                    this.config.getError().close();
                    try {
                        this.config.getInput().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i2 = 0; i2 < env.length; ++i2) {
                String[] kv = env[i2].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(this.parentRuntime.getInstanceConfig()){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io2) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io3) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

