/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.operands.Label;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.transformations.inlining.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionRegion {
    private Label ensureBlockLabel;
    private Label firstRescueBlockLabel;
    private List<BasicBlock> exclusiveBBs;
    private List<ExceptionRegion> nestedRegions;
    private BasicBlock endBB;
    private BasicBlock firstRescueBB;

    public ExceptionRegion(Label firstRescueBlockLabel, Label ensureBlockLabel) {
        this.firstRescueBlockLabel = firstRescueBlockLabel;
        this.ensureBlockLabel = ensureBlockLabel;
        this.exclusiveBBs = new ArrayList<BasicBlock>();
        this.nestedRegions = new ArrayList<ExceptionRegion>();
    }

    public void setEndBB(BasicBlock bb) {
        this.endBB = bb;
    }

    public Label getEnsureBlockLabel() {
        return this.ensureBlockLabel;
    }

    public List<BasicBlock> getExclusiveBBs() {
        return this.exclusiveBBs;
    }

    public void addBB(BasicBlock bb) {
        this.exclusiveBBs.add(bb);
    }

    public void addNestedRegion(ExceptionRegion r) {
        this.nestedRegions.add(r);
    }

    public void setFirstRescueBB(BasicBlock frbb) {
        this.firstRescueBB = frbb;
    }

    public Label getFirstRescueBlockLabel() {
        return this.firstRescueBlockLabel;
    }

    public ExceptionRegion cloneForInlining(InlinerInfo ii) {
        ExceptionRegion newR = new ExceptionRegion(ii.getRenamedLabel(this.firstRescueBlockLabel), this.ensureBlockLabel == null ? null : ii.getRenamedLabel(this.ensureBlockLabel));
        newR.endBB = ii.getRenamedBB(this.endBB);
        newR.firstRescueBB = ii.getRenamedBB(this.firstRescueBB);
        for (BasicBlock b : this.exclusiveBBs) {
            newR.addBB(ii.getRenamedBB(b));
        }
        for (ExceptionRegion r : this.nestedRegions) {
            newR.addNestedRegion(r.cloneForInlining(ii));
        }
        return newR;
    }
}

