/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsNode
extends Node {
    private final ListNode pre;
    private final int preCount;
    private final ListNode optArgs;
    protected final ArgumentNode restArgNode;
    protected final int restArg;
    private final BlockArgNode blockArgNode;
    protected Arity arity;
    private final int requiredArgsCount;
    protected final boolean hasOptArgs;
    protected final boolean hasMasgnArgs;
    protected int maxArgsCount;
    protected final boolean isSimple;
    private final ListNode post;
    private final int postCount;
    private final int postIndex;

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, BlockArgNode blockArgNode) {
        super(position);
        this.pre = pre;
        this.preCount = pre == null ? 0 : pre.size();
        this.post = post;
        this.postCount = post == null ? 0 : post.size();
        int optArgCount = optionalArguments == null ? 0 : optionalArguments.size();
        this.postIndex = this.getPostCount(this.preCount, optArgCount, rest2);
        this.optArgs = optionalArguments;
        this.restArg = rest2 == null ? -1 : rest2.getIndex();
        this.restArgNode = rest2;
        this.blockArgNode = blockArgNode;
        this.requiredArgsCount = this.preCount + this.postCount;
        this.hasOptArgs = this.getOptArgs() != null;
        this.hasMasgnArgs = this.hasMasgnArgs();
        this.maxArgsCount = this.getRestArg() >= 0 ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
        this.arity = this.calculateArity();
        this.isSimple = !this.hasMasgnArgs && !this.hasOptArgs && this.restArg < 0 && this.postCount <= 0;
    }

    private int getPostCount(int preCount, int optArgCount, RestArgNode rest2) {
        if (rest2 != null) {
            return rest2.getIndex() + 1;
        }
        return preCount + optArgCount;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    protected Arity calculateArity() {
        if (this.getOptArgs() != null || this.getRestArg() >= 0) {
            return Arity.required(this.getRequiredArgsCount());
        }
        return Arity.createArity(this.getRequiredArgsCount());
    }

    protected boolean hasMasgnArgs() {
        if (this.preCount > 0) {
            for (Node node : this.pre.childNodes()) {
                if (!(node instanceof AssignableNode)) continue;
                return true;
            }
        }
        if (this.postCount > 0) {
            for (Node node : this.post.childNodes()) {
                if (!(node instanceof AssignableNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getPre() {
        return this.pre;
    }

    @Deprecated
    public ListNode getArgs() {
        return this.pre;
    }

    public Arity getArity() {
        return this.arity;
    }

    public int getRequiredArgsCount() {
        return this.requiredArgsCount;
    }

    public int getOptionalArgsCount() {
        return this.optArgs == null ? 0 : this.optArgs.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    public int getMaxArgumentsCount() {
        return this.maxArgsCount;
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    @Deprecated
    public BlockArgNode getBlockArgNode() {
        return this.blockArgNode;
    }

    public BlockArgNode getBlock() {
        return this.blockArgNode;
    }

    public int getPostCount() {
        return this.postCount;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public int getPreCount() {
        return this.preCount;
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args2, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (!this.hasMasgnArgs) {
            if (this.preCount > 0) {
                scope.setArgValues(args2, Math.min(args2.length, this.preCount));
            }
            if (this.postCount > 0 && args2.length > this.preCount) {
                scope.setEndArgValues(args2, this.postIndex, Math.min(args2.length - this.preCount, this.postCount));
            }
        } else {
            this.masgnAwareArgAssign(context, runtime, self, args2, block, scope);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime, scope, self, args2);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    private void masgnAwareArgAssign(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args2, Block block, DynamicScope scope) {
        int size2;
        if (this.preCount > 0) {
            size2 = this.pre.size();
            for (int i2 = 0; i2 < size2 && i2 < args2.length; ++i2) {
                Node next = this.pre.get(i2);
                if (next instanceof AssignableNode) {
                    ((AssignableNode)next).assign(runtime, context, self, args2[i2], block, false);
                    continue;
                }
                if (next instanceof ArgumentNode) {
                    ArgumentNode argNode = (ArgumentNode)next;
                    scope.setValue(argNode.getIndex(), args2[i2], argNode.getDepth());
                    continue;
                }
                throw new RuntimeException("Whoa..not assignable and not an argument...what is it: " + next);
            }
        }
        if (this.postCount > 0) {
            size2 = this.post.size();
            int argsLength = args2.length;
            for (int i3 = 0; i3 < size2; ++i3) {
                Node next = this.post.get(i3);
                if (next instanceof AssignableNode) {
                    ((AssignableNode)next).assign(runtime, context, self, args2[argsLength - this.postCount + i3], block, false);
                    continue;
                }
                if (next instanceof ArgumentNode) {
                    ArgumentNode argNode = (ArgumentNode)next;
                    scope.setValue(argNode.getIndex(), args2[argsLength - this.postCount + i3], argNode.getDepth());
                    continue;
                }
                throw new RuntimeException("Whoa..not assignable and not an argument...what is it: " + next);
            }
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues();
        } else {
            this.prepare(context, runtime, self, IRubyObject.NULL_ARRAY, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4, arg5);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.isSimple) {
            scope.setArgValues(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        } else {
            this.prepare(context, runtime, self, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9}, block);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime, block);
        }
    }

    public void checkArgCount(Ruby runtime, int argsLength) {
        Arity.checkArgumentCount(runtime, argsLength, this.requiredArgsCount, this.maxArgsCount);
    }

    public void checkArgCount(Ruby runtime, String name2, int argsLength) {
        Arity.checkArgumentCount(runtime, name2, argsLength, this.requiredArgsCount, this.maxArgsCount);
    }

    protected void prepareOptOrRestArgs(ThreadContext context, Ruby runtime, DynamicScope scope, IRubyObject self, IRubyObject[] args2) {
        this.prepareRestArg(context, runtime, scope, args2, this.prepareOptionalArguments(context, runtime, self, args2));
    }

    protected int prepareOptionalArguments(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args2) {
        return this.hasOptArgs ? this.assignOptArgs(args2, runtime, context, self, this.preCount) : this.preCount;
    }

    protected void prepareRestArg(ThreadContext context, Ruby runtime, DynamicScope scope, IRubyObject[] args2, int givenArgsCount) {
        if (this.restArg >= 0) {
            int sizeOfRestArg = args2.length - this.postCount - givenArgsCount;
            if (sizeOfRestArg <= 0) {
                scope.setValue(this.restArg, RubyArray.newArray(runtime), 0);
            } else {
                scope.setValue(this.restArg, RubyArray.newArrayNoCopy(runtime, args2, givenArgsCount, sizeOfRestArg), 0);
            }
        }
    }

    protected int assignOptArgs(IRubyObject[] args2, Ruby runtime, ThreadContext context, IRubyObject self, int givenArgsCount) {
        int i2;
        int j = 0;
        for (i2 = this.preCount; i2 < args2.length - this.postCount && j < this.optArgs.size(); ++i2, ++j) {
            this.optArgs.get(j).assign(runtime, context, self, args2[i2], Block.NULL_BLOCK, true);
            ++givenArgsCount;
        }
        i2 = 0;
        while (j < this.optArgs.size()) {
            this.optArgs.get(j).interpret(runtime, context, self, Block.NULL_BLOCK);
            ++i2;
            ++j;
        }
        return givenArgsCount;
    }

    protected void processBlockArg(DynamicScope scope, Ruby runtime, Block block) {
        scope.setValue(this.getBlock().getCount(), RuntimeHelpers.processBlockArgument(runtime, block), 0);
    }

    @Override
    public List<Node> childNodes() {
        if (this.post != null) {
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.blockArgNode);
        }
        return Node.createList(this.pre, this.optArgs, this.restArgNode, this.blockArgNode);
    }
}

