/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

public class PsychParser
extends RubyObject {
    private static final Logger LOG = LoggerFactory.getLogger("PsychParser");
    public static final int YAML_ANY_ENCODING = 0;
    public static final int YAML_UTF8_ENCODING = UTF8Encoding.INSTANCE.getIndex();
    public static final int YAML_UTF16LE_ENCODING = UTF16LEEncoding.INSTANCE.getIndex();
    public static final int YAML_UTF16BE_ENCODING = UTF16BEEncoding.INSTANCE.getIndex();
    private Parser parser;
    private Event event;

    public static void initPsychParser(Ruby runtime, RubyModule psych2) {
        RubyClass psychParser = runtime.defineClassUnder("Parser", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new PsychParser(runtime, klazz);
            }
        }, psych2);
        RubyKernel.require(runtime.getNil(), runtime.newString("psych/syntax_error"), Block.NULL_BLOCK);
        psychParser.defineConstant("ANY", runtime.newFixnum(0));
        psychParser.defineConstant("UTF8", runtime.newFixnum(YAML_UTF8_ENCODING));
        psychParser.defineConstant("UTF16LE", runtime.newFixnum(YAML_UTF16LE_ENCODING));
        psychParser.defineConstant("UTF16BE", runtime.newFixnum(YAML_UTF16BE_ENCODING));
        psychParser.defineAnnotatedMethods(PsychParser.class);
        psych2.defineClassUnder("SyntaxError", runtime.getSyntaxError(), RubyException.EXCEPTION_ALLOCATOR);
    }

    public PsychParser(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context, IRubyObject yaml) {
        Ruby runtime = context.runtime;
        return this.parse(context, yaml, runtime.getNil());
    }

    private IRubyObject stringOrNilFor(Ruby runtime, String value2, boolean tainted) {
        if (value2 == null) {
            return runtime.getNil();
        }
        return this.stringFor(runtime, value2, tainted);
    }

    private RubyString stringFor(Ruby runtime, String value2, boolean tainted) {
        ByteList bytes2 = new ByteList(value2.getBytes(RubyEncoding.UTF8), (Encoding)UTF8Encoding.INSTANCE);
        RubyString string2 = RubyString.newString(runtime, bytes2);
        string2.setTaint(tainted);
        return string2;
    }

    private StreamReader readerFor(IRubyObject yaml) {
        if (yaml.respondsTo("read")) {
            return new StreamReader((Reader)new InputStreamReader((InputStream)new IOInputStream(yaml), RubyEncoding.UTF8));
        }
        return new StreamReader((Reader)new StringReader(yaml.convertToString().asJavaString()));
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context, IRubyObject yaml, IRubyObject path2) {
        Ruby runtime = context.runtime;
        boolean tainted = yaml.isTaint() || yaml instanceof RubyIO;
        try {
            this.parser = new ParserImpl(this.readerFor(yaml));
            if (path2.isNil() && yaml.respondsTo("path")) {
                path2 = yaml.callMethod(context, "path");
            }
            IRubyObject handler = this.getInstanceVariable("@handler");
            while (true) {
                this.event = this.parser.getEvent();
                if (this.event.is(Event.ID.StreamStart)) {
                    RuntimeHelpers.invoke(context, handler, "start_stream", (IRubyObject)runtime.newFixnum(0));
                    continue;
                }
                if (this.event.is(Event.ID.DocumentStart)) {
                    this.handleDocumentStart(context, (DocumentStartEvent)this.event, tainted, handler);
                    continue;
                }
                if (this.event.is(Event.ID.DocumentEnd)) {
                    RubyBoolean notExplicit = runtime.newBoolean(!((DocumentEndEvent)this.event).getExplicit());
                    RuntimeHelpers.invoke(context, handler, "end_document", (IRubyObject)notExplicit);
                    continue;
                }
                if (this.event.is(Event.ID.Alias)) {
                    IRubyObject alias2 = this.stringOrNilFor(runtime, ((AliasEvent)this.event).getAnchor(), tainted);
                    RuntimeHelpers.invoke(context, handler, "alias", alias2);
                    continue;
                }
                if (this.event.is(Event.ID.Scalar)) {
                    this.handleScalar(context, (ScalarEvent)this.event, tainted, handler);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceStart)) {
                    this.handleSequenceStart(context, (SequenceStartEvent)this.event, tainted, handler);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceEnd)) {
                    RuntimeHelpers.invoke(context, handler, "end_sequence");
                    continue;
                }
                if (this.event.is(Event.ID.MappingStart)) {
                    this.handleMappingStart(context, (MappingStartEvent)this.event, tainted, handler);
                    continue;
                }
                if (this.event.is(Event.ID.MappingEnd)) {
                    RuntimeHelpers.invoke(context, handler, "end_mapping");
                    continue;
                }
                if (this.event.is(Event.ID.StreamEnd)) break;
            }
            RuntimeHelpers.invoke(context, handler, "end_stream");
        }
        catch (ParserException pe) {
            this.parser = null;
            PsychParser.raiseParserException(context, yaml, (MarkedYAMLException)pe, path2);
        }
        catch (ScannerException se) {
            this.parser = null;
            StringBuilder message2 = new StringBuilder("syntax error");
            if (se.getProblemMark() != null) {
                message2.append(se.getProblemMark().toString());
            }
            PsychParser.raiseParserException(context, yaml, (MarkedYAMLException)se, path2);
        }
        catch (ReaderException re) {
            this.parser = null;
            PsychParser.raiseParserException(context, yaml, re, path2);
        }
        catch (Throwable t) {
            UnsafeFactory.getUnsafe().throwException(t);
            return this;
        }
        return this;
    }

    private void handleDocumentStart(ThreadContext context, DocumentStartEvent dse, boolean tainted, IRubyObject handler) {
        Ruby runtime = context.runtime;
        Integer[] versionInts = dse.getVersion();
        RubyArray version2 = versionInts == null ? RubyArray.newArray(runtime) : RubyArray.newArray(runtime, runtime.newFixnum(versionInts[0]), runtime.newFixnum(versionInts[1]));
        Map tagsMap = dse.getTags();
        RubyArray tags = RubyArray.newArray(runtime);
        if (tagsMap != null && tagsMap.size() > 0) {
            for (Map.Entry tag2 : tagsMap.entrySet()) {
                RubyString key2 = this.stringFor(runtime, (String)tag2.getKey(), tainted);
                RubyString value2 = this.stringFor(runtime, (String)tag2.getValue(), tainted);
                tags.append(RubyArray.newArray(runtime, key2, value2));
            }
        }
        RubyBoolean notExplicit = runtime.newBoolean(!dse.getExplicit());
        RuntimeHelpers.invoke(context, handler, "start_document", (IRubyObject)version2, (IRubyObject)tags, (IRubyObject)notExplicit);
    }

    private void handleMappingStart(ThreadContext context, MappingStartEvent mse, boolean tainted, IRubyObject handler) {
        Ruby runtime = context.runtime;
        IRubyObject anchor = this.stringOrNilFor(runtime, mse.getAnchor(), tainted);
        IRubyObject tag2 = this.stringOrNilFor(runtime, mse.getTag(), tainted);
        RubyBoolean implicit = runtime.newBoolean(mse.getImplicit());
        RubyFixnum style = runtime.newFixnum(PsychParser.translateFlowStyle(mse.getFlowStyle()));
        RuntimeHelpers.invoke(context, handler, "start_mapping", anchor, tag2, implicit, style);
    }

    private void handleScalar(ThreadContext context, ScalarEvent se, boolean tainted, IRubyObject handler) {
        Ruby runtime = context.runtime;
        IRubyObject anchor = this.stringOrNilFor(runtime, se.getAnchor(), tainted);
        IRubyObject tag2 = this.stringOrNilFor(runtime, se.getTag(), tainted);
        RubyBoolean plain_implicit = runtime.newBoolean(se.getImplicit().canOmitTagInPlainScalar());
        RubyBoolean quoted_implicit = runtime.newBoolean(se.getImplicit().canOmitTagInNonPlainScalar());
        RubyFixnum style = runtime.newFixnum(PsychParser.translateStyle(se.getStyle()));
        RubyString val = this.stringFor(runtime, se.getValue(), tainted);
        RuntimeHelpers.invoke(context, handler, "scalar", val, anchor, tag2, plain_implicit, quoted_implicit, style);
    }

    private void handleSequenceStart(ThreadContext context, SequenceStartEvent sse, boolean tainted, IRubyObject handler) {
        Ruby runtime = context.runtime;
        IRubyObject anchor = this.stringOrNilFor(runtime, sse.getAnchor(), tainted);
        IRubyObject tag2 = this.stringOrNilFor(runtime, sse.getTag(), tainted);
        RubyBoolean implicit = runtime.newBoolean(sse.getImplicit());
        RubyFixnum style = runtime.newFixnum(PsychParser.translateFlowStyle(sse.getFlowStyle()));
        RuntimeHelpers.invoke(context, handler, "start_sequence", anchor, tag2, implicit, style);
    }

    private static void raiseParserException(ThreadContext context, IRubyObject yaml, ReaderException re, IRubyObject rbPath) {
        Ruby runtime = context.runtime;
        RubyClass se = (RubyClass)runtime.getModule("Psych").getConstant("SyntaxError");
        IRubyObject exception2 = se.newInstance(context, new IRubyObject[]{rbPath, runtime.newFixnum(0), runtime.newFixnum(0), runtime.newFixnum(re.getPosition()), null == re.getName() ? runtime.getNil() : runtime.newString(re.getName()), null == re.toString() ? runtime.getNil() : runtime.newString(re.toString())}, Block.NULL_BLOCK);
        RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{exception2}, Block.NULL_BLOCK);
    }

    private static void raiseParserException(ThreadContext context, IRubyObject yaml, MarkedYAMLException mye, IRubyObject rbPath) {
        Ruby runtime = context.runtime;
        RubyClass se = (RubyClass)runtime.getModule("Psych").getConstant("SyntaxError");
        Mark mark2 = mye.getProblemMark();
        IRubyObject exception2 = se.newInstance(context, new IRubyObject[]{rbPath, runtime.newFixnum(mark2.getLine() + 1), runtime.newFixnum(mark2.getColumn() + 1), runtime.newFixnum(mark2.getIndex()), null == mye.getProblem() ? runtime.getNil() : runtime.newString(mye.getProblem()), null == mye.getContext() ? runtime.getNil() : runtime.newString(mye.getContext())}, Block.NULL_BLOCK);
        RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{exception2}, Block.NULL_BLOCK);
    }

    private static int translateStyle(Character style) {
        if (style == null) {
            return 0;
        }
        switch (style.charValue()) {
            case '\u0000': {
                return 1;
            }
            case '\'': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '|': {
                return 4;
            }
            case '>': {
                return 5;
            }
        }
        return 0;
    }

    private static int translateFlowStyle(Boolean flowStyle) {
        if (flowStyle == null) {
            return 0;
        }
        if (flowStyle.booleanValue()) {
            return 2;
        }
        return 1;
    }

    @JRubyMethod
    public IRubyObject mark(ThreadContext context) {
        Ruby runtime = context.runtime;
        Event event = null;
        if (this.parser != null && (event = this.parser.peekEvent()) == null) {
            event = this.event;
        }
        if (event == null) {
            return ((RubyClass)context.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(context, runtime.newFixnum(0), runtime.newFixnum(0), runtime.newFixnum(0), Block.NULL_BLOCK);
        }
        Mark mark2 = event.getStartMark();
        return ((RubyClass)context.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(context, runtime.newFixnum(mark2.getIndex()), runtime.newFixnum(mark2.getLine()), runtime.newFixnum(mark2.getColumn()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"external_encoding="})
    public IRubyObject external_encoding_set(ThreadContext context, IRubyObject encoding2) {
        return encoding2;
    }
}

