/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.SecureRandom;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Random {
    public static void createRandom(Ruby runtime, RubyModule ossl) {
        RubyModule rand2 = ossl.defineModuleUnder("Random");
        RubyClass osslError = (RubyClass)ossl.getConstant("OpenSSLError");
        rand2.defineClassUnder("RandomError", osslError, osslError.getAllocator());
        rand2.defineAnnotatedMethods(Random.class);
        RandomHolder holder = new RandomHolder();
        holder.randomizers = new java.util.Random[]{new java.util.Random(), new SecureRandom()};
        rand2.dataWrapStruct(holder);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_random_file(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject write_random_file(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_bytes(IRubyObject recv2, IRubyObject arg2) {
        return Random.generate(recv2, arg2, 1);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject pseudo_bytes(IRubyObject recv2, IRubyObject arg2) {
        return Random.generate(recv2, arg2, 0);
    }

    private static RubyString generate(IRubyObject recv2, IRubyObject arg2, int ix) {
        RandomHolder holder = (RandomHolder)recv2.dataGetStruct();
        int len = RubyNumeric.fix2int(arg2);
        if (len < 0 || len > Integer.MAX_VALUE) {
            throw recv2.getRuntime().newArgumentError("negative string size (or size too big)");
        }
        byte[] buf = new byte[len];
        holder.randomizers[ix].nextBytes(buf);
        return RubyString.newString(recv2.getRuntime(), new ByteList(buf, false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd(IRubyObject recv2, IRubyObject arg2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd_bytes(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return recv2.getRuntime().getNil();
    }

    private static final class RandomHolder {
        public java.util.Random[] randomizers;

        private RandomHolder() {
        }
    }
}

