/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.nkf.Command;
import org.jruby.ext.nkf.CommandParser;
import org.jruby.ext.nkf.Option;
import org.jruby.ext.nkf.Options;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"NKF"})
public class RubyNKF {
    public static final NKFCharset AUTO = new NKFCharset(0, "x-JISAutoDetect");
    public static final NKFCharset JIS = new NKFCharset(1, "iso-2022-jp");
    public static final NKFCharset EUC = new NKFCharset(2, "EUC-JP");
    public static final NKFCharset SJIS = new NKFCharset(3, "Windows-31J");
    public static final NKFCharset BINARY = new NKFCharset(4, null);
    public static final NKFCharset NOCONV = new NKFCharset(4, null);
    public static final NKFCharset UNKNOWN = new NKFCharset(0, null);
    public static final NKFCharset ASCII = new NKFCharset(5, "iso-8859-1");
    public static final NKFCharset UTF8 = new NKFCharset(6, "UTF-8");
    public static final NKFCharset UTF16 = new NKFCharset(8, "UTF-16");
    public static final NKFCharset UTF32 = new NKFCharset(12, "UTF-32");
    public static final NKFCharset OTHER = new NKFCharset(16, null);
    public static final NKFCharset BASE64 = new NKFCharset(20, "base64");
    public static final NKFCharset QENCODE = new NKFCharset(21, "qencode");
    public static final NKFCharset MIME_DETECT = new NKFCharset(22, "MimeAutoDetect");
    private static final ByteList BEGIN_MIME_STRING = new ByteList(ByteList.plain((CharSequence)"=?"));
    private static final ByteList END_MIME_STRING = new ByteList(ByteList.plain((CharSequence)"?="));
    private static final ByteList PACK_BASE64 = new ByteList(ByteList.plain((CharSequence)"m"));
    private static final ByteList PACK_QENCODE = new ByteList(ByteList.plain((CharSequence)"M"));

    public static void createNKF(Ruby runtime2) {
        RubyModule nkfModule = runtime2.defineModule("NKF");
        nkfModule.defineConstant("AUTO", RubyFixnum.newFixnum(runtime2, AUTO.getValue()));
        nkfModule.defineConstant("JIS", RubyFixnum.newFixnum(runtime2, JIS.getValue()));
        nkfModule.defineConstant("EUC", RubyFixnum.newFixnum(runtime2, EUC.getValue()));
        nkfModule.defineConstant("SJIS", RubyFixnum.newFixnum(runtime2, SJIS.getValue()));
        nkfModule.defineConstant("BINARY", RubyFixnum.newFixnum(runtime2, BINARY.getValue()));
        nkfModule.defineConstant("NOCONV", RubyFixnum.newFixnum(runtime2, NOCONV.getValue()));
        nkfModule.defineConstant("UNKNOWN", RubyFixnum.newFixnum(runtime2, UNKNOWN.getValue()));
        nkfModule.defineConstant("ASCII", RubyFixnum.newFixnum(runtime2, ASCII.getValue()));
        nkfModule.defineConstant("UTF8", RubyFixnum.newFixnum(runtime2, UTF8.getValue()));
        nkfModule.defineConstant("UTF16", RubyFixnum.newFixnum(runtime2, UTF16.getValue()));
        nkfModule.defineConstant("UTF32", RubyFixnum.newFixnum(runtime2, UTF32.getValue()));
        nkfModule.defineConstant("OTHER", RubyFixnum.newFixnum(runtime2, OTHER.getValue()));
        RubyString version = runtime2.newString("2.0.7 (JRuby 2007-05-11)");
        RubyString nkfVersion = runtime2.newString("2.0.7");
        RubyString nkfDate = runtime2.newString("2007-05-11");
        ThreadContext context = runtime2.getCurrentContext();
        version.freeze(context);
        nkfVersion.freeze(context);
        nkfDate.freeze(context);
        nkfModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext context, IRubyObject recv2, IRubyObject s2) {
        CharsetDecoder decoder;
        Ruby runtime2 = context.getRuntime();
        if (!s2.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + s2.getMetaClass() + " into String");
        }
        ByteList bytes2 = s2.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        try {
            decoder = Charset.forName("x-JISAutoDetect").newDecoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newStandardError("charsets.jar is required to use NKF#guess. Please install JRE which supports m17n.");
        }
        try {
            decoder.decode(buf);
        }
        catch (CharacterCodingException e) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        if (!decoder.isCharsetDetected()) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        Charset charset = decoder.detectedCharset();
        String name2 = charset.name();
        if ("Shift_JIS".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("windows-31j".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("EUC-JP".equals(name2)) {
            return runtime2.newFixnum(EUC.getValue());
        }
        if ("ISO-2022-JP".equals(name2)) {
            return runtime2.newFixnum(JIS.getValue());
        }
        return runtime2.newFixnum(UNKNOWN.getValue());
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext context, IRubyObject recv2, IRubyObject opt, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (!opt.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + opt.getMetaClass() + " into String");
        }
        if (!str.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> options2 = RubyNKF.parseOpt(opt.convertToString().toString());
        if (options2.get("input").getValue() == AUTO.getValue()) {
            KCode kcode2 = runtime2.getKCode();
            if (kcode2 == KCode.SJIS) {
                options2.put("input", SJIS);
            } else if (kcode2 == KCode.EUC) {
                options2.put("input", EUC);
            } else if (kcode2 == KCode.UTF8) {
                options2.put("input", UTF8);
            }
        }
        ByteList bstr = str.convertToString().getByteList();
        Converter converter = null;
        converter = Converter.isMimeText(bstr, options2) ? new MimeConverter(context, options2) : new DefaultConverter(context, options2);
        RubyString result2 = converter.convert(bstr);
        if (options2.get("mime-encode") == BASE64) {
            result2 = Converter.encodeMimeString(runtime2, result2, RubyNKF.PACK_BASE64);
        } else if (options2.get("mime-encode") == QENCODE) {
            result2 = Converter.encodeMimeString(runtime2, result2, RubyNKF.PACK_QENCODE);
        }
        return result2;
    }

    public static Command parseOption(String s2) {
        Options options2 = new Options();
        options2.addOption("b");
        options2.addOption("u");
        options2.addOption("j", "jis");
        options2.addOption("s", "sjis");
        options2.addOption("e", "euc");
        options2.addOption("w", null, "[0-9][0-9]");
        options2.addOption("J", "jis-input");
        options2.addOption("S", "sjis-input");
        options2.addOption("E", "euc-input");
        options2.addOption("W", null, "[0-9][0-9]");
        options2.addOption("t");
        options2.addOption("i_");
        options2.addOption("o_");
        options2.addOption("r");
        options2.addOption("h1", "hiragana");
        options2.addOption("h2", "katakana");
        options2.addOption("h3", "katakana-hiragana");
        options2.addOption("T");
        options2.addOption("l");
        options2.addOption("f", null, "[0-9]+-[0-9]*");
        options2.addOption("F");
        options2.addOption("Z", null, "[0-3]");
        options2.addOption("X");
        options2.addOption("x");
        options2.addOption("B", null, "[0-2]");
        options2.addOption("I");
        options2.addOption("L", null, "[uwm]");
        options2.addOption("d");
        options2.addOption("c");
        options2.addOption("m", null, "[BQN0]");
        options2.addOption("M", null, "[BQ]");
        options2.addOption(null, "fj");
        options2.addOption(null, "unix");
        options2.addOption(null, "mac");
        options2.addOption(null, "msdos");
        options2.addOption(null, "windows");
        options2.addOption(null, "mime");
        options2.addOption(null, "base64");
        options2.addOption(null, "mime-input");
        options2.addOption(null, "base64-input");
        options2.addOption(null, "ic", "ic=(.*)");
        options2.addOption(null, "oc", "oc=(.*)");
        options2.addOption(null, "fb-skip");
        options2.addOption(null, "fb-html");
        options2.addOption(null, "fb-xml");
        options2.addOption(null, "fb-perl");
        options2.addOption(null, "fb-java");
        options2.addOption(null, "fb-subchar", "fb-subchar=(.*)");
        options2.addOption(null, "no-cp932ext");
        options2.addOption(null, "cap-input");
        options2.addOption(null, "url-input");
        options2.addOption(null, "numchar-input");
        options2.addOption(null, "no-best-fit-chars");
        CommandParser parser = new CommandParser();
        Command cmd = parser.parse(options2, s2);
        return cmd;
    }

    private static Map<String, NKFCharset> parseOpt(String s2) {
        Option opt;
        HashMap<String, NKFCharset> options2 = new HashMap<String, NKFCharset>();
        options2.put("input", AUTO);
        options2.put("output", JIS);
        options2.put("mime-decode", MIME_DETECT);
        options2.put("mime-encode", NOCONV);
        Command cmd = RubyNKF.parseOption(s2);
        if (cmd.hasOption("j")) {
            options2.put("output", JIS);
        }
        if (cmd.hasOption("s")) {
            options2.put("output", SJIS);
        }
        if (cmd.hasOption("e")) {
            options2.put("output", EUC);
        }
        if (cmd.hasOption("w")) {
            opt = cmd.getOption("w");
            if ("32".equals(opt.getValue())) {
                options2.put("output", UTF32);
            } else if ("16".equals(opt.getValue())) {
                options2.put("output", UTF16);
            } else {
                options2.put("output", UTF8);
            }
        }
        if (cmd.hasOption("J")) {
            options2.put("input", JIS);
        }
        if (cmd.hasOption("S")) {
            options2.put("input", SJIS);
        }
        if (cmd.hasOption("E")) {
            options2.put("input", EUC);
        }
        if (cmd.hasOption("W")) {
            opt = cmd.getOption("W");
            if ("32".equals(opt.getValue())) {
                options2.put("input", UTF32);
            } else if ("16".equals(opt.getValue())) {
                options2.put("input", UTF16);
            } else {
                options2.put("input", UTF8);
            }
        }
        if (cmd.hasOption("m")) {
            opt = cmd.getOption("m");
            if (opt.getValue() == null) {
                options2.put("mime-decode", MIME_DETECT);
            } else if ("B".equals(opt.getValue())) {
                options2.put("mime-decode", BASE64);
            } else if ("Q".equals(opt.getValue())) {
                options2.put("mime-decode", QENCODE);
            } else if (!"N".equals(opt.getValue()) && "0".equals(opt.getValue())) {
                options2.put("mime-decode", NOCONV);
            }
        }
        if (cmd.hasOption("M")) {
            opt = cmd.getOption("M");
            if (opt.getValue() == null) {
                options2.put("mime-encode", NOCONV);
            } else if ("B".equals(opt.getValue())) {
                options2.put("mime-encode", BASE64);
            } else if ("Q".equals(opt.getValue())) {
                options2.put("mime-encode", QENCODE);
            }
        }
        if (cmd.hasOption("base64")) {
            options2.put("mime-encode", BASE64);
        }
        if (cmd.hasOption("oc")) {
            opt = cmd.getOption("oc");
            if ("ISO-2022-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", JIS);
            } else if ("EUC-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", EUC);
            } else if ("CP932".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", SJIS);
            } else if ("UTF-8".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF8);
            } else if ("UTF-16".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF16);
            } else if ("UTF-32".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", UTF32);
            }
        }
        if (cmd.hasOption("ic")) {
            opt = cmd.getOption("ic");
            if ("ISO-2022-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", JIS);
            } else if ("EUC-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", EUC);
            } else if ("CP932".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", SJIS);
            } else if ("UTF-8".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF8);
            } else if ("UTF-16".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF16);
            } else if ("UTF-32".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", UTF32);
            }
        }
        return options2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MimeConverter
    extends Converter {
        public MimeConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        private String detectCharset(String charset) {
            if (charset.compareToIgnoreCase(UTF8.getCharset()) == 0) {
                return UTF8.getCharset();
            }
            if (charset.compareToIgnoreCase(JIS.getCharset()) == 0) {
                return JIS.getCharset();
            }
            if (charset.compareToIgnoreCase(EUC.getCharset()) == 0) {
                return EUC.getCharset();
            }
            return ASCII.getCharset();
        }

        private ByteList decodeMimeString(String str) {
            String[] mime = str.split("^=\\?|\\?|\\?=$");
            String charset = this.detectCharset(mime[1]);
            char encode2 = mime[2].charAt(0);
            ByteList body = new ByteList(mime[3].getBytes(), (Encoding)ASCIIEncoding.INSTANCE);
            RubyArray array = null;
            array = 'B' == encode2 || 'b' == encode2 ? Pack.unpack(this.context.getRuntime(), body, PACK_BASE64) : Pack.unpack(this.context.getRuntime(), body, PACK_QENCODE);
            RubyString s2 = (RubyString)array.entry(0);
            ByteList decodeStr = s2.asString().getByteList();
            return this.convert_byte(decodeStr, charset, (NKFCharset)this.options.get("output"));
        }

        RubyString makeRubyString(ArrayList<ByteList> list2) {
            ByteList r = new ByteList();
            for (ByteList l : list2) {
                r.append(l);
            }
            return this.context.getRuntime().newString(r);
        }

        @Override
        RubyString convert(ByteList str) {
            String s2 = str.toString();
            String[] token = s2.split("\\s");
            ArrayList<ByteList> raw_data = new ArrayList<ByteList>();
            for (int i2 = 0; i2 < token.length; ++i2) {
                raw_data.add(this.decodeMimeString(token[i2]));
            }
            return this.makeRubyString(raw_data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultConverter
    extends Converter {
        public DefaultConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        @Override
        RubyString convert(ByteList str) {
            NKFCharset input = (NKFCharset)this.options.get("input");
            NKFCharset output = (NKFCharset)this.options.get("output");
            ByteList b = this.convert_byte(str, input.getCharset(), output);
            return this.context.getRuntime().newString(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Converter {
        protected ThreadContext context;
        protected Map<String, NKFCharset> options;

        public Converter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            this.context = ctx;
            this.options = opt;
        }

        static boolean isMimeText(ByteList str, Map<String, NKFCharset> options2) {
            if (str.length() <= 6) {
                return false;
            }
            if (options2.get("mime-decode") == NOCONV) {
                return false;
            }
            if (str.indexOf(BEGIN_MIME_STRING) < 0) {
                return false;
            }
            return str.lastIndexOf(END_MIME_STRING) >= 0;
        }

        private static RubyString encodeMimeString(Ruby runtime2, RubyString str, ByteList format) {
            RubyArray array = RubyArray.newArray(runtime2, str);
            return Pack.pack(runtime2, array, format).chomp(runtime2.getCurrentContext());
        }

        abstract RubyString convert(ByteList var1);

        ByteList convert_byte(ByteList str, String inputCharset, NKFCharset output) {
            Ruby ruby2;
            Encoding enc;
            CharsetEncoder encoder;
            CharsetDecoder decoder;
            String outputCharset = output.getCharset();
            try {
                decoder = Charset.forName(inputCharset).newDecoder();
                encoder = Charset.forName(outputCharset).newEncoder();
            }
            catch (UnsupportedCharsetException e) {
                throw this.context.getRuntime().newArgumentError("invalid charset");
            }
            ByteBuffer buf = ByteBuffer.wrap(str.getUnsafeBytes(), str.begin(), str.length());
            try {
                CharBuffer cbuf = decoder.decode(buf);
                encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                buf = encoder.encode(cbuf);
            }
            catch (CharacterCodingException e) {
                throw this.context.getRuntime().newArgumentError("invalid encoding");
            }
            byte[] arr = buf.array();
            ByteList r = new ByteList(arr, 0, buf.limit());
            if (outputCharset.equalsIgnoreCase("Windows-31J")) {
                outputCharset = "Shift_JIS";
            }
            if (outputCharset.equalsIgnoreCase("UTF-16")) {
                outputCharset = "UTF-16BE";
            }
            if ((enc = (ruby2 = this.context.getRuntime()).getEncodingService().findEncoding(ruby2.newString(outputCharset))) != null) {
                r.setEncoding(enc);
            }
            return r;
        }
    }

    public static class NKFCharset {
        private final int value;
        private final String charset;

        public NKFCharset(int v, String c) {
            this.value = v;
            this.charset = c;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

