/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVariables {
    private Ruby runtime;
    private Map<String, GlobalVariable> globalVariables = new ConcurrentHashMap<String, GlobalVariable>();
    private IRubyObject defaultSeparator;

    public GlobalVariables(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public void define(String name2, IAccessor accessor) {
        assert (name2 != null);
        assert (accessor != null);
        assert (name2.startsWith("$"));
        this.globalVariables.put(name2, new GlobalVariable(accessor));
    }

    public void defineReadonly(String name2, IAccessor accessor) {
        assert (name2 != null);
        assert (accessor != null);
        assert (name2.startsWith("$"));
        this.globalVariables.put(name2, new GlobalVariable(new ReadonlyAccessor(name2, accessor)));
    }

    public boolean isDefined(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name2);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name2, String oldName) {
        assert (name2 != null);
        assert (oldName != null);
        assert (name2.startsWith("$"));
        assert (oldName.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't alias global variable");
        }
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = this.globalVariables.get(name2);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw new RaiseException(this.runtime, this.runtime.getRuntimeError(), "can't alias in tracer", false);
        }
        this.globalVariables.put(name2, oldVariable);
    }

    public IRubyObject get(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name2);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        if (this.runtime.isVerbose()) {
            this.runtime.getWarnings().warning(IRubyWarnings.ID.GLOBAL_NOT_INITIALIZED, "global variable `" + name2 + "' not initialized");
        }
        return this.runtime.getNil();
    }

    public IRubyObject set(String name2, IRubyObject value2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't change global variable value");
        }
        GlobalVariable variable = this.createIfNotDefined(name2);
        IRubyObject result2 = variable.getAccessor().setValue(value2);
        variable.trace(value2);
        return result2;
    }

    public IRubyObject clear(String name2) {
        return this.set(name2, this.runtime.getNil());
    }

    public void setTraceVar(String name2, RubyProc proc2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        GlobalVariable variable = this.createIfNotDefined(name2);
        variable.addTrace(proc2);
    }

    public boolean untraceVar(String name2, IRubyObject command) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        if (this.isDefined(name2)) {
            GlobalVariable variable = this.globalVariables.get(name2);
            return variable.removeTrace(command);
        }
        return false;
    }

    public void untraceVar(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        if (this.isDefined(name2)) {
            GlobalVariable variable = this.globalVariables.get(name2);
            variable.removeTraces();
        }
    }

    public Set<String> getNames() {
        return this.globalVariables.keySet();
    }

    private GlobalVariable createIfNotDefined(String name2) {
        GlobalVariable variable = this.globalVariables.get(name2);
        if (variable == null) {
            variable = GlobalVariable.newUndefined(this.runtime, name2);
            this.globalVariables.put(name2, variable);
        }
        return variable;
    }

    public IRubyObject getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(IRubyObject defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
    }
}

