/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;

public class IRClosure
extends IRExecutionScope {
    public final Label startLabel = this.getNewLabel("_CLOSURE_START");
    public final Label endLabel = this.getNewLabel("_CLOSURE_END");
    public final int closureId;
    private final BlockBody body;

    public IRClosure(IRScope lexicalParent, StaticScope staticScope, Arity arity2, int argumentType) {
        super(lexicalParent, MetaObject.create(lexicalParent), null, staticScope);
        this.closureId = lexicalParent.getNextClosureId();
        this.setName("_CLOSURE_" + this.closureId);
        this.body = new InterpretedIRBlockBody(this, arity2, argumentType);
    }

    public int getNextClosureId() {
        return this.lexicalParent.getNextClosureId();
    }

    public int getTemporaryVariableSize() {
        return this.getPrefixCountSize("%cl_" + this.closureId);
    }

    public Variable getNewTemporaryVariable() {
        return this.getNewTemporaryClosureVariable(this.closureId);
    }

    public Label getNewLabel() {
        return this.getNewLabel("CL" + this.closureId + "_LBL");
    }

    public String getScopeName() {
        return "Closure";
    }

    public String toStringBody() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName()).append(" = { \n");
        CFG c = this.getCFG();
        if (c != null) {
            buf.append("\nCFG:\n").append(c.getGraph().toString());
            buf.append("\nInstructions:\n").append(c.toStringInstrs());
        } else {
            buf.append(this.toStringInstrs());
        }
        buf.append("\n}\n\n");
        return buf.toString();
    }

    protected StaticScope constructStaticScope(StaticScope parent) {
        return new BlockStaticScope(parent);
    }

    public BlockBody getBlockBody() {
        return this.body;
    }
}

