/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.CExtension;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLUtil;

public class LoadService {
    private final LoadTimer loadTimer;
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|bundle|jar)$");
    protected RubyArray loadPath;
    protected RubyArray loadedFeatures;
    protected List loadedFeaturesInternal;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Map<String, IAutoloadMethod> autoloadMap = new HashMap<String, IAutoloadMethod>();
    protected final Ruby runtime;
    protected boolean caseInsensitiveFS = false;
    protected Map requireLocks = new Hashtable();
    protected final List<LoadSearcher> searchers = new ArrayList<LoadSearcher>();

    public LoadService(Ruby runtime2) {
        this.searchers.add(new SourceBailoutSearcher());
        this.searchers.add(new NormalSearcher());
        this.searchers.add(new ClassLoaderSearcher());
        this.searchers.add(new BailoutSearcher());
        this.searchers.add(new ExtensionSearcher());
        this.searchers.add(new ScriptClassSearcher());
        this.runtime = runtime2;
        this.loadTimer = RubyInstanceConfig.DEBUG_LOAD_TIMINGS ? new TracingLoadTimer() : new LoadTimer();
    }

    public void init(List additionalDirectories) {
        block11: {
            RubyString env_rubylib;
            this.loadPath = RubyArray.newArray(this.runtime);
            this.loadedFeatures = RubyArray.newArray(this.runtime);
            this.loadedFeaturesInternal = Collections.synchronizedList(this.loadedFeatures);
            Iterator iter = additionalDirectories.iterator();
            while (iter.hasNext()) {
                this.addPath((String)iter.next());
            }
            RubyHash env = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
            if (env.has_key_p(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
                String rubylib = env.op_aref(this.runtime.getCurrentContext(), env_rubylib).toString();
                String[] paths = rubylib.split(File.pathSeparator);
                for (int i2 = 0; i2 < paths.length; ++i2) {
                    this.addPath(paths[i2]);
                }
            }
            try {
                String jrubyHome = this.runtime.getJRubyHome();
                if (jrubyHome == null) break block11;
                char sep = '/';
                String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
                if (this.runtime.is1_9()) {
                    this.addPath(rubyDir + "site_ruby" + sep + "1.9");
                    this.addPath(rubyDir + "site_ruby" + sep + "shared");
                    this.addPath(rubyDir + "site_ruby" + sep + "1.8");
                    this.addPath(rubyDir + "1.9");
                } else {
                    this.addPath(rubyDir + "site_ruby" + sep + "1.8");
                    this.addPath(rubyDir + "site_ruby" + sep + "shared");
                    this.addPath(rubyDir + "1.8");
                }
                String lowerCaseJRubyHome = jrubyHome.toLowerCase();
                String upperCaseJRubyHome = lowerCaseJRubyHome.toUpperCase();
                try {
                    String canonNormal = new File(jrubyHome).getCanonicalPath();
                    String canonLower = new File(lowerCaseJRubyHome).getCanonicalPath();
                    String canonUpper = new File(upperCaseJRubyHome).getCanonicalPath();
                    if (canonNormal.equals(canonLower) && canonLower.equals(canonUpper)) {
                        this.caseInsensitiveFS = true;
                    }
                }
                catch (Exception e) {}
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        if (!this.runtime.is1_9() && this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    protected void addLoadedFeature(RubyString loadNameRubyString) {
        this.loadedFeaturesInternal.add(loadNameRubyString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPath(String path2) {
        if (path2 == null || path2.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(path2.replace('\\', '/')));
        }
    }

    public void load(String file2, boolean wrap2) {
        if (!this.runtime.getProfile().allowLoad(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        SearchState state = new SearchState(file2);
        state.prepareLoadSearch(file2);
        Library library2 = this.findBuiltinLibrary(state, state.searchFile, state.suffixType);
        if (library2 == null) {
            library2 = this.findLibraryWithoutCWD(state, state.searchFile, state.suffixType);
        }
        if (library2 == null && (library2 = this.findLibraryWithClassloaders(state, state.searchFile, state.suffixType)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        try {
            library2.load(this.runtime, wrap2);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace(this.runtime.getErr());
            }
            throw LoadService.newLoadErrorFromThrowable(this.runtime, file2, e);
        }
    }

    public SearchState findFileForLoad(String file2) throws AlreadyLoaded {
        SearchState state = new SearchState(file2);
        state.prepareRequireSearch(file2);
        for (LoadSearcher searcher : this.searchers) {
            if (!searcher.shouldTrySearch(state)) continue;
            searcher.trySearch(state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lockAndRequire(String requireName) {
        Map map;
        boolean bl;
        try {
            Object requireLock;
            Object object = this.requireLocks;
            synchronized (object) {
                requireLock = this.requireLocks.get(requireName);
                if (requireLock == null) {
                    requireLock = new Object();
                    this.requireLocks.put(requireName, requireLock);
                }
            }
            object = requireLock;
            synchronized (object) {
                bl = this.require(requireName);
            }
            Object var7_5 = null;
            map = this.requireLocks;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Map map2 = this.requireLocks;
            synchronized (map2) {
                this.requireLocks.remove(requireName);
                throw throwable;
            }
        }
        synchronized (map) {
            this.requireLocks.remove(requireName);
            return bl;
        }
    }

    public boolean smartLoad(String file2) {
        this.checkEmptyLoad(file2);
        if (Platform.IS_WINDOWS) {
            file2 = file2.replace('\\', '/');
        }
        try {
            if (file2.endsWith(".so")) {
                file2 = file2.replaceAll(".so$", ".jar");
            }
            SearchState state = this.findFileForLoad(file2);
            return this.tryLoadingLibraryOrScript(this.runtime, state);
        }
        catch (AlreadyLoaded al) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean require(String file2) {
        if (!this.runtime.getProfile().allowRequire(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        if (this.featureAlreadyLoaded(RubyString.newString(this.runtime, file2))) {
            return false;
        }
        long startTime = this.loadTimer.startLoad(file2);
        try {
            boolean bl = this.smartLoad(file2);
            Object var6_4 = null;
            this.loadTimer.endLoad(file2, startTime);
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.loadTimer.endLoad(file2, startTime);
            throw throwable;
        }
    }

    public static void reflectedLoad(Ruby runtime2, String libraryName, String className, ClassLoader classLoader, boolean wrap2) {
        block7: {
            try {
                Object libObject;
                if (classLoader == null && Ruby.isSecurityRestricted()) {
                    classLoader = runtime2.getInstanceConfig().getLoader();
                }
                if ((libObject = classLoader.loadClass(className).newInstance()) instanceof Library) {
                    Library library2 = (Library)libObject;
                    library2.load(runtime2, false);
                    break block7;
                }
                if (libObject instanceof BasicLibraryService) {
                    BasicLibraryService service = (BasicLibraryService)libObject;
                    service.basicLoad(runtime2);
                    break block7;
                }
                throw runtime2.newLoadError("library `" + libraryName + "' is not of type Library or BasicLibraryService");
            }
            catch (RaiseException re) {
                throw re;
            }
            catch (Throwable e) {
                if (runtime2.getDebug().isTrue()) {
                    e.printStackTrace();
                }
                throw runtime2.newLoadError("library `" + libraryName + "' could not be loaded: " + e);
            }
        }
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String name2) {
        return this.autoloadMap.get(name2);
    }

    public void removeAutoLoadFor(String name2) {
        this.autoloadMap.remove(name2);
    }

    public IRubyObject autoload(String name2) {
        IAutoloadMethod loadMethod = this.autoloadMap.remove(name2);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name2);
        }
        return null;
    }

    public void addAutoload(String name2, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name2, loadMethod);
    }

    public void addBuiltinLibrary(String name2, Library library2) {
        this.builtinLibraries.put(name2, library2);
    }

    public void removeBuiltinLibrary(String name2) {
        this.builtinLibraries.remove(name2);
    }

    public void removeInternalLoadedFeature(String name2) {
        if (this.caseInsensitiveFS) {
            Iterator iter = this.loadedFeaturesInternal.iterator();
            while (iter.hasNext()) {
                Object feature = iter.next();
                if (!feature.toString().equalsIgnoreCase(name2)) continue;
                iter.remove();
            }
        } else {
            this.loadedFeaturesInternal.remove(name2);
        }
    }

    protected boolean featureAlreadyLoaded(RubyString loadNameRubyString) {
        if (this.caseInsensitiveFS) {
            String name2 = loadNameRubyString.toString();
            for (Object feature : this.loadedFeaturesInternal) {
                if (!feature.toString().equalsIgnoreCase(name2)) continue;
                return true;
            }
            return false;
        }
        return this.loadedFeaturesInternal.contains(loadNameRubyString);
    }

    protected boolean isJarfileLibrary(SearchState state, String file2) {
        return state.library instanceof JarredScript && file2.endsWith(".jar");
    }

    protected void removeLoadedFeature(RubyString loadNameRubyString) {
        this.loadedFeaturesInternal.remove(loadNameRubyString);
    }

    protected void reraiseRaiseExceptions(Throwable e) throws RaiseException {
        if (e instanceof RaiseException) {
            throw (RaiseException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryLoadingLibraryOrScript(Ruby runtime2, SearchState state) {
        RubyString loadNameRubyString = RubyString.newString(runtime2, state.loadName);
        try {
            List list2 = this.loadedFeaturesInternal;
            synchronized (list2) {
                if (this.featureAlreadyLoaded(loadNameRubyString)) {
                    return false;
                }
                this.addLoadedFeature(loadNameRubyString);
            }
            state.library.load(runtime2, false);
            return true;
        }
        catch (MainExitException mee) {
            throw mee;
        }
        catch (Throwable e) {
            if (this.isJarfileLibrary(state, state.searchFile)) {
                return true;
            }
            this.removeLoadedFeature(loadNameRubyString);
            this.reraiseRaiseExceptions(e);
            if (runtime2.getDebug().isTrue()) {
                e.printStackTrace(runtime2.getErr());
            }
            RaiseException re = LoadService.newLoadErrorFromThrowable(runtime2, state.searchFile, e);
            re.initCause(e);
            throw re;
        }
    }

    private static RaiseException newLoadErrorFromThrowable(Ruby runtime2, String file2, Throwable t) {
        return runtime2.newLoadError(String.format("load error: %s -- %s: %s", file2, t.getClass().getName(), t.getMessage()));
    }

    protected String buildClassName(String className) {
        if ((className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(".") != -1) {
            className = className.substring(0, className.lastIndexOf("."));
        }
        className = className.replace("-", "_minus_").replace('.', '_');
        return className;
    }

    protected void checkEmptyLoad(String file2) throws RaiseException {
        if (file2.equals("")) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
    }

    protected void debugLogTry(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            this.runtime.getErr().println("LoadService: trying " + what + ": " + msg);
        }
    }

    protected void debugLogFound(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            this.runtime.getErr().println("LoadService: found " + what + ": " + msg);
        }
    }

    protected void debugLogFound(LoadServiceResource resource2) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            String resourceUrl;
            try {
                resourceUrl = resource2.getURL().toString();
            }
            catch (IOException e) {
                resourceUrl = e.getMessage();
            }
            this.runtime.getErr().println("LoadService: found: " + resourceUrl);
        }
    }

    protected Library findBuiltinLibrary(SearchState state, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            this.debugLogTry("builtinLib", namePlusSuffix);
            if (!this.builtinLibraries.containsKey(namePlusSuffix)) continue;
            state.loadName = namePlusSuffix;
            Library lib = this.builtinLibraries.get(namePlusSuffix);
            this.debugLogFound("builtinLib", namePlusSuffix);
            return lib;
        }
        return null;
    }

    protected Library findLibraryWithoutCWD(SearchState state, String baseName, SuffixType suffixType) {
        Library library2 = null;
        switch (suffixType) {
            case Both: {
                library2 = this.findBuiltinLibrary(state, baseName, SuffixType.Source);
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.findBuiltinLibrary(state, baseName, SuffixType.Extension);
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Extension));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Extension));
                break;
            }
            case Source: 
            case Extension: {
                library2 = this.findBuiltinLibrary(state, baseName, suffixType);
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, suffixType));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, suffixType));
                break;
            }
            case Neither: {
                library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Neither));
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Neither));
            }
        }
        return library2;
    }

    protected Library findLibraryWithClassloaders(SearchState state, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String file2 = baseName + suffix;
            LoadServiceResource resource2 = this.findFileInClasspath(file2);
            if (resource2 == null) continue;
            state.loadName = this.resolveLoadName(resource2, file2);
            return this.createLibrary(state, resource2);
        }
        return null;
    }

    protected Library createLibrary(SearchState state, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = state.loadName;
        if (file2.endsWith(".so") || file2.endsWith(".dll") || file2.endsWith(".bundle")) {
            if (this.runtime.getInstanceConfig().isCextEnabled()) {
                return new CExtension(resource2);
            }
            throw this.runtime.newLoadError("C extensions are disabled, can't load `" + resource2.getName() + "'");
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, file2);
    }

    protected LoadServiceResource tryResourceFromCWD(SearchState state, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromCWD", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                foundResource = new LoadServiceResource((File)((Object)file2), this.getFileName(file2, namePlusSuffix), absolute);
                this.debugLogFound(foundResource);
                state.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                break;
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromHome(SearchState state, String baseName, SuffixType suffixType) throws RaiseException {
        RubyString env_home;
        LoadServiceResource foundResource = null;
        RubyHash env = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        if (env.has_key_p(env_home = this.runtime.newString("HOME")).isFalse()) {
            return null;
        }
        String home2 = env.op_aref(this.runtime.getCurrentContext(), env_home).toString();
        String path2 = baseName.substring(2);
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = path2 + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(home2, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromHome", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                state.loadName = file2.getPath();
                foundResource = new LoadServiceResource((File)((Object)file2), state.loadName, absolute);
                this.debugLogFound(foundResource);
                break;
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromJarURL(SearchState state, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource;
        block10: {
            block11: {
                foundResource = null;
                if (!baseName.startsWith("jar:")) break block11;
                for (String suffix : suffixType.getSuffixes()) {
                    String namePlusSuffix = baseName + suffix;
                    try {
                        URL url = new URL(namePlusSuffix);
                        this.debugLogTry("resourceFromJarURL", url.toString());
                        if (url.openStream() != null) {
                            foundResource = new LoadServiceResource(url, namePlusSuffix);
                            this.debugLogFound(foundResource);
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    if (foundResource == null) continue;
                    state.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                    break block10;
                }
                break block10;
            }
            if (!baseName.startsWith("file:") || baseName.indexOf("!/") == -1) break block10;
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                try {
                    String jarFile = namePlusSuffix.substring(5, namePlusSuffix.indexOf("!/"));
                    JarFile file2 = new JarFile(jarFile);
                    String expandedFilename = this.expandRelativeJarPath(namePlusSuffix.substring(namePlusSuffix.indexOf("!/") + 2));
                    this.debugLogTry("resourceFromJarURL", expandedFilename.toString());
                    if (file2.getJarEntry(expandedFilename) != null) {
                        foundResource = new LoadServiceResource(new URL("jar:file:" + jarFile + "!/" + expandedFilename), namePlusSuffix);
                        this.debugLogFound(foundResource);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (foundResource == null) continue;
                state.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                break;
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromLoadPathOrURL(SearchState state, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource = null;
        if (baseName.startsWith("./")) {
            foundResource = this.tryResourceFromCWD(state, baseName, suffixType);
            if (foundResource != null) {
                state.loadName = this.resolveLoadName(foundResource, foundResource.getName());
            }
            return foundResource;
        }
        if (baseName.startsWith("~/")) {
            foundResource = this.tryResourceFromHome(state, baseName, suffixType);
            if (foundResource != null) {
                state.loadName = this.resolveLoadName(foundResource, foundResource.getName());
            }
            return foundResource;
        }
        if (new File(baseName).isAbsolute() || baseName.startsWith("../")) {
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = this.tryResourceAsIs(namePlusSuffix);
                if (foundResource == null) continue;
                state.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                return foundResource;
            }
            return null;
        }
        block1: for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            RubyString entryString = this.loadPath.eltInternal(i2).convertToString();
            String loadPathEntry = entryString.asJavaString();
            if (loadPathEntry.equals(".") || loadPathEntry.equals("")) {
                foundResource = this.tryResourceFromCWD(state, baseName, suffixType);
                if (foundResource == null) continue;
                String ss = foundResource.getName();
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state.loadName = this.resolveLoadName(foundResource, ss);
                break;
            }
            boolean looksLikeJarURL = this.loadPathLooksLikeJarURL(loadPathEntry);
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = looksLikeJarURL ? this.tryResourceFromJarURLWithLoadPath(namePlusSuffix, loadPathEntry) : this.tryResourceFromLoadPath(namePlusSuffix, loadPathEntry);
                if (foundResource == null) continue;
                String ss = namePlusSuffix;
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state.loadName = this.resolveLoadName(foundResource, ss);
                break block1;
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromJarURLWithLoadPath(String namePlusSuffix, String loadPathEntry) {
        String before;
        LoadServiceResource foundResource = null;
        JarFile current2 = this.jarFiles.get(loadPathEntry);
        boolean isFileJarUrl = loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!/") != -1;
        String after = isFileJarUrl ? loadPathEntry.substring(loadPathEntry.indexOf("!/") + 2) + "/" : "";
        String string2 = before = isFileJarUrl ? loadPathEntry.substring(0, loadPathEntry.indexOf("!/")) : loadPathEntry;
        if (null == current2) {
            try {
                current2 = loadPathEntry.startsWith("jar:") ? new JarFile(loadPathEntry.substring(4)) : (loadPathEntry.endsWith(".jar") ? new JarFile(loadPathEntry) : new JarFile(loadPathEntry.substring(5, loadPathEntry.indexOf("!/"))));
                this.jarFiles.put(loadPathEntry, current2);
            }
            catch (ZipException ignored) {
                if (this.runtime.getInstanceConfig().isDebug()) {
                    this.runtime.getErr().println("ZipException trying to access " + loadPathEntry + ", stack trace follows:");
                    ignored.printStackTrace(this.runtime.getErr());
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        String canonicalEntry = after + namePlusSuffix;
        if (current2 != null) {
            this.debugLogTry("resourceFromJarURLWithLoadPath", current2.getName() + "!/" + canonicalEntry);
            if (current2.getJarEntry(canonicalEntry) != null) {
                try {
                    foundResource = loadPathEntry.endsWith(".jar") ? new LoadServiceResource(new URL("jar:file:" + loadPathEntry + "!/" + canonicalEntry), "/" + namePlusSuffix) : (loadPathEntry.startsWith("file:") ? new LoadServiceResource(new URL("jar:" + before + "!/" + canonicalEntry), loadPathEntry + "/" + namePlusSuffix) : new LoadServiceResource(new URL("jar:file:" + loadPathEntry.substring(4) + "!/" + namePlusSuffix), loadPathEntry + namePlusSuffix));
                    this.debugLogFound(foundResource);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
        }
        return foundResource;
    }

    protected boolean loadPathLooksLikeJarURL(String loadPathEntry) {
        return loadPathEntry.startsWith("jar:") || loadPathEntry.endsWith(".jar") || loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!/") != -1;
    }

    protected LoadServiceResource tryResourceFromLoadPath(String namePlusSuffix, String loadPathEntry) throws RaiseException {
        LoadServiceResource foundResource = null;
        try {
            if (!Ruby.isSecurityRestricted()) {
                JRubyFile actualPath;
                String reportedPath = loadPathEntry + "/" + namePlusSuffix;
                boolean absolute = false;
                if (new File(reportedPath).isAbsolute()) {
                    absolute = true;
                    actualPath = JRubyFile.create(loadPathEntry, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    absolute = false;
                    if (reportedPath.charAt(0) != '.') {
                        reportedPath = "./" + reportedPath;
                    }
                    actualPath = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), loadPathEntry).getAbsolutePath(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                }
                if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
                    this.debugLogTry("resourceFromLoadPath", "'" + actualPath.toString() + "' " + actualPath.isFile() + " " + actualPath.canRead());
                }
                if (actualPath.isFile() && actualPath.canRead()) {
                    foundResource = new LoadServiceResource((File)((Object)actualPath), reportedPath, absolute);
                    this.debugLogFound(foundResource);
                }
            }
        }
        catch (SecurityException secEx) {
            // empty catch block
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceAsIs(String namePlusSuffix) throws RaiseException {
        LoadServiceResource foundResource = null;
        try {
            if (!Ruby.isSecurityRestricted()) {
                Object actualPath;
                String reportedPath = namePlusSuffix;
                if (new File(reportedPath).isAbsolute()) {
                    actualPath = new File(RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    if (reportedPath.charAt(0) == '.' && reportedPath.charAt(1) == '/') {
                        reportedPath = reportedPath.replaceFirst("\\./", this.runtime.getCurrentDirectory());
                    }
                    actualPath = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                }
                this.debugLogTry("resourceAsIs", ((File)actualPath).toString());
                if (((File)actualPath).isFile() && ((File)actualPath).canRead()) {
                    foundResource = new LoadServiceResource((File)actualPath, reportedPath);
                    this.debugLogFound(foundResource);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return foundResource;
    }

    protected LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        if (name2.startsWith("classpath:/")) {
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
            if (foundResource != null) {
                return foundResource;
            }
        } else if (name2.startsWith("classpath:")) {
            name2 = name2.substring("classpath:".length());
        }
        for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            LoadServiceResource foundResource;
            RubyString entryString = this.loadPath.eltInternal(i2).convertToString();
            String entry = entryString.asJavaString();
            if (entry.length() == 0 || entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':') continue;
            if (entry.startsWith("classpath:/")) {
                entry = entry.substring("classpath:/".length());
            } else if (entry.startsWith("classpath:")) {
                entry = entry.substring("classpath:".length());
            }
            if (name2.startsWith(entry)) {
                name2 = name2.substring(entry.length());
            }
            if ((foundResource = this.getClassPathResource(classLoader, entry + "/" + name2)) == null) continue;
            return foundResource;
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
        if (foundResource != null) {
            return foundResource;
        }
        return null;
    }

    protected boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(URLUtil.getPath(loc)).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    protected LoadServiceResource getClassPathResource(ClassLoader classLoader, String name2) {
        boolean isClasspathScheme = false;
        if (name2.startsWith("classpath:/")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:/".length());
        } else if (name2.startsWith("classpath:")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:".length());
        } else if (name2.startsWith("file:") && name2.indexOf("!/") != -1) {
            name2 = name2.substring(name2.indexOf("!/") + 2);
        }
        this.debugLogTry("fileInClasspath", name2);
        URL loc = classLoader.getResource(name2);
        if (loc != null) {
            String path2 = "classpath:/" + name2;
            if (!isClasspathScheme && (loc.getProtocol().equals("jar") || loc.getProtocol().equals("file")) && this.isRequireable(loc)) {
                path2 = URLUtil.getPath(loc);
            }
            LoadServiceResource foundResource = new LoadServiceResource(loc, path2);
            this.debugLogFound(foundResource);
            return foundResource;
        }
        return null;
    }

    private String expandRelativeJarPath(String path2) {
        try {
            String cwd = new File(".").getCanonicalPath();
            return new File(path2).getCanonicalPath().substring(cwd.length() + 1).replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            return path2;
        }
    }

    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        return previousPath;
    }

    protected String getFileName(JRubyFile file2, String namePlusSuffix) {
        String s2 = namePlusSuffix;
        if (!namePlusSuffix.startsWith("./")) {
            s2 = "./" + s2;
        }
        return s2;
    }

    public boolean isCaseInsensitiveFS() {
        return this.caseInsensitiveFS;
    }

    public static class SearchState {
        public Library library;
        public String loadName;
        public SuffixType suffixType;
        public String searchFile;

        public SearchState(String file2) {
            this.loadName = file2;
        }

        public void prepareRequireSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    matcher = extensionPattern.matcher(file2);
                    if (matcher.find()) {
                        this.suffixType = SuffixType.Extension;
                        this.searchFile = file2.substring(0, matcher.start());
                    } else {
                        this.suffixType = SuffixType.Both;
                        this.searchFile = file2;
                    }
                }
            } else {
                this.suffixType = SuffixType.Both;
                this.searchFile = file2;
            }
        }

        public void prepareLoadSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    this.suffixType = SuffixType.Neither;
                    this.searchFile = file2;
                }
            } else {
                this.suffixType = SuffixType.Neither;
                this.searchFile = file2;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName()).append(": ");
            sb.append("library=").append(this.library.toString());
            sb.append(", loadName=").append(this.loadName);
            sb.append(", suffixType=").append(this.suffixType.toString());
            sb.append(", searchFile=").append(this.searchFile);
            return sb.toString();
        }
    }

    public class ScriptClassSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) throws RaiseException {
            Script script;
            String className = LoadService.this.buildClassName(state.searchFile);
            int lastSlashIndex = className.lastIndexOf(47);
            if (lastSlashIndex > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? "_" + className : className.substring(0, lastSlashIndex + 1) + "_" + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                throw LoadService.this.runtime.newLoadError("no such file to load -- " + state.searchFile);
            }
            state.library = new ScriptClassLibrary(script);
        }

        public class ScriptClassLibrary
        implements Library {
            private Script script;

            public ScriptClassLibrary(Script script) {
                this.script = script;
            }

            public void load(Ruby runtime2, boolean wrap2) {
                runtime2.loadScript(this.script, wrap2);
            }
        }
    }

    public class ExtensionSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return (state.library == null || state.library instanceof JarredScript) && !state.searchFile.equalsIgnoreCase("");
        }

        public void trySearch(SearchState state) {
            Library oldLibrary = state.library;
            String[] all = state.searchFile.split("/");
            StringBuilder finName = new StringBuilder();
            int j = all.length - 1;
            for (int i2 = 0; i2 < j; ++i2) {
                finName.append(all[i2].toLowerCase()).append(".");
            }
            try {
                String[] last2 = all[all.length - 1].split("_");
                int j2 = last2.length;
                for (int i3 = 0; i3 < j2; ++i3) {
                    finName.append(Character.toUpperCase(last2[i3].charAt(0))).append(last2[i3].substring(1));
                }
                finName.append("Service");
                String className = finName.toString().replaceAll("^\\.*", "");
                if (state.library instanceof JarredScript) {
                    LoadService.this.runtime.getJRubyClassLoader().addURL(((JarredScript)state.library).getResource().getURL());
                }
                Class theClass = LoadService.this.runtime.getJavaSupport().loadJavaClass(className);
                state.library = new ClassExtensionLibrary(className + ".java", theClass);
            }
            catch (ClassNotFoundException cnfe) {
                if (LoadService.this.runtime.isDebug()) {
                    cnfe.printStackTrace();
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                if (LoadService.this.runtime.isDebug()) {
                    ucve.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("JRuby ext built for wrong Java version in `" + finName + "': " + ucve);
            }
            catch (IOException ioe) {
                if (LoadService.this.runtime.isDebug()) {
                    ioe.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("IOException loading extension `" + finName + "`: " + ioe);
            }
            catch (Exception e) {
                if (LoadService.this.runtime.isDebug()) {
                    e.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("Exception loading extension `" + finName + "`: " + e);
            }
            if (state.library == null && oldLibrary != null) {
                state.library = oldLibrary;
            }
        }
    }

    public class ClassLoaderSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) {
            state.library = LoadService.this.findLibraryWithClassloaders(state, state.searchFile, state.suffixType);
        }
    }

    public class NormalSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) {
            state.library = LoadService.this.findLibraryWithoutCWD(state, state.searchFile, state.suffixType);
        }
    }

    public class SourceBailoutSearcher
    extends BailoutSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return !extensionPattern.matcher(state.loadName).find();
        }

        public void trySearch(SearchState state) throws AlreadyLoaded {
            super.trySearch(state.searchFile, SuffixType.Source);
        }
    }

    public class BailoutSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        protected void trySearch(String file2, SuffixType suffixType) throws AlreadyLoaded {
            for (String suffix : suffixType.getSuffixes()) {
                String searchName = file2 + suffix;
                RubyString searchNameString = RubyString.newString(LoadService.this.runtime, searchName);
                if (!LoadService.this.featureAlreadyLoaded(searchNameString)) continue;
                throw new AlreadyLoaded(searchNameString);
            }
        }

        public void trySearch(SearchState state) throws AlreadyLoaded {
            this.trySearch(state.searchFile, state.suffixType);
        }
    }

    public static class AlreadyLoaded
    extends Exception {
        private RubyString searchNameString;

        public AlreadyLoaded(RubyString searchNameString) {
            this.searchNameString = searchNameString;
        }

        public RubyString getSearchNameString() {
            return this.searchNameString;
        }
    }

    public static interface LoadSearcher {
        public boolean shouldTrySearch(SearchState var1);

        public void trySearch(SearchState var1) throws AlreadyLoaded;
    }

    private static class TracingLoadTimer
    extends LoadTimer {
        private final AtomicInteger indent = new AtomicInteger(0);

        private TracingLoadTimer() {
        }

        private String getIndentString() {
            StringBuilder buf = new StringBuilder();
            int i2 = this.indent.get();
            for (int j = 0; j < i2; ++j) {
                buf.append("  ");
            }
            return buf.toString();
        }

        public long startLoad(String file2) {
            this.indent.incrementAndGet();
            System.err.println(this.getIndentString() + "-> " + file2);
            return System.currentTimeMillis();
        }

        public void endLoad(String file2, long startTime) {
            System.err.println(this.getIndentString() + "<- " + file2 + " - " + (System.currentTimeMillis() - startTime) + "ms");
            this.indent.decrementAndGet();
        }
    }

    private static class LoadTimer {
        private LoadTimer() {
        }

        public long startLoad(String file2) {
            return 0L;
        }

        public void endLoad(String file2, long startTime) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SuffixType {
        Source,
        Extension,
        Both,
        Neither;

        public static final String[] sourceSuffixes;
        public static final String[] extensionSuffixes;
        private static final String[] allSuffixes;
        private static final String[] emptySuffixes;

        public String[] getSuffixes() {
            switch (this) {
                case Source: {
                    return sourceSuffixes;
                }
                case Extension: {
                    return extensionSuffixes;
                }
                case Both: {
                    return allSuffixes;
                }
                case Neither: {
                    return emptySuffixes;
                }
            }
            throw new RuntimeException("Unknown SuffixType: " + (Object)((Object)this));
        }

        static {
            sourceSuffixes = new String[]{".class", ".rb"};
            extensionSuffixes = new String[]{".jar", ".so", ".bundle", ".dll"};
            allSuffixes = new String[]{".class", ".rb", ".jar", ".so", ".bundle", ".dll"};
            emptySuffixes = new String[]{""};
        }
    }
}

