/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

public class PsychParser
extends RubyObject {
    public static final int YAML_ANY_ENCODING = 0;
    public static final int YAML_UTF8_ENCODING = UTF8Encoding.INSTANCE.getIndex();
    public static final int YAML_UTF16LE_ENCODING = UTF16LEEncoding.INSTANCE.getIndex();
    public static final int YAML_UTF16BE_ENCODING = UTF16BEEncoding.INSTANCE.getIndex();

    public static void initPsychParser(Ruby runtime2, RubyModule psych2) {
        RubyClass psychParser = runtime2.defineClassUnder("Parser", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new PsychParser(runtime2, klazz);
            }
        }, psych2);
        psychParser.defineConstant("ANY", runtime2.newFixnum(0));
        psychParser.defineConstant("UTF8", runtime2.newFixnum(YAML_UTF8_ENCODING));
        psychParser.defineConstant("UTF16LE", runtime2.newFixnum(YAML_UTF16LE_ENCODING));
        psychParser.defineConstant("UTF16BE", runtime2.newFixnum(YAML_UTF16BE_ENCODING));
        psychParser.defineAnnotatedMethods(PsychParser.class);
        psych2.defineClassUnder("SyntaxError", runtime2.getSyntaxError(), RubyException.EXCEPTION_ALLOCATOR);
    }

    public PsychParser(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context, IRubyObject target) {
        StreamReader reader;
        Ruby runtime2 = context.runtime;
        boolean tainted = target.isTaint();
        if (target.respondsTo("read")) {
            reader = new StreamReader((Reader)new InputStreamReader(new IOInputStream(target)));
            if (target instanceof RubyIO) {
                tainted = true;
            }
        } else {
            reader = new StreamReader((Reader)new StringReader(target.convertToString().asJavaString()));
        }
        ParserImpl parser = new ParserImpl(reader);
        IRubyObject handler = this.getInstanceVariable("@handler");
        while (true) {
            try {
                while (true) {
                    RubyFixnum style;
                    RubyBoolean implicit;
                    IRubyObject tag2;
                    IRubyObject anchor;
                    Event event;
                    if ((event = parser.getEvent()).is(Event.ID.StreamStart)) {
                        RuntimeHelpers.invoke(context, handler, "start_stream", (IRubyObject)runtime2.newFixnum(0));
                        continue;
                    }
                    if (event.is(Event.ID.DocumentStart)) {
                        DocumentStartEvent dse = (DocumentStartEvent)event;
                        Integer[] versionInts = dse.getVersion();
                        IRubyObject version = versionInts == null ? runtime2.getNil() : RubyArray.newArray(runtime2, runtime2.newFixnum(versionInts[0]), runtime2.newFixnum(versionInts[1]));
                        Map tagsMap = dse.getTags();
                        RubyArray tags = RubyArray.newArray(runtime2);
                        if (tags.size() > 0) {
                            for (Map.Entry tag3 : tagsMap.entrySet()) {
                                RubyString key2 = RubyString.newString(runtime2, (String)tag3.getKey());
                                RubyString value2 = RubyString.newString(runtime2, (String)tag3.getValue());
                                key2.setTaint(tainted);
                                value2.setTaint(tainted);
                                tags.append(RubyArray.newArray(runtime2, key2, value2));
                            }
                        }
                        RuntimeHelpers.invoke(context, handler, "start_document", version, (IRubyObject)tags, (IRubyObject)runtime2.newBoolean(dse.getExplicit()));
                        continue;
                    }
                    if (event.is(Event.ID.DocumentEnd)) {
                        DocumentEndEvent dee = (DocumentEndEvent)event;
                        RuntimeHelpers.invoke(context, handler, "end_document", (IRubyObject)runtime2.newBoolean(dee.getExplicit()));
                        continue;
                    }
                    if (event.is(Event.ID.Alias)) {
                        AliasEvent ae = (AliasEvent)event;
                        IRubyObject alias2 = runtime2.getNil();
                        if (ae.getAnchor() != null) {
                            alias2 = RubyString.newString(runtime2, ae.getAnchor());
                            alias2.setTaint(tainted);
                        }
                        RuntimeHelpers.invoke(context, handler, "alias", alias2);
                        continue;
                    }
                    if (event.is(Event.ID.Scalar)) {
                        ScalarEvent se = (ScalarEvent)event;
                        anchor = se.getAnchor() == null ? runtime2.getNil() : RubyString.newString(runtime2, se.getAnchor());
                        tag2 = se.getTag() == null ? runtime2.getNil() : RubyString.newString(runtime2, se.getTag());
                        RubyBoolean plain_implicit = runtime2.newBoolean(se.getImplicit().isFirst());
                        RubyBoolean quoted_implicit = runtime2.newBoolean(se.getImplicit().isSecond());
                        RubyFixnum style2 = runtime2.newFixnum(se.getStyle().charValue());
                        RubyString val = RubyString.newString(runtime2, se.getValue());
                        val.setTaint(tainted);
                        anchor.setTaint(tainted);
                        tag2.setTaint(tainted);
                        RuntimeHelpers.invoke(context, handler, "scalar", val, anchor, tag2, plain_implicit, quoted_implicit, style2);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceStart)) {
                        SequenceStartEvent sse = (SequenceStartEvent)event;
                        anchor = sse.getAnchor() == null ? runtime2.getNil() : RubyString.newString(runtime2, sse.getAnchor());
                        tag2 = sse.getTag() == null ? runtime2.getNil() : RubyString.newString(runtime2, sse.getTag());
                        implicit = runtime2.newBoolean(sse.getImplicit());
                        style = runtime2.newFixnum(sse.getFlowStyle() != false ? 1 : 0);
                        anchor.setTaint(tainted);
                        tag2.setTaint(tainted);
                        RuntimeHelpers.invoke(context, handler, "start_sequence", anchor, tag2, implicit, style);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceEnd)) {
                        RuntimeHelpers.invoke(context, handler, "end_sequence");
                        continue;
                    }
                    if (event.is(Event.ID.MappingStart)) {
                        MappingStartEvent mse = (MappingStartEvent)event;
                        anchor = mse.getAnchor() == null ? runtime2.getNil() : RubyString.newString(runtime2, mse.getAnchor());
                        tag2 = mse.getTag() == null ? runtime2.getNil() : RubyString.newString(runtime2, mse.getTag());
                        implicit = runtime2.newBoolean(mse.getImplicit());
                        style = runtime2.newFixnum(mse.getFlowStyle() != false ? 1 : 0);
                        anchor.setTaint(tainted);
                        tag2.setTaint(tainted);
                        RuntimeHelpers.invoke(context, handler, "start_mapping", anchor, tag2, implicit, style);
                        continue;
                    }
                    if (event.is(Event.ID.MappingEnd)) {
                        RuntimeHelpers.invoke(context, handler, "end_mapping");
                        continue;
                    }
                    if (event.is(Event.ID.StreamEnd)) break;
                }
                RuntimeHelpers.invoke(context, handler, "end_stream");
            }
            catch (ParserException pe) {
                parser = null;
                RubyKernel.raise(context, runtime2.getKernel(), new IRubyObject[]{runtime2.getModule("Psych").getConstant("SyntaxError"), runtime2.newString(pe.getLocalizedMessage())}, Block.NULL_BLOCK);
                continue;
            }
            catch (ScannerException se) {
                parser = null;
                StringBuilder message2 = new StringBuilder("syntax error");
                if (se.getProblemMark() != null) {
                    message2.append(se.getProblemMark().toString());
                }
                throw runtime2.newArgumentError(message2.toString());
            }
            break;
        }
        return this;
    }
}

