/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.util.ArrayList;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.util.JavaNameMangler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktraceData {
    private RubyStackTraceElement[] backtraceElements;
    private final StackTraceElement[] javaTrace;
    private final BacktraceElement[] rubyTrace;
    private final boolean fullTrace;
    private final boolean maskNative;
    private final TraceType.Gather gather;
    public static final BacktraceData EMPTY = new BacktraceData(new StackTraceElement[0], new BacktraceElement[0], false, false, TraceType.Gather.NORMAL);

    public BacktraceData(StackTraceElement[] javaTrace, BacktraceElement[] rubyTrace, boolean fullTrace, boolean maskNative, TraceType.Gather gather) {
        this.javaTrace = javaTrace;
        this.rubyTrace = rubyTrace;
        this.fullTrace = fullTrace;
        this.maskNative = maskNative;
        this.gather = gather;
    }

    public RubyStackTraceElement[] getBacktrace(Ruby runtime2) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.transformBacktrace(runtime2.getBoundMethods());
        }
        return this.backtraceElements;
    }

    private RubyStackTraceElement[] transformBacktrace(Map<String, String> boundMethods) {
        int rubyFrameIndex;
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(this.javaTrace.length);
        boolean dupFrame = false;
        String dupFrameName = null;
        int n = rubyFrameIndex = this.rubyTrace == null ? -1 : this.rubyTrace.length - 1;
        if (this.javaTrace == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.javaTrace.length; ++i2) {
            String classMethod;
            FrameType frameType;
            StackTraceElement element = this.javaTrace[i2];
            if (element.getFileName() != null && (element.getFileName().endsWith(".rb") || element.getFileName().equals("-e") || element.getClassName().startsWith("rubyjit.") || element.getMethodName().contains("$RUBY$") || element.getMethodName().contains("__file__"))) {
                if (element.getLineNumber() == -1) continue;
                String methodName = element.getMethodName();
                String className = element.getClassName();
                if (className.startsWith("rubyjit")) {
                    methodName = className.substring("rubyjit".length() + 1, className.lastIndexOf("_"));
                    methodName = JavaNameMangler.demangleMethodName(methodName);
                    RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false);
                    if (this.maskNative && dupFrame) {
                        dupFrame = false;
                        trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                    }
                    trace.add(rubyElement);
                    if (!element.getMethodName().contains("$RUBY$SYNTHETIC")) continue;
                    while (element.getMethodName().indexOf("$RUBY$SYNTHETIC") != -1 && ++i2 < this.javaTrace.length) {
                        element = this.javaTrace[i2];
                    }
                    continue;
                }
                int RUBYindex = methodName.indexOf("$RUBY$");
                if (RUBYindex >= 0) {
                    if ((methodName = methodName.substring(RUBYindex)).startsWith("$RUBY$SYNTHETIC")) {
                        methodName = methodName.substring("$RUBY$SYNTHETIC".length());
                        if ((methodName = JavaNameMangler.demangleMethodName(methodName)).equals("__file__")) {
                            methodName = "(root)";
                        }
                        RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false);
                        if (this.maskNative && dupFrame) {
                            dupFrame = false;
                            trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                        }
                        trace.add(rubyElement);
                        while (element.getMethodName().indexOf("$RUBY$SYNTHETIC") != -1 && ++i2 < this.javaTrace.length) {
                            element = this.javaTrace[i2];
                        }
                        continue;
                    }
                    methodName = methodName.substring("$RUBY$".length());
                    methodName = JavaNameMangler.demangleMethodName(methodName);
                    RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false);
                    if (this.maskNative && dupFrame) {
                        dupFrame = false;
                        trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                    }
                    trace.add(rubyElement);
                    continue;
                }
                if (methodName.equals("__file__") && !element.getFileName().endsWith("AbstractScript.java")) {
                    methodName = "(root)";
                    RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false);
                    if (this.maskNative && dupFrame) {
                        dupFrame = false;
                        trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                    }
                    trace.add(rubyElement);
                    continue;
                }
            }
            String dotClassMethod = element.getClassName() + "." + element.getMethodName();
            String rubyName = null;
            if (this.fullTrace || (rubyName = boundMethods.get(dotClassMethod)) != null) {
                String filename2 = element.getFileName();
                if (filename2 == null) {
                    filename2 = element.getClassName().replaceAll("\\.", "/");
                } else {
                    int lastDot = element.getClassName().lastIndexOf(46);
                    if (lastDot != -1) {
                        filename2 = element.getClassName().substring(0, lastDot + 1).replaceAll("\\.", "/") + filename2;
                    }
                }
                if (this.maskNative) {
                    dupFrame = true;
                    dupFrameName = rubyName;
                    continue;
                }
                if (rubyName == null) {
                    rubyName = element.getMethodName();
                }
                trace.add(new RubyStackTraceElement(element.getClassName(), rubyName, filename2, element.getLineNumber(), false));
                if (!this.fullTrace) continue;
            }
            if ((frameType = FrameType.INTERPRETED_FRAMES.get(classMethod = element.getClassName() + "." + element.getMethodName())) == null || rubyFrameIndex < 0) continue;
            BacktraceElement rubyFrame = this.rubyTrace[rubyFrameIndex];
            RubyStackTraceElement rubyElement = new RubyStackTraceElement(rubyFrame.klass, rubyFrame.method, rubyFrame.filename, rubyFrame.line + 1, false);
            if (this.maskNative && dupFrame) {
                dupFrame = false;
                trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
            }
            trace.add(rubyElement);
            --rubyFrameIndex;
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }
}

