/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.AbstractLocalContextProvider;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContext;
import org.jruby.embed.internal.LocalContextProvider;

public class SingletonLocalContextProvider
extends AbstractLocalContextProvider {
    private static LocalContext localContext = null;
    private static BiVariableMap varMap = null;
    private static HashMap attribute = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalContext getLocalContextInstance(RubyInstanceConfig config, LocalVariableBehavior behavior, boolean lazy) {
        if (localContext != null) return localContext;
        Class<LocalContext> clazz = LocalContext.class;
        synchronized (LocalContext.class) {
            localContext = new LocalContext(config, behavior, lazy);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return localContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BiVariableMap getBiVariableInstance(LocalContextProvider provider, boolean lazy) {
        if (varMap != null) return varMap;
        Class<BiVariableMap> clazz = BiVariableMap.class;
        synchronized (BiVariableMap.class) {
            varMap = new BiVariableMap(provider, lazy);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return varMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap getAttributeInstance() {
        if (attribute != null) return attribute;
        Class<HashMap> clazz = HashMap.class;
        synchronized (HashMap.class) {
            attribute = new HashMap();
            attribute.put(AttributeName.READER, new InputStreamReader(System.in));
            attribute.put(AttributeName.WRITER, new PrintWriter(System.out, true));
            attribute.put(AttributeName.ERROR_WRITER, new PrintWriter(System.err, true));
            // ** MonitorExit[var0] (shouldn't be in output)
            return attribute;
        }
    }

    public static LocalVariableBehavior getLocalVariableBehaviorOrNull() {
        if (localContext == null) {
            return null;
        }
        return localContext.getLocalVariableBehavior();
    }

    public SingletonLocalContextProvider(LocalVariableBehavior behavior, boolean lazy) {
        this.behavior = behavior;
        this.lazy = lazy;
    }

    public Ruby getRuntime() {
        if (!Ruby.isGlobalRuntimeReady()) {
            return Ruby.newInstance(this.config);
        }
        return Ruby.getGlobalRuntime();
    }

    public RubyInstanceConfig getRubyInstanceConfig() {
        if (Ruby.isGlobalRuntimeReady()) {
            return Ruby.getGlobalRuntime().getInstanceConfig();
        }
        return this.config;
    }

    public BiVariableMap getVarMap() {
        return SingletonLocalContextProvider.getBiVariableInstance(this, this.lazy);
    }

    public Map getAttributeMap() {
        return SingletonLocalContextProvider.getAttributeInstance();
    }

    public boolean isRuntimeInitialized() {
        LocalContext context = SingletonLocalContextProvider.getLocalContextInstance(this.config, this.behavior, this.lazy);
        return context.initialized;
    }

    public void terminate() {
        LocalContext context = SingletonLocalContextProvider.getLocalContextInstance(this.config, this.behavior, this.lazy);
        context.remove();
        context = null;
    }
}

