/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.kenai.constantine.Constant;
import com.kenai.constantine.platform.AddressFamily;
import com.kenai.constantine.platform.INAddr;
import com.kenai.constantine.platform.IPProto;
import com.kenai.constantine.platform.NameInfo;
import com.kenai.constantine.platform.ProtocolFamily;
import com.kenai.constantine.platform.Shutdown;
import com.kenai.constantine.platform.Sock;
import com.kenai.constantine.platform.SocketLevel;
import com.kenai.constantine.platform.SocketOption;
import com.kenai.constantine.platform.TCP;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubySocket(runtime2, klass);
        }
    };
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    private int soDomain;
    private int soType;
    private int soProtocol;
    private static final ByteList BROADCAST = new ByteList("<broadcast>".getBytes());
    private static final byte[] INADDR_BROADCAST = new byte[]{-1, -1, -1, -1};
    private static final ByteList ANY = new ByteList("<any>".getBytes());
    private static final byte[] INADDR_ANY = new byte[]{0, 0, 0, 0};
    private static final Pattern STRING_IPV4_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final Pattern ALREADY_BOUND_PATTERN = Pattern.compile("[Aa]lready.*bound");
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    private static final Pattern PERM_DENIED_PATTERN = Pattern.compile("[Pp]ermission.*denied");
    private static final int IPV4_HOST_GROUP = 3;
    private static final int IPV4_PORT_GROUP = 5;

    static void createSocket(Ruby runtime2) {
        RubyClass rb_cSocket = runtime2.defineClass("Socket", runtime2.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        runtime2.loadConstantSet(rb_mConstants, Sock.class);
        runtime2.loadConstantSet(rb_mConstants, SocketOption.class);
        runtime2.loadConstantSet(rb_mConstants, SocketLevel.class);
        runtime2.loadConstantSet(rb_mConstants, ProtocolFamily.class);
        runtime2.loadConstantSet(rb_mConstants, AddressFamily.class);
        runtime2.loadConstantSet(rb_mConstants, INAddr.class);
        runtime2.loadConstantSet(rb_mConstants, IPProto.class);
        runtime2.loadConstantSet(rb_mConstants, Shutdown.class);
        runtime2.loadConstantSet(rb_mConstants, TCP.class);
        runtime2.loadConstantSet(rb_mConstants, NameInfo.class);
        rb_mConstants.fastSetConstant("MSG_OOB", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("MSG_PEEK", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("MSG_DONTROUTE", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("AI_PASSIVE", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IP_MULTICAST_TTL", runtime2.newFixnum(10));
        rb_mConstants.fastSetConstant("IP_MULTICAST_LOOP", runtime2.newFixnum(11));
        rb_mConstants.fastSetConstant("IP_ADD_MEMBERSHIP", runtime2.newFixnum(12));
        rb_mConstants.fastSetConstant("IP_MAX_MEMBERSHIPS", runtime2.newFixnum(20));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_LOOP", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_TTL", runtime2.newFixnum(1));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected int getSoTypeDefault() {
        return this.soType;
    }

    @Deprecated
    public static IRubyObject for_fd(IRubyObject socketClass, IRubyObject fd) {
        return RubySocket.for_fd(socketClass.getRuntime().getCurrentContext(), socketClass, fd);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject fd) {
        Ruby ruby2 = context.getRuntime();
        if (fd instanceof RubyFixnum) {
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno((int)((RubyFixnum)fd).getLongValue());
            if (descriptor == null) {
                throw ruby2.newErrnoEBADFError();
            }
            Channel mainChannel = descriptor.getChannel();
            if (mainChannel instanceof SocketChannel) {
                socket2.soDomain = AddressFamily.AF_INET.value();
                socket2.soType = Sock.SOCK_STREAM.value();
                socket2.soProtocol = 0;
            } else if (mainChannel instanceof DatagramChannel) {
                socket2.soDomain = AddressFamily.AF_INET.value();
                socket2.soType = Sock.SOCK_DGRAM.value();
                socket2.soProtocol = 0;
            } else {
                throw context.getRuntime().newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
            }
            socket2.initSocket(ruby2, descriptor);
            return socket2;
        }
        throw context.getRuntime().newTypeError(fd, context.getRuntime().getFixnum());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol) {
        try {
            void var5_11;
            if (domain instanceof RubyString) {
                String string2 = domain.toString();
                if (string2.equals("AF_INET")) {
                    this.soDomain = AddressFamily.AF_INET.value();
                } else {
                    if (!string2.equals("PF_INET")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket domain " + string2);
                    this.soDomain = ProtocolFamily.PF_INET.value();
                }
            } else {
                this.soDomain = RubyNumeric.fix2int(domain);
            }
            if (type2 instanceof RubyString) {
                String string3 = type2.toString();
                if (string3.equals("SOCK_STREAM")) {
                    this.soType = Sock.SOCK_STREAM.value();
                } else {
                    if (!string3.equals("SOCK_DGRAM")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket type " + string3);
                    this.soType = Sock.SOCK_DGRAM.value();
                }
            } else {
                this.soType = RubyNumeric.fix2int(type2);
            }
            this.soProtocol = RubyNumeric.fix2int(protocol);
            Object var5_8 = null;
            if (this.soType == Sock.SOCK_STREAM.value()) {
                SocketChannel socketChannel = SocketChannel.open();
            } else if (this.soType == Sock.SOCK_DGRAM.value()) {
                DatagramChannel datagramChannel = DatagramChannel.open();
            }
            this.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)var5_11, new ModeFlags(ModeFlags.RDWR)));
            return this;
        }
        catch (InvalidValueException invalidValueException) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw RubySocket.sockerr(context.getRuntime(), "initialize: " + iOException.toString());
        }
    }

    private static RuntimeException sockerr(Ruby runtime2, String msg) {
        return new RaiseException(runtime2, runtime2.fastGetClass("SocketError"), msg, true);
    }

    @Deprecated
    public static IRubyObject gethostname(IRubyObject recv2) {
        return RubySocket.gethostname(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        try {
            return context.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return context.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw RubySocket.sockerr(context.getRuntime(), "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(Ruby runtime2, String s2) {
        try {
            byte[] bs = ByteList.plain((CharSequence)s2);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "strtoaddr: " + e.toString());
        }
    }

    private static String intoString(Ruby runtime2, InetAddress as) {
        try {
            return new String(ByteList.plain((byte[])as.getAddress()));
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "addrtostr: " + e.toString());
        }
    }

    @Deprecated
    public static IRubyObject gethostbyaddr(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.gethostbyaddr(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] ret = new IRubyObject[]{runtime2.newString(RubySocket.intoAddress(runtime2, args2[0].convertToString().toString()).getCanonicalHostName()), runtime2.newArray(), runtime2.newFixnum(2), args2[0]};
        return runtime2.newArrayNoCopy(ret);
    }

    @Deprecated
    public static IRubyObject getservbyname(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getservbyname(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int port;
        String proto;
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        String name2 = args2[0].convertToString().toString();
        Service service = Service.getServiceByName((String)name2, (String)(proto = argc == 1 ? "tcp" : args2[1].convertToString().toString()));
        if (service != null) {
            port = service.getPort();
        } else {
            try {
                port = Integer.parseInt(name2.trim());
            }
            catch (NumberFormatException nfe) {
                throw RubySocket.sockerr(runtime2, "no such service " + name2 + "/" + proto);
            }
        }
        return runtime2.newFixnum(port);
    }

    @JRubyMethod(name={"listen"}, backtrace=true)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return context.getRuntime().newFixnum(0);
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_un(IRubyObject recv2, IRubyObject filename2) {
        return RubySocket.pack_sockaddr_un(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u0000');
        sb.append('\u0001');
        String str = filename2.convertToString().toString();
        sb.append(str);
        for (int i2 = str.length(); i2 < 104; ++i2) {
            sb.append('\u0000');
        }
        return context.getRuntime().newString(sb.toString());
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        Channel socketChannel = this.getChannel();
        try {
            if (!(socketChannel instanceof AbstractSelectableChannel)) {
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
            ((AbstractSelectableChannel)socketChannel).configureBlocking(false);
            this.connect(context, arg2);
        }
        catch (ClosedChannelException e) {
            throw context.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw RubySocket.sockerr(context.getRuntime(), "connect(2): name or service not known");
        }
        catch (Error e) {
            Throwable cause2 = e.getCause();
            if (cause2 instanceof SocketException) {
                this.handleSocketException(context.getRuntime(), "connect", (SocketException)cause2);
            }
            throw e;
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        block16: {
            RubyArray sockaddr = (RubyArray)RubySocket.unpack_sockaddr_in(context, this, arg2);
            try {
                IRubyObject addr2 = sockaddr.pop(context);
                IRubyObject port = sockaddr.pop(context);
                InetSocketAddress iaddr = new InetSocketAddress(addr2.convertToString().toString(), RubyNumeric.fix2int(port));
                Channel socketChannel = this.getChannel();
                if (socketChannel instanceof SocketChannel) {
                    if (!((SocketChannel)socketChannel).connect(iaddr)) {
                        throw context.getRuntime().newErrnoEINPROGRESSError();
                    }
                    break block16;
                }
                if (socketChannel instanceof DatagramChannel) {
                    ((DatagramChannel)socketChannel).connect(iaddr);
                    break block16;
                }
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
            catch (AlreadyConnectedException e) {
                throw context.getRuntime().newErrnoEISCONNError();
            }
            catch (ConnectionPendingException e) {
                Channel socketChannel = this.getChannel();
                if (socketChannel instanceof SocketChannel) {
                    try {
                        if (((SocketChannel)socketChannel).finishConnect()) {
                            throw context.getRuntime().newErrnoEISCONNError();
                        }
                        throw context.getRuntime().newErrnoEINPROGRESSError();
                    }
                    catch (IOException ex) {
                        throw RubySocket.sockerr(context.getRuntime(), "connect(2): name or service not known");
                    }
                }
                throw context.getRuntime().newErrnoEINPROGRESSError();
            }
            catch (UnknownHostException e) {
                throw RubySocket.sockerr(context.getRuntime(), "connect(2): unknown host");
            }
            catch (SocketException e) {
                this.handleSocketException(context.getRuntime(), "connect", e);
            }
            catch (IOException e) {
                throw RubySocket.sockerr(context.getRuntime(), "connect(2): name or service not known");
            }
            catch (IllegalArgumentException iae) {
                throw RubySocket.sockerr(context.getRuntime(), iae.getMessage());
            }
            catch (Error e) {
                Throwable cause2 = e.getCause();
                if (cause2 instanceof SocketException) {
                    this.handleSocketException(context.getRuntime(), "connect", (SocketException)cause2);
                }
                throw e;
            }
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject bind(ThreadContext context, IRubyObject arg2) {
        block9: {
            RubyArray sockaddr = (RubyArray)RubySocket.unpack_sockaddr_in(context, this, arg2);
            try {
                IRubyObject addr2 = sockaddr.pop(context);
                IRubyObject port = sockaddr.pop(context);
                InetSocketAddress iaddr = new InetSocketAddress(addr2.convertToString().toString(), RubyNumeric.fix2int(port));
                Channel socketChannel = this.getChannel();
                if (socketChannel instanceof SocketChannel) {
                    Socket socket2 = ((SocketChannel)socketChannel).socket();
                    socket2.bind(iaddr);
                    break block9;
                }
                if (socketChannel instanceof DatagramChannel) {
                    DatagramSocket socket3 = ((DatagramChannel)socketChannel).socket();
                    socket3.bind(iaddr);
                    break block9;
                }
                throw this.getRuntime().newErrnoENOPROTOOPTError();
            }
            catch (UnknownHostException e) {
                throw RubySocket.sockerr(context.getRuntime(), "bind(2): unknown host");
            }
            catch (SocketException e) {
                this.handleSocketException(context.getRuntime(), "bind", e);
            }
            catch (IOException e) {
                throw RubySocket.sockerr(context.getRuntime(), "bind(2): name or service not known");
            }
            catch (IllegalArgumentException iae) {
                throw RubySocket.sockerr(context.getRuntime(), iae.getMessage());
            }
            catch (Error e) {
                Throwable cause2 = e.getCause();
                if (cause2 instanceof SocketException) {
                    this.handleSocketException(context.getRuntime(), "bind", (SocketException)cause2);
                }
                throw e;
            }
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    private void handleSocketException(Ruby runtime2, String caller2, SocketException e) {
        String msg = RubySocket.formatMessage(e, "bind");
        if (ALREADY_BOUND_PATTERN.matcher(msg).find()) {
            throw runtime2.newErrnoEINVALError(msg);
        }
        if (ADDR_NOT_AVAIL_PATTERN.matcher(msg).find()) {
            throw runtime2.newErrnoEADDRNOTAVAILError(msg);
        }
        if (PERM_DENIED_PATTERN.matcher(msg).find()) {
            throw runtime2.newErrnoEACCESError(msg);
        }
        throw runtime2.newErrnoEADDRINUSEError(msg);
    }

    private static String formatMessage(Throwable e, String defaultMsg) {
        String msg = e.getMessage();
        msg = msg == null ? defaultMsg : defaultMsg + " - " + msg;
        return msg;
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_in(IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return RubySocket.pack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, port, host);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return RubySocket.pack_sockaddr_in(context, recv2, RubyNumeric.fix2int(port), host.isNil() ? null : host.convertToString().toString());
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, int iport, String host) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            RubySocket.writeSockaddrHeader(ds);
            RubySocket.writeSockaddrPort(ds, iport);
            try {
                if (host != null && "".equals(host)) {
                    ds.writeInt(0);
                } else {
                    InetAddress[] addrs = InetAddress.getAllByName(host);
                    byte[] addr2 = addrs[0].getAddress();
                    ds.write(addr2, 0, addr2.length);
                }
            }
            catch (UnknownHostException e) {
                throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: No address associated with nodename");
            }
            RubySocket.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(context.getRuntime(), "pack_sockaddr_in: internal error");
        }
        return context.getRuntime().newString(new ByteList(bufS.toByteArray(), false));
    }

    static IRubyObject pack_sockaddr_in(ThreadContext context, InetSocketAddress sock) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            RubySocket.writeSockaddrHeader(ds);
            RubySocket.writeSockaddrPort(ds, sock);
            String host = sock.getAddress().getHostAddress();
            if (host != null && "".equals(host)) {
                ds.writeInt(0);
            } else {
                byte[] addr2 = sock.getAddress().getAddress();
                ds.write(addr2, 0, addr2.length);
            }
            RubySocket.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(context.getRuntime(), "pack_sockaddr_in: internal error");
        }
        return context.getRuntime().newString(new ByteList(bufS.toByteArray(), false));
    }

    @Deprecated
    public static IRubyObject unpack_sockaddr_in(IRubyObject recv2, IRubyObject addr2) {
        return RubySocket.unpack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        ByteList val = addr2.convertToString().getByteList();
        if (Platform.IS_BSD && val.get(0) != 16 && val.get(1) != 2 || !Platform.IS_BSD && val.get(0) != 2) {
            throw context.getRuntime().newArgumentError("can't resolve socket address of wrong type");
        }
        int port = ((val.get(2) & 0xFF) << 8) + (val.get(3) & 0xFF);
        StringBuilder sb = new StringBuilder();
        sb.append(val.get(4) & 0xFF);
        sb.append(".");
        sb.append(val.get(5) & 0xFF);
        sb.append(".");
        sb.append(val.get(6) & 0xFF);
        sb.append(".");
        sb.append(val.get(7) & 0xFF);
        IRubyObject[] result = new IRubyObject[]{context.getRuntime().newFixnum(port), context.getRuntime().newString(sb.toString())};
        return context.getRuntime().newArrayNoCopy(result);
    }

    public static InetAddress getRubyInetAddress(ByteList address2) throws UnknownHostException {
        if (address2.equal(BROADCAST)) {
            return InetAddress.getByAddress(INADDR_BROADCAST);
        }
        if (address2.equal(ANY)) {
            return InetAddress.getByAddress(INADDR_ANY);
        }
        return InetAddress.getByName(address2.toString());
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubySocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            InetAddress addr2 = RubySocket.getRubyInetAddress(hostname.convertToString().getByteList());
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] ret = new IRubyObject[]{runtime2.newString(addr2.getHostAddress()), runtime2.newArray(), runtime2.newFixnum(2), runtime2.newString(new ByteList(addr2.getAddress()))};
            return runtime2.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "gethostbyname: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getaddrinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getaddrinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=2, optional=4, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(context.getRuntime(), args2, 2, 4);
        try {
            int flag;
            boolean emptyHost;
            Ruby r = context.getRuntime();
            IRubyObject host = args2[0];
            IRubyObject port = args2[1];
            boolean bl = emptyHost = host.isNil() || host.convertToString().isEmpty();
            if (port instanceof RubyString) {
                port = RubySocket.getservbyname(context, recv2, new IRubyObject[]{port});
            }
            IRubyObject family = args2[2];
            IRubyObject socktype = args2[3];
            IRubyObject flags = args2[5];
            boolean is_ipv6 = !family.isNil() && (RubyNumeric.fix2int(family) & AddressFamily.AF_INET6.value()) == AddressFamily.AF_INET6.value();
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype.isNil()) {
                int val = RubyNumeric.fix2int(socktype);
                if (val == Sock.SOCK_STREAM.value()) {
                    sock_dgram = false;
                } else if (val == Sock.SOCK_DGRAM.value()) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = null;
            if (!flags.isNil() && RubyFixnum.fix2int(flags) > 0 && (flag = RubyNumeric.fix2int(flags)) == 1 && emptyHost) {
                addrs = InetAddress.getAllByName(is_ipv6 ? "[::]" : "0.0.0.0");
            }
            if (addrs == null) {
                addrs = InetAddress.getAllByName(emptyHost ? (is_ipv6 ? "[::1]" : null) : host.convertToString().toString());
            }
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i2 = 0; i2 < addrs.length; ++i2) {
                IRubyObject[] c;
                if (sock_dgram) {
                    c = new IRubyObject[]{r.newString(is_ipv6 ? "AF_INET6" : "AF_INET"), port, r.newString(RubySocket.getHostAddress(recv2, addrs[i2])), r.newString(addrs[i2].getHostAddress()), r.newFixnum((Constant)(is_ipv6 ? ProtocolFamily.PF_INET6 : ProtocolFamily.PF_INET)), r.newFixnum((Constant)Sock.SOCK_DGRAM), r.newFixnum((Constant)IPProto.IPPROTO_UDP)};
                    l.add(r.newArrayNoCopy(c));
                }
                if (!sock_stream) continue;
                c = new IRubyObject[]{r.newString(is_ipv6 ? "AF_INET6" : "AF_INET"), port, r.newString(RubySocket.getHostAddress(recv2, addrs[i2])), r.newString(addrs[i2].getHostAddress()), r.newFixnum((Constant)(is_ipv6 ? ProtocolFamily.PF_INET6 : ProtocolFamily.PF_INET)), r.newFixnum((Constant)Sock.SOCK_STREAM), r.newFixnum((Constant)IPProto.IPPROTO_TCP)};
                l.add(r.newArrayNoCopy(c));
            }
            return r.newArray(l);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getnameinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getnameinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        InetAddress addr2;
        String port;
        String host;
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        int flags = argc == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject arg0 = args2[0];
        if (arg0 instanceof RubyArray) {
            List list2 = ((RubyArray)arg0).getList();
            int len = list2.size();
            if (len < 3 || len > 4) {
                throw runtime2.newArgumentError("array size should be 3 or 4, " + len + " given");
            }
            host = list2.size() == 3 ? list2.get(2).toString() : list2.get(3).toString();
            port = list2.get(1).toString();
        } else {
            if (!(arg0 instanceof RubyString)) throw runtime2.newArgumentError("invalid args");
            String arg2 = ((RubyString)arg0).toString();
            Matcher m = STRING_IPV4_ADDRESS_PATTERN.matcher(arg2);
            if (!m.matches()) {
                IRubyObject obj = RubySocket.unpack_sockaddr_in(context, recv2, arg0);
                if (!(obj instanceof RubyArray)) throw runtime2.newArgumentError("invalid address string");
                List list3 = ((RubyArray)obj).getList();
                int len = list3.size();
                if (len != 2) {
                    throw runtime2.newArgumentError("invalid address representation");
                }
                host = list3.get(1).toString();
                port = list3.get(0).toString();
            } else {
                host = m.group(3);
                if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                    throw runtime2.newArgumentError("invalid address string");
                }
                try {
                    InetAddress ipv6_addr = InetAddress.getByName(host);
                    if (ipv6_addr instanceof Inet6Address) {
                        host = ipv6_addr.getHostAddress();
                    }
                }
                catch (UnknownHostException uhe) {
                    throw runtime2.newArgumentError("invalid address string");
                }
            }
        }
        try {
            addr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(runtime2, "unknown host: " + host);
        }
        host = (flags & NameInfo.NI_NUMERICHOST.value()) == 0 ? addr2.getCanonicalHostName() : addr2.getHostAddress();
        Service serv = Service.getServiceByPort((int)Integer.parseInt(port), null);
        if (serv == null) return runtime2.newArray((IRubyObject)runtime2.newString(host), (IRubyObject)runtime2.newString(port));
        port = (flags & NameInfo.NI_NUMERICSERV.value()) == 0 ? serv.getName() : Integer.toString(serv.getPort());
        return runtime2.newArray((IRubyObject)runtime2.newString(host), (IRubyObject)runtime2.newString(port));
    }

    private static String getHostAddress(IRubyObject recv2, InetAddress addr2) {
        return RubySocket.do_not_reverse_lookup(recv2).isTrue() ? addr2.getHostAddress() : addr2.getCanonicalHostName();
    }

    private static void writeSockaddrHeader(DataOutputStream ds) throws IOException {
        if (Platform.IS_BSD) {
            ds.write(16);
            ds.write(2);
        } else {
            ds.write(2);
            ds.write(0);
        }
    }

    private static void writeSockaddrFooter(DataOutputStream ds) throws IOException {
        ds.writeInt(0);
        ds.writeInt(0);
    }

    private static void writeSockaddrPort(DataOutputStream ds, InetSocketAddress sockaddr) throws IOException {
        RubySocket.writeSockaddrPort(ds, sockaddr.getPort());
    }

    private static void writeSockaddrPort(DataOutputStream ds, int port) throws IOException {
        ds.write(port >> 8);
        ds.write(port);
    }

    @JRubyModule(name={"Socket::Constants"})
    public static class Constants {
    }

    @JRubyClass(name={"SocketError"}, parent="StandardError")
    public static class SocketError {
    }
}

