/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::VariadicInvoker"}, parent="Object")
public class VariadicInvoker
extends RubyObject {
    private final CallingConvention convention;
    private final Pointer address;
    private final FunctionInvoker functionInvoker;
    private final com.kenai.jffi.Type returnType;

    public static RubyClass createVariadicInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("VariadicInvoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(VariadicInvoker.class);
        result.defineAnnotatedConstants(VariadicInvoker.class);
        return result;
    }

    private VariadicInvoker(Ruby runtime2, IRubyObject klazz, Pointer address2, FunctionInvoker functionInvoker, com.kenai.jffi.Type returnType, CallingConvention convention) {
        super(runtime2, (RubyClass)klazz);
        this.address = address2;
        this.functionInvoker = functionInvoker;
        this.returnType = returnType;
        this.convention = convention;
    }

    public final Arity getArity() {
        return Arity.OPTIONAL;
    }

    @JRubyMethod(name={"__new"}, meta=true, required=3, optional=1)
    public static VariadicInvoker newInvoker(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        if (!(args2[0] instanceof Pointer)) {
            throw context.getRuntime().newTypeError(args2[0], context.getRuntime().fastGetModule("FFI").fastGetClass("Pointer"));
        }
        Pointer address2 = (Pointer)args2[0];
        if (!(args2[1] instanceof Type)) {
            throw context.getRuntime().newTypeError("invalid return type");
        }
        Type returnType = (Type)args2[1];
        CallingConvention conv2 = "stdcall".equals(args2[2].toString()) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        return new VariadicInvoker(context.getRuntime(), klass, address2, functionInvoker, FFIUtil.getFFIType(returnType), conv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"invoke"})
    public IRubyObject invoke(ThreadContext context, IRubyObject typesArg, IRubyObject paramsArg) {
        IRubyObject iRubyObject;
        IRubyObject[] types = ((RubyArray)typesArg).toJavaArrayMaybeUnsafe();
        IRubyObject[] params2 = ((RubyArray)paramsArg).toJavaArrayMaybeUnsafe();
        com.kenai.jffi.Type[] ffiParamTypes = new com.kenai.jffi.Type[types.length];
        ParameterMarshaller[] marshallers = new ParameterMarshaller[types.length];
        block7: for (int i2 = 0; i2 < types.length; ++i2) {
            Type type2 = (Type)types[i2];
            switch (NativeType.valueOf(type2)) {
                case CHAR: 
                case SHORT: 
                case INT: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.SINT32;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller(NativeType.INT);
                    continue block7;
                }
                case UCHAR: 
                case USHORT: 
                case UINT: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.UINT32;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller(NativeType.UINT);
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.DOUBLE;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller(NativeType.DOUBLE);
                    continue block7;
                }
                default: {
                    ffiParamTypes[i2] = FFIUtil.getFFIType(type2);
                    marshallers[i2] = DefaultMethodFactory.getMarshaller((Type)types[i2], CallingConvention.DEFAULT, null);
                }
            }
        }
        Invocation invocation = new Invocation(context);
        Function function = new Function(this.address.getAddress(), this.returnType, ffiParamTypes, this.convention);
        try {
            HeapInvocationBuffer args2 = new HeapInvocationBuffer(function);
            for (int i3 = 0; i3 < marshallers.length; ++i3) {
                marshallers[i3].marshal(invocation, (InvocationBuffer)args2, params2[i3]);
            }
            iRubyObject = this.functionInvoker.invoke(context, function, args2);
            Object var13_14 = null;
            invocation.finish();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            invocation.finish();
            function.dispose();
            throw throwable;
        }
        function.dispose();
        return iRubyObject;
    }
}

