/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineClassMethodInstr
extends OneOperandInstr {
    public final Operand container;
    public final IRMethod method;

    public DefineClassMethodInstr(Operand container, IRMethod method2) {
        super(Operation.DEF_CLASS_METH, null, container);
        this.container = container;
        this.method = method2;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.container + ", " + this.method.getName();
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return this;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        Operand o = this.container;
        Operand v = valueMap.get(o);
        if (v != null) {
            this.method.setContainer(v);
        }
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        RubyModule clazz = (RubyModule)this.container.retrieve(interp);
        clazz.addMethod(this.method.getName(), new InterpretedIRMethod(this.method, clazz));
        return null;
    }
}

