/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static final ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyRange(runtime2, klass);
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<Object>> attrs = range.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime2.getTrue() : runtime2.getFalse()));
            marshalStream.dumpVariables(attrs);
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type2.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultVariablesUnmarshal(range);
            range.begin = (IRubyObject)range.removeInternalVariable("begin");
            range.end = (IRubyObject)range.removeInternalVariable("end");
            range.isExclusive = ((IRubyObject)range.removeInternalVariable("excl")).isTrue();
            return range;
        }
    };

    public static RubyClass createRangeClass(Ruby runtime2) {
        RubyClass result = runtime2.defineClass("Range", runtime2.getObject(), RANGE_ALLOCATOR);
        runtime2.setRange(result);
        result.index = 18;
        result.setReifiedClass(RubyRange.class);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyRange;
            }
        };
        result.setMarshal(RANGE_MARSHAL);
        result.includeModule(runtime2.getEnumerable());
        result.defineAnnotatedMethods(RubyRange.class);
        return result;
    }

    private RubyRange(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.begin = this.end = runtime2.getNil();
    }

    public static RubyRange newRange(Ruby runtime2, ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, begin2, end2, isExclusive);
        return range;
    }

    public static RubyRange newExclusiveRange(Ruby runtime2, ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, begin2, end2, true);
        return range;
    }

    public static RubyRange newInclusiveRange(Ruby runtime2, ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, begin2, end2, false);
        return range;
    }

    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyRange range = (RubyRange)clone;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final boolean checkBegin(long length2) {
        long beg = RubyNumeric.num2long(this.begin);
        return !(beg < 0L ? (beg += length2) < 0L : length2 < beg);
    }

    final long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end2 = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    final int[] begLenInt(int len, int err) {
        int beg = RubyNumeric.num2int(this.begin);
        int end2 = RubyNumeric.num2int(this.end);
        if (beg < 0 && (beg += len) < 0) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        return new int[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        if (!(begin2 instanceof RubyFixnum) || !(end2 instanceof RubyFixnum)) {
            try {
                IRubyObject result = begin2.callMethod(context, "<=>", end2);
                if (result.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException re) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = begin2;
        this.end = end2;
        this.isExclusive = isExclusive;
    }

    @JRubyMethod(required=2, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        if (!this.begin.isNil() || !this.end.isNil()) {
            throw this.getRuntime().newNameError("`initialize' called twice", "initialize");
        }
        this.init(context, args2[0], args2[1], args2.length > 2 && args2[2].isTrue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"first", "begin"})
    public IRubyObject first() {
        return this.begin;
    }

    @JRubyMethod(name={"last", "end"})
    public IRubyObject last() {
        return this.end;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        long hash2;
        long h = hash2 = this.isExclusive ? 1L : 0L;
        long v = this.begin.callMethod(context, "hash").convertToInteger().getLongValue();
        hash2 ^= v << 1;
        v = this.end.callMethod(context, "hash").convertToInteger().getLongValue();
        hash2 ^= v << 9;
        return this.getRuntime().newFixnum(hash2 ^= h << 24);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyString str = RubyRange.inspect(context, this.begin).strDup(context.getRuntime());
        RubyString str2 = RubyRange.inspect(context, this.end);
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        RubyString str = RubyString.objAsString(context, this.begin).strDup(context.getRuntime());
        RubyString str2 = RubyString.objAsString(context, this.end);
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (RubyRange.equalInternal(context, this.begin, otherRange.begin) && RubyRange.equalInternal(context, this.end, otherRange.end) && this.isExclusive == otherRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (RubyRange.eqlInternal(context, this.begin, otherRange.begin) && RubyRange.eqlInternal(context, this.end, otherRange.end) && this.isExclusive == otherRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject result = a.callMethod(context, "<=>", b);
        if (result.isNil()) {
            return null;
        }
        return RubyComparable.cmpint(context, result, a, b) < 0 ? this.getRuntime().getTrue() : null;
    }

    private IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject result = a.callMethod(context, "<=>", b);
        if (result.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result, a, b);
        if (c == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return c < 0 ? this.getRuntime().getTrue() : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (this.rangeLt(context, v, this.end) != null) {
                callback.call(context, v);
                v = v.callMethod(context, "succ");
            }
        } else {
            IRubyObject c;
            while ((c = this.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.call(context, v);
                if (c != RubyFixnum.zero(this.getRuntime())) {
                    v = v.callMethod(context, "succ");
                    continue;
                }
                break;
            }
        }
    }

    @JRubyMethod
    public IRubyObject to_a(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long base;
            long size2;
            long lim = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++lim;
            }
            if ((size2 = lim - (base = ((RubyFixnum)this.begin).getLongValue())) > Integer.MAX_VALUE) {
                throw runtime2.newRangeError("Range size too large for to_a");
            }
            if (size2 < 0L) {
                return RubyArray.newEmptyArray(runtime2);
            }
            IRubyObject[] array = new IRubyObject[(int)size2];
            int i2 = 0;
            while ((long)i2 < size2) {
                array[i2] = RubyFixnum.newFixnum(runtime2, base + (long)i2);
                ++i2;
            }
            return RubyArray.newArrayNoCopy(runtime2, array);
        }
        return RubyEnumerable.to_a(context, this);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject each(ThreadContext context, final Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "each");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, runtime2, block);
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).uptoCommon18(context, this.end, this.isExclusive, block);
        } else {
            if (!this.begin.respondsTo("succ")) {
                throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
            }
            this.rangeEach(context, new RangeCallBack(){

                void call(ThreadContext context, IRubyObject arg2) {
                    block.yield(context, arg2);
                }
            });
        }
        return this;
    }

    private void fixnumEach(ThreadContext context, Ruby runtime2, Block block) {
        long lim = ((RubyFixnum)this.end).getLongValue();
        if (!this.isExclusive) {
            ++lim;
        }
        if (block.getBody().getArgumentType() == 0) {
            IRubyObject nil = runtime2.getNil();
            for (long i2 = ((RubyFixnum)this.begin).getLongValue(); i2 < lim; ++i2) {
                block.yield(context, nil);
            }
        } else {
            for (long i3 = ((RubyFixnum)this.begin).getLongValue(); i3 < lim; ++i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
        }
    }

    @JRubyMethod(name={"each"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, final Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "each");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, runtime2, block);
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).uptoCommon19(context, this.end, this.isExclusive, block);
        } else if (this.begin instanceof RubySymbol) {
            this.begin.asString().uptoCommon19(context, this.end.asString(), this.isExclusive, block, true);
        } else {
            if (!this.begin.respondsTo("succ")) {
                throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
            }
            this.rangeEach(context, new RangeCallBack(){

                void call(ThreadContext context, IRubyObject arg2) {
                    block.yield(context, arg2);
                }
            });
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject step(ThreadContext context, IRubyObject step2, Block block) {
        return block.isGiven() ? this.stepCommon(context, step2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "step", step2);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject step(ThreadContext context, Block block) {
        return block.isGiven() ? this.stepCommon(context, RubyFixnum.one(context.getRuntime()), block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "step");
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject step2, Block block) {
        Ruby runtime2 = context.getRuntime();
        long unit = RubyNumeric.num2long(step2);
        if (unit < 0L) {
            throw runtime2.newArgumentError("step can't be negative");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            if (unit == 0L) {
                throw runtime2.newArgumentError("step can't be 0");
            }
            this.fixnumStep(context, runtime2, unit, block);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                if (unit == 0L) {
                    throw runtime2.newArgumentError("step can't be 0");
                }
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2);
                Block blockCallback = CallBlock.newCallClosure(this, runtime2.getRange(), Arity.singleArgument(), callback, context);
                ((RubyString)tmp).uptoCommon18(context, this.end, this.isExclusive, blockCallback);
            } else if (this.begin instanceof RubyNumeric) {
                if (RubyRange.equalInternal(context, step2, RubyFixnum.zero(runtime2))) {
                    throw runtime2.newArgumentError("step can't be 0");
                }
                this.numericStep(context, runtime2, step2, block);
            } else {
                if (unit == 0L) {
                    throw runtime2.newArgumentError("step can't be 0");
                }
                if (!this.begin.respondsTo("succ")) {
                    throw runtime2.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2));
            }
        }
        return this;
    }

    private void fixnumStep(ThreadContext context, Ruby runtime2, long unit, Block block) {
        long e = ((RubyFixnum)this.end).getLongValue();
        if (!this.isExclusive) {
            ++e;
        }
        for (long i2 = ((RubyFixnum)this.begin).getLongValue(); i2 < e; i2 += unit) {
            block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
        }
    }

    private void numericStep(ThreadContext context, Ruby runtime2, IRubyObject step2, Block block) {
        String method2 = this.isExclusive ? "<" : "<=";
        IRubyObject beg = this.begin;
        while (beg.callMethod(context, method2, this.end).isTrue()) {
            block.yield(context, beg);
            beg = beg.callMethod(context, "+", step2);
        }
    }

    @JRubyMethod(name={"step"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject step19(ThreadContext context, Block block) {
        return block.isGiven() ? this.stepCommon19(context, RubyFixnum.zero(context.getRuntime()), block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "step");
    }

    @JRubyMethod(name={"step"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject step19(ThreadContext context, IRubyObject step2, Block block) {
        RubyFixnum zero;
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, (IRubyObject)this, "step", step2);
        }
        if (!(step2 instanceof RubyNumeric)) {
            step2 = step2.convertToInteger("to_int");
        }
        if (step2.callMethod(context, "<", zero = RubyFixnum.zero(runtime2)).isTrue()) {
            throw runtime2.newArgumentError("step can't be negative");
        }
        if (!step2.callMethod(context, ">", zero).isTrue()) {
            throw runtime2.newArgumentError("step can't be 0");
        }
        return this.stepCommon19(context, step2, block);
    }

    private IRubyObject stepCommon19(ThreadContext context, IRubyObject step2, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            this.fixnumStep(context, runtime2, ((RubyFixnum)step2).getLongValue(), block);
        } else if (this.begin instanceof RubyFloat || this.end instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep19(context, runtime2, this.begin, this.end, step2, this.isExclusive, block);
        } else if (this.begin instanceof RubyNumeric || !this.checkIntegerType(runtime2, this.begin, "to_int").isNil() || !this.checkIntegerType(runtime2, this.end, "to_int").isNil()) {
            this.numericStep19(context, runtime2, step2, block);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2);
                Block blockCallback = CallBlock.newCallClosure(this, runtime2.getRange(), Arity.singleArgument(), callback, context);
                ((RubyString)tmp).uptoCommon19(context, this.end, this.isExclusive, blockCallback);
            } else {
                if (!this.begin.respondsTo("succ")) {
                    throw runtime2.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2));
            }
        }
        return this;
    }

    private void numericStep19(ThreadContext context, Ruby runtime2, IRubyObject step2, Block block) {
        String method2 = this.isExclusive ? "<" : "<=";
        IRubyObject beg = this.begin;
        long i2 = 0L;
        while (beg.callMethod(context, method2, this.end).isTrue()) {
            block.yield(context, beg);
            beg = this.begin.callMethod(context, "+", RubyFixnum.newFixnum(runtime2, ++i2).callMethod(context, "*", step2));
        }
    }

    @JRubyMethod(name={"include?", "member?", "==="}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        if (this.rangeLe(context, this.begin, obj) != null && (this.isExclusive ? this.rangeLt(context, obj, this.end) != null : this.rangeLe(context, obj, this.end) != null)) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"include?", "member?"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject include_p19(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        if (this.begin instanceof RubyNumeric || this.end instanceof RubyNumeric || !TypeConverter.convertToTypeWithCheck(this.begin, runtime2.getInteger(), "to_int").isNil() || !TypeConverter.convertToTypeWithCheck(this.end, runtime2.getInteger(), "to_int").isNil()) {
            if (this.rangeLe(context, this.begin, obj) != null && (this.isExclusive ? this.rangeLt(context, obj, this.end) != null : this.rangeLe(context, obj, this.end) != null)) {
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }
        if (this.begin instanceof RubyString && this.end instanceof RubyString && ((RubyString)this.begin).getByteList().getRealSize() == 1 && ((RubyString)this.end).getByteList().getRealSize() == 1) {
            if (obj.isNil()) {
                return runtime2.getFalse();
            }
            if (obj instanceof RubyString) {
                ByteList Vbytes = ((RubyString)obj).getByteList();
                if (Vbytes.getRealSize() != 1) {
                    return runtime2.getFalse();
                }
                int v = Vbytes.getUnsafeBytes()[Vbytes.getBegin()] & 0xFF;
                ByteList Bbytes = ((RubyString)this.begin).getByteList();
                int b = Bbytes.getUnsafeBytes()[Bbytes.getBegin()] & 0xFF;
                ByteList Ebytes = ((RubyString)this.end).getByteList();
                int e = Ebytes.getUnsafeBytes()[Ebytes.getBegin()] & 0xFF;
                if (Encoding.isAscii((int)v) && Encoding.isAscii((int)b) && Encoding.isAscii((int)e)) {
                    if (b <= v && v < e || !this.isExclusive && v == e) {
                        return runtime2.getTrue();
                    }
                    return runtime2.getFalse();
                }
            }
        }
        return RuntimeHelpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"==="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject eqq_p19(ThreadContext context, IRubyObject obj) {
        return this.callMethod(context, "include?", obj);
    }

    @JRubyMethod(name={"cover?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject cover_p(ThreadContext context, IRubyObject obj) {
        return this.include_p(context, obj);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9, frame=true)
    public IRubyObject min(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return RuntimeHelpers.invokeSuper(context, this, block);
        }
        int c = RubyComparable.cmpint(context, this.begin.callMethod(context, "<=>", this.end), this.begin, this.end);
        if (c > 0 || c == 0 && this.isExclusive) {
            return context.getRuntime().getNil();
        }
        return this.begin;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9, frame=true)
    public IRubyObject max(ThreadContext context, Block block) {
        if (this.begin.callMethod(context, ">", this.end).isTrue()) {
            return context.getRuntime().getNil();
        }
        if (block.isGiven() || this.isExclusive && !(this.end instanceof RubyNumeric)) {
            return RuntimeHelpers.invokeSuper(context, this, block);
        }
        int c = RubyComparable.cmpint(context, this.begin.callMethod(context, "<=>", this.end), this.begin, this.end);
        Ruby runtime2 = context.getRuntime();
        if (this.isExclusive) {
            if (!(this.end instanceof RubyInteger)) {
                throw runtime2.newTypeError("cannot exclude non Integer end value");
            }
            if (c == 0) {
                return runtime2.getNil();
            }
            if (this.end instanceof RubyFixnum) {
                return RubyFixnum.newFixnum(runtime2, ((RubyFixnum)this.end).getLongValue() - 1L);
            }
            return this.end.callMethod(context, "-", RubyFixnum.one(runtime2));
        }
        return this.end;
    }

    @JRubyMethod(name={"first"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject first(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod(name={"first"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject first(ThreadContext context, IRubyObject arg2) {
        final Ruby runtime2 = context.getRuntime();
        final int num = RubyNumeric.num2int(arg2);
        final RubyArray result = runtime2.newArray(num);
        try {
            RubyEnumerable.callEach(runtime2, context, (IRubyObject)this, Arity.ONE_ARGUMENT, new BlockCallback(){
                int n;
                {
                    this.n = num;
                }

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (this.n-- <= 0) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result.append(largs[0]);
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod(name={"last"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject last(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod(name={"last"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject last(ThreadContext context, IRubyObject arg2) {
        return ((RubyArray)RubyKernel.new_array(context, this, this)).last(arg2);
    }

    private static final class StepBlockCallBack
    extends RangeCallBack
    implements BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;

        StepBlockCallBack(Block block, IRubyObject iter, IRubyObject step2) {
            this.block = block;
            this.iter = iter;
            this.step = step2;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block originalBlock) {
            this.call(context, args2[0]);
            return context.getRuntime().getNil();
        }

        void call(ThreadContext context, IRubyObject arg2) {
            this.iter = this.iter instanceof RubyFixnum ? RubyFixnum.newFixnum(context.getRuntime(), ((RubyFixnum)this.iter).getLongValue() - 1L) : this.iter.callMethod(context, "-", RubyFixnum.one(context.getRuntime()));
            if (this.iter == RubyFixnum.zero(context.getRuntime())) {
                this.block.yield(context, arg2);
                this.iter = this.step;
            }
        }
    }

    private static abstract class RangeCallBack {
        private RangeCallBack() {
        }

        abstract void call(ThreadContext var1, IRubyObject var2);
    }
}

