/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.threading.DaemonThreadFactory;

public class FiberLibrary
implements Library {
    private Executor executor;

    public void load(Ruby runtime2, boolean wrap2) {
        RubyClass cFiber = runtime2.defineClass("Fiber", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new Fiber(runtime2, klazz);
            }
        });
        cFiber.defineAnnotatedMethods(Fiber.class);
        cFiber.defineAnnotatedMethods(FiberMeta.class);
        this.executor = runtime2.getExecutor() != null ? runtime2.getExecutor() : Executors.newCachedThreadPool(new DaemonThreadFactory());
    }

    public static class FiberMeta {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, rest=true, meta=true)
        public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            Fiber fiber = context.getFiber();
            if (fiber == null) {
                throw context.getRuntime().newFiberError("can't yield from root fiber");
            }
            if (args2.length == 1) {
                fiber.result = args2[0];
            } else if (args2.length > 0) {
                fiber.result = context.getRuntime().newArrayNoCopyLight(args2);
            }
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                try {
                    fiber.state = FiberState.YIELDED;
                    fiber.yieldLock.wait();
                }
                catch (InterruptedException ie) {
                    throw context.getRuntime().newConcurrencyError(ie.getLocalizedMessage());
                }
            }
            return fiber.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JRubyClass(name={"Fiber"})
    public class Fiber
    extends RubyObject
    implements ExecutionContext {
        private final Object yieldLock;
        private final Map<Object, IRubyObject> contextVariables;
        private Block block;
        private IRubyObject result;
        private RubyThread parent;
        private Runnable runnable;
        private FiberState state;

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
            final Ruby runtime2 = context.getRuntime();
            if (block == null || !block.isGiven()) {
                throw runtime2.newArgumentError("tried to create Proc object without a block");
            }
            this.block = block;
            this.parent = context.getThread();
            this.result = runtime2.getNil();
            this.runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.state = FiberState.STARTED;
                        ThreadContext context = runtime2.getCurrentContext();
                        context.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yieldArray(context, Fiber.this.result, null, null);
                        }
                        catch (JumpException.RetryJump rtry) {
                            Fiber.this.parent.raise(new IRubyObject[]{runtime2.newSyntaxError("Invalid retry").getException()}, Block.NULL_BLOCK);
                        }
                        catch (JumpException.BreakJump brk) {
                            Fiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime2.getNil(), "break from proc-closure").getException()}, Block.NULL_BLOCK);
                        }
                        catch (JumpException.ReturnJump ret) {
                            Fiber.this.parent.raise(new IRubyObject[]{runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, runtime2.getNil(), "unexpected return").getException()}, Block.NULL_BLOCK);
                        }
                        catch (RaiseException re) {
                            Fiber.this.parent.raise(new IRubyObject[]{re.getException()}, Block.NULL_BLOCK);
                        }
                        finally {
                            Fiber.this.yieldLock.notify();
                            Fiber.this.state = FiberState.FINISHED;
                        }
                    }
                }
            };
            return this;
        }

        public Fiber(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            this.yieldLock = new Object();
            this.contextVariables = new WeakHashMap<Object, IRubyObject>();
            this.state = FiberState.NOT_STARTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(ThreadContext context, IRubyObject[] args2) {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = args2.length == 0 ? context.getRuntime().getNil() : (args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopyLight(args2));
                try {
                    switch (this.state) {
                        case NOT_STARTED: {
                            FiberLibrary.this.executor.execute(this.runnable);
                            this.yieldLock.wait();
                            break;
                        }
                        case RUNNING: {
                            throw context.getRuntime().newFiberError("double resume");
                        }
                        case FINISHED: {
                            throw context.getRuntime().newFiberError("dead fiber called");
                        }
                        case YIELDED: {
                            this.state = FiberState.RUNNING;
                            this.yieldLock.notify();
                            this.yieldLock.wait();
                            break;
                        }
                        default: {
                            throw context.getRuntime().newFiberError("fiber in an unknown state");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    throw context.getRuntime().newConcurrencyError(ie.getLocalizedMessage());
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"transfer"}, rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(ThreadContext context, IRubyObject[] args2) {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                try {
                    this.yieldLock.wait();
                }
                catch (InterruptedException ie) {
                    throw context.getRuntime().newConcurrencyError(ie.getLocalizedMessage());
                }
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p(ThreadContext context) {
            return context.getRuntime().newBoolean(this.state != FiberState.FINISHED);
        }

        @Override
        public Map<Object, IRubyObject> getContextVariables() {
            return this.contextVariables;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FiberState {
        NOT_STARTED,
        STARTED,
        YIELDED,
        RUNNING,
        FINISHED;

    }
}

