/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.CallbackMarshaller;
import org.jruby.ext.ffi.jffi.CallbackMethodWithBlock;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.DefaultMethodOneArg;
import org.jruby.ext.ffi.jffi.DefaultMethodThreeArg;
import org.jruby.ext.ffi.jffi.DefaultMethodTwoArg;
import org.jruby.ext.ffi.jffi.DefaultMethodZeroArg;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FastIntMethodFactory;
import org.jruby.ext.ffi.jffi.FastIntMethodZeroArg;
import org.jruby.ext.ffi.jffi.FastIntPointerMethodOneArg;
import org.jruby.ext.ffi.jffi.FastIntPointerMethodThreeArg;
import org.jruby.ext.ffi.jffi.FastIntPointerMethodTwoArg;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.IntParameterConverter;
import org.jruby.ext.ffi.jffi.IntResultConverter;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class DefaultMethodFactory {
    private DefaultMethodFactory() {
    }

    public static final DefaultMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    DynamicMethod createMethod(RubyModule module, com.kenai.jffi.Function function, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums) {
        int i2;
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i3 = 0; i3 < parameterTypes.length; ++i3) {
            marshallers[i3] = DefaultMethodFactory.getMarshaller(parameterTypes[i3], convention, enums);
            if (marshallers[i3] != null) continue;
            throw module.getRuntime().newTypeError("Could not create marshaller for " + parameterTypes[i3]);
        }
        if (marshallers.length > 0) {
            int cbcount = 0;
            int cbindex = -1;
            for (i2 = 0; i2 < marshallers.length; ++i2) {
                if (!(marshallers[i2] instanceof CallbackMarshaller)) continue;
                ++cbcount;
                cbindex = i2;
            }
            if (cbcount == 1) {
                return new CallbackMethodWithBlock(module, function, functionInvoker, marshallers, cbindex);
            }
        }
        FastIntMethodFactory fastIntFactory = FastIntMethodFactory.getFactory();
        boolean canBeFastInt = parameterTypes.length <= 3 && fastIntFactory.isFastIntResult(returnType) && convention == CallingConvention.DEFAULT;
        block17: for (i2 = 0; canBeFastInt && i2 < parameterTypes.length; ++i2) {
            Type t;
            Type type2 = t = parameterTypes[i2] instanceof MappedType ? ((MappedType)parameterTypes[i2]).getRealType() : parameterTypes[i2];
            if (!(t instanceof Type.Builtin) || marshallers[i2].requiresPostInvoke()) {
                canBeFastInt = false;
                continue;
            }
            switch (t.getNativeType()) {
                case POINTER: 
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    canBeFastInt = Platform.getPlatform().addressSize() == 32;
                    continue block17;
                }
                default: {
                    canBeFastInt = fastIntFactory.isFastIntParam(parameterTypes[i2]);
                }
            }
        }
        if (!canBeFastInt) {
            switch (parameterTypes.length) {
                case 0: {
                    return new DefaultMethodZeroArg(module, function, functionInvoker);
                }
                case 1: {
                    return new DefaultMethodOneArg(module, function, functionInvoker, marshallers);
                }
                case 2: {
                    return new DefaultMethodTwoArg(module, function, functionInvoker, marshallers);
                }
                case 3: {
                    return new DefaultMethodThreeArg(module, function, functionInvoker, marshallers);
                }
            }
            return new DefaultMethod(module, function, functionInvoker, marshallers);
        }
        IntResultConverter resultConverter = fastIntFactory.getIntResultConverter(returnType);
        IntParameterConverter[] intParameterConverters = new IntParameterConverter[parameterTypes.length];
        for (int i4 = 0; i4 < parameterTypes.length; ++i4) {
            intParameterConverters[i4] = fastIntFactory.getIntParameterConverter(parameterTypes[i4], enums);
        }
        switch (parameterTypes.length) {
            case 0: {
                return new FastIntMethodZeroArg(module, function, resultConverter, intParameterConverters);
            }
            case 1: {
                return new FastIntPointerMethodOneArg(module, function, resultConverter, intParameterConverters, marshallers);
            }
            case 2: {
                return new FastIntPointerMethodTwoArg(module, function, resultConverter, intParameterConverters, marshallers);
            }
            case 3: {
                return new FastIntPointerMethodThreeArg(module, function, resultConverter, intParameterConverters, marshallers);
            }
        }
        throw new IllegalArgumentException("Parameter types not supported");
    }

    static FunctionInvoker getFunctionInvoker(Type returnType) {
        if (returnType instanceof Type.Builtin) {
            return DefaultMethodFactory.getFunctionInvoker(returnType.getNativeType());
        }
        if (returnType instanceof CallbackInfo) {
            return new CallbackInvoker((CallbackInfo)returnType);
        }
        if (returnType instanceof StructByValue) {
            return new StructByValueInvoker((StructByValue)returnType);
        }
        if (returnType instanceof MappedType) {
            MappedType ctype = (MappedType)returnType;
            return new MappedTypeInvoker(DefaultMethodFactory.getFunctionInvoker(ctype.getRealType()), ctype);
        }
        throw returnType.getRuntime().newArgumentError("Cannot get FunctionInvoker for " + returnType);
    }

    static FunctionInvoker getFunctionInvoker(NativeType returnType) {
        switch (returnType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case BOOL: {
                return BooleanInvoker.INSTANCE;
            }
            case POINTER: {
                return PointerInvoker.INSTANCE;
            }
            case CHAR: {
                return Signed8Invoker.INSTANCE;
            }
            case SHORT: {
                return Signed16Invoker.INSTANCE;
            }
            case INT: {
                return Signed32Invoker.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8Invoker.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Invoker.INSTANCE;
            }
            case UINT: {
                return Unsigned32Invoker.INSTANCE;
            }
            case LONG_LONG: {
                return Signed64Invoker.INSTANCE;
            }
            case ULONG_LONG: {
                return Unsigned64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32Invoker.INSTANCE : Unsigned64Invoker.INSTANCE;
            }
            case FLOAT: {
                return Float32Invoker.INSTANCE;
            }
            case DOUBLE: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + returnType);
    }

    static final ParameterMarshaller getMarshaller(Type type2, CallingConvention convention, IRubyObject enums) {
        if (type2 instanceof Type.Builtin) {
            return enums != null && !enums.isNil() ? DefaultMethodFactory.getEnumMarshaller(type2, enums) : DefaultMethodFactory.getMarshaller(type2.getNativeType());
        }
        if (type2 instanceof CallbackInfo) {
            return new CallbackMarshaller((CallbackInfo)type2, convention);
        }
        if (type2 instanceof StructByValue) {
            return new StructByValueMarshaller((StructByValue)type2);
        }
        if (type2 instanceof MappedType) {
            MappedType ctype = (MappedType)type2;
            return new MappedTypeMarshaller(DefaultMethodFactory.getMarshaller(ctype.getRealType(), convention, enums), ctype);
        }
        return null;
    }

    static final ParameterMarshaller getEnumMarshaller(Type type2, IRubyObject enums) {
        switch (type2.getNativeType()) {
            case CHAR: 
            case SHORT: 
            case INT: 
            case UCHAR: 
            case USHORT: 
            case UINT: {
                if (!(enums instanceof RubyHash)) {
                    throw type2.getRuntime().newArgumentError("wrong argument type " + enums.getMetaClass().getName() + " (expected Hash)");
                }
                return new IntOrEnumMarshaller((RubyHash)enums);
            }
        }
        return DefaultMethodFactory.getMarshaller(type2.getNativeType());
    }

    static final ParameterMarshaller getMarshaller(NativeType type2) {
        switch (type2) {
            case BOOL: {
                return BooleanMarshaller.INSTANCE;
            }
            case CHAR: {
                return Signed8Marshaller.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case SHORT: {
                return Signed16Marshaller.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case LONG_LONG: {
                return Signed64Marshaller.INSTANCE;
            }
            case ULONG_LONG: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Unsigned64Marshaller.INSTANCE;
            }
            case FLOAT: {
                return Float32Marshaller.INSTANCE;
            }
            case DOUBLE: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
            case POINTER: {
                return BufferMarshaller.INOUT;
            }
            case BUFFER_IN: {
                return BufferMarshaller.IN;
            }
            case BUFFER_OUT: {
                return BufferMarshaller.OUT;
            }
            case BUFFER_INOUT: {
                return BufferMarshaller.INOUT;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + type2);
    }

    static final class MappedTypeMarshaller
    implements ParameterMarshaller {
        private final ParameterMarshaller nativeMarshaller;
        private final MappedType mappedType;

        public MappedTypeMarshaller(ParameterMarshaller nativeMarshaller, MappedType mappedType) {
            this.nativeMarshaller = nativeMarshaller;
            this.mappedType = mappedType;
        }

        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            ThreadContext context = invocation.getThreadContext();
            IRubyObject nativeValue = this.mappedType.toNative(context, parameter);
            if (this.mappedType.isReferenceRequired()) {
                invocation.addReference(nativeValue);
            }
            this.nativeMarshaller.marshal(context, buffer, nativeValue);
        }

        public void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            this.nativeMarshaller.marshal(context, buffer, this.mappedType.toNative(context, parameter));
        }

        public boolean requiresPostInvoke() {
            return this.mappedType.isReferenceRequired();
        }

        public boolean requiresReference() {
            return this.mappedType.isReferenceRequired();
        }
    }

    static final class StructByValueMarshaller
    extends BaseMarshaller {
        private final StructLayout layout;

        public StructByValueMarshaller(StructByValue sbv) {
            this.layout = sbv.getStructLayout();
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (!(parameter instanceof Struct)) {
                throw context.getRuntime().newTypeError("wrong argument type " + parameter.getMetaClass().getName() + " (expected instance of FFI::Struct)");
            }
            AbstractMemory memory = ((Struct)parameter).getMemory();
            if (memory.getSize() < (long)this.layout.getSize()) {
                throw context.getRuntime().newArgumentError("struct memory too small for parameter");
            }
            MemoryIO io2 = memory.getMemoryIO();
            if (io2 instanceof DirectMemoryIO) {
                if (io2.isNull()) {
                    throw context.getRuntime().newRuntimeError("Cannot use a NULL pointer as a struct by value argument");
                }
                buffer.putStruct(((DirectMemoryIO)io2).getAddress());
            } else if (io2 instanceof ArrayMemoryIO) {
                ArrayMemoryIO aio = (ArrayMemoryIO)io2;
                buffer.putStruct(aio.array(), aio.arrayOffset());
            } else {
                throw context.getRuntime().newRuntimeError("invalid struct memory");
            }
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static final class StringMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new StringMarshaller();

        StringMarshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (parameter instanceof RubyString) {
                Util.checkStringSafety(context.getRuntime(), parameter);
                ByteList bl = ((RubyString)parameter).getByteList();
                buffer.putArray(bl.getUnsafeBytes(), bl.begin(), bl.length(), 5);
            } else if (parameter.isNil()) {
                buffer.putAddress(0L);
            } else {
                throw context.getRuntime().newArgumentError("Invalid string parameter");
            }
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static final class BufferMarshaller
    extends BaseMarshaller {
        static final ParameterMarshaller IN = new BufferMarshaller(1);
        static final ParameterMarshaller OUT = new BufferMarshaller(2);
        static final ParameterMarshaller INOUT = new BufferMarshaller(3);
        private final int flags;

        public BufferMarshaller(int flags) {
            this.flags = flags;
        }

        private static final int bufferFlags(Buffer buffer) {
            int f = buffer.getInOutFlags();
            return ((f & 1) != 0 ? 1 : 0) | ((f & 2) != 0 ? 2 : 0);
        }

        public boolean requiresPostInvoke() {
            return false;
        }

        private static final void addBufferParameter(InvocationBuffer buffer, IRubyObject parameter, int flags) {
            ArrayMemoryIO memory = (ArrayMemoryIO)((Buffer)parameter).getMemoryIO();
            buffer.putArray(memory.array(), memory.arrayOffset(), memory.arrayLength(), flags & BufferMarshaller.bufferFlags((Buffer)parameter));
        }

        private static final long getAddress(Pointer ptr) {
            return ((DirectMemoryIO)ptr.getMemoryIO()).getAddress();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (parameter instanceof Buffer) {
                BufferMarshaller.addBufferParameter(buffer, parameter, this.flags);
                return;
            }
            if (parameter instanceof Pointer) {
                buffer.putAddress(BufferMarshaller.getAddress((Pointer)parameter));
                return;
            }
            if (parameter instanceof Struct) {
                AbstractMemory memory = ((Struct)parameter).getMemory();
                if (memory instanceof Buffer) {
                    BufferMarshaller.addBufferParameter(buffer, memory, this.flags);
                    return;
                } else if (memory instanceof Pointer) {
                    buffer.putAddress(BufferMarshaller.getAddress((Pointer)memory));
                    return;
                } else {
                    if (memory != null && !memory.isNil()) throw context.getRuntime().newArgumentError("Invalid Struct memory");
                    buffer.putAddress(0L);
                }
                return;
            }
            if (parameter.isNil()) {
                buffer.putAddress(0L);
                return;
            }
            if (parameter instanceof RubyString) {
                ByteList bl = ((RubyString)parameter).getByteList();
                buffer.putArray(bl.getUnsafeBytes(), bl.begin(), bl.length(), this.flags | 4);
                return;
            }
            if (!parameter.respondsTo("to_ptr")) throw context.getRuntime().newArgumentError("Invalid buffer/pointer parameter");
            int MAXRECURSE = 4;
            for (int depth = 0; depth < 4; ++depth) {
                IRubyObject ptr = parameter.callMethod(context, "to_ptr");
                if (ptr instanceof Pointer) {
                    buffer.putAddress(BufferMarshaller.getAddress((Pointer)ptr));
                    return;
                }
                if (ptr instanceof Buffer) {
                    BufferMarshaller.addBufferParameter(buffer, ptr, this.flags);
                    return;
                }
                if (ptr.isNil()) {
                    buffer.putAddress(0L);
                    return;
                }
                if (depth >= 4 || !ptr.respondsTo("to_ptr")) {
                    throw context.getRuntime().newArgumentError("to_ptr returned an invalid pointer");
                }
                parameter = ptr;
            }
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static final class Float64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putDouble(RubyNumeric.num2dbl(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putDouble(RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Float32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putFloat((float)RubyNumeric.num2dbl(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putFloat((float)RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Unsigned64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned64Marshaller();

        Unsigned64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.uint64Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.uint64Value(parameter));
        }
    }

    static final class Signed64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed64Marshaller();

        Signed64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.int64Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.int64Value(parameter));
        }
    }

    static final class Unsigned32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned32Marshaller();

        Unsigned32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt((int)Util.uint32Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt((int)Util.uint32Value(parameter));
        }
    }

    static final class Signed32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed32Marshaller();

        Signed32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(Util.int32Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(Util.int32Value(parameter));
        }
    }

    static final class Unsigned16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned16Marshaller();

        Unsigned16Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.uint16Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.uint16Value(parameter));
        }
    }

    static final class Signed16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed16Marshaller();

        Signed16Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort((int)Util.int16Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort((int)Util.int16Value(parameter));
        }
    }

    static final class Unsigned8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned8Marshaller();

        Unsigned8Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte((int)Util.uint8Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte((int)Util.uint8Value(parameter));
        }
    }

    static final class Signed8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed8Marshaller();

        Signed8Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte((int)Util.int8Value(parameter));
        }

        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte((int)Util.int8Value(parameter));
        }
    }

    static final class BooleanMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new BooleanMarshaller();

        BooleanMarshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(parameter.isTrue() ? 1 : 0);
        }

        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            if (!(parameter instanceof RubyBoolean)) {
                throw invocation.getThreadContext().getRuntime().newTypeError("wrong argument type.  Expected true or false");
            }
            buffer.putByte(parameter.isTrue() ? 1 : 0);
        }
    }

    static final class IntOrEnumMarshaller
    extends BaseMarshaller {
        private final RubyHash enums;

        public IntOrEnumMarshaller(RubyHash enums) {
            this.enums = enums;
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(Util.intValue(parameter, this.enums));
        }

        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static abstract class BaseMarshaller
    implements ParameterMarshaller {
        BaseMarshaller() {
        }

        public boolean requiresPostInvoke() {
            return false;
        }

        public boolean requiresReference() {
            return false;
        }
    }

    private static final class CallbackInvoker
    extends BaseInvoker {
        NativeFunctionInfo functionInfo;

        public CallbackInvoker(CallbackInfo cbInfo) {
            this.functionInfo = new NativeFunctionInfo(cbInfo.getRuntime(), cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT);
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            long address2 = invoker.invokeAddress(function, args2);
            if (address2 == 0L) {
                return context.getRuntime().getNil();
            }
            return new Function(context.getRuntime(), context.getRuntime().fastGetModule("FFI").fastGetClass("Function"), (DirectMemoryIO)new CodeMemoryIO(context.getRuntime(), address2), this.functionInfo, null);
        }
    }

    private static final class MappedTypeInvoker
    extends BaseInvoker {
        private final FunctionInvoker nativeInvoker;
        private final MappedType mappedType;

        public MappedTypeInvoker(FunctionInvoker nativeInvoker, MappedType converter) {
            this.nativeInvoker = nativeInvoker;
            this.mappedType = converter;
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return this.mappedType.fromNative(context, this.nativeInvoker.invoke(context, function, args2));
        }
    }

    private static final class StructByValueInvoker
    extends BaseInvoker {
        private final StructByValue info;

        public StructByValueInvoker(StructByValue info) {
            this.info = info;
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            Buffer buf = new Buffer(context.getRuntime(), invoker.invokeStruct(function, args2), 0, this.info.getStructLayout().getSize());
            return this.info.getStructClass().newInstance(context, new IRubyObject[]{buf}, Block.NULL_BLOCK);
        }
    }

    private static final class StringInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return FFIUtil.getString(context.getRuntime(), invoker.invokeAddress(function, args2));
        }
    }

    private static final class PointerInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new PointerInvoker();

        private PointerInvoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            long address2 = invoker.invokeAddress(function, args2);
            return new Pointer(context.getRuntime(), NativeMemoryIO.wrap(context.getRuntime(), address2));
        }
    }

    private static final class Float64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return context.getRuntime().newFloat(invoker.invokeDouble(function, args2));
        }
    }

    private static final class Float32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return context.getRuntime().newFloat(invoker.invokeFloat(function, args2));
        }
    }

    private static final class Unsigned64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned64Invoker();

        private Unsigned64Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned64(context.getRuntime(), invoker.invokeLong(function, args2));
        }
    }

    private static final class Signed64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newSigned64(context.getRuntime(), invoker.invokeLong(function, args2));
        }
    }

    private static final class Unsigned32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned32(context.getRuntime(), invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newSigned32(context.getRuntime(), invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned16Invoker();

        private Unsigned16Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned16(context.getRuntime(), (short)invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed16Invoker();

        private Signed16Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newSigned16(context.getRuntime(), (short)invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned8Invoker();

        private Unsigned8Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned8(context.getRuntime(), (byte)invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed8Invoker();

        private Signed8Invoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return Util.newSigned8(context.getRuntime(), (byte)invoker.invokeInt(function, args2));
        }
    }

    private static final class BooleanInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new BooleanInvoker();

        private BooleanInvoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            return context.getRuntime().newBoolean((invoker.invokeInt(function, args2) & 0xFF) != 0);
        }
    }

    private static final class VoidInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        public final IRubyObject invoke(ThreadContext context, com.kenai.jffi.Function function, HeapInvocationBuffer args2) {
            invoker.invokeInt(function, args2);
            return context.getRuntime().getNil();
        }
    }

    private static abstract class BaseInvoker
    implements FunctionInvoker {
        static final Invoker invoker = Invoker.getInstance();

        private BaseInvoker() {
        }
    }

    private static final class SingletonHolder {
        private static final DefaultMethodFactory INSTANCE = new DefaultMethodFactory();

        private SingletonHolder() {
        }
    }
}

