/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.Tuple;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.BranchInstr;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.CaseInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.JUMP_INDIRECT_Instr;
import org.jruby.compiler.ir.instructions.JumpInstr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_END_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_START_MARKER_Instr;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.instructions.SET_RETADDR_Instr;
import org.jruby.compiler.ir.instructions.THROW_EXCEPTION_Instr;
import org.jruby.compiler.ir.instructions.YieldInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.compiler.ir.representations.RescuedRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFG {
    IRExecutionScope _scope;
    BasicBlock _entryBB;
    BasicBlock _exitBB;
    int _nextBBId = 0;
    DirectedGraph<BasicBlock, CFG_Edge> _cfg;
    LinkedList<BasicBlock> _postOrderList;
    Map<String, DataFlowProblem> _dfProbs;
    Map<Label, BasicBlock> _bbMap;
    BasicBlock[] _fallThruMap;
    List<BasicBlock> _linearizedBBList;
    Map<BasicBlock, BasicBlock> _bbRescuerMap;
    List<RescuedRegion> _outermostRRs;
    private Instr[] _instrs;
    private Set<Variable> _definedLocalVars;
    private Set<Variable> _usedLocalVars;

    public CFG(IRExecutionScope s2) {
        this._scope = s2;
        this._postOrderList = null;
        this._dfProbs = new HashMap<String, DataFlowProblem>();
        this._bbMap = new HashMap<Label, BasicBlock>();
        this._outermostRRs = new ArrayList<RescuedRegion>();
        this._bbRescuerMap = new HashMap<BasicBlock, BasicBlock>();
        this._instrs = null;
    }

    public DirectedGraph getGraph() {
        return this._cfg;
    }

    public IRExecutionScope getScope() {
        return this._scope;
    }

    public BasicBlock getEntryBB() {
        return this._entryBB;
    }

    public BasicBlock getExitBB() {
        return this._exitBB;
    }

    public int getNextBBID() {
        ++this._nextBBId;
        return this._nextBBId;
    }

    public int getMaxNodeID() {
        return this._nextBBId;
    }

    public int numNodes() {
        return this._cfg.vertexSet().size();
    }

    public Set<CFG_Edge> incomingEdgesOf(BasicBlock bb) {
        return this._cfg.incomingEdgesOf((Object)bb);
    }

    public Set<CFG_Edge> outgoingEdgesOf(BasicBlock bb) {
        return this._cfg.outgoingEdgesOf((Object)bb);
    }

    public Set<BasicBlock> getNodes() {
        return this._cfg.vertexSet();
    }

    public BasicBlock getFallThroughBB(BasicBlock bb) {
        return this._fallThruMap[bb.getID()];
    }

    public BasicBlock getTargetBB(Label l) {
        return this._bbMap.get(l);
    }

    private Label getNewLabel() {
        return this._scope.getNewLabel();
    }

    private BasicBlock createNewBB(Label l, DirectedGraph<BasicBlock, CFG_Edge> g, Map<Label, BasicBlock> bbMap, Stack<RescuedRegion> nestedRescuedRegions) {
        BasicBlock b = new BasicBlock(this, l);
        bbMap.put(b._label, b);
        g.addVertex((Object)b);
        if (!nestedRescuedRegions.empty()) {
            nestedRescuedRegions.peek().addBB(b);
        }
        return b;
    }

    private BasicBlock createNewBB(DirectedGraph<BasicBlock, CFG_Edge> g, Map<Label, BasicBlock> bbMap, Stack<RescuedRegion> nestedRescuedRegions) {
        return this.createNewBB(this.getNewLabel(), g, bbMap, nestedRescuedRegions);
    }

    private void removeBB(BasicBlock b) {
        this._cfg.removeVertex((Object)b);
        this._bbMap.remove(b._label);
        this._bbRescuerMap.remove(b);
    }

    private void addEdge(DirectedGraph<BasicBlock, CFG_Edge> g, BasicBlock src, Label tgt, Map<Label, BasicBlock> bbMap, Map<Label, List<BasicBlock>> forwardRefs) {
        BasicBlock tgtBB = bbMap.get(tgt);
        if (tgtBB != null) {
            g.addEdge((Object)src, (Object)tgtBB);
        } else {
            List<BasicBlock> frefs = forwardRefs.get(tgt);
            if (frefs == null) {
                frefs = new ArrayList<BasicBlock>();
                forwardRefs.put(tgt, frefs);
            }
            frefs.add(src);
        }
    }

    private DefaultDirectedGraph<BasicBlock, CFG_Edge> getNewCFG() {
        return new DefaultDirectedGraph((EdgeFactory)new EdgeFactory<BasicBlock, CFG_Edge>(){

            public CFG_Edge createEdge(BasicBlock s2, BasicBlock d) {
                return new CFG_Edge(s2, d);
            }
        });
    }

    public Instr[] prepareForInterpretation() {
        if (this._instrs != null) {
            return this._instrs;
        }
        ArrayList<Instr> instrs = new ArrayList<Instr>();
        List<BasicBlock> bbs = this.linearize();
        this.setupFallThruMap();
        HashMap<Label, Integer> labelIPCMap = new HashMap<Label, Integer>();
        ArrayList<Label> labelsToFixup = new ArrayList<Label>();
        int ipc = 0;
        for (BasicBlock b : bbs) {
            labelIPCMap.put(b.getLabel(), ipc);
            labelsToFixup.add(b.getLabel());
            for (Instr i2 : b.getInstrs()) {
                instrs.add(i2);
                ++ipc;
            }
        }
        for (Label l : labelsToFixup) {
            l.setTargetPC((Integer)labelIPCMap.get(l));
        }
        this.getExitBB().getLabel().setTargetPC(ipc + 1);
        this._instrs = instrs.toArray(new Instr[instrs.size()]);
        return this._instrs;
    }

    public Instr[] getInstrArray() {
        return this._instrs;
    }

    public void build(List<Instr> instrs) {
        HashMap<Label, List<BasicBlock>> forwardRefs = new HashMap<Label, List<BasicBlock>>();
        HashMap<Variable, HashSet<Label>> retAddrMap = new HashMap<Variable, HashSet<Label>>();
        ArrayList<BasicBlock> retBBs = new ArrayList<BasicBlock>();
        ArrayList<BasicBlock> excBBs = new ArrayList<BasicBlock>();
        Stack<RescuedRegion> nestedRescuedRegions = new Stack<RescuedRegion>();
        ArrayList<RescuedRegion> allRescuedRegions = new ArrayList<RescuedRegion>();
        DefaultDirectedGraph<BasicBlock, CFG_Edge> g = this.getNewCFG();
        this._entryBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap, nestedRescuedRegions);
        BasicBlock firstBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap, nestedRescuedRegions);
        BasicBlock prevBB = null;
        BasicBlock currBB = firstBB;
        BasicBlock newBB = null;
        boolean bbEnded = false;
        boolean bbEndedWithControlXfer = false;
        for (Instr i2 : instrs) {
            Operand closureArg;
            Operation iop = i2.operation;
            if (iop == Operation.LABEL) {
                Label l = ((LABEL_Instr)i2)._lbl;
                prevBB = currBB;
                newBB = this.createNewBB(l, (DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap, nestedRescuedRegions);
                if (!bbEndedWithControlXfer) {
                    g.addEdge((Object)currBB, (Object)newBB);
                }
                currBB = newBB;
                List frefs = (List)forwardRefs.get(l);
                if (frefs != null) {
                    for (BasicBlock b : frefs) {
                        g.addEdge((Object)b, (Object)newBB);
                    }
                }
                bbEnded = false;
                bbEndedWithControlXfer = false;
            } else if (bbEnded && iop != Operation.RESCUE_BODY_END) {
                prevBB = currBB;
                newBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap, nestedRescuedRegions);
                if (!bbEndedWithControlXfer) {
                    g.addEdge((Object)currBB, (Object)newBB);
                }
                currBB = newBB;
                bbEnded = false;
                bbEndedWithControlXfer = false;
            }
            if (i2 instanceof RESCUED_BODY_START_MARKER_Instr) {
                RESCUED_BODY_START_MARKER_Instr rbsmi = (RESCUED_BODY_START_MARKER_Instr)i2;
                RescuedRegion rr = new RescuedRegion(rbsmi._elseBlock, rbsmi._rescueBlockLabels);
                rr.addBB(currBB);
                allRescuedRegions.add(rr);
                if (nestedRescuedRegions.empty()) {
                    this._outermostRRs.add(rr);
                } else {
                    nestedRescuedRegions.peek().addNestedRegion(rr);
                }
                nestedRescuedRegions.push(rr);
            } else if (i2 instanceof RESCUED_BODY_END_MARKER_Instr) {
                nestedRescuedRegions.pop().setEndBB(currBB);
            } else if (iop.endsBasicBlock()) {
                Label tgt;
                bbEnded = true;
                currBB.addInstr(i2);
                if (i2 instanceof BranchInstr) {
                    tgt = ((BranchInstr)i2).getJumpTarget();
                } else if (i2 instanceof JumpInstr) {
                    tgt = ((JumpInstr)i2).getJumpTarget();
                    bbEndedWithControlXfer = true;
                } else if (i2 instanceof CaseInstr) {
                    tgt = null;
                } else if (i2 instanceof BREAK_Instr) {
                    tgt = null;
                    retBBs.add(currBB);
                    bbEndedWithControlXfer = true;
                } else if (i2 instanceof ReturnInstr) {
                    tgt = null;
                    retBBs.add(currBB);
                    bbEndedWithControlXfer = true;
                } else if (i2 instanceof THROW_EXCEPTION_Instr) {
                    tgt = null;
                    excBBs.add(currBB);
                    bbEndedWithControlXfer = true;
                } else if (i2 instanceof JUMP_INDIRECT_Instr) {
                    tgt = null;
                    bbEndedWithControlXfer = true;
                    Set retAddrs = (Set)retAddrMap.get(((JUMP_INDIRECT_Instr)i2)._target);
                    for (Label l : retAddrs) {
                        this.addEdge((DirectedGraph<BasicBlock, CFG_Edge>)g, currBB, l, this._bbMap, (Map<Label, List<BasicBlock>>)forwardRefs);
                    }
                } else {
                    tgt = null;
                }
                if (tgt != null) {
                    this.addEdge((DirectedGraph<BasicBlock, CFG_Edge>)g, currBB, tgt, this._bbMap, (Map<Label, List<BasicBlock>>)forwardRefs);
                }
            } else if (iop != Operation.LABEL) {
                currBB.addInstr(i2);
            }
            if (i2 instanceof SET_RETADDR_Instr) {
                Variable v = i2.getResult();
                HashSet<Label> addrs = (HashSet<Label>)retAddrMap.get(v);
                if (addrs == null) {
                    addrs = new HashSet<Label>();
                    retAddrMap.put(v, addrs);
                }
                addrs.add(((SET_RETADDR_Instr)i2).getReturnAddr());
                continue;
            }
            if (!(i2 instanceof CallInstr) || !((closureArg = ((CallInstr)i2).getClosureArg()) instanceof MetaObject)) continue;
            ((IRClosure)((MetaObject)closureArg).scope).buildCFG();
        }
        for (RescuedRegion rr : allRescuedRegions) {
            BasicBlock firstRescueBB = this.getTargetBB(rr.getFirstRescueBlockLabel());
            rr.setFirstRescueBB(firstRescueBB);
            for (BasicBlock b : rr._exclusiveBBs) {
                this._bbRescuerMap.put(b, firstRescueBB);
                ((CFG_Edge)g.addEdge((Object)b, (Object)firstRescueBB))._type = CFG_Edge_Type.EXCEPTION_EDGE;
            }
        }
        this._exitBB = this.createNewBB((DirectedGraph<BasicBlock, CFG_Edge>)g, this._bbMap, nestedRescuedRegions);
        ((CFG_Edge)g.addEdge((Object)this._entryBB, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        ((CFG_Edge)g.addEdge((Object)this._entryBB, (Object)firstBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        for (BasicBlock rb : retBBs) {
            ((CFG_Edge)g.addEdge((Object)rb, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        }
        for (BasicBlock rb : excBBs) {
            ((CFG_Edge)g.addEdge((Object)rb, (Object)this._exitBB))._type = CFG_Edge_Type.EXCEPTION_EDGE;
        }
        if (!bbEndedWithControlXfer) {
            ((CFG_Edge)g.addEdge((Object)currBB, (Object)this._exitBB))._type = CFG_Edge_Type.DUMMY_EDGE;
        }
        this._cfg = g;
        this.deleteOrphanedBlocks();
    }

    private void setupFallThruMap() {
        List<BasicBlock> bbs = this.linearize();
        this._fallThruMap = new BasicBlock[1 + this.getMaxNodeID()];
        BasicBlock prev = null;
        for (BasicBlock b : bbs) {
            if (prev != null) {
                this._fallThruMap[prev.getID()] = b;
            }
            prev = b;
        }
    }

    private void mergeBBs(BasicBlock a, BasicBlock b) {
        BasicBlock bR;
        BasicBlock aR = this._bbRescuerMap.get(a);
        if (aR == (bR = this._bbRescuerMap.get(b)) || a.isEmpty() || b.isEmpty()) {
            a.swallowBB(b);
            this._cfg.removeEdge((Object)a, (Object)b);
            for (CFG_Edge e : this._cfg.outgoingEdgesOf((Object)b)) {
                ((CFG_Edge)this._cfg.addEdge((Object)a, (Object)e._dst))._type = e._type;
            }
            this.removeBB(b);
            if (aR == null && bR != null) {
                this._bbRescuerMap.put(a, bR);
            }
        }
    }

    private void mergeStraightlineBBs(BasicBlock callBB, BasicBlock splitBB) {
        Set<CFG_Edge> edges = this.outgoingEdgesOf(callBB);
        assert (edges.size() == 1);
        this.mergeBBs(callBB, edges.iterator().next()._dst);
        edges = this.incomingEdgesOf(splitBB);
        assert (edges.size() == 1);
        this.mergeBBs(edges.iterator().next()._src, splitBB);
    }

    private void inlineClosureAtYieldSite(InlinerInfo ii, IRClosure cl, BasicBlock yieldBB, YieldInstr yield2) {
        BasicBlock splitBB = yieldBB.splitAtInstruction(yield2, this.getNewLabel(), false);
        this._cfg.addVertex((Object)splitBB);
        this._bbMap.put(splitBB._label, splitBB);
        ArrayList<CFG_Edge> edgesToRemove = new ArrayList<CFG_Edge>();
        for (CFG_Edge e : this.outgoingEdgesOf(yieldBB)) {
            ((CFG_Edge)this._cfg.addEdge((Object)splitBB, (Object)e._dst))._type = e._type;
            edgesToRemove.add(e);
        }
        this._cfg.removeAllEdges(edgesToRemove);
        CFG ccfg = cl.getCFG();
        BasicBlock cEntry = ccfg.getEntryBB();
        BasicBlock cExit = ccfg.getExitBB();
        for (BasicBlock b : ccfg.getNodes()) {
            if (b == cEntry || b == cExit) continue;
            this._cfg.addVertex((Object)b);
            this._bbMap.put(b._label, b);
            b.updateCFG(this);
            b.processClosureArgAndReturnInstrs(ii, yield2);
        }
        for (CFG_Edge e : ccfg.outgoingEdgesOf(cEntry)) {
            if (e._dst == cExit) continue;
            ((CFG_Edge)this._cfg.addEdge((Object)yieldBB, (Object)e._dst))._type = e._type;
        }
        for (CFG_Edge e : ccfg.incomingEdgesOf(cExit)) {
            if (e._src == cEntry) continue;
            if (e._type == CFG_Edge_Type.EXCEPTION_EDGE) {
                BasicBlock rescuerOfSplitBB = this._bbRescuerMap.get(splitBB);
                ((CFG_Edge)this._cfg.addEdge((Object)e._src, (Object)(rescuerOfSplitBB != null ? rescuerOfSplitBB : this._exitBB)))._type = CFG_Edge_Type.EXCEPTION_EDGE;
                continue;
            }
            ((CFG_Edge)this._cfg.addEdge((Object)e._src, (Object)splitBB))._type = e._type;
        }
        for (RescuedRegion r : ccfg._outermostRRs) {
            this._outermostRRs.add(r);
        }
        BasicBlock yieldBBrescuer = this._bbRescuerMap.get(yieldBB);
        if (yieldBBrescuer != null) {
            this._bbRescuerMap.put(splitBB, yieldBBrescuer);
        }
        Map<BasicBlock, BasicBlock> cRescuerMap = ccfg._bbRescuerMap;
        for (BasicBlock cb : ccfg.getNodes()) {
            if (cb == cEntry || cb == cExit) continue;
            BasicBlock cbProtector = cRescuerMap.get(cb);
            if (cbProtector != null) {
                this._bbRescuerMap.put(cb, cbProtector);
                continue;
            }
            if (yieldBBrescuer == null) continue;
            this._bbRescuerMap.put(cb, yieldBBrescuer);
        }
        this.mergeStraightlineBBs(yieldBB, splitBB);
    }

    public void inlineMethod(IRMethod m, BasicBlock callBB, CallInstr call2) {
        InlinerInfo ii = new InlinerInfo(call2, this);
        BasicBlock splitBB = callBB.splitAtInstruction(call2, this.getNewLabel(), false);
        this._bbMap.put(splitBB._label, splitBB);
        this._cfg.addVertex((Object)splitBB);
        ArrayList<CFG_Edge> edgesToRemove = new ArrayList<CFG_Edge>();
        for (CFG_Edge e : this.outgoingEdgesOf(callBB)) {
            ((CFG_Edge)this._cfg.addEdge((Object)splitBB, (Object)e._dst))._type = e._type;
            edgesToRemove.add(e);
        }
        this._cfg.removeAllEdges(edgesToRemove);
        CFG mcfg = m.getCFG();
        BasicBlock mEntry = mcfg.getEntryBB();
        BasicBlock mExit = mcfg.getExitBB();
        DefaultDirectedGraph<BasicBlock, CFG_Edge> g = this.getNewCFG();
        for (BasicBlock b : mcfg.getNodes()) {
            if (b == mEntry || b == mExit) continue;
            BasicBlock bCloned = b.cloneForInlining(ii);
            this._cfg.addVertex((Object)bCloned);
            this._bbMap.put(bCloned._label, bCloned);
        }
        for (BasicBlock x : mcfg.getNodes()) {
            if (x == mEntry || x == mExit) continue;
            BasicBlock rx = ii.getRenamedBB(x);
            for (CFG_Edge e : mcfg.outgoingEdgesOf(x)) {
                BasicBlock b = e._dst;
                if (b == mExit) continue;
                ((CFG_Edge)this._cfg.addEdge((Object)rx, (Object)ii.getRenamedBB((BasicBlock)b)))._type = e._type;
            }
        }
        for (CFG_Edge e : mcfg.outgoingEdgesOf(mEntry)) {
            if (e._dst == mExit) continue;
            ((CFG_Edge)this._cfg.addEdge((Object)callBB, (Object)ii.getRenamedBB((BasicBlock)e._dst)))._type = e._type;
        }
        for (CFG_Edge e : mcfg.incomingEdgesOf(mExit)) {
            if (e._src == mEntry) continue;
            if (e._type == CFG_Edge_Type.EXCEPTION_EDGE) {
                BasicBlock rescuerOfSplitBB = this._bbRescuerMap.get(splitBB);
                ((CFG_Edge)this._cfg.addEdge((Object)ii.getRenamedBB((BasicBlock)e._src), (Object)(rescuerOfSplitBB != null ? rescuerOfSplitBB : this._exitBB)))._type = CFG_Edge_Type.EXCEPTION_EDGE;
                continue;
            }
            ((CFG_Edge)this._cfg.addEdge((Object)ii.getRenamedBB((BasicBlock)e._src), (Object)splitBB))._type = e._type;
        }
        for (RescuedRegion r : mcfg._outermostRRs) {
            this._outermostRRs.add(r.cloneForInlining(ii));
        }
        BasicBlock callBBrescuer = this._bbRescuerMap.get(callBB);
        if (callBBrescuer != null) {
            this._bbRescuerMap.put(splitBB, callBBrescuer);
        }
        Map<BasicBlock, BasicBlock> mRescuerMap = mcfg._bbRescuerMap;
        for (BasicBlock x : mcfg.getNodes()) {
            if (x == mEntry || x == mExit) continue;
            BasicBlock xRenamed = ii.getRenamedBB(x);
            BasicBlock xProtector = mRescuerMap.get(x);
            if (xProtector != null) {
                this._bbRescuerMap.put(xRenamed, ii.getRenamedBB(xProtector));
                continue;
            }
            if (callBBrescuer == null) continue;
            this._bbRescuerMap.put(xRenamed, callBBrescuer);
        }
        this.mergeStraightlineBBs(callBB, splitBB);
        Operand closureArg = call2.getClosureArg();
        List yieldSites = ii.getYieldSites();
        if (closureArg != null && !yieldSites.isEmpty()) {
            if (yieldSites.size() > 1) {
                throw new RuntimeException("Encountered " + yieldSites.size() + " yield sites.  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            if (!(closureArg instanceof MetaObject)) {
                throw new RuntimeException("Encountered a dynamic closure arg.  Cannot inline it here!  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            Tuple t = (Tuple)yieldSites.get(0);
            this.inlineClosureAtYieldSite(ii, (IRClosure)((MetaObject)closureArg).scope, (BasicBlock)t.a, (YieldInstr)t.b);
        }
        this.setupFallThruMap();
    }

    private void buildPostOrderTraversal() {
        this._postOrderList = new LinkedList();
        BasicBlock root = this.getEntryBB();
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        stack.push(root);
        BitSet bbSet = new BitSet(1 + this.getMaxNodeID());
        bbSet.set(root.getID());
        while (!stack.empty()) {
            BasicBlock b = (BasicBlock)stack.peek();
            boolean allChildrenDone = true;
            for (CFG_Edge e : this._cfg.outgoingEdgesOf((Object)b)) {
                BasicBlock dst = e._dst;
                int dstID = dst.getID();
                if (bbSet.get(dstID)) continue;
                allChildrenDone = false;
                stack.push(dst);
                bbSet.set(dstID);
            }
            if (!allChildrenDone) continue;
            stack.pop();
            this._postOrderList.add(b);
        }
    }

    public ListIterator<BasicBlock> getPostOrderTraverser() {
        if (this._postOrderList == null) {
            this.buildPostOrderTraversal();
        }
        return this._postOrderList.listIterator();
    }

    public ListIterator<BasicBlock> getReversePostOrderTraverser() {
        if (this._postOrderList == null) {
            this.buildPostOrderTraversal();
        }
        return this._postOrderList.listIterator(this.numNodes());
    }

    private Integer intersectDomSets(Integer[] idomMap, Integer nb1, Integer nb2) {
        while (nb1 != nb2) {
            while (nb1 < nb2) {
                nb1 = idomMap[nb1];
            }
            while (nb2 < nb1) {
                nb2 = idomMap[nb2];
            }
        }
        return nb1;
    }

    public void buildDominatorTree() {
        Integer rootPoNumber;
        int maxNodeId = this.getMaxNodeID();
        Integer[] bbToPoNumbers = new Integer[maxNodeId + 1];
        BasicBlock[] poNumbersToBB = new BasicBlock[maxNodeId + 1];
        ListIterator<BasicBlock> it = this.getPostOrderTraverser();
        int n = 0;
        while (it.hasNext()) {
            BasicBlock b = it.next();
            bbToPoNumbers[b.getID()] = n;
            poNumbersToBB[n] = b;
            ++n;
        }
        Integer[] idoms = new Integer[maxNodeId + 1];
        BasicBlock root = this.getEntryBB();
        idoms[rootPoNumber.intValue()] = rootPoNumber = bbToPoNumbers[root.getID()];
        boolean changed = true;
        while (changed) {
            changed = false;
            it = this.getReversePostOrderTraverser();
            while (it.hasPrevious()) {
                BasicBlock b = it.previous();
                if (b == root) continue;
                Integer bPoNumber = bbToPoNumbers[b.getID()];
                Integer oldBIdom = idoms[bPoNumber];
                Integer newBIdom = null;
                for (CFG_Edge e : this._cfg.incomingEdgesOf((Object)b)) {
                    BasicBlock src = e._src;
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    if (idoms[srcPoNumber] == null) continue;
                    newBIdom = srcPoNumber;
                    break;
                }
                assert (newBIdom != null);
                Integer processedPred = newBIdom;
                for (CFG_Edge e : this._cfg.incomingEdgesOf((Object)b)) {
                    BasicBlock src = e._src;
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    Integer srcIdom = idoms[srcPoNumber];
                    if (srcIdom == null || srcPoNumber == processedPred) continue;
                    newBIdom = this.intersectDomSets(idoms, srcPoNumber, newBIdom);
                }
                if (oldBIdom == newBIdom) continue;
                changed = true;
                idoms[bPoNumber.intValue()] = newBIdom;
            }
        }
        HashMap<BasicBlock, BasicBlock> idomMap = new HashMap<BasicBlock, BasicBlock>();
        Integer i2 = 0;
        while (i2 < maxNodeId) {
            idomMap.put(poNumbersToBB[i2], poNumbersToBB[idoms[i2]]);
            Integer n2 = i2;
            Integer n3 = i2 = Integer.valueOf(i2 + 1);
        }
    }

    public String toStringInstrs() {
        StringBuffer buf = new StringBuffer();
        for (BasicBlock b : this.getNodes()) {
            buf.append(b.toStringInstrs());
        }
        buf.append("\n\n------ Exception handling map ------\n");
        for (BasicBlock bb : this._bbRescuerMap.keySet()) {
            buf.append("BB " + bb.getID() + " --> BB " + this._bbRescuerMap.get(bb).getID() + "\n");
        }
        List<IRClosure> closures = this._scope.getClosures();
        if (!closures.isEmpty()) {
            buf.append("\n\n------ Closures encountered in this scope ------\n");
            for (IRClosure c : closures) {
                buf.append(c.toStringBody());
            }
            buf.append("------------------------------------------------\n");
        }
        return buf.toString();
    }

    public void setDataFlowSolution(String name2, DataFlowProblem p2) {
        this._dfProbs.put(name2, p2);
    }

    public DataFlowProblem getDataFlowSolution(String name2) {
        return this._dfProbs.get(name2);
    }

    private void pushBBOnStack(Stack<BasicBlock> stack, BitSet bbSet, BasicBlock bb) {
        if (!bbSet.get(bb.getID())) {
            stack.push(bb);
            bbSet.set(bb.getID());
        }
    }

    public void deleteOrphanedBlocks() {
        while (true) {
            BasicBlock bbToRemove = null;
            for (BasicBlock b : this.getNodes()) {
                if (b == this._entryBB || this.incomingEdgesOf(b).size() != 0) continue;
                bbToRemove = b;
                break;
            }
            if (bbToRemove == null) break;
            this.removeBB(bbToRemove);
        }
    }

    public void splitCalls() {
    }

    public List<BasicBlock> linearize() {
        if (this._linearizedBBList != null) {
            return this._linearizedBBList;
        }
        this._linearizedBBList = new ArrayList<BasicBlock>();
        BasicBlock root = this.getEntryBB();
        BitSet bbSet = new BitSet(1 + this.getMaxNodeID());
        bbSet.set(root.getID());
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        for (CFG_Edge e : this._cfg.edgeSet()) {
            if (e._type != CFG_Edge_Type.EXCEPTION_EDGE) continue;
            this.pushBBOnStack(stack, bbSet, e._dst);
        }
        stack.push(root);
        while (!stack.empty()) {
            BasicBlock b = (BasicBlock)stack.pop();
            this._linearizedBBList.add(b);
            if (b == this._exitBB) {
                assert (stack.empty());
                continue;
            }
            assert (!stack.empty());
            Instr lastInstr = b.getLastInstr();
            if (lastInstr == null) {
                BasicBlock b1 = null;
                BasicBlock b2 = null;
                for (CFG_Edge e : this._cfg.outgoingEdgesOf((Object)b)) {
                    if (b1 == null) {
                        b1 = e._dst;
                        continue;
                    }
                    if (b2 == null) {
                        b2 = e._dst;
                        continue;
                    }
                    throw new RuntimeException("Encountered bb: " + b.getID() + " with no instrs. and more than 2 targets!!");
                }
                assert (b1 != null);
                if (b2 == null) {
                    this.pushBBOnStack(stack, bbSet, b1);
                    continue;
                }
                if (b1.getID() < b2.getID()) {
                    this.pushBBOnStack(stack, bbSet, b2);
                    this.pushBBOnStack(stack, bbSet, b1);
                    continue;
                }
                this.pushBBOnStack(stack, bbSet, b1);
                this.pushBBOnStack(stack, bbSet, b2);
                continue;
            }
            BasicBlock blockToIgnore = null;
            if (lastInstr instanceof JumpInstr) {
                blockToIgnore = this._bbMap.get(((JumpInstr)lastInstr).target);
                boolean allJumps = true;
                for (CFG_Edge e : this._cfg.incomingEdgesOf((Object)blockToIgnore)) {
                    if (e._src.getLastInstr() instanceof JumpInstr) continue;
                    allJumps = false;
                }
                if (allJumps) {
                    blockToIgnore = null;
                }
            } else if (lastInstr instanceof BranchInstr) {
                BasicBlock takenBlock = this._bbMap.get(((BranchInstr)lastInstr).getJumpTarget());
                this.pushBBOnStack(stack, bbSet, takenBlock);
                blockToIgnore = takenBlock;
            }
            for (CFG_Edge e : this._cfg.outgoingEdgesOf((Object)b)) {
                BasicBlock x = e._dst;
                if (x == blockToIgnore) continue;
                this.pushBBOnStack(stack, bbSet, x);
            }
        }
        for (BasicBlock b : this.getNodes()) {
            if (bbSet.get(b.getID())) continue;
            throw new RuntimeException("Bad CFG linearization: BB " + b.getID() + " has been missed!");
        }
        int n = this._linearizedBBList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            BasicBlock curr = this._linearizedBBList.get(i2);
            Instr li = curr.getLastInstr();
            if (i2 + 1 < n) {
                BasicBlock next2 = this._linearizedBBList.get(i2 + 1);
                if (li instanceof JumpInstr) {
                    if (next2 == this._bbMap.get(((JumpInstr)li).target)) {
                        System.out.println("BB " + curr.getID() + " falls through in layout to BB " + next2.getID() + ".  Removing jump from former bb!");
                        curr.removeInstr(li);
                    }
                } else {
                    BasicBlock tgt;
                    Set succs = this._cfg.outgoingEdgesOf((Object)curr);
                    if (!(succs.size() != 1 || (tgt = ((CFG_Edge)succs.iterator().next())._dst) == next2 || li != null && li.operation.xfersControl())) {
                        System.out.println("BB " + curr.getID() + " doesn't fall through to " + next2.getID() + ".  Adding a jump to " + tgt._label);
                        curr.addInstr(new JumpInstr(tgt._label));
                    }
                }
                if (curr != this._exitBB) continue;
                System.out.println("Exit bb is not the last bb in the layout!  Adding a dummy return!");
                curr.addInstr(new ReturnInstr(Nil.NIL));
                continue;
            }
            if (curr == this._exitBB) continue;
            Set succs = this._cfg.outgoingEdgesOf((Object)curr);
            assert (succs.size() == 1);
            BasicBlock tgt = ((CFG_Edge)succs.iterator().next())._dst;
            if (li != null && li.operation.xfersControl()) continue;
            System.out.println("BB " + curr.getID() + " is the last bb in the layout! Adding a jump to " + tgt._label);
            curr.addInstr(new JumpInstr(tgt._label));
        }
        return this._linearizedBBList;
    }

    public String toString() {
        return "CFG[" + this._scope.getScopeName() + ":" + this._scope.getName() + "]";
    }

    public void setUpUseDefLocalVarMaps() {
        this._definedLocalVars = new HashSet<Variable>();
        this._usedLocalVars = new HashSet<Variable>();
        for (BasicBlock bb : this.getNodes()) {
            for (Instr i2 : bb.getInstrs()) {
                for (Variable v : i2.getUsedVariables()) {
                    if (!(v instanceof LocalVariable)) continue;
                    this._usedLocalVars.add(v);
                }
                Variable v = i2.getResult();
                if (v == null || !(v instanceof LocalVariable)) continue;
                this._definedLocalVars.add(v);
            }
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            cl.getCFG().setUpUseDefLocalVarMaps();
        }
    }

    public Set<Variable> usedLocalVarsFromClosures() {
        HashSet<Variable> vs = new HashSet<Variable>();
        for (IRClosure cl : this.getScope().getClosures()) {
            CFG c = cl.getCFG();
            vs.addAll(c._usedLocalVars);
            vs.addAll(c.usedLocalVarsFromClosures());
        }
        return vs;
    }

    public Set<Variable> definedLocalVarsFromClosures() {
        HashSet<Variable> vs = new HashSet<Variable>();
        for (IRClosure cl : this.getScope().getClosures()) {
            CFG c = cl.getCFG();
            vs.addAll(c._definedLocalVars);
            vs.addAll(c.definedLocalVarsFromClosures());
        }
        return vs;
    }

    public boolean usesLocalVariable(Variable v) {
        if (this._usedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            if (!cl.getCFG().usesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean definesLocalVariable(Variable v) {
        if (this._definedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getScope().getClosures()) {
            if (!cl.getCFG().definesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public static class CFG_Edge {
        public final BasicBlock _src;
        public final BasicBlock _dst;
        public CFG_Edge_Type _type;

        public CFG_Edge(BasicBlock s2, BasicBlock d) {
            this._src = s2;
            this._dst = d;
            this._type = CFG_Edge_Type.REGULAR;
        }

        public String toString() {
            return "<" + this._src.getID() + " --> " + this._dst.getID() + "> (" + (Object)((Object)this._type) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CFG_Edge_Type {
        REGULAR,
        DUMMY_EDGE,
        JUMP_EDGE,
        FALLTHRU_EDGE,
        FORWARD_EDGE,
        BACK_EDGE,
        EXIT_EDGE,
        EXCEPTION_EDGE;

    }
}

