/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.StampedVariableAccessor;
import org.jruby.runtime.ivars.SynchronizedVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.runtime.ivars.VariableAccessorVar0;
import org.jruby.runtime.ivars.VariableAccessorVar1;
import org.jruby.runtime.ivars.VariableAccessorVar2;
import org.jruby.runtime.ivars.VariableAccessorVar3;
import org.jruby.runtime.ivars.VariableAccessorVar4;
import org.jruby.runtime.ivars.VariableAccessorVar5;
import org.jruby.runtime.ivars.VariableAccessorVar6;
import org.jruby.runtime.ivars.VariableAccessorVar7;
import org.jruby.runtime.ivars.VariableAccessorVar8;
import org.jruby.runtime.ivars.VariableAccessorVar9;
import org.jruby.util.unsafe.UnsafeHolder;

public class VariableTableManager {
    private final RubyClass realClass;
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private Map<String, VariableAccessor> variableAccessors = Collections.EMPTY_MAP;
    private volatile String[] variableNames = EMPTY_STRING_ARRAY;
    private volatile boolean hasObjectID = false;
    private volatile int fieldVariables = 0;
    private final VariableAccessorField objectIdVariableAccessorField = new VariableAccessorField("object_id");
    private final VariableAccessorField cextHandleVariableAccessorField = new VariableAccessorField("cext");
    private final VariableAccessorField ffiHandleVariableAccessorField = new VariableAccessorField("ffi");
    private final VariableAccessorField objectGroupVariableAccessorField = new VariableAccessorField("objectspace_group");

    public VariableTableManager(RubyClass realClass) {
        this.realClass = realClass;
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableAccessors;
    }

    public boolean hasObjectID() {
        return this.hasObjectID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectId(RubyBasicObject self2) {
        VariableAccessor objectIdAccessor = this.getObjectIdAccessorField().getVariableAccessorForRead();
        Long id2 = (Long)objectIdAccessor.get(self2);
        if (id2 != null) {
            return id2;
        }
        RubyBasicObject rubyBasicObject = self2;
        synchronized (rubyBasicObject) {
            objectIdAccessor = this.getObjectIdAccessorField().getVariableAccessorForRead();
            id2 = (Long)objectIdAccessor.get(self2);
            if (id2 != null) {
                return id2;
            }
            return this.initObjectId(self2, this.getObjectIdAccessorField().getVariableAccessorForWrite(this));
        }
    }

    public void setVariableInternal(RubyBasicObject self2, int index2, Object value2) {
        if (UnsafeHolder.U == null) {
            SynchronizedVariableAccessor.setVariable(self2, this.realClass, index2, value2);
        } else {
            StampedVariableAccessor.setVariable(self2, this.realClass, index2, value2);
        }
    }

    public static void setVariableInternal(RubyClass realClass, RubyBasicObject self2, int index2, Object value2) {
        if (UnsafeHolder.U == null) {
            SynchronizedVariableAccessor.setVariable(self2, realClass, index2, value2);
        } else {
            StampedVariableAccessor.setVariable(self2, realClass, index2, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableAccessor getVariableAccessorForWrite(String name2) {
        VariableAccessor ivarAccessor = this.variableAccessors.get(name2);
        if (ivarAccessor == null) {
            RubyClass rubyClass = this.realClass;
            synchronized (rubyClass) {
                Map<String, VariableAccessor> myVariableAccessors = this.variableAccessors;
                ivarAccessor = myVariableAccessors.get(name2);
                if (ivarAccessor == null) {
                    ivarAccessor = this.allocateVariableAccessor(name2);
                    HashMap<String, VariableAccessor> newVariableAccessors = new HashMap<String, VariableAccessor>(myVariableAccessors.size() + 1);
                    newVariableAccessors.putAll(myVariableAccessors);
                    newVariableAccessors.put(name2, ivarAccessor);
                    this.variableAccessors = newVariableAccessors;
                }
            }
        }
        return ivarAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableAccessor getVariableAccessorForVar(String name2, int index2) {
        VariableAccessor ivarAccessor = this.variableAccessors.get(name2);
        if (ivarAccessor == null) {
            RubyClass rubyClass = this.realClass;
            synchronized (rubyClass) {
                Map<String, VariableAccessor> myVariableAccessors = this.variableAccessors;
                ivarAccessor = myVariableAccessors.get(name2);
                if (ivarAccessor == null) {
                    ivarAccessor = this.allocateVariableAccessorForVar(name2, index2);
                    HashMap<String, VariableAccessor> newVariableAccessors = new HashMap<String, VariableAccessor>(myVariableAccessors.size() + 1);
                    newVariableAccessors.putAll(myVariableAccessors);
                    newVariableAccessors.put(name2, ivarAccessor);
                    this.variableAccessors = newVariableAccessors;
                }
            }
        }
        return ivarAccessor;
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessorField getObjectIdAccessorField() {
        return this.objectIdVariableAccessorField;
    }

    public VariableAccessorField getNativeHandleAccessorField() {
        return this.cextHandleVariableAccessorField;
    }

    public VariableAccessor getNativeHandleAccessorForRead() {
        return this.cextHandleVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getNativeHandleAccessorForWrite() {
        return this.cextHandleVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessorField getFFIHandleAccessorField() {
        return this.ffiHandleVariableAccessorField;
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.ffiHandleVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        return this.ffiHandleVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessorField getObjectGroupAccessorField() {
        return this.objectGroupVariableAccessorField;
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.objectGroupVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        return this.objectGroupVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public final Object getNativeHandle(RubyBasicObject self2) {
        return this.getNativeHandleAccessorForRead().get(self2);
    }

    public final void setNativeHandle(RubyBasicObject self2, Object value2) {
        int index2 = this.getNativeHandleAccessorForRead().getIndex();
        VariableTableManager.setVariableInternal(this.realClass, self2, index2, value2);
    }

    public final Object getFFIHandle(RubyBasicObject self2) {
        return this.getFFIHandleAccessorForRead().get(self2);
    }

    public final void setFFIHandle(RubyBasicObject self2, Object value2) {
        int index2 = this.getFFIHandleAccessorForWrite().getIndex();
        VariableTableManager.setVariableInternal(this.realClass, self2, index2, value2);
    }

    public int getVariableTableSize() {
        return this.variableAccessors.size();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableNames.length;
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    public String[] getVariableNames() {
        String[] original = this.variableNames;
        String[] copy = new String[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncVariables(RubyBasicObject self2, IRubyObject other) {
        boolean sameTable;
        RubyClass otherRealClass = other.getMetaClass().getRealClass();
        boolean bl = sameTable = otherRealClass == this.realClass;
        if (sameTable && this.fieldVariables == 0) {
            int idIndex = otherRealClass.getObjectIdAccessorField().getVariableAccessorForRead().getIndex();
            Object[] otherVars = ((RubyBasicObject)other).varTable;
            if (UnsafeHolder.U == null) {
                RubyBasicObject rubyBasicObject = self2;
                synchronized (rubyBasicObject) {
                    self2.varTable = VariableTableManager.makeSyncedTable(self2.varTable, otherVars, idIndex);
                }
            } else {
                int oldStamp;
                while (((oldStamp = self2.varTableStamp) & 1) == 1 || !UnsafeHolder.U.compareAndSwapInt(self2, RubyBasicObject.STAMP_OFFSET, oldStamp++, oldStamp)) {
                }
                Object[] currentTable = (Object[])UnsafeHolder.U.getObjectVolatile(self2, RubyBasicObject.VAR_TABLE_OFFSET);
                Object[] newTable = VariableTableManager.makeSyncedTable(currentTable, otherVars, idIndex);
                UnsafeHolder.U.putOrderedObject(self2, RubyBasicObject.VAR_TABLE_OFFSET, newTable);
                self2.varTableStamp = oldStamp + 1;
            }
        } else {
            for (Map.Entry<String, VariableAccessor> entry : otherRealClass.getVariableAccessorsForRead().entrySet()) {
                VariableAccessor accessor = entry.getValue();
                Object value2 = accessor.get(other);
                if (value2 == null) continue;
                if (sameTable) {
                    accessor.set(self2, value2);
                    continue;
                }
                this.realClass.getVariableAccessorForWrite(accessor.getName()).set(self2, value2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasVariables(RubyBasicObject object) {
        if (this.fieldVariables > 0) return true;
        if (this.getVariableTableSize() <= 0) return false;
        Object[] myVarTable = object.varTable;
        if (object.varTable == null) return false;
        if (myVarTable.length <= 0) return false;
        return true;
    }

    public void serializeVariables(RubyBasicObject object, ObjectOutputStream oos) throws IOException {
        if (object.varTable != null) {
            Map<String, VariableAccessor> accessors = this.getVariableAccessorsForRead();
            oos.writeInt(accessors.size());
            for (VariableAccessor accessor : accessors.values()) {
                oos.writeUTF("Insecure: can't modify instance variable");
                oos.writeObject(accessor.get(object));
            }
        } else {
            oos.writeInt(0);
        }
    }

    public void deserializeVariables(RubyBasicObject object, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int varCount = ois.readInt();
        for (int i2 = 0; i2 < varCount; ++i2) {
            String name2 = ois.readUTF();
            Object value2 = ois.readObject();
            this.getVariableAccessorForWrite(name2).set(object, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clearVariable(RubyBasicObject object, String name2) {
        RubyBasicObject rubyBasicObject = object;
        synchronized (rubyBasicObject) {
            Object value2 = this.getVariableAccessorForRead(name2).get(object);
            this.getVariableAccessorForWrite(name2).set(object, null);
            return value2;
        }
    }

    protected synchronized long initObjectId(RubyBasicObject self2, VariableAccessor objectIdAccessor) {
        Ruby runtime = self2.getRuntime();
        long id2 = runtime.isObjectSpaceEnabled() ? runtime.getObjectSpace().createAndRegisterObjectId(self2) : ObjectSpace.calculateObjectId(self2);
        VariableTableManager.setObjectId(this.realClass, self2, objectIdAccessor.getIndex(), id2);
        return id2;
    }

    private static void setObjectId(RubyClass realClass, RubyBasicObject self2, int index2, long value2) {
        if (index2 < 0) {
            return;
        }
        VariableTableManager.setVariableInternal(realClass, self2, index2, value2);
    }

    private static Object[] makeSyncedTable(Object[] currentTable, Object[] otherTable, int objectIdIdx) {
        if (currentTable == null || currentTable.length < otherTable.length) {
            currentTable = (Object[])otherTable.clone();
        } else {
            System.arraycopy(otherTable, 0, currentTable, 0, otherTable.length);
        }
        if (objectIdIdx >= 0 && objectIdIdx < currentTable.length) {
            currentTable[objectIdIdx] = null;
        }
        return currentTable;
    }

    final synchronized VariableAccessor allocateVariableAccessor(String name2) {
        int id2 = this.realClass.id;
        String[] myVariableNames = this.variableNames;
        int newIndex = myVariableNames.length;
        String[] newVariableNames = new String[newIndex + 1];
        VariableAccessor newVariableAccessor = UnsafeHolder.U == null ? new SynchronizedVariableAccessor(this.realClass, name2, newIndex, id2) : new StampedVariableAccessor(this.realClass, name2, newIndex, id2);
        System.arraycopy(myVariableNames, 0, newVariableNames, 0, newIndex);
        newVariableNames[newIndex] = name2;
        this.variableNames = newVariableNames;
        return newVariableAccessor;
    }

    final synchronized VariableAccessor allocateVariableAccessorForVar(String name2, int index2) {
        FieldVariableAccessor newVariableAccessor;
        int id2 = this.realClass.id;
        String[] myVariableNames = this.variableNames;
        int newIndex = myVariableNames.length;
        String[] newVariableNames = new String[newIndex + 1];
        ++this.fieldVariables;
        switch (index2) {
            case 0: {
                newVariableAccessor = new VariableAccessorVar0(this.realClass, name2, newIndex, id2);
                break;
            }
            case 1: {
                newVariableAccessor = new VariableAccessorVar1(this.realClass, name2, newIndex, id2);
                break;
            }
            case 2: {
                newVariableAccessor = new VariableAccessorVar2(this.realClass, name2, newIndex, id2);
                break;
            }
            case 3: {
                newVariableAccessor = new VariableAccessorVar3(this.realClass, name2, newIndex, id2);
                break;
            }
            case 4: {
                newVariableAccessor = new VariableAccessorVar4(this.realClass, name2, newIndex, id2);
                break;
            }
            case 5: {
                newVariableAccessor = new VariableAccessorVar5(this.realClass, name2, newIndex, id2);
                break;
            }
            case 6: {
                newVariableAccessor = new VariableAccessorVar6(this.realClass, name2, newIndex, id2);
                break;
            }
            case 7: {
                newVariableAccessor = new VariableAccessorVar7(this.realClass, name2, newIndex, id2);
                break;
            }
            case 8: {
                newVariableAccessor = new VariableAccessorVar8(this.realClass, name2, newIndex, id2);
                break;
            }
            case 9: {
                newVariableAccessor = new VariableAccessorVar9(this.realClass, name2, newIndex, id2);
                break;
            }
            default: {
                throw new RuntimeException("unsupported var index in " + this.realClass + ": " + index2);
            }
        }
        System.arraycopy(myVariableNames, 0, newVariableNames, 0, newIndex);
        newVariableNames[newIndex] = name2;
        this.variableNames = newVariableNames;
        return newVariableAccessor;
    }
}

