/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class AndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public AndNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "AndNode.first == null";
        assert (secondNode != null) : "AndNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ANDNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitAndNode(this);
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject result2 = this.firstNode.interpret(runtime, context, self2, aBlock);
        if (!result2.isTrue()) {
            return result2;
        }
        return this.secondNode.interpret(runtime, context, self2, aBlock);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        if (!context.runtime.is1_9()) {
            return super.definition(runtime, context, self2, aBlock);
        }
        return runtime.getDefinedMessage(DefinedMessage.EXPRESSION);
    }
}

