/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineInstanceMethodInstr
extends Instr {
    private Operand container;
    private final IRMethod method;

    public DefineInstanceMethodInstr(Operand container, IRMethod method2) {
        super(Operation.DEF_INST_METH);
        this.container = container;
        this.method = method2;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.container + ", " + this.method.getName() + ", " + this.method.getFileName() + ")";
    }

    public IRMethod getMethod() {
        return this.method;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineInstanceMethodInstr(this.container.cloneForInlining(ii), this.method);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        RubyModule clazz = context.getRubyClass();
        String name2 = this.method.getName();
        Ruby runtime = context.runtime;
        if (clazz == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        if (clazz == runtime.getObject() && "initialize".equals(name2)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop");
        }
        if ("__id__".equals(name2) || "__send__".equals(name2)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name2 + "' may cause serious problem");
        }
        Visibility visibility = context.getCurrentVisibility();
        if ("initialize".equals(name2) || "initialize_copy".equals(name2) || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        InterpretedIRMethod newMethod = new InterpretedIRMethod(this.method, visibility, clazz);
        clazz.addMethod(name2, newMethod);
        if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            clazz.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)clazz.getSingletonClass(), newMethod, Visibility.PUBLIC));
            clazz.callMethod(context, "singleton_method_added", (IRubyObject)runtime.fastNewSymbol(name2));
        }
        if (clazz.isSingleton()) {
            ((MetaClass)clazz).getAttached().callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name2));
        } else {
            clazz.callMethod(context, "method_added", (IRubyObject)runtime.fastNewSymbol(name2));
        }
        return null;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.container};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.container = this.container.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineInstanceMethodInstr(this);
    }
}

