/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashMap;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.analyses.UnboxableOp;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisNode;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;

public class UnboxableOpsAnalysisProblem
extends DataFlowProblem<UnboxableOpsAnalysisProblem, UnboxableOpsAnalysisNode> {
    public static final String NAME = "UnboxableOpsAnalysis";

    public UnboxableOpsAnalysisProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    @Override
    public String getName() {
        return "Unboxable Operands Analysis";
    }

    @Override
    public UnboxableOpsAnalysisNode buildFlowGraphNode(BasicBlock bb) {
        return new UnboxableOpsAnalysisNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void unbox() {
        HashMap<Variable, TemporaryLocalVariable> unboxMap = new HashMap<Variable, TemporaryLocalVariable>();
        for (UnboxableOpsAnalysisNode n : this.generateWorkList()) {
            n.unbox(unboxMap);
        }
    }

    public boolean isUnboxableMethod(String name2) {
        return UnboxableOp.opsMap.get(name2) != null;
    }

    public boolean acceptsArgTypes(String name2, Class receiverType, Class argType) {
        UnboxableOp uop = UnboxableOp.opsMap.get(name2);
        return uop == null ? false : uop.acceptsArgTypes(receiverType, argType);
    }

    public Class getUnboxedType(String name2, Class receiverType, Class argType) {
        UnboxableOp uop = UnboxableOp.opsMap.get(name2);
        return uop == null ? null : uop.getUnboxedType(receiverType, argType);
    }

    public Class getUnboxedResultType(String name2, Class operandType) {
        UnboxableOp uop = UnboxableOp.opsMap.get(name2);
        return uop == null ? null : uop.getUnboxedResultType(operandType);
    }

    public Operation getUnboxedOp(String name2, Class operandType) {
        UnboxableOp uop = UnboxableOp.opsMap.get(name2);
        return uop == null ? null : uop.getUnboxedOp(operandType);
    }
}

