/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Opcodes;

public class CodeSizeEvaluator
extends MethodVisitor
implements Opcodes {
    private int minSize;
    private int maxSize;

    public CodeSizeEvaluator(MethodVisitor methodVisitor) {
        this(393216, methodVisitor);
    }

    protected CodeSizeEvaluator(int api, MethodVisitor methodVisitor) {
        super(api, methodVisitor);
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void visitInsn(int opcode) {
        ++this.minSize;
        ++this.maxSize;
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 17) {
            this.minSize += 3;
            this.maxSize += 3;
        } else {
            this.minSize += 2;
            this.maxSize += 2;
        }
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        if (var < 4 && opcode != 169) {
            ++this.minSize;
            ++this.maxSize;
        } else if (var >= 256) {
            this.minSize += 4;
            this.maxSize += 4;
        } else {
            this.minSize += 2;
            this.maxSize += 2;
        }
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type2) {
        this.minSize += 3;
        this.maxSize += 3;
        super.visitTypeInsn(opcode, type2);
    }

    public void visitFieldInsn(int opcode, String owner2, String name2, String descriptor) {
        this.minSize += 3;
        this.maxSize += 3;
        super.visitFieldInsn(opcode, owner2, name2, descriptor);
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner2, String name2, String descriptor) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner2, name2, descriptor);
            return;
        }
        this.doVisitMethodInsn(opcode, owner2, name2, descriptor, opcode == 185);
    }

    public void visitMethodInsn(int opcode, String owner2, String name2, String descriptor, boolean isInterface) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
            return;
        }
        this.doVisitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
    }

    private void doVisitMethodInsn(int opcode, String owner2, String name2, String descriptor, boolean isInterface) {
        if (opcode == 185) {
            this.minSize += 5;
            this.maxSize += 5;
        } else {
            this.minSize += 3;
            this.maxSize += 3;
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
        }
    }

    public void visitInvokeDynamicInsn(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.minSize += 5;
        this.maxSize += 5;
        super.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    public void visitJumpInsn(int opcode, Label label2) {
        this.minSize += 3;
        this.maxSize = opcode == 167 || opcode == 168 ? (this.maxSize += 5) : (this.maxSize += 8);
        super.visitJumpInsn(opcode, label2);
    }

    public void visitLdcInsn(Object value2) {
        if (value2 instanceof Long || value2 instanceof Double) {
            this.minSize += 3;
            this.maxSize += 3;
        } else {
            this.minSize += 2;
            this.maxSize += 3;
        }
        super.visitLdcInsn(value2);
    }

    public void visitIincInsn(int var, int increment) {
        if (var > 255 || increment > 127 || increment < -128) {
            this.minSize += 6;
            this.maxSize += 6;
        } else {
            this.minSize += 3;
            this.maxSize += 3;
        }
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        this.minSize += 13 + labels.length * 4;
        this.maxSize += 16 + labels.length * 4;
        super.visitTableSwitchInsn(min2, max2, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        this.minSize += 9 + keys2.length * 8;
        this.maxSize += 12 + keys2.length * 8;
        super.visitLookupSwitchInsn(dflt, keys2, labels);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.minSize += 4;
        this.maxSize += 4;
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
    }
}

