/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import java.util.List;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.commons.AnnotationRemapper;
import org.jruby.org.objectweb.asm.commons.FieldRemapper;
import org.jruby.org.objectweb.asm.commons.MethodRemapper;
import org.jruby.org.objectweb.asm.commons.ModuleHashesAttribute;
import org.jruby.org.objectweb.asm.commons.ModuleRemapper;
import org.jruby.org.objectweb.asm.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        this(393216, classVisitor, remapper);
    }

    protected ClassRemapper(int api, ClassVisitor classVisitor, Remapper remapper) {
        super(api, classVisitor);
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.className = name2;
        super.visit(version, access, this.remapper.mapType(name2), this.remapper.mapSignature(signature, false), this.remapper.mapType(superName), interfaces2 == null ? null : this.remapper.mapTypes(interfaces2));
    }

    public ModuleVisitor visitModule(String name2, int flags2, String version) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name2), flags2, version);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List<String> modules = moduleHashesAttribute.modules;
            for (int i2 = 0; i2 < modules.size(); ++i2) {
                modules.set(i2, this.remapper.mapModuleName(modules.get(i2)));
            }
        }
        super.visitAttribute(attribute);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        FieldVisitor fieldVisitor = super.visitField(access, this.remapper.mapFieldName(this.className, name2, descriptor), this.remapper.mapDesc(descriptor), this.remapper.mapSignature(signature, true), this.remapper.mapValue(value2));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(descriptor);
        MethodVisitor methodVisitor = super.visitMethod(access, this.remapper.mapMethodName(this.className, name2, descriptor), remappedDescriptor, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name2), outerName == null ? null : this.remapper.mapType(outerName), innerName, access);
    }

    public void visitOuterClass(String owner2, String name2, String descriptor) {
        super.visitOuterClass(this.remapper.mapType(owner2), name2 == null ? null : this.remapper.mapMethodName(owner2, name2, descriptor), descriptor == null ? null : this.remapper.mapMethodDesc(descriptor));
    }

    public void visitNestHostExperimental(String nestHost) {
        super.visitNestHostExperimental(this.remapper.mapType(nestHost));
    }

    public void visitNestMemberExperimental(String nestMember) {
        super.visitNestMemberExperimental(this.remapper.mapType(nestMember));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }
}

