/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ArrayDerefInvokeSite;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.IRBytecodeAdapter6;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.NormalInvokeSite;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.VariableSite;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.Label;

public class IRBytecodeAdapter7
extends IRBytecodeAdapter6 {
    public IRBytecodeAdapter7(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void invokeOther(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        if (call2.isPotentiallyRefined()) {
            super.invokeOther(file2, line, scopeFieldName, call2, arity2);
            return;
        }
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        if (blockPassType.given()) {
            if (arity2 == -1) {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            } else {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), NormalInvokeSite.BOOTSTRAP, false, file2, line);
        } else {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), NormalInvokeSite.BOOTSTRAP, false, file2, line);
        }
    }

    @Override
    public void invokeArrayDeref(String file2, int line, String scopeFieldName, CallBase call2) {
        this.adapter.invokedynamic("aref", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, 1)), ArrayDerefInvokeSite.BOOTSTRAP, file2, line);
    }

    @Override
    public void invokeOtherOneFixnum(String file2, int line, CallBase call2, long fixnum) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id2)) {
            this.pushFixnum(fixnum);
            this.invokeOtherOrSelfArity1(file2, line, call2);
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(id2), signature, Bootstrap.getFixnumOperatorHandle(), fixnum, call2.getCallType().ordinal(), file2, line);
    }

    @Override
    public void invokeOtherOneFloat(String file2, int line, CallBase call2, double flote) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id2)) {
            this.pushFloat(flote);
            this.invokeOtherOrSelfArity1(file2, line, call2);
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(id2), signature, Bootstrap.getFloatOperatorHandle(), flote, call2.getCallType().ordinal(), file2, line);
    }

    private void invokeOtherOrSelfArity1(String file2, int line, CallBase call2) {
        if (call2.getCallType() == CallType.NORMAL) {
            this.invokeOther(file2, line, null, call2, 1);
        } else {
            this.invokeSelf(file2, line, null, call2, 1);
        }
    }

    @Override
    public void invokeSelf(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        if (call2.isPotentiallyRefined()) {
            super.invokeSelf(file2, line, scopeFieldName, call2, arity2);
            return;
        }
        String action = call2.getCallType() == CallType.FUNCTIONAL ? "callFunctional" : "callVariable";
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        if (blockPassType != IRBytecodeAdapter.BlockPassType.NONE) {
            if (arity2 == -1) {
                this.adapter.invokedynamic(action + ':' + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            } else {
                this.adapter.invokedynamic(action + ':' + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic(action + ':' + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), SelfInvokeSite.BOOTSTRAP, false, file2, line);
        } else {
            this.adapter.invokedynamic(action + ':' + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), SelfInvokeSite.BOOTSTRAP, false, file2, line);
        }
    }

    @Override
    public void invokeInstanceSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeClassSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeUnresolvedSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeZSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeZSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeZSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void putField(String name2) {
        this.adapter.invokedynamic("ivarSet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class), VariableSite.IVAR_ASM_HANDLE, new Object[0]);
    }

    @Override
    public void getField(String name2) {
        this.adapter.invokedynamic("ivarGet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, IRubyObject.class), VariableSite.IVAR_ASM_HANDLE, new Object[0]);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            super.array(length2);
            return;
        }
        this.adapter.invokedynamic("array", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2)), Bootstrap.array(), new Object[0]);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("hash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2)), Bootstrap.hash(), new Object[0]);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("kwargsHash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, JVM.OBJECT, length2 * 2)), Bootstrap.kwargsHash(), new Object[0]);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokedynamic("checkpoint", CodegenUtils.sig(Void.TYPE, ThreadContext.class), Bootstrap.checkpointHandle(), new Object[0]);
    }

    @Override
    public void branchIfNil(Label label2) {
        this.adapter.invokedynamic("isNil", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isNilBoot(), new Object[0]);
        this.adapter.iftrue(label2);
    }

    @Override
    public void branchIfTruthy(Label label2) {
        this.adapter.invokedynamic("isTrue", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isTrueBoot(), new Object[0]);
        this.adapter.iftrue(label2);
    }
}

