/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jruby.RubySymbol;
import org.jruby.ast.IterNode;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.ClosureInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.objectweb.asm.Handle;

public class IRClosure
extends IRScope {
    public final int closureId;
    private boolean isEND;
    private Signature signature;
    private IterNode source;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private IRBlockBody body;
    private Handle handle;
    private static final ByteList CLOSURE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95});
    private static final ByteList CLOSURE_CLONE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95, 67, 76, 79, 78, 69, 95}, false);

    protected IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, ByteList prefix) {
        super(manager, lexicalParent, null, lineNumber, staticScope);
        this.closureId = lexicalParent.getNextClosureId();
        ByteList name2 = prefix.dup();
        name2.append(Integer.toString(this.closureId).getBytes());
        this.setByteName(name2);
        this.body = null;
    }

    protected IRClosure(IRClosure c, IRScope lexicalParent, int closureId, ByteList fullName) {
        super(c, lexicalParent);
        boolean shouldJit;
        this.closureId = closureId;
        super.setByteName(fullName);
        this.body = this.getManager().isDryRun() ? null : ((shouldJit = this.getManager().getInstanceConfig().getCompileMode().shouldJIT()) ? new MixedModeIRBlockBody(c, c.getSignature()) : new InterpretedIRBlockBody(c, c.getSignature()));
        this.isEND = c.isEND;
        this.signature = c.signature;
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, boolean needsCoverage) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false, needsCoverage);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, isBeginEndBlock, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock, boolean needsCoverage) {
        this(manager, lexicalParent, lineNumber, staticScope, prefix);
        this.signature = signature;
        lexicalParent.addClosure(this);
        if (this.getManager().isDryRun()) {
            this.body = null;
        } else {
            boolean shouldJit = manager.getInstanceConfig().getCompileMode().shouldJIT();
            IRBlockBody iRBlockBody = this.body = shouldJit ? new MixedModeIRBlockBody(this, signature) : new InterpretedIRBlockBody(this, signature);
            if (staticScope != null && !isBeginEndBlock) {
                staticScope.setIRScope(this);
                staticScope.setScopeType(this.getScopeType());
            }
        }
        if (needsCoverage) {
            this.getFlags().add(IRFlags.CODE_COVERAGE);
        }
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new ClosureInterpreterContext(this, instructions);
        return this.interpreterContext;
    }

    @Override
    public InterpreterContext allocateInterpreterContext(Supplier<List<Instr>> instructions) {
        try {
            this.interpreterContext = new ClosureInterpreterContext(this, instructions);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        return this.interpreterContext;
    }

    public void setIsEND() {
        this.isEND = true;
    }

    public boolean isEND() {
        return this.isEND;
    }

    @Override
    public int getNextClosureId() {
        return this.getLexicalParent().getNextClosureId();
    }

    @Override
    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.CLOSURE);
    }

    @Override
    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        if (type2 == TemporaryVariableType.CLOSURE) {
            ++this.temporaryVariableIndex;
            return new TemporaryClosureVariable(this.closureId, this.temporaryVariableIndex);
        }
        return super.getNewTemporaryVariable(type2);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel(this.getManager().getClosurePrefix(this.closureId));
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.CLOSURE;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    public String toStringBody() {
        return this.getId() + " = {\n" + this.toStringInstrs() + "\n}\n\n";
    }

    public BlockBody getBlockBody() {
        return this.body;
    }

    public boolean isNestedClosuresSafeForMethodConversion() {
        for (IRClosure closure : this.getClosures()) {
            if (closure.isNestedClosuresSafeForMethodConversion()) continue;
            return false;
        }
        return !this.getFlags().contains((Object)IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
    }

    public IRMethod convertToMethod(ByteList name2) {
        if (this.source == null || this.getFlags().contains((Object)IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES) || this.getFlags().contains((Object)IRFlags.RECEIVES_CLOSURE_ARG) || !this.isNestedClosuresSafeForMethodConversion()) {
            this.source = null;
            return null;
        }
        IterNode def = this.source;
        this.source = null;
        return new IRMethod(this.getManager(), this.getLexicalParent(), def, name2, true, this.getLine(), this.getStaticScope(), this.getFlags().contains((Object)IRFlags.CODE_COVERAGE));
    }

    public void setSource(IterNode iter) {
        this.source = iter;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.lookupExistingLVar(name2);
        if (lvar != null) {
            return lvar;
        }
        int newDepth = scopeDepth - 1;
        if (newDepth >= 0 && (lvar = this.getLexicalParent().findExistingLocalVariable(name2, newDepth)) != null) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        return lvar;
    }

    @Override
    public LocalVariable getNewLocalVariable(RubySymbol name2, int depth) {
        if (depth == 0 && !(this instanceof IRFor)) {
            ClosureLocalVariable lvar = new ClosureLocalVariable(name2, 0, this.getStaticScope().addVariableThisScope(name2.idString()));
            this.localVars.put(name2, lvar);
            return lvar;
        }
        if (!(this instanceof IRFor)) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        IRScope s2 = this;
        int d = depth;
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (d < 0) break;
        }
        return s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int depth) {
        LocalVariable lvar;
        IRScope s2 = this;
        int d = depth;
        if (depth > 0 && !(this instanceof IRFor)) {
            this.flags.add(IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES);
        }
        if (depth == 0) {
            return s2.getNewLocalVariable(name2, 0);
        }
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            lvar = s2.lookupExistingLVar(name2);
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (lvar != null || d < 0) break;
        }
        if (lvar == null) {
            lvar = s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
        } else {
            int lvarDepth = depth - (d + 1);
            if (lvar.getScopeDepth() != lvarDepth) {
                lvar = lvar.cloneForDepth(lvarDepth);
            }
        }
        return lvar;
    }

    protected IRClosure cloneForInlining(CloneInfo ii, IRClosure clone2) {
        SimpleCloneInfo clonedII = ii.cloneForCloningClosure(clone2);
        ArrayList<Instr> newInstrs = new ArrayList<Instr>(this.interpreterContext.getInstructions().length);
        for (Instr i2 : this.interpreterContext.getInstructions()) {
            newInstrs.add(i2.clone(clonedII));
        }
        clone2.allocateInterpreterContext(newInstrs);
        return clone2;
    }

    public IRClosure cloneForInlining(CloneInfo ii) {
        IRClosure clonedClosure;
        IRScope lexicalParent = ii.getScope();
        if (ii instanceof SimpleCloneInfo && !((SimpleCloneInfo)ii).isEnsureBlockCloneMode()) {
            clonedClosure = new IRClosure(this, lexicalParent, this.closureId, this.getByteName());
        } else {
            int id2 = lexicalParent.getNextClosureId();
            ByteList fullName = lexicalParent.getByteName();
            fullName = fullName != null ? fullName.dup() : new ByteList();
            fullName.append(CLOSURE_CLONE);
            fullName.append(Integer.toString(id2).getBytes());
            clonedClosure = new IRClosure(this, lexicalParent, id2, fullName);
        }
        lexicalParent.addClosure(clonedClosure);
        return this.cloneForInlining(ii, clonedClosure);
    }

    @Override
    public void setByteName(ByteList name2) {
        ByteList newName = this.getLexicalParent().getByteName();
        newName = newName == null ? new ByteList() : newName.dup();
        newName.append(name2);
        super.setByteName(newName);
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }

    @Override
    public void persistScopeHeader(IRWriterEncoder file2) {
        super.persistScopeHeader(file2);
        file2.encode(this.isEND());
        file2.encode(this.getSignature());
    }
}

