/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.net.BindException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Errno;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTimeZone;
import org.joni.WarnCallback;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.ParseResult;
import org.jruby.Profile;
import org.jruby.RubyArgumentError;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyConcurrencyError;
import org.jruby.RubyContinuation;
import org.jruby.RubyConverter;
import org.jruby.RubyDir;
import org.jruby.RubyDomainError;
import org.jruby.RubyEOFError;
import org.jruby.RubyEncoding;
import org.jruby.RubyEncodingError;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFatal;
import org.jruby.RubyFiberError;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyFloatDomainError;
import org.jruby.RubyFrozenError;
import org.jruby.RubyGC;
import org.jruby.RubyGenerator;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyIOError;
import org.jruby.RubyIndexError;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyInterrupt;
import org.jruby.RubyInterruptedRegexpError;
import org.jruby.RubyKernel;
import org.jruby.RubyKeyError;
import org.jruby.RubyLoadError;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMemoryError;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNotImplementedError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyRangeError;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyRegexpError;
import org.jruby.RubyRuntimeError;
import org.jruby.RubyScriptError;
import org.jruby.RubySecurityError;
import org.jruby.RubySignal;
import org.jruby.RubySignalException;
import org.jruby.RubyStandardError;
import org.jruby.RubyStopIteration;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySyntaxError;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubySystemStackError;
import org.jruby.RubyThread;
import org.jruby.RubyThreadError;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyTypeError;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUncaughtThrowError;
import org.jruby.RubyYielder;
import org.jruby.RubyZeroDivisionError;
import org.jruby.TopSelfFactory;
import org.jruby.anno.TypePopulator;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.ScriptAndCode;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.Constantizable;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.embed.Extension;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.JRubyPOSIXHandler;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.ext.fiber.ThreadFiberLibrary;
import org.jruby.ext.jruby.JRubyLibrary;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.ext.thread.ConditionVariable;
import org.jruby.ext.thread.Mutex;
import org.jruby.ext.thread.Queue;
import org.jruby.ext.thread.SizedQueue;
import org.jruby.ext.tracepoint.TracePoint;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.ir.Compiler;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderStream;
import org.jruby.ir.persistence.util.IRFileExpert;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaPackage;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaSupportImpl;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.management.BeanManager;
import org.jruby.management.BeanManagerFactory;
import org.jruby.management.Caches;
import org.jruby.management.Config;
import org.jruby.management.InlineStats;
import org.jruby.management.ParserStats;
import org.jruby.management.Runtime;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.profile.ProfilingService;
import org.jruby.runtime.profile.ProfilingServiceLookup;
import org.jruby.runtime.profile.builtin.ProfiledMethods;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.CommonByteLists;
import org.jruby.util.DefinedMessage;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.KCode;
import org.jruby.util.MRIRecursionGuard;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SecurityHelper;
import org.jruby.util.SelfFirstJRubyClassLoader;
import org.jruby.util.StringSupport;
import org.jruby.util.StrptimeParser;
import org.jruby.util.StrptimeToken;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.ConcurrentWeakHashMap;
import org.jruby.util.func.Function1;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.SelectorPool;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public final class Ruby
implements Constantizable {
    private static final Logger LOG = LoggerFactory.getLogger(Ruby.class);
    public static final int NIL_PREFILLED_ARRAY_SIZE = 128;
    private final IRubyObject[] nilPrefilledArray;
    private final Map<Integer, RubyClass> errnos = new HashMap<Integer, RubyClass>();
    RubyRandom.RandomType defaultRand;
    private RubyHash charsetMap;
    static final String ROOT_FRAME_NAME = "(root)";
    private static final EnumSet<RubyEvent> interest;
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook();
    private static final Pattern ADDR_NOT_AVAIL_PATTERN;
    private final ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();
    private final ThreadLocal<FStringEqual> DEDUP_WRAPPER_CACHE = ThreadLocal.withInitial(FStringEqual::new);
    @Deprecated
    private static final RecursiveFunctionEx<RecursiveFunction> LEGACY_RECURSE;
    private final ConcurrentHashMap<String, Invalidator> constantNameInvalidators = new ConcurrentHashMap(16, 0.75f, 1);
    private final Invalidator checkpointInvalidator;
    private ThreadService threadService;
    private final POSIX posix;
    private final ObjectSpace objectSpace = new ObjectSpace();
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private static final EventHook[] EMPTY_HOOKS;
    private volatile EventHook[] eventHooks = EMPTY_HOOKS;
    private boolean hasEventHooks;
    private boolean globalAbortOnExceptionEnabled = false;
    private IRubyObject reportOnException;
    private boolean doNotReverseLookupEnabled = false;
    private volatile boolean objectSpaceEnabled;
    private boolean siphashEnabled;
    @Deprecated
    private long globalState = 1L;
    private final IRubyObject topSelf;
    private final RubyNil nilObject;
    private final IRubyObject[] singleNilArray;
    private final RubyBoolean trueObject;
    private final RubyBoolean falseObject;
    final RubyFixnum[] fixnumCache = new RubyFixnum[2 * RubyFixnum.CACHE_OFFSET];
    final Object[] fixnumConstants = new Object[this.fixnumCache.length];
    @Deprecated
    private IRubyObject rootFiber;
    private boolean verbose;
    private boolean warningsEnabled;
    private boolean debug;
    private IRubyObject verboseValue;
    private RubyThreadGroup defaultThreadGroup;
    private final RubyClass basicObjectClass;
    private final RubyClass objectClass;
    private final RubyClass moduleClass;
    private final RubyClass classClass;
    private final RubyClass nilClass;
    private final RubyClass trueClass;
    private final RubyClass falseClass;
    private final RubyClass numericClass;
    private final RubyClass floatClass;
    private final RubyClass integerClass;
    private final RubyClass fixnumClass;
    private final RubyClass complexClass;
    private final RubyClass rationalClass;
    private final RubyClass enumeratorClass;
    private final RubyClass yielderClass;
    private final RubyClass fiberClass;
    private final RubyClass generatorClass;
    private final RubyClass arrayClass;
    private final RubyClass hashClass;
    private final RubyClass rangeClass;
    private final RubyClass stringClass;
    private final RubyClass encodingClass;
    private final RubyClass converterClass;
    private final RubyClass symbolClass;
    private final RubyClass procClass;
    private final RubyClass bindingClass;
    private final RubyClass methodClass;
    private final RubyClass unboundMethodClass;
    private final RubyClass matchDataClass;
    private final RubyClass regexpClass;
    private final RubyClass timeClass;
    private final RubyClass bignumClass;
    private final RubyClass dirClass;
    private final RubyClass fileClass;
    private final RubyClass fileStatClass;
    private final RubyClass ioClass;
    private final RubyClass threadClass;
    private final RubyClass threadGroupClass;
    private final RubyClass continuationClass;
    private final RubyClass structClass;
    private final RubyClass exceptionClass;
    private final RubyClass dummyClass;
    private final RubyClass randomClass;
    private final RubyClass dataClass;
    private RubyClass tmsStruct;
    private RubyClass passwdStruct;
    private RubyClass groupStruct;
    private RubyClass procStatusClass;
    private RubyClass runtimeError;
    private RubyClass frozenError;
    private RubyClass ioError;
    private RubyClass scriptError;
    private RubyClass nameError;
    private RubyClass nameErrorMessage;
    private RubyClass noMethodError;
    private RubyClass signalException;
    private RubyClass rangeError;
    private RubyClass systemExit;
    private RubyClass localJumpError;
    private RubyClass nativeException;
    private RubyClass systemCallError;
    private RubyClass fatal;
    private RubyClass interrupt;
    private RubyClass typeError;
    private RubyClass argumentError;
    private RubyClass uncaughtThrowError;
    private RubyClass indexError;
    private RubyClass stopIteration;
    private RubyClass syntaxError;
    private RubyClass standardError;
    private RubyClass loadError;
    private RubyClass notImplementedError;
    private RubyClass securityError;
    private RubyClass noMemoryError;
    private RubyClass regexpError;
    private RubyClass eofError;
    private RubyClass threadError;
    private RubyClass concurrencyError;
    private RubyClass systemStackError;
    private RubyClass zeroDivisionError;
    private RubyClass floatDomainError;
    private RubyClass mathDomainError;
    private RubyClass encodingError;
    private RubyClass encodingCompatibilityError;
    private RubyClass converterNotFoundError;
    private RubyClass undefinedConversionError;
    private RubyClass invalidByteSequenceError;
    private RubyClass fiberError;
    private RubyClass keyError;
    private RubyClass locationClass;
    private RubyClass interruptedRegexpError;
    private final RubyModule kernelModule;
    private final RubyModule comparableModule;
    private final RubyModule enumerableModule;
    private final RubyModule mathModule;
    private final RubyModule marshalModule;
    private final RubyModule fileTestModule;
    private final RubyModule gcModule;
    private final RubyModule objectSpaceModule;
    private final RubyModule processModule;
    private final RubyModule warningModule;
    private RubyModule etcModule;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyModule errnoModule;
    private DynamicMethod privateMethodMissing;
    private DynamicMethod protectedMethodMissing;
    private DynamicMethod variableMethodMissing;
    private DynamicMethod superMethodMissing;
    private DynamicMethod normalMethodMissing;
    private DynamicMethod defaultMethodMissing;
    private DynamicMethod defaultModuleMethodMissing;
    private DynamicMethod respondTo;
    private DynamicMethod respondToMissing;
    private GlobalVariable recordSeparatorVar;
    private volatile String currentDirectory;
    private volatile int currentLine = 0;
    private volatile IRubyObject argsFile;
    private final long startTime = System.currentTimeMillis();
    final RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private JavaSupport javaSupport;
    private final JRubyClassLoader jrubyClassLoader;
    private final BeanManager beanManager;
    private final ParserStats parserStats;
    private InlineStats inlineStats;
    private final JITCompiler jitCompiler;
    private final Caches caches;
    private static volatile boolean securityRestricted;
    private final Parser parser = new Parser(this);
    private final LoadService loadService;
    private Encoding defaultInternalEncoding;
    private Encoding defaultExternalEncoding;
    private Encoding defaultFilesystemEncoding;
    private final EncodingService encodingService;
    private final GlobalVariables globalVariables = new GlobalVariables(this);
    private final RubyWarnings warnings = new RubyWarnings(this);
    private final WarnCallback regexpWarnings = new WarnCallback(){

        @Override
        public void warn(String message2) {
            Ruby.this.getWarnings().warning(message2);
        }
    };
    private final Stack<RubyProc> atExitBlocks = new Stack();
    private Profile profile;
    private KCode kcode = KCode.NONE;
    private final AtomicInteger symbolLastId = new AtomicInteger(128);
    private final AtomicInteger moduleLastId = new AtomicInteger(0);
    private final ConcurrentWeakHashMap<RubyModule, Object> allModules = new ConcurrentWeakHashMap(128);
    private final Map<String, DateTimeZone> timeZoneCache = new HashMap<String, DateTimeZone>();
    private Map<Finalizable, Object> finalizers;
    private Map<Finalizable, Object> internalFinalizers;
    private final Object finalizersMutex = new Object();
    private final Object internalFinalizersMutex = new Object();
    private final ExecutorService executor;
    private final ExecutorService fiberExecutor;
    private final Object hierarchyLock = new Object();
    private final AtomicLong dynamicMethodSerial = new AtomicLong(1L);
    private final AtomicInteger moduleGeneration = new AtomicInteger(1);
    private final Map<String, Map<String, String>> boundMethods = new HashMap<String, Map<String, String>>();
    private final SelectorPool selectorPool = new SelectorPool();
    private final RuntimeCache runtimeCache;
    public static final String ERRNO_BACKTRACE_MESSAGE = "errno backtraces disabled; run with -Xerrno.backtrace=true to enable";
    public static final String STOPIERATION_BACKTRACE_MESSAGE = "StopIteration backtraces disabled; run with -Xstop_iteration.backtrace=true to enable";
    private final AtomicInteger exceptionCount = new AtomicInteger();
    private final AtomicInteger backtraceCount = new AtomicInteger();
    private final AtomicInteger callerCount = new AtomicInteger();
    private final AtomicInteger warningCount = new AtomicInteger();
    private final Invalidator fixnumInvalidator = OptoFactory.newGlobalInvalidator(0);
    private final Invalidator floatInvalidator = OptoFactory.newGlobalInvalidator(0);
    private boolean fixnumReopened;
    private boolean floatReopened;
    private final boolean coreIsBooted;
    private final boolean runtimeIsBooted;
    private RubyHash envObject;
    private final CoverageData coverageData = new CoverageData();
    private static volatile Ruby globalRuntime;
    private static final ThreadLocal<Ruby> threadLocalRuntime;
    final Random random;
    private final long hashSeedK0;
    private final long hashSeedK1;
    private final StaticScopeFactory staticScopeFactory;
    private final IRManager irManager;
    private FFI ffi;
    private JavaProxyClassFactory javaProxyClassFactory;
    private final ProfilingServiceLookup profilingServiceLookup;
    private final EnumMap<DefinedMessage, RubyString> definedMessages = new EnumMap(DefinedMessage.class);
    private final EnumMap<RubyThread.Status, RubyString> threadStatuses = new EnumMap(RubyThread.Status.class);
    private static final ObjectSpacer DISABLED_OBJECTSPACE;
    private static final ObjectSpacer ENABLED_OBJECTSPACE;
    private final ObjectSpacer objectSpacer;
    private final RubyArray emptyFrozenArray;
    private final ConcurrentHashMap<FStringEqual, WeakReference<RubyString>> dedupMap = new ConcurrentHashMap();
    private static final AtomicInteger RUNTIME_NUMBER;
    private final int runtimeNumber = RUNTIME_NUMBER.getAndIncrement();
    private final Config configBean;
    private final Runtime runtimeBean;
    private final FilenoUtil filenoUtil;
    private final Interpreter interpreter = new Interpreter();
    private final Object constant;
    private DynamicMethod baseNewMethod;
    private MethodHandle nullToNil;
    public final ClassValue<TypePopulator> POPULATORS = new ClassValue<TypePopulator>(){

        @Override
        protected TypePopulator computeValue(Class<?> type2) {
            return RubyModule.loadPopulatorFor(type2);
        }
    };
    public final JavaSites sites = new JavaSites();
    private volatile MRIRecursionGuard mriRecursionGuard;
    private final Map<Class, Consumer<RubyModule>> javaExtensionDefinitions = new WeakHashMap<Class, Consumer<RubyModule>>();
    private final Map<String, List<StrptimeToken>> strptimeFormatCache = new ConcurrentHashMap<String, List<StrptimeToken>>();
    transient RubyString tzVar;

    private Ruby(RubyInstanceConfig config) {
        this.config = config;
        this.threadService = new ThreadService(this);
        this.profilingServiceLookup = config.isProfiling() ? new ProfilingServiceLookup(this) : null;
        this.constant = OptoFactory.newConstantWrapper(Ruby.class, this);
        this.jrubyClassLoader = this.initJRubyClassLoader(config);
        this.staticScopeFactory = new StaticScopeFactory(this);
        this.beanManager = BeanManagerFactory.create(this, config.isManagementEnabled());
        this.jitCompiler = new JITCompiler(this);
        this.parserStats = new ParserStats(this);
        this.inlineStats = new InlineStats();
        this.caches = new Caches();
        this.random = this.initRandom();
        if (RubyInstanceConfig.CONSISTENT_HASHING_ENABLED) {
            this.hashSeedK0 = -561135208506705104L;
            this.hashSeedK1 = 7114160726623585955L;
        } else {
            this.hashSeedK0 = this.random.nextLong();
            this.hashSeedK1 = this.random.nextLong();
        }
        this.configBean = new Config(this);
        this.runtimeBean = new Runtime(this);
        this.registerMBeans();
        this.runtimeCache = new RuntimeCache();
        this.runtimeCache.initMethodCache(ClassIndex.MAX_CLASSES.ordinal() * MethodNames.values().length - 1);
        this.checkpointInvalidator = OptoFactory.newConstantInvalidator(this);
        this.objectSpacer = this.initObjectSpacer(config);
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), config.isNativeEnabled());
        this.filenoUtil = new FilenoUtil(this.posix);
        this.reinitialize(false);
        this.loadService = this.config.createLoadService(this);
        this.javaSupport = this.loadJavaSupport();
        this.executor = new ThreadPoolExecutor(RubyInstanceConfig.POOL_MIN, RubyInstanceConfig.POOL_MAX, (long)RubyInstanceConfig.POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Worker"));
        this.fiberExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, (long)RubyInstanceConfig.FIBER_POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Fiber"));
        this.basicObjectClass = RubyClass.createBootstrapClass(this, "BasicObject", null, RubyBasicObject.BASICOBJECT_ALLOCATOR);
        this.objectClass = RubyClass.createBootstrapClass(this, "Object", this.basicObjectClass, RubyObject.OBJECT_ALLOCATOR);
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        this.basicObjectClass.setMetaClass(this.classClass);
        this.objectClass.setMetaClass(this.basicObjectClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        RubyClass metaClass = this.basicObjectClass.makeMetaClass(this.classClass);
        metaClass = this.objectClass.makeMetaClass(metaClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        this.classClass.makeMetaClass(metaClass);
        RubyBasicObject.createBasicObjectClass(this, this.basicObjectClass);
        RubyObject.createObjectClass(this, this.objectClass);
        RubyModule.createModuleClass(this, this.moduleClass);
        RubyClass.createClassClass(this, this.classClass);
        this.basicObjectClass.setConstant("BasicObject", this.basicObjectClass);
        this.objectClass.setConstant("BasicObject", this.basicObjectClass);
        this.objectClass.setConstant("Object", this.objectClass);
        this.objectClass.setConstant("Class", this.classClass);
        this.objectClass.setConstant("Module", this.moduleClass);
        RubyModule kernel = this.kernelModule = RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        this.initKernelGsub(kernel);
        this.topSelf = TopSelfFactory.createTopSelf(this, false);
        this.nilClass = RubyNil.createNilClass(this);
        this.falseClass = RubyBoolean.createFalseClass(this);
        this.trueClass = RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        this.nilPrefilledArray = new IRubyObject[128];
        for (int i2 = 0; i2 < 128; ++i2) {
            this.nilPrefilledArray[i2] = this.nilObject;
        }
        this.singleNilArray = new IRubyObject[]{this.nilObject};
        this.falseObject = new RubyBoolean.False(this);
        this.falseObject.setFrozen(true);
        this.trueObject = new RubyBoolean.True(this);
        this.trueObject.setFrozen(true);
        this.reportOnException = this.trueObject;
        this.threadService.initMainThread();
        ThreadContext context = this.getCurrentContext();
        context.prepareTopLevel(this.objectClass, this.topSelf);
        this.dataClass = this.initDataClass();
        this.comparableModule = RubyComparable.createComparable(this);
        this.enumerableModule = RubyEnumerable.createEnumerableModule(this);
        this.stringClass = RubyString.createStringClass(this);
        this.encodingService = new EncodingService(this);
        this.symbolClass = RubySymbol.createSymbolClass(this);
        this.threadGroupClass = this.profile.allowClass("ThreadGroup") ? RubyThreadGroup.createThreadGroupClass(this) : null;
        this.threadClass = this.profile.allowClass("Thread") ? RubyThread.createThreadClass(this) : null;
        this.exceptionClass = this.profile.allowClass("Exception") ? RubyException.createExceptionClass(this) : null;
        this.numericClass = this.profile.allowClass("Numeric") ? RubyNumeric.createNumericClass(this) : null;
        this.integerClass = this.profile.allowClass("Integer") ? RubyInteger.createIntegerClass(this) : null;
        this.fixnumClass = this.profile.allowClass("Fixnum") ? RubyFixnum.createFixnumClass(this) : null;
        this.encodingClass = RubyEncoding.createEncodingClass(this);
        this.converterClass = RubyConverter.createConverterClass(this);
        this.encodingService.defineEncodings();
        this.encodingService.defineAliases();
        this.initDefaultEncodings();
        this.complexClass = this.profile.allowClass("Complex") ? RubyComplex.createComplexClass(this) : null;
        this.rationalClass = this.profile.allowClass("Rational") ? RubyRational.createRationalClass(this) : null;
        RubyClass rubyClass = this.hashClass = this.profile.allowClass("Hash") ? RubyHash.createHashClass(this) : null;
        if (this.profile.allowClass("Array")) {
            this.arrayClass = RubyArray.createArrayClass(this);
            this.emptyFrozenArray = this.newEmptyArray();
            this.emptyFrozenArray.setFrozen(true);
        } else {
            this.arrayClass = null;
            this.emptyFrozenArray = null;
        }
        RubyClass rubyClass2 = this.floatClass = this.profile.allowClass("Float") ? RubyFloat.createFloatClass(this) : null;
        if (this.profile.allowClass("Bignum")) {
            this.bignumClass = RubyBignum.createBignumClass(this);
            this.randomClass = RubyRandom.createRandomClass(this);
        } else {
            this.bignumClass = null;
            this.randomClass = null;
            this.defaultRand = null;
        }
        this.ioClass = RubyIO.createIOClass(this);
        this.structClass = this.profile.allowClass("Struct") ? RubyStruct.createStructClass(this) : null;
        this.bindingClass = this.profile.allowClass("Binding") ? RubyBinding.createBindingClass(this) : null;
        this.mathModule = this.profile.allowModule("Math") ? RubyMath.createMathModule(this) : null;
        this.regexpClass = this.profile.allowClass("Regexp") ? RubyRegexp.createRegexpClass(this) : null;
        this.rangeClass = this.profile.allowClass("Range") ? RubyRange.createRangeClass(this) : null;
        this.objectSpaceModule = this.profile.allowModule("ObjectSpace") ? RubyObjectSpace.createObjectSpaceModule(this) : null;
        this.gcModule = this.profile.allowModule("GC") ? RubyGC.createGCModule(this) : null;
        this.procClass = this.profile.allowClass("Proc") ? RubyProc.createProcClass(this) : null;
        this.methodClass = this.profile.allowClass("Method") ? RubyMethod.createMethodClass(this) : null;
        this.matchDataClass = this.profile.allowClass("MatchData") ? RubyMatchData.createMatchDataClass(this) : null;
        this.marshalModule = this.profile.allowModule("Marshal") ? RubyMarshal.createMarshalModule(this) : null;
        this.dirClass = this.profile.allowClass("Dir") ? RubyDir.createDirClass(this) : null;
        this.fileTestModule = this.profile.allowModule("FileTest") ? RubyFileTest.createFileTestModule(this) : null;
        this.fileClass = this.profile.allowClass("File") ? RubyFile.createFileClass(this) : null;
        this.fileStatClass = this.profile.allowClass("File::Stat") ? RubyFileStat.createFileStatClass(this) : null;
        this.processModule = this.profile.allowModule("Process") ? RubyProcess.createProcessModule(this) : null;
        this.timeClass = this.profile.allowClass("Time") ? RubyTime.createTimeClass(this) : null;
        RubyClass rubyClass3 = this.unboundMethodClass = this.profile.allowClass("UnboundMethod") ? RubyUnboundMethod.defineUnboundMethodClass(this) : null;
        if (this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Enumerator")) {
            this.enumeratorClass = RubyEnumerator.defineEnumerator(this, this.enumerableModule);
            this.generatorClass = RubyGenerator.createGeneratorClass(this, this.enumeratorClass);
            this.yielderClass = RubyYielder.createYielderClass(this);
        } else {
            this.enumeratorClass = null;
            this.generatorClass = null;
            this.yielderClass = null;
        }
        this.continuationClass = this.initContinuation();
        TracePoint.createTracePointClass(this);
        this.warningModule = RubyWarnings.createWarningModule(this);
        this.initExceptions();
        Mutex.setup(this);
        ConditionVariable.setup(this);
        Queue.setup(this);
        SizedQueue.setup(this);
        this.fiberClass = new ThreadFiberLibrary().createFiberClass(this);
        ThreadFiber.initRootFiber(context, context.getThread());
        this.initDefinedMessages();
        this.initThreadStatuses();
        this.irManager = new IRManager(this, this.getInstanceConfig());
        IRScriptBody top = new IRScriptBody(this.irManager, "", context.getCurrentScope().getStaticScope());
        top.allocateInterpreterContext(Collections.EMPTY_LIST);
        this.dummyClass = new RubyClass(this, this.classClass);
        this.dummyClass.setFrozen(true);
        RubyGlobal.createGlobals(this);
        this.getLoadService().init(this.config.getLoadPaths());
        this.coreIsBooted = true;
        if (!RubyInstanceConfig.DEBUG_PARSER) {
            this.initBootLibraries();
        }
        SecurityHelper.checkCryptoRestrictions(this);
        if (this.config.isProfiling()) {
            this.initProfiling();
        }
        if (this.config.getLoadGemfile()) {
            this.loadBundler();
        }
        this.deprecatedNetworkStackProperty();
        this.runtimeIsBooted = true;
    }

    private void initProfiling() {
        this.getLoadService().require("jruby/profiler/shutdown_hook");
        this.kernelModule.invalidateCacheDescendants();
        RubyKernel.recacheBuiltinMethods(this, this.kernelModule);
        RubyBasicObject.recacheBuiltinMethods(this);
    }

    private void initBootLibraries() {
        this.initJavaSupport();
        this.initRubyKernel();
        if (!this.config.isDisableGems()) {
            this.defineModule("Gem");
        }
        if (!this.config.isDisableDidYouMean()) {
            this.defineModule("DidYouMean");
        }
        this.loadService.provide("enumerator", "enumerator.rb");
        this.loadService.provide("rational", "rational.rb");
        this.loadService.provide("complex", "complex.rb");
        this.loadService.provide("thread", "thread.rb");
        this.initRubyPreludes();
    }

    private void initKernelGsub(RubyModule kernel) {
        if (this.config.getKernelGsubDefined()) {
            kernel.addMethod("gsub", new JavaMethod(kernel, Visibility.PRIVATE, "gsub"){

                @Override
                public IRubyObject call(ThreadContext context1, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    switch (args2.length) {
                        case 1: {
                            return RubyKernel.gsub(context1, self2, args2[0], block);
                        }
                        case 2: {
                            return RubyKernel.gsub(context1, self2, args2[0], args2[1], block);
                        }
                    }
                    throw Ruby.this.newArgumentError(String.format("wrong number of arguments %d for 1..2", args2.length));
                }
            });
        }
    }

    private ObjectSpacer initObjectSpacer(RubyInstanceConfig config) {
        ObjectSpacer objectSpacer = config.isObjectSpaceEnabled() ? ENABLED_OBJECTSPACE : DISABLED_OBJECTSPACE;
        return objectSpacer;
    }

    private JRubyClassLoader initJRubyClassLoader(RubyInstanceConfig config) {
        JRubyClassLoader jrubyClassLoader = !Ruby.isSecurityRestricted() ? (config.isClassloaderDelegate() ? new JRubyClassLoader(config.getLoader()) : new SelfFirstJRubyClassLoader(config.getLoader())) : null;
        return jrubyClassLoader;
    }

    private void initDefaultEncodings() {
        Encoding loadedEncoding;
        String encoding2 = this.config.getExternalEncoding();
        if (encoding2 != null && !encoding2.equals("")) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultExternalEncoding(loadedEncoding);
        } else {
            Encoding consoleEncoding = this.encodingService.getConsoleEncoding();
            Encoding availableEncoding = consoleEncoding == null ? this.encodingService.getLocaleEncoding() : consoleEncoding;
            this.setDefaultExternalEncoding(availableEncoding);
        }
        if (Platform.IS_WINDOWS) {
            this.setDefaultFilesystemEncoding(this.encodingService.getWindowsFilesystemEncoding(this));
        } else {
            this.setDefaultFilesystemEncoding(this.getDefaultExternalEncoding());
        }
        encoding2 = this.config.getInternalEncoding();
        if (encoding2 != null && !encoding2.equals("")) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultInternalEncoding(loadedEncoding);
        }
    }

    private RubyClass initDataClass() {
        RubyClass dataClass = null;
        if (this.profile.allowClass("Data")) {
            dataClass = this.defineClass("Data", this.objectClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            this.getObject().deprecateConstant(this, "Data");
        }
        return dataClass;
    }

    private Random initRandom() {
        Random myRandom;
        try {
            myRandom = new SecureRandom();
        }
        catch (Throwable t) {
            LOG.debug("unable to instantiate SecureRandom, falling back on Random", t);
            myRandom = new Random();
        }
        return myRandom;
    }

    public void registerMBeans() {
        this.beanManager.register(this.jitCompiler);
        this.beanManager.register(this.configBean);
        this.beanManager.register(this.parserStats);
        this.beanManager.register(this.runtimeBean);
        this.beanManager.register(this.caches);
        this.beanManager.register(this.inlineStats);
    }

    void reinitialize(boolean reinitCore) {
        this.doNotReverseLookupEnabled = true;
        this.in = this.config.getInput();
        this.out = this.config.getOutput();
        this.err = this.config.getError();
        this.objectSpaceEnabled = this.config.isObjectSpaceEnabled();
        this.siphashEnabled = this.config.isSiphashEnabled();
        this.profile = this.config.getProfile();
        this.currentDirectory = this.config.getCurrentDirectory();
        this.kcode = this.config.getKCode();
        if (reinitCore) {
            RubyGlobal.initARGV(this);
            RubyGlobal.initSTDIO(this, this.globalVariables);
        }
    }

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config) {
        Ruby ruby = new Ruby(config);
        ruby.loadRequiredLibraries();
        Ruby.setGlobalRuntimeFirstTimeOnly(ruby);
        return ruby;
    }

    private void loadRequiredLibraries() {
        ThreadContext context = this.getCurrentContext();
        for (String scriptName : this.config.getRequiredLibraries()) {
            this.topSelf.callMethod(context, "require", RubyString.newString(this, scriptName));
        }
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setInput(in);
        config.setOutput(out);
        config.setError(err);
        return Ruby.newInstance(config);
    }

    public static boolean isGlobalRuntimeReady() {
        return globalRuntime != null;
    }

    private static synchronized void setGlobalRuntimeFirstTimeOnly(Ruby runtime2) {
        if (globalRuntime == null) {
            globalRuntime = runtime2;
        }
    }

    public static synchronized Ruby getGlobalRuntime() {
        if (globalRuntime == null) {
            Ruby.newInstance();
        }
        return globalRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAsGlobalRuntime() {
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            globalRuntime = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalRuntime() {
        globalRuntime = null;
    }

    public static Ruby getThreadLocalRuntime() {
        return threadLocalRuntime.get();
    }

    public static void setThreadLocalRuntime(Ruby ruby) {
        threadLocalRuntime.set(ruby);
    }

    public IRubyObject evalScriptlet(String script) {
        ThreadContext context = this.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        ManyVarsDynamicScope newScope = new ManyVarsDynamicScope(this.getStaticScopeFactory().newEvalScope(currentScope.getStaticScope()), currentScope);
        return this.evalScriptlet(script, newScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalScriptlet(String script, DynamicScope scope) {
        ThreadContext context = this.getCurrentContext();
        RootNode rootNode = (RootNode)this.parseEval(script, "<script>", scope, 0);
        context.preEvalScriptlet(scope);
        try {
            IRubyObject iRubyObject = (IRubyObject)this.interpreter.execute(this, rootNode, context.getFrameSelf());
            return iRubyObject;
        }
        finally {
            context.postEvalScriptlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeScript(String script, String filename2) {
        byte[] bytes2 = this.encodeToBytes(script);
        ParseResult root = (ParseResult)((Object)this.parseInline(new ByteArrayInputStream(bytes2), filename2, null));
        ThreadContext context = this.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(root.getFile(), root.getLine());
            IRubyObject iRubyObject = this.runInterpreter(root);
            return iRubyObject;
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromMain(InputStream inputStream, String filename2) {
        ValueAccessor d = new ValueAccessor(this.newString(filename2));
        this.getGlobalVariables().define("$PROGRAM_NAME", d, GlobalVariable.Scope.GLOBAL);
        this.getGlobalVariables().define("$0", d, GlobalVariable.Scope.GLOBAL);
        for (Map.Entry<String, String> entry : this.config.getOptionGlobals().entrySet()) {
            RubyObject varvalue = entry.getValue() != null ? this.newString(entry.getValue()) : this.getTrue();
            this.getGlobalVariables().set('$' + entry.getKey(), varvalue);
        }
        if (filename2.endsWith(".class")) {
            IRScope script = CompiledScriptLoader.loadScriptFromFile(this, inputStream, null, filename2, false);
            if (script == null) {
                throw new MainExitException(1, "error: .class file specified is not a compiled JRuby script");
            }
            script.setFileName(filename2);
            this.runInterpreter(script);
            return;
        }
        ParseResult parseResult = this.parseFromMain(filename2, inputStream);
        if (this.fetchGlobalConstant("DATA") == null) {
            try {
                inputStream.close();
            }
            catch (IOException entry) {
                // empty catch block
            }
        }
        if (parseResult instanceof RootNode) {
            RootNode scriptNode = (RootNode)parseResult;
            ThreadContext context = this.getCurrentContext();
            String oldFile = context.getFile();
            int oldLine = context.getLine();
            try {
                context.setFileAndLine(scriptNode.getFile(), scriptNode.getLine());
                if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                    this.runWithGetsLoop(scriptNode, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit());
                }
                this.runNormally(scriptNode);
            }
            finally {
                context.setFileAndLine(oldFile, oldLine);
            }
        } else {
            this.runInterpreter(parseResult);
        }
    }

    public Node parseFromMain(InputStream inputStream, String filename2) {
        if (this.config.isInlineScript()) {
            return this.parseInline(inputStream, filename2, this.getCurrentContext().getCurrentScope());
        }
        return this.parseFileFromMain(inputStream, filename2, this.getCurrentContext().getCurrentScope());
    }

    public ParseResult parseFromMain(String fileName, InputStream in) {
        if (this.config.isInlineScript()) {
            return (ParseResult)((Object)this.parseInline(in, fileName, this.getCurrentContext().getCurrentScope()));
        }
        return this.parseFileFromMain(fileName, in, this.getCurrentContext().getCurrentScope());
    }

    @Deprecated
    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split2, boolean unused2) {
        return this.runWithGetsLoop((RootNode)scriptNode, printing, processLineEnds, split2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject runWithGetsLoop(RootNode scriptNode, boolean printing, boolean processLineEnds, boolean split2) {
        ThreadContext context = this.getCurrentContext();
        scriptNode = this.addGetsLoop(scriptNode, printing, processLineEnds, split2);
        Script script = null;
        boolean compile2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile2) {
            block11: {
                try {
                    script = this.tryCompile(scriptNode);
                    if (Options.JIT_LOGGING.load().booleanValue()) {
                        LOG.info("successfully compiled: {}", scriptNode.getFile());
                    }
                }
                catch (Throwable e) {
                    if (!Options.JIT_LOGGING.load().booleanValue()) break block11;
                    if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                        LOG.error("failed to compile: " + scriptNode.getFile(), e);
                    }
                    LOG.error("failed to compile: " + scriptNode.getFile() + " - " + e, new Object[0]);
                }
            }
            if (!compile2 || script == null) {
                // empty if block
            }
        }
        Helpers.preLoad(context, scriptNode.getStaticScope().getVariables());
        try {
            if (script != null) {
                this.runScriptBody(script);
            } else {
                this.runInterpreterBody(scriptNode);
            }
        }
        finally {
            Helpers.postLoad(context);
        }
        return this.getNil();
    }

    private RootNode addGetsLoop(RootNode oldRoot, boolean printing, boolean processLineEndings, boolean split2) {
        ISourcePosition pos2 = oldRoot.getPosition();
        BlockNode newBody = new BlockNode(pos2);
        RubySymbol dollarSlash = this.newSymbol(CommonByteLists.DOLLAR_SLASH);
        newBody.add(new GlobalAsgnNode(pos2, dollarSlash, new StrNode(pos2, ((RubyString)this.globalVariables.get("$/")).getByteList())));
        if (processLineEndings) {
            newBody.add(new GlobalAsgnNode(pos2, this.newSymbol(CommonByteLists.DOLLAR_BACKSLASH), new GlobalVarNode(pos2, dollarSlash)));
        }
        GlobalVarNode dollarUnderscore = new GlobalVarNode(pos2, this.newSymbol("$_"));
        BlockNode whileBody = new BlockNode(pos2);
        newBody.add(new WhileNode(pos2, new VCallNode(pos2, this.newSymbol("gets")), whileBody));
        if (processLineEndings) {
            whileBody.add(new CallNode(pos2, dollarUnderscore, this.newSymbol("chomp!"), null, null, false));
        }
        if (split2) {
            whileBody.add(new GlobalAsgnNode(pos2, this.newSymbol("$F"), new CallNode(pos2, dollarUnderscore, this.newSymbol("split"), null, null, false)));
        }
        if (oldRoot.getBodyNode() instanceof BlockNode) {
            whileBody.addAll((BlockNode)oldRoot.getBodyNode());
        } else {
            whileBody.add(oldRoot.getBodyNode());
        }
        if (printing) {
            whileBody.add(new FCallNode(pos2, this.newSymbol("puts"), new ArrayNode(pos2, dollarUnderscore), null));
        }
        return new RootNode(pos2, oldRoot.getScope(), newBody, oldRoot.getFile());
    }

    public IRubyObject runNormally(Node scriptNode, boolean wrap2) {
        ScriptAndCode scriptAndCode = null;
        boolean compile2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile2 || this.config.isShowBytecode()) {
            scriptAndCode = this.precompileCLI((RootNode)scriptNode);
        }
        if (scriptAndCode != null) {
            if (this.config.isShowBytecode()) {
                TraceClassVisitor tracer = new TraceClassVisitor(new PrintWriter(System.err));
                ClassReader reader = new ClassReader(scriptAndCode.bytecode());
                reader.accept((ClassVisitor)tracer, 0);
                return this.getNil();
            }
            return this.runScript(scriptAndCode.script(), wrap2);
        }
        return this.runInterpreter(scriptNode);
    }

    public IRubyObject runNormally(Node scriptNode) {
        return this.runNormally(scriptNode, false);
    }

    private ScriptAndCode precompileCLI(RootNode scriptNode) {
        ScriptAndCode scriptAndCode;
        block4: {
            scriptAndCode = null;
            try {
                scriptAndCode = this.tryCompile(scriptNode, new ClassDefiningJRubyClassLoader(this.getJRubyClassLoader()));
                if (scriptAndCode != null && Options.JIT_LOGGING.load().booleanValue()) {
                    LOG.info("done compiling target script: {}", scriptNode.getFile());
                }
            }
            catch (Exception e) {
                if (!Options.JIT_LOGGING.load().booleanValue()) break block4;
                if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                    LOG.error("failed to compile target script: " + scriptNode.getFile(), e);
                }
                LOG.error("failed to compile target script: " + scriptNode.getFile() + " - " + e, new Object[0]);
            }
        }
        return scriptAndCode;
    }

    public Script tryCompile(Node node) {
        return this.tryCompile((RootNode)node, new ClassDefiningJRubyClassLoader(this.getJRubyClassLoader())).script();
    }

    private ScriptAndCode tryCompile(RootNode root, ClassDefiningClassLoader classLoader) {
        try {
            return (ScriptAndCode)Compiler.getInstance().execute(this, root, classLoader);
        }
        catch (NotCompilableException e) {
            if (Options.JIT_LOGGING.load().booleanValue()) {
                if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                    LOG.error("failed to compile target script: " + root.getFile(), e);
                } else {
                    LOG.error("failed to compile target script: " + root.getFile() + " - " + e.getLocalizedMessage(), new Object[0]);
                }
            }
            return null;
        }
    }

    public IRubyObject runScript(Script script) {
        return this.runScript(script, false);
    }

    public IRubyObject runScript(Script script, boolean wrap2) {
        return script.load(this.getCurrentContext(), this.getTopSelf(), wrap2);
    }

    public IRubyObject runScriptBody(Script script) {
        return script.__file__(this.getCurrentContext(), this.getTopSelf(), Block.NULL_BLOCK);
    }

    public IRubyObject runInterpreter(ThreadContext context, ParseResult parseResult, IRubyObject self2) {
        try {
            return (IRubyObject)this.interpreter.execute(this, parseResult, self2);
        }
        catch (IRReturnJump ex) {
            if (!ex.methodToReturnFrom.getStaticScope().getIRScope().isScriptScope()) {
                System.err.println("Unexpected 'return' escaped the runtime from " + ex.returnScope + " to " + ex.methodToReturnFrom.getStaticScope().getIRScope());
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(ex, false));
                Throwable t = ex;
                while ((t = t.getCause()) != null) {
                    System.err.println("Caused by:");
                    System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t, false));
                }
            }
            return context.nil;
        }
    }

    public IRubyObject runInterpreter(ThreadContext context, Node rootNode, IRubyObject self2) {
        assert (rootNode != null) : "scriptNode is not null";
        return (IRubyObject)this.interpreter.execute(this, (ParseResult)((Object)rootNode), self2);
    }

    public IRubyObject runInterpreter(Node scriptNode) {
        return this.runInterpreter(this.getCurrentContext(), scriptNode, this.getTopSelf());
    }

    public IRubyObject runInterpreter(ParseResult parseResult) {
        return this.runInterpreter(this.getCurrentContext(), parseResult, this.getTopSelf());
    }

    public IRubyObject runInterpreterBody(Node scriptNode) {
        assert (scriptNode != null) : "scriptNode is not null";
        assert (scriptNode instanceof RootNode) : "scriptNode is not a RootNode";
        return this.runInterpreter(scriptNode);
    }

    public Parser getParser() {
        return this.parser;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public JITCompiler getJITCompiler() {
        return this.jitCompiler;
    }

    public InlineStats getInlineStats() {
        return this.inlineStats;
    }

    public Caches getCaches() {
        return this.caches;
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance();
    }

    @Deprecated
    public static Ruby getCurrentInstance() {
        return null;
    }

    @Deprecated
    public static void setCurrentInstance(Ruby runtime2) {
    }

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    public void addModule(RubyModule module) {
        this.allModules.put(module, RubyBasicObject.NEVER);
    }

    public void eachModule(Consumer<RubyModule> func) {
        Enumeration<RubyModule> e = this.allModules.keys();
        while (e.hasMoreElements()) {
            func.accept(e.nextElement());
        }
    }

    @Deprecated
    public void eachModule(Function1<Object, IRubyObject> func) {
        Enumeration<RubyModule> e = this.allModules.keys();
        while (e.hasMoreElements()) {
            func.apply(e.nextElement());
        }
    }

    public RubyModule getModule(String name2) {
        return this.objectClass.getModule(name2);
    }

    @Deprecated
    public RubyModule fastGetModule(String internedName) {
        return this.getModule(internedName);
    }

    public RubyClass getClass(String name2) {
        return this.objectClass.getClass(name2);
    }

    @Deprecated
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(internedName);
    }

    @Extension
    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass);
    }

    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator, CallSite[] callSites) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass, callSites);
    }

    @Extension
    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent) {
        return this.defineClassUnder(name2, superClass, allocator, parent, null);
    }

    public RubyClass defineClassUnder(String id2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent, CallSite[] callSites) {
        boolean parentIsObject;
        IRubyObject classObj = parent.getConstantAt(id2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw this.newTypeError(RubyStringBuilder.str(this, RubyStringBuilder.ids(this, id2), " is not a class"));
            }
            RubyClass klazz = (RubyClass)classObj;
            if (klazz.getSuperClass().getRealClass() != superClass) {
                throw this.newNameError(RubyStringBuilder.str(this, RubyStringBuilder.ids(this, id2), " is already defined"), id2);
            }
            if (klazz.getAllocator() != allocator) {
                klazz.setAllocator(allocator);
            }
            return klazz;
        }
        boolean bl = parentIsObject = parent == this.objectClass;
        if (superClass == null) {
            RubyString className = parentIsObject ? RubyStringBuilder.ids(this, id2) : parent.toRubyString(this.getCurrentContext()).append(this.newString("::")).append(RubyStringBuilder.ids(this, id2));
            this.warnings.warn(IRubyWarnings.ID.NO_SUPER_CLASS, RubyStringBuilder.str(this, "no super class for `", className, "', Object assumed"));
            superClass = this.objectClass;
        }
        return RubyClass.newClass(this, superClass, id2, allocator, parent, !parentIsObject, callSites);
    }

    @Extension
    public RubyModule defineModule(String name2) {
        return this.defineModuleUnder(name2, this.objectClass);
    }

    @Extension
    public RubyModule defineModuleUnder(String name2, RubyModule parent) {
        boolean parentIsObject;
        IRubyObject moduleObj = parent.getConstantAt(name2);
        boolean bl = parentIsObject = parent == this.objectClass;
        if (moduleObj != null) {
            if (moduleObj.isModule()) {
                return (RubyModule)moduleObj;
            }
            RubyString typeName = parentIsObject ? RubyStringBuilder.types(this, moduleObj.getMetaClass()) : RubyStringBuilder.types(this, parent, moduleObj.getMetaClass());
            throw this.newTypeError(RubyStringBuilder.str(this, typeName, " is not a module"));
        }
        return RubyModule.newModule(this, name2, parent, !parentIsObject);
    }

    public RubyModule getOrCreateModule(String id2) {
        IRubyObject module = this.objectClass.getConstantAt(id2);
        if (module == null) {
            module = this.defineModule(id2);
        } else if (!module.isModule()) {
            throw this.newTypeError(RubyStringBuilder.str(this, RubyStringBuilder.ids(this, id2), " is not a Module"));
        }
        return (RubyModule)module;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public void defineGlobalConstant(String name2, IRubyObject value2) {
        this.objectClass.defineConstant(name2, value2);
    }

    public IRubyObject fetchGlobalConstant(String name2) {
        return this.objectClass.fetchConstant(name2, false);
    }

    public boolean isClassDefined(String name2) {
        return this.getModule(name2) != null;
    }

    public JavaSupport loadJavaSupport() {
        return new JavaSupportImpl(this);
    }

    private void loadBundler() {
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/bundler/startup.rb", false);
    }

    private boolean doesReflectionWork() {
        try {
            ClassLoader.class.getDeclaredMethod("getResourceAsStream", String.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initDefinedMessages() {
        for (DefinedMessage definedMessage : DefinedMessage.values()) {
            RubyString str = this.freezeAndDedupString(RubyString.newString(this, ByteList.create(definedMessage.getText())));
            this.definedMessages.put(definedMessage, str);
        }
    }

    private void initThreadStatuses() {
        for (RubyThread.Status status2 : RubyThread.Status.values()) {
            RubyString str = RubyString.newString(this, status2.bytes);
            str.setFrozen(true);
            this.threadStatuses.put(status2, str);
        }
    }

    private RubyClass initContinuation() {
        if (this.profile.allowClass("Continuation")) {
            return RubyContinuation.createContinuation(this);
        }
        return null;
    }

    public IRubyObject[] getNilPrefilledArray() {
        return this.nilPrefilledArray;
    }

    private void initExceptions() {
        this.ifAllowed("StandardError", ruby -> {
            this.standardError = RubyStandardError.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("RubyError", ruby -> {
            this.runtimeError = RubyRuntimeError.define(ruby, this.standardError);
        });
        this.ifAllowed("FrozenError", ruby -> {
            this.frozenError = RubyFrozenError.define(ruby, this.runtimeError);
        });
        this.ifAllowed("IOError", ruby -> {
            this.ioError = RubyIOError.define(ruby, this.standardError);
        });
        this.ifAllowed("ScriptError", ruby -> {
            this.scriptError = RubyScriptError.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("RangeError", ruby -> {
            this.rangeError = RubyRangeError.define(ruby, this.standardError);
        });
        this.ifAllowed("SignalException", ruby -> {
            this.signalException = RubySignalException.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("NameError", ruby -> {
            this.nameError = RubyNameError.define(ruby, this.standardError);
            this.nameErrorMessage = RubyNameError.RubyNameErrorMessage.define(ruby, this.nameError);
        });
        this.ifAllowed("NoMethodError", ruby -> {
            this.noMethodError = RubyNoMethodError.define(ruby, this.nameError);
        });
        this.ifAllowed("SystemExit", ruby -> {
            this.systemExit = RubySystemExit.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("LocalJumpError", ruby -> {
            this.localJumpError = RubyLocalJumpError.define(ruby, this.standardError);
        });
        this.ifAllowed("SystemCallError", ruby -> {
            this.systemCallError = RubySystemCallError.define(ruby, this.standardError);
        });
        this.ifAllowed("Fatal", ruby -> {
            this.fatal = RubyFatal.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("Interrupt", ruby -> {
            this.interrupt = RubyInterrupt.define(ruby, this.signalException);
        });
        this.ifAllowed("TypeError", ruby -> {
            this.typeError = RubyTypeError.define(ruby, this.standardError);
        });
        this.ifAllowed("ArgumentError", ruby -> {
            this.argumentError = RubyArgumentError.define(ruby, this.standardError);
        });
        this.ifAllowed("UncaughtThrowError", ruby -> {
            this.uncaughtThrowError = RubyUncaughtThrowError.define(ruby, this.argumentError);
        });
        this.ifAllowed("IndexError", ruby -> {
            this.indexError = RubyIndexError.define(ruby, this.standardError);
        });
        this.ifAllowed("StopIteration", ruby -> {
            this.stopIteration = RubyStopIteration.define(ruby, this.indexError);
        });
        this.ifAllowed("SyntaxError", ruby -> {
            this.syntaxError = RubySyntaxError.define(ruby, this.scriptError);
        });
        this.ifAllowed("LoadError", ruby -> {
            this.loadError = RubyLoadError.define(ruby, this.scriptError);
        });
        this.ifAllowed("NotImplementedError", ruby -> {
            this.notImplementedError = RubyNotImplementedError.define(ruby, this.scriptError);
        });
        this.ifAllowed("SecurityError", ruby -> {
            this.securityError = RubySecurityError.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("NoMemoryError", ruby -> {
            this.noMemoryError = RubyNoMemoryError.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("RegexpError", ruby -> {
            this.regexpError = RubyRegexpError.define(ruby, this.standardError);
        });
        this.ifAllowed("InterruptedRegexpError", ruby -> {
            this.interruptedRegexpError = RubyInterruptedRegexpError.define(ruby, this.regexpError);
        });
        this.ifAllowed("EOFError", ruby -> {
            this.eofError = RubyEOFError.define(ruby, this.ioError);
        });
        this.ifAllowed("ThreadError", ruby -> {
            this.threadError = RubyThreadError.define(ruby, this.standardError);
        });
        this.ifAllowed("ConcurrencyError", ruby -> {
            this.concurrencyError = RubyConcurrencyError.define(ruby, this.threadError);
        });
        this.ifAllowed("SystemStackError", ruby -> {
            this.systemStackError = RubySystemStackError.define(ruby, this.exceptionClass);
        });
        this.ifAllowed("ZeroDivisionError", ruby -> {
            this.zeroDivisionError = RubyZeroDivisionError.define(ruby, this.standardError);
        });
        this.ifAllowed("FloatDomainError", ruby -> {
            this.floatDomainError = RubyFloatDomainError.define(ruby, this.rangeError);
        });
        this.ifAllowed("EncodingError", ruby -> {
            this.encodingError = RubyEncodingError.define(ruby, this.standardError);
            this.encodingCompatibilityError = RubyEncodingError.RubyCompatibilityError.define(ruby, this.encodingError, this.encodingClass);
            this.invalidByteSequenceError = RubyEncodingError.RubyInvalidByteSequenceError.define(ruby, this.encodingError, this.encodingClass);
            this.undefinedConversionError = RubyEncodingError.RubyUndefinedConversionError.define(ruby, this.encodingError, this.encodingClass);
            this.converterNotFoundError = RubyEncodingError.RubyConverterNotFoundError.define(ruby, this.encodingError, this.encodingClass);
        });
        this.ifAllowed("Fiber", ruby -> {
            this.fiberError = RubyFiberError.define(ruby, this.standardError);
        });
        this.ifAllowed("ConcurrencyError", ruby -> {
            this.concurrencyError = RubyConcurrencyError.define(ruby, this.threadError);
        });
        this.ifAllowed("KeyError", ruby -> {
            this.keyError = RubyKeyError.define(ruby, this.indexError);
        });
        this.ifAllowed("DomainError", ruby -> {
            this.mathDomainError = RubyDomainError.define(ruby, this.argumentError, this.mathModule);
        });
        this.initErrno();
        this.initNativeException();
    }

    private void ifAllowed(String name2, Consumer<Ruby> callback) {
        if (this.profile.allowClass(name2)) {
            callback.accept(this);
        }
    }

    private void initNativeException() {
        if (this.profile.allowClass("NativeException")) {
            this.nativeException = NativeException.createClass(this, this.runtimeError);
        }
    }

    public RubyClass getErrno(int n) {
        return this.errnos.get(n);
    }

    private void initErrno() {
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
            try {
                this.createSysErr(Errno.EAGAIN.intValue(), Errno.EAGAIN.name());
                for (Errno e : Errno.values()) {
                    Errno c = e;
                    if (!Character.isUpperCase(c.name().charAt(0))) continue;
                    this.createSysErr(c.intValue(), c.name());
                }
                this.errnos.put(Errno.ENOSYS.intValue(), this.notImplementedError);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    private void createSysErr(int i2, String name2) {
        if (this.profile.allowClass(name2)) {
            if (this.errnos.get(i2) == null) {
                RubyClass errno2 = this.getErrno().defineClassUnder(name2, this.systemCallError, this.systemCallError.getAllocator());
                this.errnos.put(i2, errno2);
                errno2.defineConstant("Errno", this.newFixnum(i2));
            } else {
                this.getErrno().setConstant(name2, this.errnos.get(i2));
            }
        }
    }

    private void initJavaSupport() {
        boolean reflectionWorks = this.doesReflectionWork();
        if (reflectionWorks) {
            new Java().load(this, false);
            new JRubyLibrary().load(this, false);
            new JRubyUtilLibrary().load(this, false);
            this.loadService.provide("java", "java.rb");
            this.loadService.provide("jruby", "jruby.rb");
            this.loadService.provide("jruby/util", "jruby/util.rb");
        }
    }

    private void initRubyKernel() {
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/kernel.rb", false);
    }

    private void initRubyPreludes() {
        if (RubyInstanceConfig.DEBUG_PARSER) {
            return;
        }
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/preludes.rb", false);
    }

    public IRManager getIRManager() {
        return this.irManager;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentLine(int line) {
        this.currentLine = line;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setArgsFile(IRubyObject argsFile) {
        this.argsFile = argsFile;
    }

    public IRubyObject getArgsFile() {
        return this.argsFile;
    }

    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule etcModule) {
        this.etcModule = etcModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getBasicObject() {
        return this.basicObjectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    public DynamicMethod getPrivateMethodMissing() {
        return this.privateMethodMissing;
    }

    public void setPrivateMethodMissing(DynamicMethod method2) {
        this.privateMethodMissing = method2;
    }

    public DynamicMethod getProtectedMethodMissing() {
        return this.protectedMethodMissing;
    }

    public void setProtectedMethodMissing(DynamicMethod method2) {
        this.protectedMethodMissing = method2;
    }

    public DynamicMethod getVariableMethodMissing() {
        return this.variableMethodMissing;
    }

    public void setVariableMethodMissing(DynamicMethod method2) {
        this.variableMethodMissing = method2;
    }

    public DynamicMethod getSuperMethodMissing() {
        return this.superMethodMissing;
    }

    public void setSuperMethodMissing(DynamicMethod method2) {
        this.superMethodMissing = method2;
    }

    public DynamicMethod getNormalMethodMissing() {
        return this.normalMethodMissing;
    }

    public void setNormalMethodMissing(DynamicMethod method2) {
        this.normalMethodMissing = method2;
    }

    public DynamicMethod getDefaultMethodMissing() {
        return this.defaultMethodMissing;
    }

    public boolean isDefaultMethodMissing(DynamicMethod method2) {
        return this.defaultMethodMissing == method2 || this.defaultModuleMethodMissing == method2;
    }

    public void setDefaultMethodMissing(DynamicMethod method2, DynamicMethod moduleMethod) {
        this.defaultMethodMissing = method2;
        this.defaultModuleMethodMissing = moduleMethod;
    }

    public DynamicMethod getRespondToMethod() {
        return this.respondTo;
    }

    public void setRespondToMethod(DynamicMethod rtm) {
        this.respondTo = rtm;
    }

    public DynamicMethod getRespondToMissingMethod() {
        return this.respondToMissing;
    }

    public void setRespondToMissingMethod(DynamicMethod rtmm) {
        this.respondToMissing = rtmm;
    }

    public RubyClass getDummy() {
        return this.dummyClass;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    public RubyClass getComplex() {
        return this.complexClass;
    }

    public RubyClass getRational() {
        return this.rationalClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    public RubyClass getEnumerator() {
        return this.enumeratorClass;
    }

    public RubyClass getYielder() {
        return this.yielderClass;
    }

    public RubyClass getGenerator() {
        return this.generatorClass;
    }

    public RubyClass getFiber() {
        return this.fiberClass;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    public RubyClass getEncoding() {
        return this.encodingClass;
    }

    public RubyClass getConverter() {
        return this.converterClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public IRubyObject[] getSingleNilArray() {
        return this.singleNilArray;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    public RubyClass getBignum() {
        return this.bignumClass;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    public RubyThreadGroup getDefaultThreadGroup() {
        return this.defaultThreadGroup;
    }

    void setDefaultThreadGroup(RubyThreadGroup defaultThreadGroup) {
        this.defaultThreadGroup = defaultThreadGroup;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    public RubyClass getRandomClass() {
        return this.randomClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass tmsStruct) {
        this.tmsStruct = tmsStruct;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    public void setPasswdStruct(RubyClass passwdStruct) {
        this.passwdStruct = passwdStruct;
    }

    public IRubyObject getGroupStruct() {
        return this.groupStruct;
    }

    public void setGroupStruct(RubyClass groupStruct) {
        this.groupStruct = groupStruct;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass procStatusClass) {
        this.procStatusClass = procStatusClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule procUIDModule) {
        this.procUIDModule = procUIDModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule procGIDModule) {
        this.procGIDModule = procGIDModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule procSysModule) {
        this.procSysModule = procSysModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule precisionModule) {
        this.precisionModule = precisionModule;
    }

    public RubyHash getENV() {
        return this.envObject;
    }

    public void setENV(RubyHash env) {
        this.envObject = env;
    }

    public RubyClass getLocation() {
        return this.locationClass;
    }

    public void setLocation(RubyClass location) {
        this.locationClass = location;
    }

    public RubyModule getWarning() {
        return this.warningModule;
    }

    public RubyModule getErrno() {
        return this.errnoModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNameErrorMessage() {
        return this.nameErrorMessage;
    }

    public RubyClass getNoMethodError() {
        return this.noMethodError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getLocalJumpError() {
        return this.localJumpError;
    }

    public RubyClass getNativeException() {
        return this.nativeException;
    }

    public RubyClass getSystemCallError() {
        return this.systemCallError;
    }

    public RubyClass getKeyError() {
        return this.keyError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getUncaughtThrowError() {
        return this.uncaughtThrowError;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getStopIteration() {
        return this.stopIteration;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getFrozenError() {
        return this.frozenError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getNoMemoryError() {
        return this.noMemoryError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getInterruptedRegexpError() {
        return this.interruptedRegexpError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }

    public RubyClass getThreadError() {
        return this.threadError;
    }

    public RubyClass getConcurrencyError() {
        return this.concurrencyError;
    }

    public RubyClass getSystemStackError() {
        return this.systemStackError;
    }

    public RubyClass getZeroDivisionError() {
        return this.zeroDivisionError;
    }

    public RubyClass getFloatDomainError() {
        return this.floatDomainError;
    }

    public RubyClass getMathDomainError() {
        return this.mathDomainError;
    }

    public RubyClass getEncodingError() {
        return this.encodingError;
    }

    public RubyClass getEncodingCompatibilityError() {
        return this.encodingCompatibilityError;
    }

    public RubyClass getConverterNotFoundError() {
        return this.converterNotFoundError;
    }

    public RubyClass getFiberError() {
        return this.fiberError;
    }

    public RubyClass getUndefinedConversionError() {
        return this.undefinedConversionError;
    }

    public RubyClass getInvalidByteSequenceError() {
        return this.invalidByteSequenceError;
    }

    public RubyRandom.RandomType getDefaultRand() {
        return this.defaultRand;
    }

    public void setDefaultRand(RubyRandom.RandomType defaultRand) {
        this.defaultRand = defaultRand;
    }

    @Deprecated
    public RubyHash getCharsetMap() {
        if (this.charsetMap == null) {
            this.charsetMap = new RubyHash(this);
        }
        return this.charsetMap;
    }

    public IRubyObject getVerbose() {
        return this.verboseValue;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean warningsEnabled() {
        return this.warningsEnabled;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose.isTrue();
        this.verboseValue = verbose;
        this.warningsEnabled = !verbose.isNil();
    }

    public IRubyObject getDebug() {
        return this.debug ? this.trueObject : this.falseObject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug.isTrue();
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Ruby.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public JRubyClassLoader getJRubyClassLoader() {
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable, GlobalVariable.Scope scope) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return variable.get();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        }, scope);
    }

    public void defineReadonlyVariable(String name2, IRubyObject value2, GlobalVariable.Scope scope) {
        this.globalVariables.defineReadonly(name2, new ValueAccessor(value2), scope);
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope) {
        return this.parseFile(in, file2, scope, 0);
    }

    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope) {
        return this.parseFile(file2, in, scope, 0);
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope, int lineNumber) {
        this.addLoadParseToStats();
        return this.parseFileAndGetAST(in, file2, scope, lineNumber, false);
    }

    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope, int lineNumber) {
        this.addLoadParseToStats();
        if (!RubyInstanceConfig.IR_READING) {
            return (ParseResult)((Object)this.parseFileAndGetAST(in, file2, scope, lineNumber, false));
        }
        try {
            return IRReader.load(this.getIRManager(), new IRReaderStream(this.getIRManager(), IRFileExpert.getIRPersistedFile(file2), new ByteList(file2.getBytes())));
        }
        catch (IOException e) {
            return (ParseResult)((Object)this.parseFileAndGetAST(in, file2, scope, lineNumber, false));
        }
    }

    public Node parseFileFromMain(InputStream in, String file2, DynamicScope scope) {
        this.addLoadParseToStats();
        return this.parseFileFromMainAndGetAST(in, file2, scope);
    }

    public ParseResult parseFileFromMain(String file2, InputStream in, DynamicScope scope) {
        this.addLoadParseToStats();
        if (!RubyInstanceConfig.IR_READING) {
            return (ParseResult)((Object)this.parseFileFromMainAndGetAST(in, file2, scope));
        }
        try {
            return IRReader.load(this.getIRManager(), new IRReaderStream(this.getIRManager(), IRFileExpert.getIRPersistedFile(file2), new ByteList(file2.getBytes())));
        }
        catch (IOException ex) {
            if (this.config.isVerbose()) {
                LOG.info(ex);
            } else {
                LOG.debug(ex);
            }
            return (ParseResult)((Object)this.parseFileFromMainAndGetAST(in, file2, scope));
        }
    }

    private Node parseFileFromMainAndGetAST(InputStream in, String file2, DynamicScope scope) {
        return this.parseFileAndGetAST(in, file2, scope, 0, true);
    }

    private Node parseFileAndGetAST(InputStream in, String file2, DynamicScope scope, int lineNumber, boolean isFromMain) {
        ParserConfiguration parserConfig = new ParserConfiguration(this, lineNumber, false, true, isFromMain, this.config);
        this.setupSourceEncoding(parserConfig, UTF8Encoding.INSTANCE);
        return this.parser.parse(file2, in, scope, parserConfig);
    }

    public Node parseInline(InputStream in, String file2, DynamicScope scope) {
        this.addEvalParseToStats();
        ParserConfiguration parserConfig = new ParserConfiguration(this, 0, false, true, false, this.config);
        this.setupSourceEncoding(parserConfig, this.getEncodingService().getLocaleEncoding());
        return this.parser.parse(file2, in, scope, parserConfig);
    }

    private void setupSourceEncoding(ParserConfiguration parserConfig, Encoding defaultEncoding) {
        if (this.config.getSourceEncoding() != null) {
            if (this.config.isVerbose()) {
                this.config.getError().println("-K is specified; it is for 1.8 compatibility and may cause odd behavior");
            }
            parserConfig.setDefaultEncoding(this.getEncodingService().getEncodingFromString(this.config.getSourceEncoding()));
        } else {
            parserConfig.setDefaultEncoding(defaultEncoding);
        }
    }

    public Node parseEval(String content, String file2, DynamicScope scope, int lineNumber) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, this.encodeToBytes(content), scope, new ParserConfiguration(this, lineNumber, false, false, this.config));
    }

    private byte[] encodeToBytes(String string2) {
        Charset charset = this.getDefaultCharset();
        byte[] bytes2 = charset == null ? string2.getBytes() : string2.getBytes(charset);
        return bytes2;
    }

    @Deprecated
    public Node parse(String content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        return this.parser.parse(file2, content.getBytes(), scope, new ParserConfiguration(this, lineNumber, extraPositionInformation, false, true, this.config));
    }

    public Node parseEval(ByteList content, String file2, DynamicScope scope, int lineNumber) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this, lineNumber, false, false, false, this.config));
    }

    public Node parse(ByteList content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this, lineNumber, extraPositionInformation, false, true, this.config));
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return ThreadService.getCurrentContext(this.threadService);
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public Encoding getDefaultInternalEncoding() {
        return this.defaultInternalEncoding;
    }

    public void setDefaultInternalEncoding(Encoding defaultInternalEncoding) {
        this.defaultInternalEncoding = defaultInternalEncoding;
    }

    public Encoding getDefaultExternalEncoding() {
        return this.defaultExternalEncoding;
    }

    public void setDefaultExternalEncoding(Encoding defaultExternalEncoding) {
        this.defaultExternalEncoding = defaultExternalEncoding;
    }

    public Encoding getDefaultFilesystemEncoding() {
        return this.defaultFilesystemEncoding;
    }

    public void setDefaultFilesystemEncoding(Encoding defaultFilesystemEncoding) {
        this.defaultFilesystemEncoding = defaultFilesystemEncoding;
    }

    public Charset getDefaultCharset() {
        Encoding enc = this.getDefaultEncoding();
        Charset charset = EncodingUtils.charsetForEncoding(enc);
        return charset;
    }

    public Encoding getDefaultEncoding() {
        Encoding enc = this.getDefaultInternalEncoding();
        if (enc == null) {
            enc = UTF8Encoding.INSTANCE;
        }
        return enc;
    }

    public EncodingService getEncodingService() {
        return this.encodingService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    WarnCallback getRegexpWarnings() {
        return this.regexpWarnings;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String path2) {
        return this.getClassFromPath(path2, this.getTypeError(), true);
    }

    public RubyModule getClassFromPath(String path2, RubyClass undefinedExceptionClass, boolean flexibleSearch) {
        if (path2.length() == 0 || path2.charAt(0) == '#') {
            throw this.newRaiseException(this.getTypeError(), RubyStringBuilder.str(this, "can't retrieve anonymous class ", RubyStringBuilder.ids(this, path2)));
        }
        ThreadContext context = this.getCurrentContext();
        RubyModule c = this.getObject();
        int pbeg = 0;
        int p2 = 0;
        int l = path2.length();
        while (p2 < l) {
            IRubyObject cc;
            while (p2 < l && path2.charAt(p2) != ':') {
                ++p2;
            }
            String str = path2.substring(pbeg, p2);
            if (p2 < l && path2.charAt(p2) == ':') {
                if (++p2 < l && path2.charAt(p2) != ':') {
                    throw this.newRaiseException(undefinedExceptionClass, RubyStringBuilder.str(this, "undefined class/module ", RubyStringBuilder.ids(this, path2)));
                }
                pbeg = ++p2;
            }
            boolean isJava = c instanceof JavaPackage || JavaClass.isProxyType(context, c);
            IRubyObject iRubyObject = cc = flexibleSearch || isJava ? c.getConstant(str) : c.getConstantAt(str);
            if (!flexibleSearch && cc == null) {
                return null;
            }
            if (!(cc instanceof RubyModule)) {
                throw this.newRaiseException(this.getTypeError(), RubyStringBuilder.str(this, RubyStringBuilder.ids(this, path2), " does not refer to class/module"));
            }
            c = (RubyModule)cc;
        }
        return c;
    }

    public void printError(RubyException ex) {
        if (ex == null) {
            return;
        }
        PrintStream errorStream = this.getErrorStream();
        String backtrace2 = this.config.getTraceType().printBacktrace(ex, errorStream == System.err && this.getPosix().isatty(FileDescriptor.err));
        try {
            errorStream.print(backtrace2);
        }
        catch (Exception e) {
            System.err.print(backtrace2);
        }
    }

    public void printError(Throwable ex) {
        if (ex instanceof RaiseException) {
            this.printError(((RaiseException)ex).getException());
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = this.getErrorStream();
        ex.printStackTrace(new PrintStream(baos));
        try {
            errorStream.write(baos.toByteArray());
        }
        catch (Exception e) {
            try {
                System.err.write(baos.toByteArray());
            }
            catch (IOException ioe) {
                ioe.initCause(e);
                throw new RuntimeException("BUG: could not write exception trace", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String scriptName, InputStream in, boolean wrap2) {
        IRubyObject self2 = wrap2 ? this.getTopSelf().rbClone() : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            context.preNodeEval(self2);
            ParseResult parseResult = this.parseFile(scriptName, in, null);
            if (wrap2) {
                this.wrapWithModule((RubyBasicObject)self2, parseResult);
            }
            this.runInterpreter(context, parseResult, self2);
        }
        finally {
            context.postNodeEval();
        }
    }

    public void loadScope(IRScope scope, boolean wrap2) {
        IRubyObject self2;
        IRubyObject iRubyObject = self2 = wrap2 ? TopSelfFactory.createTopSelf(this, true) : this.getTopSelf();
        if (wrap2) {
            scope.getStaticScope().setModule(RubyModule.newModule(this));
        }
        this.runInterpreter(this.getCurrentContext(), scope, self2);
    }

    public void compileAndLoadFile(String filename2, InputStream in, boolean wrap2) {
        IRubyObject self2 = wrap2 ? this.getTopSelf().rbClone() : this.getTopSelf();
        ParseResult parseResult = this.parseFile(filename2, in, null);
        RootNode root = (RootNode)parseResult;
        if (wrap2) {
            this.wrapWithModule((RubyBasicObject)self2, root);
        } else {
            root.getStaticScope().setModule(this.getObject());
        }
        this.runNormally(root, wrap2);
    }

    private void wrapWithModule(RubyBasicObject self2, ParseResult result2) {
        RubyModule wrapper = RubyModule.newModule(this);
        self2.extend(new IRubyObject[]{wrapper});
        StaticScope top = result2.getStaticScope();
        StaticScope newTop = this.staticScopeFactory.newLocalScope(null);
        top.setPreviousCRefScope(newTop);
        top.setModule(wrapper);
    }

    public void loadScript(Script script) {
        this.loadScript(script, false);
    }

    public void loadScript(Script script, boolean wrap2) {
        script.load(this.getCurrentContext(), this.getTopSelf(), wrap2);
    }

    public void loadExtension(String extName, BasicLibraryService extension, boolean wrap2) {
        IRubyObject self2 = wrap2 ? TopSelfFactory.createTopSelf(this, true) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            context.preExtensionLoad(self2);
            extension.basicLoad(this);
        }
        catch (IOException ioe) {
            throw this.newIOErrorFromException(ioe);
        }
        finally {
            context.postNodeEval();
        }
    }

    public void addBoundMethod(String className, String methodName, String rubyName) {
        Map<String, String> javaToRuby = this.boundMethods.get(className);
        if (javaToRuby == null) {
            javaToRuby = new HashMap<String, String>();
            this.boundMethods.put(className, javaToRuby);
        }
        javaToRuby.put(methodName, rubyName);
    }

    public void addBoundMethods(String className, String ... tuples) {
        Map<String, String> javaToRuby = this.boundMethods.get(className);
        if (javaToRuby == null) {
            javaToRuby = new HashMap<String, String>(tuples.length / 2 + 1, 1.0f);
            this.boundMethods.put(className, javaToRuby);
        }
        for (int i2 = 0; i2 < tuples.length; i2 += 2) {
            javaToRuby.put(tuples[i2], tuples[i2 + 1]);
        }
    }

    @Deprecated
    public void addBoundMethodsPacked(String className, String packedTuples) {
        List<String> names2 = StringSupport.split(packedTuples, ';');
        for (int i2 = 0; i2 < names2.size(); i2 += 2) {
            this.addBoundMethod(className, names2.get(i2), names2.get(i2 + 1));
        }
    }

    @Deprecated
    public void addSimpleBoundMethodsPacked(String className, String packedNames) {
        List<String> names2 = StringSupport.split(packedNames, ';');
        for (String name2 : names2) {
            this.addBoundMethod(className, name2, name2);
        }
    }

    public Map<String, Map<String, String>> getBoundMethods() {
        return this.boundMethods;
    }

    public void setJavaProxyClassFactory(JavaProxyClassFactory factory) {
        this.javaProxyClassFactory = factory;
    }

    public JavaProxyClassFactory getJavaProxyClassFactory() {
        return this.javaProxyClassFactory;
    }

    public synchronized void addEventHook(EventHook hook) {
        if (!RubyInstanceConfig.FULL_TRACE_ENABLED && hook.needsDebug()) {
            this.getWarnings().warn("tracing (e.g. set_trace_func) will not capture all events without --debug flag");
        }
        EventHook[] hooks = this.eventHooks;
        EventHook[] newHooks = Arrays.copyOf(hooks, hooks.length + 1);
        newHooks[hooks.length] = hook;
        this.eventHooks = newHooks;
        this.hasEventHooks = true;
    }

    public synchronized void removeEventHook(EventHook hook) {
        EventHook[] hooks = this.eventHooks;
        if (hooks.length == 0) {
            return;
        }
        int pivot = -1;
        for (int i2 = 0; i2 < hooks.length; ++i2) {
            if (hooks[i2] != hook) continue;
            pivot = i2;
            break;
        }
        if (pivot == -1) {
            return;
        }
        EventHook[] newHooks = new EventHook[hooks.length - 1];
        if (pivot != 0) {
            System.arraycopy(hooks, 0, newHooks, 0, pivot);
        }
        if (pivot != hooks.length - 1) {
            System.arraycopy(hooks, pivot + 1, newHooks, pivot, hooks.length - (pivot + 1));
        }
        this.eventHooks = newHooks;
        this.hasEventHooks = newHooks.length > 0;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.removeEventHook(this.callTraceFuncHook);
        if (traceFunction == null) {
            return;
        }
        this.callTraceFuncHook.setTraceFunc(traceFunction);
        this.addEventHook(this.callTraceFuncHook);
    }

    public void callEventHooks(ThreadContext context, RubyEvent event2, String file2, int line, String name2, IRubyObject type2) {
        if (context.isEventHooksEnabled()) {
            EventHook[] hooks;
            for (EventHook eventHook : hooks = this.eventHooks) {
                if (!eventHook.isInterestedInEvent(event2)) continue;
                IRubyObject klass = context.nil;
                if (type2 instanceof RubyModule) {
                    if (((RubyModule)type2).isIncluded()) {
                        klass = ((RubyModule)type2).getNonIncludedClass();
                    } else if (((RubyModule)type2).isSingleton()) {
                        klass = ((MetaClass)type2).getAttached();
                    }
                }
                eventHook.event(context, event2, file2, line, name2, klass);
            }
        }
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    @Deprecated
    public void setGlobalVariables(GlobalVariables globalVariables) {
    }

    public IRubyObject pushExitBlock(RubyProc proc2) {
        this.atExitBlocks.push(proc2);
        return proc2;
    }

    public void pushEndBlock(RubyProc proc2) {
        if (this.alreadyRegisteredEndBlock(proc2) != null) {
            return;
        }
        this.pushExitBlock(proc2);
    }

    private RubyProc alreadyRegisteredEndBlock(RubyProc newProc) {
        Block block = newProc.getBlock();
        for (RubyProc proc2 : this.atExitBlocks) {
            if (!block.equals(proc2.getBlock())) continue;
            return proc2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers == null) {
                this.internalFinalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.internalFinalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.finalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                this.internalFinalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers != null) {
                this.finalizers.remove(finalizer);
            }
        }
    }

    public void tearDown() {
        this.tearDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tearDown(boolean systemExit) {
        Finalizable f;
        Iterator<Finalizable> finalIter;
        Object trapResultEntries;
        IRubyObject exitHandlerProc;
        int status2 = 0;
        this.mriRecursionGuard = null;
        ThreadContext context = this.getCurrentContext();
        if (!context.hasAnyScopes()) {
            StaticScope topStaticScope = this.getStaticScopeFactory().newLocalScope(null);
            context.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        }
        while (!this.atExitBlocks.empty()) {
            RubyProc proc2 = this.atExitBlocks.pop();
            try {
                proc2.call(context, IRubyObject.NULL_ARRAY);
            }
            catch (RaiseException rj) {
                if (rj.getException() instanceof RubyLocalJumpError) {
                    RubyLocalJumpError rlje = (RubyLocalJumpError)rj.getException();
                    String filename2 = proc2.getBlock().getBinding().filename;
                    if (rlje.getReason() == RubyLocalJumpError.Reason.RETURN) {
                        this.getWarnings().warn(filename2, "unexpected return");
                        continue;
                    }
                    this.getWarnings().warn(filename2, "break from proc-closure");
                    continue;
                }
                RubyException raisedException = rj.getException();
                if (!this.getSystemExit().isInstance(raisedException)) {
                    status2 = 1;
                    this.printError(raisedException);
                    continue;
                }
                IRubyObject statusObj = raisedException.callMethod(context, "status");
                if (statusObj == null || statusObj.isNil()) continue;
                status2 = RubyNumeric.fix2int(statusObj);
            }
            catch (IRReturnJump e) {
                this.getWarnings().warn(proc2.getBlock().getBinding().filename, "unexpected return");
            }
        }
        IRubyObject trapResult = RubySignal.__jtrap_osdefault_kernel(this.getNil(), this.newString("EXIT"));
        if (trapResult instanceof RubyArray && (exitHandlerProc = (trapResultEntries = ((RubyArray)trapResult).toJavaArray())[0]) instanceof RubyProc) {
            ((RubyProc)exitHandlerProc).call(context, this.getSingleNilArray());
        }
        if (this.finalizers != null) {
            trapResultEntries = this.finalizersMutex;
            synchronized (trapResultEntries) {
                finalIter = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
        }
        trapResultEntries = this.internalFinalizersMutex;
        synchronized (trapResultEntries) {
            if (this.internalFinalizers != null) {
                finalIter = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
        }
        this.getBeanManager().unregisterCompiler();
        this.getBeanManager().unregisterConfig();
        this.getBeanManager().unregisterParserStats();
        this.getBeanManager().unregisterMethodCache();
        this.getBeanManager().unregisterRuntime();
        this.getSelectorPool().cleanup();
        if (this.config.isProfilingEntireRun()) {
            ProfileCollection profileCollection = this.threadService.getMainThread().getContext().getProfileCollection();
            this.printProfileData(profileCollection);
        }
        this.threadService = new ThreadService(this);
        this.getJITCompiler().shutdown();
        this.getExecutor().shutdown();
        this.getFiberExecutor().shutdown();
        if (systemExit && status2 != 0) {
            throw this.newSystemExit(status2);
        }
        if (this != globalRuntime) return;
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            if (this != globalRuntime) return;
            globalRuntime = null;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void releaseClassLoader() {
        if (this.jrubyClassLoader != null) {
            this.jrubyClassLoader.close();
        }
    }

    public synchronized void printProfileData(ProfileCollection profileData) {
        this.getProfilingService().newProfileReporter(this.getCurrentContext()).report(profileData);
    }

    private ProfilingServiceLookup getProfilingServiceLookup() {
        return this.profilingServiceLookup;
    }

    public ProfilingService getProfilingService() {
        ProfilingServiceLookup lockup = this.getProfilingServiceLookup();
        return lockup == null ? null : lockup.getService();
    }

    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject ... objects) {
        return RubyArray.newArray(this, objects);
    }

    public RubyArray newArrayNoCopy(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    public RubyArray newArray(List<IRubyObject> list2) {
        return RubyArray.newArray(this, list2);
    }

    public RubyArray newArray(int size2) {
        return RubyArray.newArray(this, size2);
    }

    public RubyArray getEmptyFrozenArray() {
        return this.emptyFrozenArray;
    }

    public RubyBoolean newBoolean(boolean value2) {
        return value2 ? this.trueObject : this.falseObject;
    }

    public RubyFileStat newFileStat(String filename2, boolean lstat2) {
        return RubyFileStat.newFileStat(this, filename2, lstat2);
    }

    public RubyFileStat newFileStat(FileDescriptor descriptor) {
        return RubyFileStat.newFileStat(this, descriptor);
    }

    public RubyFixnum newFixnum(long value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(int value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(Constant value2) {
        return RubyFixnum.newFixnum(this, value2.intValue());
    }

    public RubyFloat newFloat(double value2) {
        return RubyFloat.newFloat(this, value2);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyRational newRational(long num, long den) {
        return RubyRational.newRationalRaw(this, this.newFixnum(num), this.newFixnum(den));
    }

    public RubyRational newRationalReduced(long num, long den) {
        return (RubyRational)RubyRational.newRationalConvert(this.getCurrentContext(), this.newFixnum(num), this.newFixnum(den));
    }

    public RubyProc newProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        return RubyProc.newProc(this, block, type2);
    }

    public RubyProc newBlockPassProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        return RubyProc.newProc(this, block, type2);
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this, this.getCurrentContext().currentBinding());
    }

    public RubyBinding newBinding(Binding binding2) {
        return RubyBinding.newBinding(this, binding2);
    }

    public RubyString newString() {
        return RubyString.newString(this, new ByteList());
    }

    public RubyString newString(String string2) {
        return RubyString.newString(this, string2);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    @Deprecated
    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol newSymbol(String name2, Encoding encoding2) {
        ByteList byteList = RubyString.encodeBytelist(name2, encoding2);
        return this.symbolTable.getSymbol(byteList);
    }

    public RubySymbol newSymbol(ByteList name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol fastNewSymbol(String internedName) {
        return this.symbolTable.fastGetSymbol(internedName);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message2) {
        return this.newRaiseException(this.getRuntimeError(), message2);
    }

    public RaiseException newArgumentError(String message2) {
        return this.newRaiseException(this.getArgumentError(), message2);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newArgumentError(got, expected, expected);
    }

    public RaiseException newArgumentError(int got, int min2, int max2) {
        if (min2 == max2) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ")");
        }
        if (max2 == -1) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + "+)");
        }
        return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ".." + max2 + ")");
    }

    public RaiseException newArgumentError(String name2, int got, int expected) {
        return this.newArgumentError(name2, got, expected, expected);
    }

    public RaiseException newArgumentError(String name2, int got, int min2, int max2) {
        if (min2 == max2) {
            return this.newRaiseException(this.getArgumentError(), RubyStringBuilder.str(this, "wrong number of arguments calling `", RubyStringBuilder.ids(this, name2), "` (given " + got + ", expected " + min2 + ")"));
        }
        if (max2 == -1) {
            return this.newRaiseException(this.getArgumentError(), RubyStringBuilder.str(this, "wrong number of arguments calling `", RubyStringBuilder.ids(this, name2), "` (given " + got + ", expected " + min2 + "+)"));
        }
        return this.newRaiseException(this.getArgumentError(), RubyStringBuilder.str(this, "wrong number of arguments calling `", RubyStringBuilder.ids(this, name2), "` (given " + got + ", expected " + min2 + ".." + max2 + ")"));
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.getErrno().getClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEISCONNError() {
        return this.newRaiseException(this.getErrno().getClass("EISCONN"), "Socket is already connected");
    }

    public RaiseException newErrnoEINPROGRESSError() {
        return this.newRaiseException(this.getErrno().getClass("EINPROGRESS"), "Operation now in progress");
    }

    public RaiseException newErrnoEINPROGRESSWritableError() {
        return this.newLightweightErrnoException(this.getIO().getClass("EINPROGRESSWaitWritable"), "");
    }

    public RaiseException newErrnoENOPROTOOPTError() {
        return this.newRaiseException(this.getErrno().getClass("ENOPROTOOPT"), "Protocol not available");
    }

    public RaiseException newErrnoEPIPEError() {
        return this.newRaiseException(this.getErrno().getClass("EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNABORTEDError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNABORTED"), "An established connection was aborted by the software in your host machine");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoECONNREFUSEDError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ECONNREFUSED"), message2);
    }

    public RaiseException newErrnoECONNRESETError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNRESET"), "Connection reset by peer");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.getErrno().getClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEADDRINUSEError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EADDRINUSE"), message2);
    }

    public RaiseException newErrnoEHOSTUNREACHError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EHOSTUNREACH"), message2);
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.getErrno().getClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoELOOPError() {
        return this.newRaiseException(this.getErrno().getClass("ELOOP"), "Too many levels of symbolic links");
    }

    public RaiseException newErrnoEMFILEError() {
        return this.newRaiseException(this.getErrno().getClass("EMFILE"), "Too many open files");
    }

    public RaiseException newErrnoENFILEError() {
        return this.newRaiseException(this.getErrno().getClass("ENFILE"), "Too many open files in system");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.getErrno().getClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EACCES"), message2);
    }

    public RaiseException newErrnoEAGAINError(String message2) {
        return this.newLightweightErrnoException(this.getErrno().getClass("EAGAIN"), message2);
    }

    public RaiseException newErrnoEAGAINReadableError(String message2) {
        return this.newLightweightErrnoException(this.getIO().getClass("EAGAINWaitReadable"), message2);
    }

    public RaiseException newErrnoEAGAINWritableError(String message2) {
        return this.newLightweightErrnoException(this.getIO().getClass("EAGAINWaitWritable"), message2);
    }

    public RaiseException newErrnoEISDirError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EISDIR"), message2);
    }

    public RaiseException newErrnoEPERMError(String name2) {
        return this.newRaiseException(this.getErrno().getClass("EPERM"), "Operation not permitted - " + name2);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newErrnoEISDirError("Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.getErrno().getClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EBADF"), message2);
    }

    public RaiseException newErrnoEINPROGRESSError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EINPROGRESS"), message2);
    }

    public RaiseException newErrnoEINPROGRESSWritableError(String message2) {
        return this.newLightweightErrnoException(this.getIO().getClass("EINPROGRESSWaitWritable"), message2);
    }

    public RaiseException newErrnoEISCONNError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EISCONN"), message2);
    }

    public RaiseException newErrnoEINVALError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EINVAL"), message2);
    }

    public RaiseException newErrnoENOTDIRError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTDIR"), message2);
    }

    public RaiseException newErrnoENOTEMPTYError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTEMPTY"), message2);
    }

    public RaiseException newErrnoENOTSOCKError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTSOCK"), message2);
    }

    public RaiseException newErrnoENOTCONNError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTCONN"), message2);
    }

    public RaiseException newErrnoENOTCONNError() {
        return this.newRaiseException(this.getErrno().getClass("ENOTCONN"), "Socket is not connected");
    }

    public RaiseException newErrnoENOENTError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOENT"), message2);
    }

    public RaiseException newErrnoEOPNOTSUPPError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EOPNOTSUPP"), message2);
    }

    public RaiseException newErrnoESPIPEError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ESPIPE"), message2);
    }

    public RaiseException newErrnoEEXISTError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EEXIST"), message2);
    }

    public RaiseException newErrnoEDOMError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EDOM"), "Domain error - " + message2);
    }

    public RaiseException newErrnoECHILDError() {
        return this.newRaiseException(this.getErrno().getClass("ECHILD"), "No child processes");
    }

    public RaiseException newErrnoEADDRNOTAVAILError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EADDRNOTAVAIL"), message2);
    }

    public RaiseException newErrnoESRCHError() {
        return this.newRaiseException(this.getErrno().getClass("ESRCH"), null);
    }

    public RaiseException newErrnoEWOULDBLOCKError() {
        return this.newRaiseException(this.getErrno().getClass("EWOULDBLOCK"), null);
    }

    public RaiseException newErrnoEDESTADDRREQError(String func) {
        return this.newRaiseException(this.getErrno().getClass("EDESTADDRREQ"), func);
    }

    public RaiseException newErrnoENETUNREACHError() {
        return this.newRaiseException(this.getErrno().getClass("ENETUNREACH"), null);
    }

    public RaiseException newErrnoEMSGSIZEError() {
        return this.newRaiseException(this.getErrno().getClass("EMSGSIZE"), null);
    }

    public RaiseException newErrnoEXDEVError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EXDEV"), message2);
    }

    public RaiseException newIndexError(String message2) {
        return this.newRaiseException(this.getIndexError(), message2);
    }

    public RaiseException newSecurityError(String message2) {
        return this.newRaiseException(this.getSecurityError(), message2);
    }

    public RaiseException newSystemCallError(String message2) {
        return this.newRaiseException(this.getSystemCallError(), message2);
    }

    public RaiseException newKeyError(String message2, IRubyObject recv2, IRubyObject key2) {
        return new RubyKeyError(this, this.getKeyError(), message2, recv2, key2).toThrowable();
    }

    public RaiseException newErrnoEINTRError() {
        return this.newRaiseException(this.getErrno().getClass("EINTR"), "Interrupted");
    }

    public RaiseException newErrnoEAFNOSUPPORTError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EAFNOSUPPORT"), message2);
    }

    public RaiseException newErrnoFromLastPOSIXErrno() {
        RubyClass errnoClass = this.getErrno(this.getPosix().errno());
        if (errnoClass == null) {
            errnoClass = this.systemCallError;
        }
        return this.newRaiseException(errnoClass, null);
    }

    public RaiseException newErrnoFromInt(int errno2, String methodName, String message2) {
        if (Platform.IS_WINDOWS && ("stat".equals(methodName) || "lstat".equals(methodName))) {
            if (errno2 == 20047) {
                return this.newErrnoENOENTError(message2);
            }
            if (errno2 == Errno.ESRCH.intValue()) {
                return this.newErrnoENOENTError(message2);
            }
        }
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoFromInt(int errno2, String message2) {
        RubyClass errnoClass = this.getErrno(errno2);
        if (errnoClass != null) {
            return this.newRaiseException(errnoClass, message2);
        }
        return this.newSystemCallError("Unknown Error (" + errno2 + ") - " + message2);
    }

    public RaiseException newErrnoFromErrno(Errno errno2, String message2) {
        if (errno2 == null || errno2 == Errno.__UNKNOWN_CONSTANT__) {
            return this.newSystemCallError(message2);
        }
        return this.newErrnoFromInt(errno2.intValue(), message2);
    }

    public RaiseException newErrnoFromInt(int errno2) {
        Errno errnoObj = Errno.valueOf(errno2);
        if (errnoObj == null) {
            return this.newSystemCallError("Unknown Error (" + errno2 + ")");
        }
        String message2 = errnoObj.description();
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoEADDRFromBindException(BindException be) {
        return this.newErrnoEADDRFromBindException(be, null);
    }

    public RaiseException newErrnoEADDRFromBindException(BindException be, String contextMessage) {
        String msg = be.getMessage();
        msg = msg == null ? "bind" : "bind - " + msg;
        if (contextMessage != null) {
            msg = msg + contextMessage;
        }
        if (ADDR_NOT_AVAIL_PATTERN.matcher(msg).find()) {
            return this.newErrnoEADDRNOTAVAILError(msg);
        }
        return this.newErrnoEADDRINUSEError(msg);
    }

    public RaiseException newTypeError(String message2) {
        return this.newRaiseException(this.getTypeError(), message2);
    }

    public RaiseException newThreadError(String message2) {
        return this.newRaiseException(this.getThreadError(), message2);
    }

    public RaiseException newConcurrencyError(String message2) {
        return this.newRaiseException(this.getConcurrencyError(), message2);
    }

    public RaiseException newSyntaxError(String message2) {
        return this.newRaiseException(this.getSyntaxError(), message2);
    }

    public RaiseException newRegexpError(String message2) {
        return this.newRaiseException(this.getRegexpError(), message2);
    }

    public RaiseException newInterruptedRegexpError(String message2) {
        return this.newRaiseException(this.getInterruptedRegexpError(), message2);
    }

    public RaiseException newRangeError(String message2) {
        return this.newRaiseException(this.getRangeError(), message2);
    }

    public RaiseException newNotImplementedError(String message2) {
        return this.newRaiseException(this.getNotImplementedError(), message2);
    }

    @Deprecated
    public RaiseException newInvalidEncoding(String message2) {
        return this.newRaiseException(this.getClass("Iconv").getClass("InvalidEncoding"), message2);
    }

    @Deprecated
    public RaiseException newIllegalSequence(String message2) {
        return this.newRaiseException(this.getClass("Iconv").getClass("IllegalSequence"), message2);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, IRubyObject name2) {
        return this.newNameError(message2, recv2, name2, false);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, IRubyObject name2, boolean privateCall) {
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(this, message2, recv2, name2);
        RubyException err = RubyNameError.newNameError(this.getNameError(), msg, name2, privateCall);
        return err.toThrowable();
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, String name2) {
        return this.newNameError(message2, recv2, name2, false);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, String name2, boolean privateCall) {
        RubySymbol nameSym = this.newSymbol(name2);
        return this.newNameError(message2, recv2, nameSym, privateCall);
    }

    public RaiseException newNameError(String message2, String name2, Throwable exception2, boolean printWhenVerbose) {
        if (exception2 != null) {
            if (printWhenVerbose && this.isVerbose()) {
                LOG.error(exception2);
            } else if (this.isDebug()) {
                LOG.debug(exception2);
            }
        }
        return new RubyNameError(this, this.getNameError(), message2, name2).toThrowable();
    }

    public RaiseException newNameError(String message2, String name2) {
        return this.newNameError(message2, name2, null);
    }

    public RaiseException newNameError(String message2, String name2, Throwable origException) {
        return this.newNameError(message2, name2, origException, false);
    }

    public RaiseException newNoMethodError(String message2, IRubyObject recv2, String name2, RubyArray args2) {
        return this.newNoMethodError(message2, recv2, name2, args2, false);
    }

    public RaiseException newNoMethodError(String message2, IRubyObject recv2, String name2, RubyArray args2, boolean privateCall) {
        RubySymbol nameStr = this.newSymbol(name2);
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(this, message2, recv2, nameStr);
        RubyException err = RubyNoMethodError.newNoMethodError(this.getNoMethodError(), msg, nameStr, args2, privateCall);
        return err.toThrowable();
    }

    public RaiseException newNoMethodError(String message2, String name2, IRubyObject args2) {
        return new RubyNoMethodError(this, this.getNoMethodError(), message2, name2, args2).toThrowable();
    }

    public RaiseException newLocalJumpError(RubyLocalJumpError.Reason reason2, IRubyObject exitValue, String message2) {
        return new RubyLocalJumpError(this, this.getLocalJumpError(), message2, reason2, exitValue).toThrowable();
    }

    public RaiseException newLocalJumpErrorNoBlock() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, this.getNil(), "no block given");
    }

    public RaiseException newRedoLocalJumpError() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.REDO, this.getNil(), "unexpected redo");
    }

    public RaiseException newLoadError(String message2) {
        return this.newRaiseException(this.getLoadError(), message2);
    }

    public RaiseException newLoadError(String message2, String path2) {
        RaiseException loadError = this.newRaiseException(this.getLoadError(), message2);
        loadError.getException().setInstanceVariable("@path", this.newString(path2));
        return loadError;
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newFrozenError(objectType, false);
    }

    public RaiseException newFrozenError(RubyModule type2) {
        return this.newRaiseException(this.getFrozenError(), RubyStringBuilder.str(this, "can't modify frozen ", RubyStringBuilder.types(this, type2)));
    }

    public RaiseException newFrozenError(String objectType, boolean runtimeError) {
        return this.newRaiseException(this.getFrozenError(), RubyStringBuilder.str(this, "can't modify frozen ", RubyStringBuilder.ids(this, objectType)));
    }

    public RaiseException newSystemStackError(String message2) {
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemStackError(String message2, StackOverflowError error2) {
        if (this.isDebug()) {
            LOG.debug(error2);
        }
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemExit(int status2) {
        return RubySystemExit.newInstance(this, status2, "exit").toThrowable();
    }

    public RaiseException newSystemExit(int status2, String message2) {
        return RubySystemExit.newInstance(this, status2, message2).toThrowable();
    }

    public RaiseException newIOError(String message2) {
        return this.newRaiseException(this.getIOError(), message2);
    }

    public RaiseException newStandardError(String message2) {
        return this.newRaiseException(this.getStandardError(), message2);
    }

    public RaiseException newIOErrorFromException(IOException ex) {
        return Helpers.newIOErrorFromException(this, ex);
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newTypeError(receivedObject, expectedType.getName());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyModule expectedType) {
        return this.newTypeError(receivedObject, expectedType.getName());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, String expectedType) {
        return this.newRaiseException(this.getTypeError(), RubyStringBuilder.str(this, "wrong argument type ", receivedObject.getMetaClass().getRealClass().toRubyString(this.getCurrentContext()), " (expected ", RubyStringBuilder.ids(this, expectedType), ")"));
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getEOFError(), "End of file reached");
    }

    public RaiseException newEOFError(String message2) {
        return this.newRaiseException(this.getEOFError(), message2);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getZeroDivisionError(), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message2) {
        return this.newRaiseException(this.getFloatDomainError(), message2);
    }

    public RaiseException newMathDomainError(String message2) {
        return this.newRaiseException(this.getMathDomainError(), "Numerical argument is out of domain - \"" + message2 + "\"");
    }

    public RaiseException newEncodingError(String message2) {
        return this.newRaiseException(this.getEncodingError(), message2);
    }

    public RaiseException newEncodingCompatibilityError(String message2) {
        return this.newRaiseException(this.getEncodingCompatibilityError(), message2);
    }

    public RaiseException newConverterNotFoundError(String message2) {
        return this.newRaiseException(this.getConverterNotFoundError(), message2);
    }

    public RaiseException newFiberError(String message2) {
        return this.newRaiseException(this.getFiberError(), message2);
    }

    public RaiseException newUndefinedConversionError(String message2) {
        return this.newRaiseException(this.getUndefinedConversionError(), message2);
    }

    public RaiseException newInvalidByteSequenceError(String message2) {
        return this.newRaiseException(this.getInvalidByteSequenceError(), message2);
    }

    public RaiseException newRaiseException(RubyClass exceptionClass, String message2) {
        return RaiseException.from(this, exceptionClass, message2);
    }

    private RaiseException newLightweightErrnoException(RubyClass exceptionClass, String message2) {
        if (RubyInstanceConfig.ERRNO_BACKTRACE) {
            return RaiseException.from(this, exceptionClass, message2);
        }
        return RaiseException.from(this, exceptionClass, ERRNO_BACKTRACE_MESSAGE, this.disabledBacktrace());
    }

    public RaiseException newStopIteration(IRubyObject result2, String message2) {
        ThreadContext context = this.getCurrentContext();
        if (message2 == null) {
            message2 = STOPIERATION_BACKTRACE_MESSAGE;
        }
        RubyStopIteration ex = RubyStopIteration.newInstance(context, result2, message2);
        if (!RubyInstanceConfig.STOPITERATION_BACKTRACE) {
            ex.setBacktrace(this.disabledBacktrace());
        }
        return ex.toThrowable();
    }

    @Deprecated
    public RaiseException newLightweightStopIterationError(String message2) {
        return this.newStopIteration(null, message2);
    }

    private IRubyObject disabledBacktrace() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyObject.Data newData(RubyClass objectClass, Object sval) {
        return new RubyObject.Data(this, objectClass, sval);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable2) {
        this.globalAbortOnExceptionEnabled = enable2;
    }

    public IRubyObject getReportOnException() {
        return this.reportOnException;
    }

    public void setReportOnException(IRubyObject enable2) {
        this.reportOnException = enable2;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b2) {
        this.doNotReverseLookupEnabled = b2;
    }

    public void registerInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val == null) {
            val = new IdentityHashMap<Object, Object>(8);
            this.inspect.set(val);
        }
        val.put(obj, null);
    }

    public boolean isInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        return val == null ? false : val.containsKey(obj);
    }

    public void unregisterInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val != null) {
            val.remove(obj);
        }
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setObjectSpaceEnabled(boolean objectSpaceEnabled) {
        this.objectSpaceEnabled = objectSpaceEnabled;
    }

    public boolean isSiphashEnabled() {
        return this.siphashEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        return this.config.getJRubyHome();
    }

    public void setJRubyHome(String home2) {
        this.config.setJRubyHome(home2);
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    @Deprecated
    public boolean is2_0() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long getGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void incGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean restricted) {
        securityRestricted = restricted;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public void setRecordSeparatorVar(GlobalVariable recordSeparatorVar) {
        this.recordSeparatorVar = recordSeparatorVar;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getFiberExecutor() {
        return this.fiberExecutor;
    }

    public Map<String, DateTimeZone> getTimezoneCache() {
        return this.timeZoneCache;
    }

    @Deprecated
    public int getConstantGeneration() {
        return -1;
    }

    public Invalidator getConstantInvalidator(String constantName) {
        Invalidator invalidator = this.constantNameInvalidators.get(constantName);
        if (invalidator != null) {
            return invalidator;
        }
        return this.addConstantInvalidator(constantName);
    }

    private Invalidator addConstantInvalidator(String constantName) {
        Invalidator invalidator = OptoFactory.newConstantInvalidator(this);
        this.constantNameInvalidators.putIfAbsent(constantName, invalidator);
        return this.constantNameInvalidators.get(constantName);
    }

    public Invalidator getCheckpointInvalidator() {
        return this.checkpointInvalidator;
    }

    public <E extends Enum<E>> void loadConstantSet(RubyModule module, Class<E> enumClass) {
        for (Enum e : EnumSet.allOf(enumClass)) {
            Constant c = (Constant)((Object)e);
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.setConstant(c.name(), this.newFixnum(c.intValue()));
        }
    }

    public void loadConstantSet(RubyModule module, String constantSetName) {
        for (Constant c : ConstantSet.getConstantSet(constantSetName)) {
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.setConstant(c.name(), this.newFixnum(c.intValue()));
        }
    }

    public long getNextDynamicMethodSerial() {
        return this.dynamicMethodSerial.getAndIncrement();
    }

    public int getNextModuleGeneration() {
        return this.moduleGeneration.incrementAndGet();
    }

    public Object getHierarchyLock() {
        return this.hierarchyLock;
    }

    public SelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public RuntimeCache getRuntimeCache() {
        return this.runtimeCache;
    }

    public List<StrptimeToken> getCachedStrptimePattern(String pattern) {
        List<StrptimeToken> tokens = this.strptimeFormatCache.get(pattern);
        if (tokens == null) {
            tokens = new StrptimeParser().compilePattern(pattern);
            this.strptimeFormatCache.put(pattern, tokens);
        }
        return tokens;
    }

    void addProfiledMethod(String id2, DynamicMethod method2) {
        if (!this.config.isProfiling() || method2.isUndefined()) {
            return;
        }
        this.getProfilingService().addProfiledMethod(id2, method2);
    }

    public void incrementExceptionCount() {
        this.exceptionCount.incrementAndGet();
    }

    public int getExceptionCount() {
        return this.exceptionCount.get();
    }

    public void incrementBacktraceCount() {
        this.backtraceCount.incrementAndGet();
    }

    public int getBacktraceCount() {
        return this.backtraceCount.get();
    }

    public void incrementWarningCount() {
        this.warningCount.incrementAndGet();
    }

    public int getWarningCount() {
        return this.warningCount.get();
    }

    public void incrementCallerCount() {
        this.callerCount.incrementAndGet();
    }

    public int getCallerCount() {
        return this.callerCount.get();
    }

    @Deprecated
    public void reopenFixnum() {
        this.fixnumInvalidator.invalidate();
        this.fixnumReopened = true;
    }

    @Deprecated
    public Invalidator getFixnumInvalidator() {
        return this.fixnumInvalidator;
    }

    @Deprecated
    public boolean isFixnumReopened() {
        return this.fixnumReopened;
    }

    @Deprecated
    public void reopenFloat() {
        this.floatInvalidator.invalidate();
        this.floatReopened = true;
    }

    @Deprecated
    public Invalidator getFloatInvalidator() {
        return this.floatInvalidator;
    }

    @Deprecated
    public boolean isFloatReopened() {
        return this.floatReopened;
    }

    public boolean isBootingCore() {
        return !this.coreIsBooted;
    }

    public boolean isBooting() {
        return !this.runtimeIsBooted;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public Random getRandom() {
        return this.random;
    }

    public long getHashSeedK0() {
        return this.hashSeedK0;
    }

    public long getHashSeedK1() {
        return this.hashSeedK1;
    }

    public StaticScopeFactory getStaticScopeFactory() {
        return this.staticScopeFactory;
    }

    public FFI getFFI() {
        return this.ffi;
    }

    public void setFFI(FFI ffi2) {
        this.ffi = ffi2;
    }

    public RubyString getDefinedMessage(DefinedMessage definedMessage) {
        return this.definedMessages.get((Object)definedMessage);
    }

    public RubyString getThreadStatus(RubyThread.Status status2) {
        return this.threadStatuses.get((Object)status2);
    }

    public RubyString freezeAndDedupString(RubyString string2) {
        RubyString deduped;
        if (string2.getMetaClass() != this.stringClass) {
            RubyString duped = string2.strDup(this);
            duped.setFrozen(true);
            return duped;
        }
        FStringEqual wrapper = this.DEDUP_WRAPPER_CACHE.get();
        wrapper.string = string2;
        WeakReference dedupedRef = this.dedupMap.get(wrapper);
        if (dedupedRef == null || (deduped = (RubyString)dedupedRef.get()) == null) {
            this.DEDUP_WRAPPER_CACHE.remove();
            deduped = string2.strDup(this);
            deduped.setFrozen(true);
            WeakReference<RubyString> weakref = new WeakReference<RubyString>(deduped);
            wrapper.string = deduped;
            dedupedRef = this.dedupMap.computeIfAbsent(wrapper, key2 -> weakref);
            if (dedupedRef == null) {
                return deduped;
            }
            RubyString unduped = (RubyString)dedupedRef.get();
            if (unduped != null) {
                return unduped;
            }
            do {
                wrapper.string = string2;
            } while ((unduped = (RubyString)(dedupedRef = this.dedupMap.computeIfPresent(wrapper, (key2, old) -> old.get() == null ? weakref : old)).get()) == null);
            return unduped;
        }
        wrapper.string = null;
        return deduped;
    }

    public int getRuntimeNumber() {
        return this.runtimeNumber;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    public void setBaseNewMethod(DynamicMethod baseNewMethod) {
        this.baseNewMethod = baseNewMethod;
    }

    public DynamicMethod getBaseNewMethod() {
        return this.baseNewMethod;
    }

    public MethodHandle getNullToNilHandle() {
        MethodHandle nullToNil = this.nullToNil;
        if (nullToNil != null) {
            return nullToNil;
        }
        nullToNil = InvokeDynamicSupport.findStatic(Helpers.class, "nullToNil", MethodType.methodType(IRubyObject.class, IRubyObject.class, IRubyObject.class));
        nullToNil = MethodHandles.insertArguments(nullToNil, 1, this.nilObject);
        this.nullToNil = nullToNil = MethodHandles.explicitCastArguments(nullToNil, MethodType.methodType(IRubyObject.class, Object.class));
        return this.nullToNil;
    }

    private void addLoadParseToStats() {
        if (this.parserStats != null) {
            this.parserStats.addLoadParse();
        }
    }

    private void addEvalParseToStats() {
        if (this.parserStats != null) {
            this.parserStats.addEvalParse();
        }
    }

    public FilenoUtil getFilenoUtil() {
        return this.filenoUtil;
    }

    public RubyClass getData() {
        return this.dataClass;
    }

    public Map<Class, Consumer<RubyModule>> getJavaExtensionDefinitions() {
        return this.javaExtensionDefinitions;
    }

    @Deprecated
    public int getSafeLevel() {
        return 0;
    }

    @Deprecated
    public void setSafeLevel(int safeLevel) {
    }

    @Deprecated
    public void checkSafeString(IRubyObject object) {
    }

    @Deprecated
    public void secure(int level2) {
    }

    @Deprecated
    public RaiseException newNameErrorObject(String message2, IRubyObject name2) {
        RubyNameError error2 = new RubyNameError(this, this.getNameError(), message2, name2);
        return error2.toThrowable();
    }

    @Deprecated
    public boolean is1_8() {
        return false;
    }

    @Deprecated
    public boolean is1_9() {
        return true;
    }

    @Deprecated
    public IRubyObject safeRecurse(RecursiveFunction func, IRubyObject obj, String name2, boolean outer) {
        return this.safeRecurse(LEGACY_RECURSE, this.getCurrentContext(), func, obj, name2, outer);
    }

    @Deprecated
    public ProfiledMethods getProfiledMethods() {
        return new ProfiledMethods(this);
    }

    @Deprecated
    public <T> IRubyObject safeRecurse(RecursiveFunctionEx<T> func, ThreadContext context, T state2, IRubyObject obj, String name2, boolean outer) {
        return context.safeRecurse(func, state2, obj, name2, outer);
    }

    @Deprecated
    public IRubyObject execRecursive(RecursiveFunction func, IRubyObject obj) {
        return this.oldRecursionGuard().execRecursive(func, obj);
    }

    @Deprecated
    public IRubyObject execRecursiveOuter(RecursiveFunction func, IRubyObject obj) {
        return this.oldRecursionGuard().execRecursiveOuter(func, obj);
    }

    @Deprecated
    public <T extends IRubyObject> T recursiveListOperation(Callable<T> body) {
        return this.oldRecursionGuard().recursiveListOperation(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private MRIRecursionGuard oldRecursionGuard() {
        MRIRecursionGuard mriRecursionGuard = this.mriRecursionGuard;
        if (mriRecursionGuard != null) {
            return mriRecursionGuard;
        }
        Ruby ruby = this;
        synchronized (ruby) {
            mriRecursionGuard = this.mriRecursionGuard;
            if (mriRecursionGuard != null) {
                return mriRecursionGuard;
            }
            mriRecursionGuard = new MRIRecursionGuard(this);
            return mriRecursionGuard;
        }
    }

    @Deprecated
    public IRubyObject getRootFiber() {
        return this.rootFiber;
    }

    @Deprecated
    public void setRootFiber(IRubyObject fiber2) {
        this.rootFiber = fiber2;
    }

    @Deprecated
    void setKernel(RubyModule kernelModule) {
    }

    @Deprecated
    void setComparable(RubyModule comparableModule) {
    }

    @Deprecated
    void setNumeric(RubyClass numericClass) {
    }

    @Deprecated
    void setFloat(RubyClass floatClass) {
    }

    @Deprecated
    void setInteger(RubyClass integerClass) {
    }

    @Deprecated
    void setFixnum(RubyClass fixnumClass) {
    }

    @Deprecated
    void setComplex(RubyClass complexClass) {
    }

    @Deprecated
    void setRational(RubyClass rationalClass) {
    }

    @Deprecated
    void setEnumerable(RubyModule enumerableModule) {
    }

    @Deprecated
    void setEnumerator(RubyClass enumeratorClass) {
    }

    @Deprecated
    void setYielder(RubyClass yielderClass) {
    }

    @Deprecated
    public void setGenerator(RubyClass generatorClass) {
    }

    @Deprecated
    public void setFiber(RubyClass fiberClass) {
    }

    @Deprecated
    void setString(RubyClass stringClass) {
    }

    @Deprecated
    void setEncoding(RubyClass encodingClass) {
    }

    @Deprecated
    void setConverter(RubyClass converterClass) {
    }

    @Deprecated
    void setSymbol(RubyClass symbolClass) {
    }

    @Deprecated
    void setArray(RubyClass arrayClass) {
    }

    @Deprecated
    void setHash(RubyClass hashClass) {
    }

    @Deprecated
    void setRange(RubyClass rangeClass) {
    }

    @Deprecated
    void setNilClass(RubyClass nilClass) {
    }

    @Deprecated
    void setTrueClass(RubyClass trueClass) {
    }

    @Deprecated
    void setFalseClass(RubyClass falseClass) {
    }

    @Deprecated
    void setProc(RubyClass procClass) {
    }

    @Deprecated
    void setBinding(RubyClass bindingClass) {
    }

    @Deprecated
    void setMethod(RubyClass methodClass) {
    }

    @Deprecated
    void setUnboundMethod(RubyClass unboundMethodClass) {
    }

    @Deprecated
    void setMatchData(RubyClass matchDataClass) {
    }

    @Deprecated
    void setRegexp(RubyClass regexpClass) {
    }

    @Deprecated
    void setTime(RubyClass timeClass) {
    }

    @Deprecated
    void setMath(RubyModule mathModule) {
    }

    @Deprecated
    void setMarshal(RubyModule marshalModule) {
    }

    @Deprecated
    void setBignum(RubyClass bignumClass) {
    }

    @Deprecated
    void setDir(RubyClass dirClass) {
    }

    @Deprecated
    void setFile(RubyClass fileClass) {
    }

    @Deprecated
    void setFileStat(RubyClass fileStatClass) {
    }

    @Deprecated
    void setFileTest(RubyModule fileTestModule) {
    }

    @Deprecated
    void setIO(RubyClass ioClass) {
    }

    @Deprecated
    void setThread(RubyClass threadClass) {
    }

    @Deprecated
    void setThreadGroup(RubyClass threadGroupClass) {
    }

    @Deprecated
    void setContinuation(RubyClass continuationClass) {
    }

    @Deprecated
    void setStructClass(RubyClass structClass) {
    }

    @Deprecated
    void setRandomClass(RubyClass randomClass) {
    }

    @Deprecated
    void setGC(RubyModule gcModule) {
    }

    @Deprecated
    void setObjectSpaceModule(RubyModule objectSpaceModule) {
    }

    @Deprecated
    void setProcess(RubyModule processModule) {
    }

    @Deprecated
    public void setWarning(RubyModule warningModule) {
    }

    @Deprecated
    void setException(RubyClass exceptionClass) {
    }

    public void addToObjectSpace(boolean useObjectSpace, IRubyObject object) {
        this.objectSpacer.addToObjectSpace(this, useObjectSpace, object);
    }

    @Deprecated
    private void setNetworkStack() {
        this.deprecatedNetworkStackProperty();
    }

    private void deprecatedNetworkStackProperty() {
        if (Options.PREFER_IPV4.load().booleanValue()) {
            LOG.warn("Warning: not setting network stack system property because socket subsystem may already be booted.If you need this option please set it manually as a JVM property.\nUse JAVA_OPTS=-Djava.net.preferIPv4Stack=true OR prepend -J as a JRuby option.", new Object[0]);
        }
    }

    static {
        if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
            LOG.setDebugEnable(true);
        }
        interest = EnumSet.of(RubyEvent.C_CALL, new RubyEvent[]{RubyEvent.C_RETURN, RubyEvent.CALL, RubyEvent.CLASS, RubyEvent.END, RubyEvent.LINE, RubyEvent.RAISE, RubyEvent.RETURN});
        ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
        LEGACY_RECURSE = new RecursiveFunctionEx<RecursiveFunction>(){

            @Override
            public IRubyObject call(ThreadContext context, RecursiveFunction func, IRubyObject obj, boolean recur) {
                return func.call(obj, recur);
            }
        };
        EMPTY_HOOKS = new EventHook[0];
        securityRestricted = false;
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflected.handles")) {
            securityRestricted = true;
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkCreateClassLoader();
                }
                catch (SecurityException se) {
                    securityRestricted = true;
                }
            }
        }
        threadLocalRuntime = new ThreadLocal();
        DISABLED_OBJECTSPACE = new ObjectSpacer(){

            @Override
            public void addToObjectSpace(Ruby runtime2, boolean useObjectSpace, IRubyObject object) {
            }
        };
        ENABLED_OBJECTSPACE = new ObjectSpacer(){

            @Override
            public void addToObjectSpace(Ruby runtime2, boolean useObjectSpace, IRubyObject object) {
                if (useObjectSpace) {
                    runtime2.objectSpace.add(object);
                }
            }
        };
        RUNTIME_NUMBER = new AtomicInteger(0);
    }

    public static interface ObjectSpacer {
        public void addToObjectSpace(Ruby var1, boolean var2, IRubyObject var3);
    }

    @Deprecated
    public static interface RecursiveFunction
    extends MRIRecursionGuard.RecursiveFunction {
    }

    public static interface RecursiveFunctionEx<T>
    extends ThreadContext.RecursiveFunctionEx<T> {
        @Override
        public IRubyObject call(ThreadContext var1, T var2, IRubyObject var3, boolean var4);
    }

    static class FStringEqual {
        RubyString string;

        FStringEqual() {
        }

        public boolean equals(Object other) {
            if (other instanceof FStringEqual) {
                RubyString otherString = ((FStringEqual)other).string;
                RubyString string2 = this.string;
                if (string2 == null || otherString == null) {
                    return false;
                }
                return string2.equals(otherString) && string2.getEncoding() == otherString.getEncoding();
            }
            return false;
        }

        public int hashCode() {
            RubyString string2 = this.string;
            if (string2 == null) {
                return 0;
            }
            return string2.hashCode();
        }
    }

    public static class CallTraceFuncHook
    extends EventHook {
        private RubyProc traceFunc;

        public void setTraceFunc(RubyProc traceFunc) {
            this.traceFunc = traceFunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (!context.isWithinTrace()) {
                if (file2 == null) {
                    file2 = "(ruby)";
                }
                if (type2 == null) {
                    type2 = context.nil;
                }
                Ruby runtime2 = context.runtime;
                RubyBinding binding2 = RubyBinding.newBinding(runtime2, context.currentBinding());
                switch (eventName) {
                    case "c_return": {
                        eventName = "c-return";
                        break;
                    }
                    case "c_call": {
                        eventName = "c-call";
                    }
                }
                context.preTrace();
                try {
                    this.traceFunc.call(context, runtime2.newString(eventName), runtime2.newString(file2), runtime2.newFixnum(line), name2 != null ? runtime2.newSymbol(name2) : runtime2.getNil(), binding2, type2);
                }
                finally {
                    context.postTrace();
                }
            }
        }

        @Override
        public boolean isInterestedInEvent(RubyEvent event2) {
            return interest.contains((Object)event2);
        }

        public EnumSet<RubyEvent> eventSet() {
            return interest;
        }
    }
}

