/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.encoding;

import java.io.Console;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.ISO8859_16Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.ext.nkf.RubyNKF;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.encoding.ISO_8859_16;

public final class EncodingService {
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> encodings;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> aliases;
    public final IRubyObject[] encodingList;
    private RubyEncoding[] encodingIndex = new RubyEncoding[4];
    private final Ruby runtime;
    private final Encoding ascii8bit;
    private final Encoding javaDefault;
    private static final ByteList LOCALE_BL = ByteList.create("locale");
    private static final ByteList EXTERNAL_BL = ByteList.create("external");
    private static final ByteList INTERNAL_BL = ByteList.create("internal");
    private static final ByteList FILESYSTEM_BL = ByteList.create("filesystem");

    public EncodingService(Ruby runtime) {
        this.runtime = runtime;
        this.encodings = EncodingDB.getEncodings();
        this.aliases = EncodingDB.getAliases();
        this.ascii8bit = this.encodings.get("ASCII-8BIT".getBytes()).getEncoding();
        Charset javaDefaultCharset = Charset.defaultCharset();
        ByteList javaDefaultBL = new ByteList(javaDefaultCharset.name().getBytes());
        EncodingDB.Entry javaDefaultEntry = this.findEncodingOrAliasEntry(javaDefaultBL);
        this.javaDefault = javaDefaultEntry == null ? this.ascii8bit : javaDefaultEntry.getEncoding();
        this.encodingList = new IRubyObject[this.encodings.size()];
    }

    public Encoding getConsoleEncoding() {
        if (!Platform.IS_WINDOWS) {
            return null;
        }
        Encoding consoleEncoding = null;
        try {
            Console console = System.console();
            if (console != null) {
                String CONSOLE_CHARSET = "cs";
                Field fcs = Console.class.getDeclaredField("cs");
                fcs.setAccessible(true);
                Charset cs = (Charset)fcs.get(console);
                consoleEncoding = this.loadEncoding(ByteList.create(cs.name()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return consoleEncoding;
    }

    public Encoding getUSAsciiEncoding() {
        return USASCIIEncoding.INSTANCE;
    }

    public Encoding getAscii8bitEncoding() {
        return this.ascii8bit;
    }

    public Encoding getFileSystemEncoding(Ruby runtime) {
        return SpecialEncoding.FILESYSTEM.toEncoding(runtime);
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getEncodings() {
        return this.encodings;
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getAliases() {
        return this.aliases;
    }

    public EncodingDB.Entry findEncodingEntry(ByteList bytes2) {
        return this.encodings.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findEncodingEntry(byte[] bytes2) {
        return this.encodings.get(bytes2);
    }

    public EncodingDB.Entry findAliasEntry(ByteList bytes2) {
        return this.aliases.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findAliasEntry(byte[] bytes2) {
        return this.aliases.get(bytes2);
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(byte[] bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public Encoding getLocaleEncoding() {
        Encoding consoleEncoding = this.getConsoleEncoding();
        if (consoleEncoding != null) {
            return consoleEncoding;
        }
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(new ByteList(Charset.defaultCharset().name().getBytes()));
        return entry == null ? ASCIIEncoding.INSTANCE : entry.getEncoding();
    }

    public IRubyObject[] getEncodingList() {
        return this.encodingList;
    }

    public Encoding loadEncoding(ByteList name2) {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(name2);
        if (entry == null) {
            return null;
        }
        Encoding enc = entry.getEncoding();
        int index2 = enc.getIndex();
        if (index2 >= this.encodingIndex.length) {
            RubyEncoding[] tmp = new RubyEncoding[index2 + 4];
            System.arraycopy(this.encodingIndex, 0, tmp, 0, this.encodingIndex.length);
            this.encodingIndex = tmp;
        }
        this.encodingIndex[index2] = (RubyEncoding)this.encodingList[entry.getIndex()];
        return enc;
    }

    public RubyEncoding getEncoding(Encoding enc) {
        RubyEncoding rubyEncoding;
        int index2 = enc.getIndex();
        if (index2 < this.encodingIndex.length && (rubyEncoding = this.encodingIndex[index2]) != null) {
            return rubyEncoding;
        }
        enc = this.loadEncoding(new ByteList(enc.getName(), false));
        return this.encodingIndex[enc.getIndex()];
    }

    public void defineEncodings() {
        this.defineEncodings(new EncodingDefinitionVisitor(){

            @Override
            public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name2, int p2, int end2) {
                RubyEncoding encoding2 = RubyEncoding.newEncoding(EncodingService.this.runtime, name2, p2, end2, encodingEntry.isDummy());
                EncodingService.this.encodingList[encodingEntry.getIndex()] = encoding2;
            }

            @Override
            public void defineConstant(int encodingListIndex, String constName) {
                EncodingService.this.defineEncodingConstant(EncodingService.this.runtime, (RubyEncoding)EncodingService.this.encodingList[encodingListIndex], constName);
            }
        });
    }

    public void defineEncodings(EncodingDefinitionVisitor visitor) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)hei).next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            visitor.defineEncoding(ee, e.bytes, e.p, e.end);
            for (String constName : this.encodingNames(e.bytes, e.p, e.end)) {
                visitor.defineConstant(ee.getIndex(), constName);
            }
        }
    }

    public void defineAliases() {
        this.defineAliases(new EncodingAliasVisitor(){

            @Override
            public void defineAlias(int encodingListIndex, String constName) {
            }

            @Override
            public void defineConstant(int encodingListIndex, String constName) {
                EncodingService.this.defineEncodingConstant(EncodingService.this.runtime, (RubyEncoding)EncodingService.this.encodingList[encodingListIndex], constName);
            }
        });
    }

    public void defineAliases(EncodingAliasVisitor visitor) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.aliases.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)hei).next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            for (String constName : this.encodingNames(e.bytes, e.p, e.end)) {
                visitor.defineAlias(ee.getIndex(), constName);
                visitor.defineConstant(ee.getIndex(), constName);
            }
        }
    }

    private List<String> encodingNames(byte[] name2, int p2, int end2) {
        ArrayList<String> names2 = new ArrayList<String>();
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s2 = p2;
        int code = name2[s2] & 0xFF;
        if (enc.isDigit(code)) {
            return names2;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s2 < end2 && (enc.isAlnum(name2[s2] & 0xFF) || name2[s2] == 95)) {
                if (!enc.isLower(name2[s2] & 0xFF)) continue;
                hasLower = true;
            }
        }
        boolean isValid = false;
        if (s2 >= end2) {
            isValid = true;
            names2.add(new String(name2, p2, end2));
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name2[s2] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s2 < end2 && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end2 - p2];
            System.arraycopy(name2, p2, constName, 0, end2 - p2);
            s2 = 0;
            code = constName[s2] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s2 < constName.length) {
                    if (!enc.isAlnum(constName[s2] & 0xFF)) {
                        constName[s2] = 95;
                    }
                    ++s2;
                }
                if (hasUpper) {
                    names2.add(new String(constName, 0, constName.length));
                }
            }
            if (hasLower) {
                for (s2 = 0; s2 < constName.length; ++s2) {
                    code = constName[s2] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                names2.add(new String(constName, 0, constName.length));
            }
        }
        return names2;
    }

    private void defineEncodingConstant(Ruby runtime, RubyEncoding encoding2, String constName) {
        runtime.getEncoding().defineConstant(constName, encoding2);
    }

    public IRubyObject getDefaultExternal() {
        IRubyObject defaultExternal = this.convertEncodingToRubyEncoding(this.runtime.getDefaultExternalEncoding());
        if (defaultExternal.isNil()) {
            ByteList encodingName = ByteList.create("US-ASCII");
            Encoding encoding2 = this.runtime.getEncodingService().loadEncoding(encodingName);
            this.runtime.setDefaultExternalEncoding(encoding2);
            defaultExternal = this.convertEncodingToRubyEncoding(encoding2);
        }
        return defaultExternal;
    }

    public IRubyObject getDefaultInternal() {
        return this.convertEncodingToRubyEncoding(this.runtime.getDefaultInternalEncoding());
    }

    public IRubyObject convertEncodingToRubyEncoding(Encoding defaultEncoding) {
        return defaultEncoding != null ? this.getEncoding(defaultEncoding) : this.runtime.getNil();
    }

    public IRubyObject findEncodingObject(byte[] bytes2) {
        EncodingDB.Entry entry = this.findEncodingEntry(bytes2);
        Encoding enc = entry != null ? entry.getEncoding() : ASCIIEncoding.INSTANCE;
        return this.convertEncodingToRubyEncoding(enc);
    }

    public Encoding getJavaDefault() {
        return this.javaDefault;
    }

    public Encoding getEncodingFromObject(IRubyObject arg2) {
        return this.getEncodingFromObjectCommon(arg2, true);
    }

    public Encoding getEncodingFromObjectNoError(IRubyObject arg2) {
        return this.getEncodingFromObjectCommon(arg2, false);
    }

    private Encoding getEncodingFromObjectCommon(IRubyObject arg2, boolean error2) {
        int id2;
        String name2;
        if (arg2 == null) {
            return null;
        }
        if (arg2 instanceof RubyEncoding) {
            return ((RubyEncoding)arg2).getEncoding();
        }
        if (arg2 instanceof RubyFixnum && (name2 = RubyNKF.NKFCharsetMap.get(id2 = (int)arg2.convertToInteger().getLongValue())) != null) {
            return this.getEncodingFromNKFName(name2);
        }
        if ((arg2 = arg2.checkStringType19()).isNil()) {
            return null;
        }
        if (!((RubyString)arg2).getEncoding().isAsciiCompatible()) {
            return null;
        }
        if (error2) {
            return this.findEncoding((RubyString)arg2);
        }
        return this.findEncodingNoError((RubyString)arg2);
    }

    private Encoding getEncodingFromNKFName(String name2) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)hei).next();
            EncodingDB.Entry entry = (EncodingDB.Entry)e.value;
            String className = entry.getEncodingClass();
            if (!className.equals(name2)) continue;
            return entry.getEncoding();
        }
        return null;
    }

    public Encoding getEncodingFromString(String string2) {
        if (string2 == null) {
            return null;
        }
        ByteList name2 = new ByteList(ByteList.plain(string2));
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        return this.findEncodingWithError(name2);
    }

    public Encoding findEncoding(IRubyObject str) {
        return this.findEncodingCommon(str, true);
    }

    public Encoding findEncodingNoError(IRubyObject str) {
        return this.findEncodingCommon(str, false);
    }

    public Encoding findEncodingNoError(ByteList str) {
        return this.findEncodingCommon(str, false);
    }

    private Encoding findEncodingCommon(IRubyObject str, boolean error2) {
        ByteList name2 = str.convertToString().getByteList();
        return this.findEncodingCommon(name2, error2);
    }

    private Encoding findEncodingCommon(ByteList name2, boolean error2) {
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        if (error2) {
            return this.findEncodingWithError(name2);
        }
        EncodingDB.Entry e = this.findEncodingOrAliasEntry(name2);
        if (e == null) {
            return null;
        }
        return e.getEncoding();
    }

    public EncodingDB.Entry findEntry(IRubyObject str) {
        ByteList name2 = str.convertToString().getByteList();
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return this.findEntryFromEncoding(special.toEncoding(this.runtime));
        }
        return this.findEntryWithError(name2);
    }

    public IRubyObject rubyEncodingFromObject(IRubyObject str) {
        if (str instanceof RubyEncoding) {
            return str;
        }
        EncodingDB.Entry entry = this.findEntry(str);
        if (entry == null) {
            return this.runtime.getNil();
        }
        return this.getEncodingList()[entry.getIndex()];
    }

    public Charset charsetForEncoding(Encoding encoding2) {
        Charset charset = encoding2.getCharset();
        if (encoding2.toString().equals("ASCII-8BIT")) {
            return Charset.forName("ISO-8859-1");
        }
        if (encoding2 == ISO8859_16Encoding.INSTANCE) {
            return ISO_8859_16.INSTANCE;
        }
        try {
            return Charset.forName(encoding2.toString());
        }
        catch (UnsupportedCharsetException uce) {
            throw this.runtime.newEncodingCompatibilityError("no java.nio.charset.Charset found for encoding `" + encoding2.toString() + "'");
        }
    }

    private void checkAsciiEncodingName(ByteList name2) {
        if (!name2.getEncoding().isAsciiCompatible()) {
            throw this.runtime.newArgumentError("invalid name encoding (non ASCII)");
        }
    }

    public Encoding findEncodingWithError(ByteList name2) {
        return this.findEntryWithError(name2).getEncoding();
    }

    private EncodingDB.Entry findEntryWithError(ByteList name2) {
        EncodingDB.Entry e = this.findEncodingOrAliasEntry(name2);
        if (e == null) {
            throw this.runtime.newArgumentError("unknown encoding name - " + name2);
        }
        return e;
    }

    private EncodingDB.Entry findEntryFromEncoding(Encoding e) {
        if (e == null) {
            return null;
        }
        return this.findEncodingEntry(new ByteList(e.getName()));
    }

    private static enum SpecialEncoding {
        LOCALE,
        EXTERNAL,
        INTERNAL,
        FILESYSTEM;


        public static SpecialEncoding valueOf(ByteList name2) {
            if (name2.caseInsensitiveCmp(LOCALE_BL) == 0) {
                return LOCALE;
            }
            if (name2.caseInsensitiveCmp(EXTERNAL_BL) == 0) {
                return EXTERNAL;
            }
            if (name2.caseInsensitiveCmp(INTERNAL_BL) == 0) {
                return INTERNAL;
            }
            if (name2.caseInsensitiveCmp(FILESYSTEM_BL) == 0) {
                return FILESYSTEM;
            }
            return null;
        }

        public Encoding toEncoding(Ruby runtime) {
            EncodingService service = runtime.getEncodingService();
            switch (this) {
                case LOCALE: {
                    return service.getLocaleEncoding();
                }
                case EXTERNAL: {
                    return runtime.getDefaultExternalEncoding();
                }
                case INTERNAL: {
                    return runtime.getDefaultInternalEncoding();
                }
                case FILESYSTEM: {
                    return runtime.getDefaultExternalEncoding();
                }
            }
            throw new RuntimeException("invalid SpecialEncoding: " + (Object)((Object)this));
        }
    }

    public static interface EncodingAliasVisitor {
        public void defineAlias(int var1, String var2);

        public void defineConstant(int var1, String var2);
    }

    public static interface EncodingDefinitionVisitor {
        public void defineEncoding(EncodingDB.Entry var1, byte[] var2, int var3, int var4);

        public void defineConstant(int var1, String var2);
    }
}

