/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;

public abstract class JavaUtil {
    public static void define(Ruby runtime) {
        Enumeration.define(runtime);
        Iterator.define(runtime);
        Collection.define(runtime);
        List.define(runtime);
    }

    private static java.util.Collection tryNewEqualInstance(java.util.Collection coll) {
        Class<?> klass = coll.getClass();
        try {
            Constructor<?> best = null;
            for (Constructor<?> ctor : klass.getDeclaredConstructors()) {
                Class<?>[] params2 = ctor.getParameterTypes();
                if (params2.length != 1 || !params2[0].isAssignableFrom(klass)) continue;
                if (best == null) {
                    best = ctor;
                    continue;
                }
                if (!best.getParameterTypes()[0].isAssignableFrom(params2[0])) continue;
                best = ctor;
            }
            if (org.jruby.javasupport.JavaUtil.CAN_SET_ACCESSIBLE) {
                best.setAccessible(true);
            }
            return (java.util.Collection)best.newInstance(coll);
        }
        catch (IllegalAccessException best) {
        }
        catch (InstantiationException e) {
            Helpers.throwException(e);
            return null;
        }
        catch (InvocationTargetException e) {
            Helpers.throwException(e.getTargetException());
            return null;
        }
        try {
            java.util.Collection clone2 = (java.util.Collection)klass.newInstance();
            clone2.addAll(coll);
            return clone2;
        }
        catch (IllegalAccessException e) {
            return coll;
        }
        catch (InstantiationException e) {
            return coll;
        }
    }

    @JRubyModule(name={"Java::JavaUtil::List"})
    public static class List {
        static RubyModule define(Ruby runtime) {
            RubyModule List2 = JavaClass.get(runtime, java.util.List.class).getProxyModule();
            List2.defineAnnotatedMethods(List.class);
            return List2;
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int size2 = list2.size();
            if (idx instanceof RubyRange) {
                int first2 = idx.callMethod(context, "first").convertToInteger().getIntValue();
                int last2 = idx.callMethod(context, "last").convertToInteger().getIntValue();
                if (last2 < 0) {
                    last2 += size2;
                }
                if (first2 < 0) {
                    first2 += size2;
                }
                if (first2 < 0 || first2 >= size2) {
                    return context.nil;
                }
                if (!((RubyRange)idx).isExcludeEnd()) {
                    ++last2;
                }
                if (last2 > size2) {
                    last2 = size2;
                }
                return Java.getInstance(context.runtime, list2.subList(first2, last2));
            }
            int i2 = idx.convertToInteger().getIntValue();
            if (i2 < 0) {
                i2 = size2 + i2;
            }
            if (i2 >= size2 || i2 < 0) {
                return context.nil;
            }
            return org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(context.runtime, list2.get(i2));
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject idx, IRubyObject len) {
            if (len.isNil()) {
                return List.aref(context, self2, idx);
            }
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int i2 = idx.convertToInteger().getIntValue();
            int size2 = list2.size();
            if (i2 < 0) {
                i2 = size2 + i2;
            }
            if (i2 >= size2 || i2 < 0) {
                return context.nil;
            }
            int last2 = len.convertToInteger().getIntValue();
            if (last2 < 0) {
                return context.nil;
            }
            if ((last2 += i2) > size2) {
                last2 = size2;
            }
            return Java.getInstance(context.runtime, list2.subList(i2, last2));
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject aset(ThreadContext context, IRubyObject self2, IRubyObject idx, IRubyObject val) {
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int size2 = list2.size();
            if (idx instanceof RubyRange) {
                int first2 = idx.callMethod(context, "first").convertToInteger().getIntValue();
                int last2 = idx.callMethod(context, "last").convertToInteger().getIntValue();
                if (last2 < 0) {
                    last2 += size2;
                }
                if (first2 < 0) {
                    first2 += size2;
                }
                if (((RubyRange)idx).isExcludeEnd()) {
                    --last2;
                }
                for (int i2 = last2; i2 >= first2; --i2) {
                    if (i2 < size2) {
                        list2.remove(i2);
                        continue;
                    }
                    list2.add(null);
                }
                list2.add(last2, val.toJava(Object.class));
                return val;
            }
            int i3 = idx.convertToInteger().getIntValue();
            if (i3 < 0) {
                i3 = size2 + i3;
            }
            if (i3 >= size2) {
                for (int t = 0; t < i3 - size2; ++t) {
                    list2.add(null);
                }
                list2.add(val.toJava(Object.class));
            } else {
                list2.set(i3, val.toJava(Object.class));
            }
            return val;
        }

        @JRubyMethod(name={"first", "ruby_first"})
        public static IRubyObject first(ThreadContext context, IRubyObject self2) {
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            return list2.isEmpty() ? context.nil : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(context.runtime, list2.get(0));
        }

        @JRubyMethod(name={"first", "ruby_first"})
        public static IRubyObject first(ThreadContext context, IRubyObject self2, IRubyObject count2) {
            int size2;
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int len = count2.convertToInteger().getIntValue();
            if (len > (size2 = list2.size())) {
                len = size2;
            }
            return Java.getInstance(context.runtime, list2.subList(0, len));
        }

        @JRubyMethod(name={"last", "ruby_last"})
        public static IRubyObject last(ThreadContext context, IRubyObject self2) {
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            return list2.isEmpty() ? context.nil : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(context.runtime, list2.get(list2.size() - 1));
        }

        @JRubyMethod(name={"last", "ruby_last"})
        public static IRubyObject last(ThreadContext context, IRubyObject self2, IRubyObject count2) {
            int end2;
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int len = count2.convertToInteger().getIntValue();
            int size2 = list2.size();
            int start2 = size2 - len;
            if (start2 < 0) {
                start2 = 0;
            }
            if ((end2 = start2 + len) > size2) {
                end2 = size2;
            }
            return Java.getInstance(context.runtime, list2.subList(start2, end2));
        }

        @JRubyMethod(name={"index"}, required=0)
        public static IRubyObject index(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            if (!block.isGiven()) {
                return runtime.getEnumerator().callMethod("new", self2, runtime.newSymbol("index"));
            }
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (list2 instanceof RandomAccess) {
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    IRubyObject ret = block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, list2.get(i2)));
                    if (!ret.isTrue()) continue;
                    return runtime.newFixnum(i2);
                }
            } else {
                int i3 = 0;
                for (Object elem : list2) {
                    IRubyObject ret = block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem));
                    if (ret.isTrue()) {
                        return runtime.newFixnum(i3);
                    }
                    ++i3;
                }
            }
            return context.nil;
        }

        @JRubyMethod(name={"index"}, required=1)
        public static IRubyObject index(ThreadContext context, IRubyObject self2, IRubyObject val, Block ignoredBlock) {
            Ruby runtime = context.runtime;
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (list2 instanceof RandomAccess) {
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    Object elem = list2.get(i2);
                    if (val != elem && !Helpers.invokedynamic(context, val, MethodNames.OP_EQUAL, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem)).isTrue()) continue;
                    return runtime.newFixnum(i2);
                }
            } else {
                int i3 = 0;
                for (Object elem : list2) {
                    if (val == elem || Helpers.invokedynamic(context, val, MethodNames.OP_EQUAL, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem)).isTrue()) {
                        return runtime.newFixnum(i3);
                    }
                    ++i3;
                }
            }
            return context.nil;
        }

        @JRubyMethod(name={"rindex"}, required=0)
        public static IRubyObject rindex(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            if (!block.isGiven()) {
                return runtime.getEnumerator().callMethod("new", self2, runtime.newSymbol("rindex"));
            }
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (list2 instanceof RandomAccess) {
                for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
                    IRubyObject ret = block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, list2.get(i2)));
                    if (!ret.isTrue()) continue;
                    return runtime.newFixnum(i2);
                }
            } else {
                int i3 = list2.size() - 1;
                ListIterator it = list2.listIterator(i3);
                while (it.hasPrevious()) {
                    Object elem = it.previous();
                    IRubyObject ret = block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem));
                    if (ret.isTrue()) {
                        return runtime.newFixnum(i3);
                    }
                    --i3;
                }
            }
            return context.nil;
        }

        @JRubyMethod(name={"rindex"}, required=1)
        public static IRubyObject rindex(ThreadContext context, IRubyObject self2, IRubyObject val, Block ignoredBlock) {
            Ruby runtime = context.runtime;
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (list2 instanceof RandomAccess) {
                for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
                    Object elem = list2.get(i2);
                    if (val != elem && !Helpers.invokedynamic(context, val, MethodNames.OP_EQUAL, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem)).isTrue()) continue;
                    return runtime.newFixnum(i2);
                }
            } else {
                int i3 = list2.size() - 1;
                ListIterator it = list2.listIterator(i3);
                while (it.hasPrevious()) {
                    Object elem = it.previous();
                    if (val == elem || Helpers.invokedynamic(context, val, MethodNames.OP_EQUAL, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem)).isTrue()) {
                        return runtime.newFixnum(i3);
                    }
                    --i3;
                }
            }
            return context.nil;
        }

        @JRubyMethod(name={"to_a", "to_ary"})
        public static RubyArray to_a(ThreadContext context, IRubyObject self2) {
            Ruby runtime = context.runtime;
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            IRubyObject[] array = new IRubyObject[list2.size()];
            int i2 = 0;
            for (Object elem : list2) {
                array[i2++] = org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, elem);
            }
            return RubyArray.newArrayNoCopy(runtime, array);
        }

        @JRubyMethod(name={"sort", "ruby_sort"})
        public static IRubyObject sort(ThreadContext context, IRubyObject self2, Block block) {
            ArrayList dupList = (ArrayList)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2.callMethod(context, "dup"));
            if (dupList == org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2)) {
                dupList = new ArrayList(dupList);
            }
            List.sortImpl(context, dupList, block);
            return Java.getInstance(context.runtime, dupList);
        }

        @JRubyMethod(name={"sort!"})
        public static IRubyObject sort_bang(ThreadContext context, IRubyObject self2, Block block) {
            java.util.List list2 = (java.util.List)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            List.sortImpl(context, list2, block);
            return self2;
        }

        private static void sortImpl(ThreadContext context, java.util.List list2, Block block) {
            Comparator comparator = block.isGiven() ? new BlockComparator(context, block) : new SpaceshipComparator(context);
            Collections.sort(list2, comparator);
        }

        private static final class SpaceshipComparator
        implements Comparator {
            final ThreadContext context;

            SpaceshipComparator(ThreadContext context) {
                this.context = context;
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                IRubyObject r1 = o1 instanceof IRubyObject ? (IRubyObject)o1 : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(this.context.runtime, o1);
                IRubyObject r2 = o2 instanceof IRubyObject ? (IRubyObject)o2 : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(this.context.runtime, o2);
                return RubyInteger.fix2int(this.compare(this.context, r1, r2));
            }

            public final IRubyObject compare(ThreadContext context, IRubyObject o1, IRubyObject o2) {
                return o1.callMethod(context, "<=>", o2);
            }
        }

        private static final class BlockComparator
        implements Comparator {
            final ThreadContext context;
            private final Block block;

            BlockComparator(ThreadContext context, Block block) {
                this.context = context;
                this.block = block;
            }

            public int compare(Object o1, Object o2) {
                IRubyObject r1 = o1 instanceof IRubyObject ? (IRubyObject)o1 : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(this.context.runtime, o1);
                IRubyObject r2 = o2 instanceof IRubyObject ? (IRubyObject)o2 : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(this.context.runtime, o2);
                return RubyInteger.fix2int(this.compare(this.context, r1, r2));
            }

            public final IRubyObject compare(ThreadContext context, IRubyObject o1, IRubyObject o2) {
                return this.block.call(context, o1, o2);
            }
        }
    }

    @JRubyModule(name={"Java::JavaUtil::Collection"}, include={"Enumerable"})
    public static class Collection {
        static RubyModule define(Ruby runtime) {
            RubyModule Collection2 = JavaClass.get(runtime, java.util.Collection.class).getProxyModule();
            Collection2.includeModule(runtime.getEnumerable());
            Collection2.defineAnnotatedMethods(Collection.class);
            return Collection2;
        }

        @JRubyMethod(name={"length", "size"})
        public static RubyNumeric length(ThreadContext context, IRubyObject self2) {
            return RubyFixnum.int2fix(context.runtime, ((java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2)).size());
        }

        @JRubyMethod
        public static IRubyObject each(ThreadContext context, IRubyObject self2, Block block) {
            return JavaLang.Iterable.each(context, self2, block);
        }

        @JRubyMethod
        public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
            return JavaLang.Iterable.each_with_index(context, self2, block);
        }

        @JRubyMethod(name={"first", "ruby_first"})
        public static IRubyObject first(ThreadContext context, IRubyObject self2) {
            java.util.Collection coll = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            return coll.isEmpty() ? context.nil : org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(context.runtime, coll.iterator().next());
        }

        @JRubyMethod(name={"first", "ruby_first"})
        public static IRubyObject first(ThreadContext context, IRubyObject self2, IRubyObject count2) {
            int size2;
            java.util.Collection coll = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            int len = count2.convertToInteger().getIntValue();
            if (len > (size2 = coll.size())) {
                len = size2;
            }
            Ruby runtime = context.runtime;
            if (len == 0) {
                return RubyArray.newEmptyArray(runtime);
            }
            RubyArray arr = RubyArray.newArray(runtime, len);
            java.util.Iterator it = coll.iterator();
            for (int i2 = 0; i2 < len; ++i2) {
                arr.append(org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, it.next()));
            }
            return arr;
        }

        @JRubyMethod(name={"<<"})
        public static IRubyObject append(IRubyObject self2, IRubyObject item) {
            java.util.Collection coll = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            coll.add(item.toJava(Object.class));
            return self2;
        }

        @JRubyMethod
        public static RubyArray to_a(ThreadContext context, IRubyObject self2) {
            Object[] array = ((java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2)).toArray();
            if (IRubyObject.class.isAssignableFrom(array.getClass().getComponentType())) {
                return RubyArray.newArrayNoCopy(context.runtime, (IRubyObject[])array);
            }
            return RubyArray.newArrayNoCopy(context.runtime, org.jruby.javasupport.JavaUtil.convertJavaArrayToRuby(context.runtime, array));
        }

        @JRubyMethod(name={"+"}, required=1)
        public static IRubyObject op_plus(ThreadContext context, IRubyObject self2, IRubyObject coll) {
            IRubyObject dup2 = self2.callMethod(context, "dup");
            java.util.Collection javaDup = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(dup2);
            if (coll instanceof java.util.Collection) {
                javaDup.addAll((java.util.Collection)((Object)coll));
            } else {
                javaDup.addAll((java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(coll));
            }
            return dup2;
        }

        @JRubyMethod(name={"-"}, required=1)
        public static IRubyObject op_minus(ThreadContext context, IRubyObject self2, IRubyObject coll) {
            IRubyObject dup2 = self2.callMethod(context, "dup");
            java.util.Collection javaDup = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(dup2);
            if (coll instanceof java.util.Collection) {
                javaDup.removeAll((java.util.Collection)((Object)coll));
            } else {
                javaDup.removeAll((java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(coll));
            }
            return dup2;
        }

        @JRubyMethod
        public static IRubyObject dup(ThreadContext context, IRubyObject self2) {
            JavaProxy dup2;
            java.util.Collection coll = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (coll == (dup2 = (JavaProxy)self2.dup()).getObject()) {
                dup2.setObject(JavaUtil.tryNewEqualInstance(coll));
            }
            return dup2;
        }

        @JRubyMethod
        public static IRubyObject clone(ThreadContext context, IRubyObject self2) {
            JavaProxy dup2;
            java.util.Collection coll = (java.util.Collection)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            if (coll == (dup2 = (JavaProxy)self2.rbClone()).getObject()) {
                dup2.setObject(JavaUtil.tryNewEqualInstance(coll));
            }
            return dup2;
        }

        @JRubyMethod
        public static IRubyObject join(ThreadContext context, IRubyObject self2) {
            return Collection.to_a(context, self2).join(context);
        }

        @JRubyMethod
        public static IRubyObject join(ThreadContext context, IRubyObject self2, IRubyObject sep) {
            return Collection.to_a(context, self2).join(context, sep);
        }
    }

    @JRubyModule(name={"Java::JavaUtil::Iterator"}, include={"Enumerable"})
    public static class Iterator {
        static RubyModule define(Ruby runtime) {
            RubyModule Iterator2 = JavaClass.get(runtime, java.util.Iterator.class).getProxyModule();
            Iterator2.includeModule(runtime.getEnumerable());
            Iterator2.defineAnnotatedMethods(Iterator.class);
            return Iterator2;
        }

        @JRubyMethod
        public static IRubyObject each(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            java.util.Iterator iterator = (java.util.Iterator)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            while (iterator.hasNext()) {
                Object value2 = iterator.next();
                block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, value2));
            }
            return context.nil;
        }
    }

    @JRubyModule(name={"Java::JavaUtil::Enumeration"}, include={"Enumerable"})
    public static class Enumeration {
        static RubyModule define(Ruby runtime) {
            RubyModule Enumeration2 = JavaClass.get(runtime, java.util.Enumeration.class).getProxyModule();
            Enumeration2.includeModule(runtime.getEnumerable());
            Enumeration2.defineAnnotatedMethods(Enumeration.class);
            return Enumeration2;
        }

        @JRubyMethod
        public static IRubyObject each(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            java.util.Enumeration enumeration = (java.util.Enumeration)org.jruby.javasupport.JavaUtil.unwrapJavaObject(self2);
            while (enumeration.hasMoreElements()) {
                Object value2 = enumeration.nextElement();
                block.yield(context, org.jruby.javasupport.JavaUtil.convertJavaToUsableRubyObject(runtime, value2));
            }
            return context.nil;
        }
    }
}

